/*
 * Decompiled with CFR 0.152.
 */
package plugins.atournay.jep.utils;

import java.util.regex.Pattern;

public class Utils {
    private static Utils instance;

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public boolean isPath(String path) {
        if (Pattern.compile("([A-Za-z]:|[/\\\\])+.(\\w)+.*").matcher(path).find()) {
            return true;
        }
        System.err.println("The input does not correspond to a System path. Please retry.");
        System.out.println();
        return false;
    }

    public String getOS() {
        return System.getProperty("os.name").toLowerCase();
    }

    public boolean isWindows() {
        return this.getOS().contains("win");
    }

    public boolean isMacOS() {
        return this.getOS().startsWith("mac");
    }

    public boolean isLinux() {
        return this.getOS().startsWith("nix") || this.getOS().contains("nux") || this.getOS().contains("aix");
    }
}

