/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.gui.dialog.MessageDialog;
import icy.math.MathUtil;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class ROIInclusionAnalysis
extends EzPlug
implements ROIBlock {
    EzVarSequence seqOuterROI = new EzVarSequence("Take outer ROI from");
    EzVarSequence seqInnerROI = new EzVarSequence("Take inner ROI from");
    EzVarBoolean includeOverlap = new EzVarBoolean("Include overlapping ROI", true);
    EzVarSequence inputSequence = new EzVarSequence("Input sequence (for path export)");
    VarROIArray outerROI = new VarROIArray("Outer (enclosing) ROI");
    VarROIArray innerROI = new VarROIArray("Inner (enclosed) ROI");
    VarWorkbook workbook = new VarWorkbook("Analysis", (Workbook)null);
    private String fullPathSequence = null;

    public void declareInput(VarList inputMap) {
        inputMap.add("Outer ROI", (Var)this.outerROI);
        inputMap.add("Inner ROI", (Var)this.innerROI);
        inputMap.add("Include overlap", this.includeOverlap.getVariable());
        inputMap.add("Input sequence", (Var)this.inputSequence.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("workbook", (Var)this.workbook);
    }

    public void clean() {
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.seqOuterROI);
        this.addEzComponent((EzComponent)this.seqInnerROI);
        this.addEzComponent((EzComponent)this.includeOverlap);
        this.getUI().setParametersIOVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (!this.isHeadLess()) {
            this.outerROI.setValue((Object)((Sequence)this.seqOuterROI.getValue(true)).getROIs().toArray(new ROI[0]));
            this.innerROI.setValue((Object)((Sequence)this.seqInnerROI.getValue(true)).getROIs().toArray(new ROI[0]));
        }
        if (this.inputSequence.getValue() != null) {
            this.fullPathSequence = ((Sequence)this.inputSequence.getValue()).getFilename();
        }
        Workbook wb = Workbooks.createEmptyWorkbook();
        IcySpreadSheet summarySheet = Workbooks.getSheet((Workbook)wb, (String)"Summary");
        IcySpreadSheet detailSheet = Workbooks.getSheet((Workbook)wb, (String)"Details");
        if (this.fullPathSequence != null) {
            detailSheet.setRow(0, new Object[]{"Full path", "Enclosing ROI", "T", "X", "Y", "Z", "Enclosed ROI", "X", "Y", "Z", "Oriented dist. to edge", "Oriented dist. to edge (%)", "Absolute dist. to edge"});
            summarySheet.setRow(0, new Object[]{"Full path", "Enclosing ROI", "T", "X", "Y", "Z", "nb. enclosed ROI", "Mean oriented dist. to edge", "Mean oriented dist. to edge (%)", "Mean absolute dist. to edge"});
        } else {
            detailSheet.setRow(0, new Object[]{"Enclosing ROI", "T", "X", "Y", "Z", "Enclosed ROI", "X", "Y", "Z", "Oriented dist. to edge", "Oriented dist. to edge (%)", "Absolute dist. to edge"});
            summarySheet.setRow(0, new Object[]{"Enclosing ROI", "T", "X", "Y", "Z", "nb. enclosed ROI", "Mean oriented dist. to edge", "Mean oriented dist. to edge (%)", "Mean absolute dist. to edge"});
        }
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        ArrayList<Future> tasks = new ArrayList<Future>(this.outerROI.size());
        try {
            for (final ROI enclosing : this.outerROI) {
                tasks.add(processor.submit((Callable)new Callable<Object[][]>(){

                    @Override
                    public Object[][] call() throws InterruptedException {
                        ArrayList<Object[]> results = new ArrayList<Object[]>();
                        Point5D cOut = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)enclosing);
                        int outT = (int)MathUtil.round((double)cOut.getT(), (int)0);
                        double outX = MathUtil.round((double)cOut.getX(), (int)2);
                        double outY = MathUtil.round((double)cOut.getY(), (int)2);
                        double outZ = MathUtil.round((double)cOut.getZ(), (int)2);
                        String outName = enclosing.getName();
                        int nbInside = 0;
                        double avgOD2E = 0.0;
                        double avgOD2E_pct = 0.0;
                        double avgAD2E = 0.0;
                        for (ROI enclosed : ROIInclusionAnalysis.this.innerROI) {
                            double[] distances = ROIInclusionAnalysis.inclusionAnalysis(enclosing, enclosed, true);
                            if (Double.isNaN(distances[0])) continue;
                            ++nbInside;
                            Point5D cIn = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)enclosed);
                            double inX = MathUtil.round((double)cIn.getX(), (int)2);
                            double inY = MathUtil.round((double)cIn.getY(), (int)2);
                            double inZ = MathUtil.round((double)cIn.getZ(), (int)2);
                            String inName = enclosed.getName();
                            double oD2E = distances[0];
                            double oD2E_pct = distances[1];
                            double absD2E = distances[2];
                            avgOD2E += oD2E;
                            avgOD2E_pct += oD2E_pct;
                            avgAD2E += absD2E;
                            oD2E = MathUtil.round((double)oD2E, (int)2);
                            oD2E_pct = MathUtil.round((double)oD2E_pct, (int)2);
                            absD2E = MathUtil.round((double)absD2E, (int)2);
                            if (ROIInclusionAnalysis.this.fullPathSequence != null) {
                                results.add(new Object[]{ROIInclusionAnalysis.this.fullPathSequence, outName, outT, outX, outY, outZ, inName, inX, inY, inZ, oD2E, oD2E_pct, absD2E});
                                continue;
                            }
                            results.add(new Object[]{outName, outT, outX, outY, outZ, inName, inX, inY, inZ, oD2E, oD2E_pct, absD2E});
                        }
                        avgOD2E = MathUtil.round((double)(avgOD2E / (double)nbInside), (int)2);
                        avgOD2E_pct = MathUtil.round((double)(avgOD2E_pct / (double)nbInside), (int)2);
                        avgAD2E = MathUtil.round((double)(avgAD2E / (double)nbInside), (int)2);
                        if (ROIInclusionAnalysis.this.fullPathSequence != null) {
                            results.add(new Object[]{ROIInclusionAnalysis.this.fullPathSequence, outName, outT, outX, outY, outZ, nbInside, avgOD2E, avgOD2E_pct, avgAD2E});
                        } else {
                            results.add(new Object[]{outName, outT, outX, outY, outZ, nbInside, avgOD2E, avgOD2E_pct, avgAD2E});
                        }
                        return (Object[][])results.toArray((T[])new Object[0][]);
                    }
                }));
            }
            int detailRow = 0;
            int summaryRow = 0;
            for (Future task : tasks) {
                Object[][] dataLines = (Object[][])task.get();
                for (int i = 0; i < dataLines.length - 1; ++i) {
                    detailSheet.setRow(++detailRow, dataLines[i]);
                }
                summarySheet.setRow(++summaryRow, dataLines[dataLines.length - 1]);
                if (this.getStatus() == null) continue;
                this.getStatus().setCompletion((double)summaryRow / (double)this.outerROI.size());
            }
        }
        catch (InterruptedException e) {
            if (!this.isHeadLess()) {
                MessageDialog.showDialog((String)"ROI inclusion analysis process interrupted !");
            }
            System.err.print("ROI inclusion analysis process interrupted !");
            this.workbook.setValue(null);
            return;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            tasks.clear();
            processor.shutdownNow();
        }
        this.workbook.setValue((Object)wb);
        if (!this.isHeadLess()) {
            Workbooks.show((Workbook)wb, (String)"Inclusion analysis");
        }
    }

    public static double[] inclusionAnalysis(ROI outerROI, ROI innerROI, boolean allowPartialOverlap) throws InterruptedException {
        Point3d inCenter;
        int innerC;
        int outerC;
        if (outerROI instanceof ROI3D) {
            if (innerROI instanceof ROI2D && ((ROI2D)innerROI).getZ() != -1) {
                int z = ((ROI2D)innerROI).getZ();
                innerROI = new ROI3DArea(((ROI2D)innerROI).getBooleanMask(true), z, z);
            }
            if (innerROI instanceof ROI3D) {
                ((ROI3D)innerROI).setC(((ROI3D)outerROI).getC());
                ((ROI3D)innerROI).setT(((ROI3D)outerROI).getT());
            }
        }
        boolean enclosure = outerROI.contains(innerROI);
        if (outerROI instanceof ROI2D && innerROI instanceof ROI2D) {
            outerC = ((ROI2D)outerROI).getC();
            innerC = ((ROI2D)innerROI).getC();
            if (outerC != -1 && outerC != innerC) {
                ((ROI2D)outerROI).setC(innerC);
                enclosure = outerROI.contains(innerROI);
                ((ROI2D)outerROI).setC(outerC);
            }
        } else if (outerROI instanceof ROI3D && innerROI instanceof ROI3D) {
            outerC = ((ROI3D)outerROI).getC();
            innerC = ((ROI3D)innerROI).getC();
            if (outerC != -1 && outerC != innerC) {
                ((ROI3D)outerROI).setC(innerC);
                enclosure = outerROI.contains(innerROI);
                ((ROI3D)outerROI).setC(outerC);
            }
        }
        if (!enclosure && allowPartialOverlap) {
            enclosure = outerROI.intersects(innerROI);
        }
        if (!enclosure) {
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        Point5D p5 = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)outerROI);
        Point3d outCenter = new Point3d(p5.getX(), p5.getY(), p5.getZ());
        if (innerROI instanceof ROI2DPoint) {
            Point2D p2 = ((ROI2DPoint)innerROI).getPoint();
            inCenter = new Point3d(p2.getX(), p2.getY(), 0.0);
        } else {
            p5 = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)innerROI);
            inCenter = new Point3d(p5.getX(), p5.getY(), p5.getZ());
        }
        double distToCenter = outCenter.distance(inCenter);
        double absoluteDistToEdge = Double.MAX_VALUE;
        double step = 0.1;
        Point3d p = new Point3d(inCenter);
        Vector3d ray = new Vector3d();
        ray.sub((Tuple3d)inCenter, (Tuple3d)outCenter);
        ray.normalize();
        ray.scale(step);
        if (outerROI instanceof ROI2D) {
            while (((ROI2D)outerROI).contains(p.x, p.y)) {
                p.add((Tuple3d)ray);
            }
            for (Point point : ((ROI2D)outerROI).getBooleanMask(true).getContourPoints()) {
                double rawDist = point.distance(inCenter.x, inCenter.y);
                if (!(rawDist < absoluteDistToEdge)) continue;
                absoluteDistToEdge = rawDist;
            }
        } else if (outerROI instanceof ROI3D) {
            while (((ROI3D)outerROI).contains(p.x, p.y, p.z)) {
                p.add((Tuple3d)ray);
            }
            for (Point point : ((ROI3D)outerROI).getBooleanMask(true).getContourPoints()) {
                double rawDist = inCenter.distance(new Point3d((double)((Point3D.Integer)point).x, (double)((Point3D.Integer)point).y, (double)((Point3D.Integer)point).z));
                if (!(rawDist < absoluteDistToEdge)) continue;
                absoluteDistToEdge = rawDist;
            }
        } else {
            while (outerROI.contains(p.x, p.y, p.z, -1.0, -1.0)) {
                p.add((Tuple3d)ray);
            }
        }
        double localRadius = p.distance(outCenter);
        double orientedDistToEdge = localRadius - distToCenter;
        return new double[]{orientedDistToEdge, distToCenter / localRadius, absoluteDistToEdge};
    }
}

