/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion;

import icy.util.ClassUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import plugins.tprovoost.scripteditor.completion.IcyAutoCompletion;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.NewInstanceCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;

public class PythonAutoCompletion
extends IcyAutoCompletion {
    public PythonAutoCompletion(CompletionProvider provider) {
        super(provider);
    }

    protected String getReplacementText(Completion c, Document doc, int start, int len) {
        String toReturn = super.getReplacementText(c, doc, start, len);
        if (c instanceof ScriptFunctionCompletion) {
            ScriptFunctionCompletion fc = (ScriptFunctionCompletion)c;
            String textBefore = "";
            if (!fc.isStatic()) {
                CompletionProvider provider = this.getCompletionProvider();
                if (provider instanceof IcyCompletionProvider) {
                    textBefore = provider.getAlreadyEnteredText(this.getTextComponent());
                    int lastIdx = textBefore.lastIndexOf(46);
                    textBefore = lastIdx != -1 ? textBefore.substring(0, lastIdx + 1) : "";
                }
                toReturn = String.valueOf(textBefore) + fc.getMethod().getName();
            }
        } else if (c instanceof BasicJavaClassCompletion) {
            Class<?> clazz = ((BasicJavaClassCompletion)c).getJavaClass();
            String textBefore = "";
            CompletionProvider provider = this.getCompletionProvider();
            if (provider instanceof IcyCompletionProvider) {
                textBefore = ((IcyCompletionProvider)provider).getAlreadyEnteredTextWithFunc(this.getTextComponent());
                int lastIdx = textBefore.lastIndexOf(46);
                textBefore = lastIdx != -1 ? textBefore.substring(0, lastIdx) : "";
            }
            if (textBefore == "") {
                toReturn = clazz.getName();
                toReturn = ClassUtil.getSimpleClassName((String)toReturn).replace('$', '.');
            } else {
                toReturn = clazz.getSimpleName();
            }
        }
        return toReturn;
    }

    protected void insertCompletion(Completion c, boolean typedParamListStartChar) {
        if (c instanceof BasicJavaClassCompletion) {
            JTextComponent tc = this.getTextComponent();
            int caretPos = tc.getCaretPosition();
            Class<?> clazz = ((BasicJavaClassCompletion)c).getJavaClass();
            String neededClass = clazz.getName();
            if (clazz.isMemberClass()) {
                neededClass = ClassUtil.getBaseClassName((String)neededClass);
            }
            if (!this.classAlreadyImported(neededClass)) {
                tc.getCaret().setDot(caretPos += this.addImport(tc, neededClass, true).length());
            }
        } else if (c instanceof NewInstanceCompletion) {
            JTextComponent tc = this.getTextComponent();
            int caretPos = tc.getCaretPosition();
            Class<?> clazz = ((NewInstanceCompletion)c).getConstructor().getDeclaringClass();
            String neededClass = clazz.getName();
            if (!this.classAlreadyImported(neededClass)) {
                tc.getCaret().setDot(caretPos += this.addImport(tc, neededClass, true).length());
            }
        }
        super.insertCompletion(c, typedParamListStartChar);
    }

    @Override
    public String addImport(JTextComponent tc, String neededClass, boolean isClass) {
        int lastIdxDot;
        String resultingImport = "";
        String packageName = ClassUtil.getPackageName((String)neededClass);
        if (!packageName.isEmpty()) {
            if (!isClass) {
                return resultingImport;
            }
            resultingImport = String.valueOf(resultingImport) + "from " + packageName + " ";
        }
        resultingImport = isClass ? String.valueOf(resultingImport) + "import " + ClassUtil.getSimpleClassName((String)neededClass) : ((lastIdxDot = packageName.lastIndexOf(46)) != -1 ? String.valueOf(resultingImport) + "as " + packageName.substring(lastIdxDot) : String.valueOf(resultingImport) + "as " + packageName);
        resultingImport = String.valueOf(resultingImport) + "\n";
        tc.setText(String.valueOf(resultingImport) + tc.getText());
        return resultingImport;
    }

    @Override
    public boolean classAlreadyImported(String neededClass) {
        String text = this.getTextComponent().getText();
        Pattern p = Pattern.compile("from\\s" + ClassUtil.getPackageName((String)neededClass) + "\\simport\\s" + ClassUtil.getSimpleClassName((String)neededClass));
        Matcher m = p.matcher(text);
        return m.find();
    }
}

