/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion.types;

import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.Parameter;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import plugins.tprovoost.scripteditor.completion.types.JavaFunctionCompletion;
import plugins.tprovoost.scripteditor.javasource.ClassSource;
import plugins.tprovoost.scripteditor.javasource.JarAccess;

public class NewInstanceCompletion
extends JavaFunctionCompletion {
    private static HashMap<String, ConstructorDeclaration> cacheConsDecl = new HashMap();
    private static HashMap<String, List<ParameterizedCompletion.Parameter>> cacheParams = new HashMap();
    private Constructor<?> constructor;
    private boolean isStatic;
    private boolean isParseDone = false;

    public NewInstanceCompletion(CompletionProvider provider, String name, Constructor<?> constructor) {
        super(provider, name, constructor.getDeclaringClass().getName());
        this.constructor = constructor;
    }

    public String getMethodCall() {
        ConstructorDeclaration constDecl = cacheConsDecl.get(this.constructor.toGenericString());
        String parametersAsString = "";
        if (constDecl != null) {
            List params = constDecl.getParameters();
            int i = 0;
            while (i < params.size()) {
                Parameter p = (Parameter)params.get(i);
                parametersAsString = i != 0 ? String.valueOf(parametersAsString) + " ," + p.getType() + " " + p.getId().getName() : String.valueOf(parametersAsString) + p.getType() + " " + p.getId().getName();
                ++i;
            }
        } else {
            Class<?>[] paramTypes = this.constructor.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                parametersAsString = i != 0 ? String.valueOf(parametersAsString) + " ,arg" + i : String.valueOf(parametersAsString) + "arg" + i;
                ++i;
            }
        }
        return "Packages." + this.constructor.getDeclaringClass().getName() + "." + this.constructor.getName() + "(" + parametersAsString + ");";
    }

    public boolean isStatic() {
        if (this.constructor != null) {
            return Modifier.isStatic(this.constructor.getModifiers());
        }
        return false;
    }

    public Class<?> getOriginatingClass() {
        if (this.isStatic) {
            return null;
        }
        return this.constructor.getDeclaringClass();
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof NewInstanceCompletion)) {
            return false;
        }
        return ((NewInstanceCompletion)((Object)arg0)).getName().contentEquals(this.getName());
    }

    public String getAlreadyEntered(JTextComponent comp) {
        Document doc = comp.getDocument();
        Segment seg = new Segment();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = seg.offset + len;
        start = segEnd - 1;
        while (start >= seg.offset && this.isValidChar(seg.array[start])) {
            --start;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(seg.array, start, len);
    }

    private boolean isValidChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '\"';
    }

    public ParameterizedCompletion.Parameter getParam(int index) {
        List<ParameterizedCompletion.Parameter> params = cacheParams.get(this.constructor.toGenericString());
        if (params != null) {
            return params.get(index);
        }
        if (!this.isParseDone) {
            this.populate();
        }
        return super.getParam(index);
    }

    public String getSummary() {
        this.summary = (String)cacheSummary.get(this.constructor.toGenericString());
        if (!this.isParseDone && this.summary == null) {
            this.populate();
        }
        StringBuilder sb = new StringBuilder();
        this.addDefinitionString(sb);
        if (!this.possiblyAddDescription(sb)) {
            sb.append("<br><br><br>");
        }
        this.addParameters(sb);
        this.possiblyAddDefinedIn(sb);
        this.possiblyAddSource(sb);
        sb.append("</html>");
        return sb.toString();
    }

    private void populate() {
        ConstructorDeclaration dc = cacheConsDecl.get(this.constructor.toGenericString());
        if (dc == null) {
            Class<?> currentClass = this.constructor.getDeclaringClass();
            while (dc == null && currentClass != null) {
                try {
                    Constructor<?> c = currentClass.getDeclaredConstructor(this.constructor.getParameterTypes());
                    ClassSource cs = ClassSource.getClassSource(currentClass);
                    if (!cs.isConstructorsSet()) {
                        cs.populateConstructors();
                    }
                    dc = cs.getConstructors().get(c.toGenericString());
                }
                catch (SecurityException c) {
                }
                catch (NoSuchMethodException c) {
                    // empty catch block
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (dc != null) {
            HashMap<String, String> paramsHash;
            JavadocComment comment = dc.getJavaDoc();
            if (comment != null) {
                String content = comment.getContent();
                this.summary = content = ClassSource.docCommentToHtml("/**" + content + "*/");
            }
            if ((paramsHash = ClassSource.getParameters(this.summary)).size() > 0 && this.summary != null) {
                int idx = this.summary.indexOf("<p><b>Parameters:</b><p class='indented'>");
                int idxEnd = this.summary.indexOf("</p>", idx);
                this.summary = String.valueOf(this.summary.substring(0, idx)) + this.summary.substring(idxEnd + "</p>".length());
            }
            ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
            List list = dc.getParameters();
            int size = this.getParamCount();
            if (list != null && list.size() == size) {
                int i = 0;
                while (i < this.getParamCount()) {
                    Parameter sourceParam = (Parameter)list.get(i);
                    String name = sourceParam.getId().getName();
                    ParameterizedCompletion.Parameter param = new ParameterizedCompletion.Parameter((Object)sourceParam.getType(), name);
                    params.add(param);
                    String desc = paramsHash.get(name);
                    if (desc != null) {
                        param.setDescription(desc);
                    }
                    ++i;
                }
                super.setParams(params);
                cacheParams.put(this.constructor.toGenericString(), params);
            }
            cacheSummary.put(this.constructor.toGenericString(), this.summary);
        } else {
            this.summary = "";
        }
        this.isParseDone = true;
    }

    private void possiblyAddSource(StringBuilder sb) {
        InputStream is = JarAccess.getJavaSourceInputStream(this.constructor.getDeclaringClass());
        if (is != null) {
            sb.append("<hr><a href=\"SourceCodeLink\">View Source</a>");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BindingFunction {
        public String value();
    }
}

