/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.file.FileUtil;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.util.FontUtil;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.system.FileDrop;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EventListener;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.DescWindowCallback;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import plugins.tprovoost.scripteditor.completion.IcyAutoCompletion;
import plugins.tprovoost.scripteditor.completion.IcyCompletionCellRenderer;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProviderPython;
import plugins.tprovoost.scripteditor.completion.JSAutoCompletion;
import plugins.tprovoost.scripteditor.completion.PythonAutoCompletion;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.NewInstanceCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;
import plugins.tprovoost.scripteditor.gui.CommandPanel;
import plugins.tprovoost.scripteditor.gui.ConsoleOutput;
import plugins.tprovoost.scripteditor.gui.Preferences;
import plugins.tprovoost.scripteditor.gui.PreferencesListener;
import plugins.tprovoost.scripteditor.gui.PreferencesWindow;
import plugins.tprovoost.scripteditor.javasource.ClassSource;
import plugins.tprovoost.scripteditor.javasource.JarAccess;
import plugins.tprovoost.scripteditor.main.ScriptListener;
import plugins.tprovoost.scripteditor.scriptingconsole.BindingsScriptFrame;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.js.JSScriptingHandlerRhino;
import plugins.tprovoost.scripteditor.scriptinghandlers.py.PythonScriptingHandler;

public class ScriptingPanel
extends JPanel
implements ScriptListener {
    private static final long serialVersionUID = 1L;
    private ScriptingHandler scriptHandler;
    private RSyntaxTextArea textArea;
    private RTextScrollPane pane;
    private CommandPanel options;
    private String panelName;
    private String saveFileString = "";
    private File saveFile = null;
    private IcyCompletionProvider provider;
    private IcyAutoCompletion ac;
    private ConsoleOutput consoleOutput;
    private boolean integrated;
    private PreferencesListener applyPrefsListener = new PreferencesListener(){

        @Override
        public void preferencesChanged() {
            Preferences preferences = Preferences.getPreferences();
            ScriptingPanel.this.textArea.setTabsEmulated(preferences.isSoftTabsEnabled());
            ScriptingPanel.this.textArea.setTabSize(preferences.indentSpacesCount());
            ScriptingPanel.this.textArea.setFont(FontUtil.setSize((Font)ScriptingPanel.this.textArea.getFont(), (int)preferences.getFontSize()));
            if (ScriptingPanel.this.consoleOutput != null) {
                ((ScriptingPanel)ScriptingPanel.this).consoleOutput.textPane.setFont(FontUtil.setSize((Font)((ScriptingPanel)ScriptingPanel.this).consoleOutput.textPane.getFont(), (int)preferences.getFontSize()));
            }
        }
    };
    private ItemListener languageListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String language = (String)e.getItem();
                ScriptingPanel.this.installLanguage(language);
            }
        }
    };
    private ActionListener runInNewListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingPanel.this.runInNew();
        }
    };
    private ActionListener runInSameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingPanel.this.runInSame();
        }
    };
    private ActionListener stopListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScriptingPanel.this.stopScript();
        }
    };
    private final EventListenerList savedAslisteners = new EventListenerList();
    private final EventListenerList titleChangedListeners = new EventListenerList();

    public ScriptingPanel(String name, String language) {
        this(name, language, true, null);
    }

    public ScriptingPanel(String name, String language, ConsoleOutput consoleOutput) {
        this(name, language, false, consoleOutput);
    }

    public ScriptingPanel(String name, String language, boolean integrated, ConsoleOutput consoleOutput) {
        this.panelName = name;
        this.integrated = integrated;
        this.consoleOutput = consoleOutput;
        this.setLayout(new BorderLayout());
        this.textArea = new RSyntaxTextArea(20, 60);
        this.textArea.setSyntaxEditingStyle("text/javascript");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setCloseCurlyBraces(true);
        this.textArea.setMarkOccurrences(true);
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setPaintMarkOccurrencesBorder(true);
        this.textArea.setPaintMatchedBracketPair(true);
        this.textArea.setPaintTabLines(true);
        this.textArea.setTabsEmulated(false);
        this.textArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NetworkUtil.openBrowser((URL)e.getURL());
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                ScriptingPanel.this.updateTitle();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                ScriptingPanel.this.updateTitle();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        this.pane = new RTextScrollPane((Component)this.textArea);
        this.pane.setIconRowHeaderEnabled(true);
        this.options = new CommandPanel(language);
        this.installLanguage(this.options.getLanguage());
        this.options.addLanguageListener(this.languageListener);
        this.options.addRunInSameListener(this.runInSameListener);
        this.options.addRunInNewListener(this.runInNewListener);
        this.options.addStopListener(this.stopListener);
        this.setTheme("eclipse");
        this.textArea.requestFocus();
        this.applyPrefsListener.preferencesChanged();
        PreferencesWindow.getPreferencesWindow().addPreferencesListener(this.applyPrefsListener);
    }

    public IcyCompletionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IcyCompletionProvider provider) {
        this.provider = provider;
    }

    public RSyntaxTextArea getTextArea() {
        return this.textArea;
    }

    public RTextScrollPane getPane() {
        return this.pane;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setSyntax(String syntaxType) {
        this.textArea.setSyntaxEditingStyle(syntaxType);
    }

    public void setTheme(String s) {
        try {
            Theme t = Theme.load((InputStream)PluginLoader.getLoader().getResourceAsStream("plugins/tprovoost/scripteditor/resources/themes/" + s + ".xml"));
            t.apply(this.textArea);
        }
        catch (IOException e) {
            System.out.println("Couldn't load theme");
        }
    }

    public boolean saveFileAs(File f) {
        if (f != null) {
            BufferedWriter writer = null;
            try {
                String s = this.textArea.getText();
                writer = new BufferedWriter(new FileWriter(f));
                writer.write(s);
                writer.close();
                this.saveFile = f;
                this.saveFileString = s;
                this.panelName = f.getName();
                this.scriptHandler.setFileName(f.getAbsolutePath());
                this.updateTitle();
                this.fireSavedAs(f);
                return true;
            }
            catch (IOException e) {
                new FailedAnnounceFrame(e.getLocalizedMessage());
                return false;
            }
        }
        return false;
    }

    public void addSavedAsListener(SavedAsListener listener) {
        this.savedAslisteners.add(SavedAsListener.class, listener);
    }

    public void removeSavedAsListener(SavedAsListener listener) {
        this.savedAslisteners.remove(SavedAsListener.class, listener);
    }

    protected void fireSavedAs(File f) {
        SavedAsListener[] savedAsListenerArray = this.getSavedAsListeners();
        int n = savedAsListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SavedAsListener listener = savedAsListenerArray[n2];
            listener.savedAs(f);
            ++n2;
        }
    }

    public SavedAsListener[] getSavedAsListeners() {
        return (SavedAsListener[])this.savedAslisteners.getListeners(SavedAsListener.class);
    }

    public boolean saveFile() {
        if (!this.isDirty()) {
            return true;
        }
        if (this.saveFile != null) {
            BufferedWriter writer = null;
            try {
                String s = this.textArea.getText();
                writer = new BufferedWriter(new FileWriter(this.saveFile));
                writer.write(s);
                writer.close();
                this.saveFileString = s;
                this.updateTitle();
                return true;
            }
            catch (IOException e) {
                new FailedAnnounceFrame(e.getLocalizedMessage());
                return false;
            }
        }
        return false;
    }

    public boolean showSaveFileDialog(String currentDirectoryPath) {
        return this.showSaveFileDialog(currentDirectoryPath, this.panelName);
    }

    public boolean showSaveFileDialog(String currentDirectoryPath, String defaultName) {
        final JFileChooser fc = currentDirectoryPath == "" ? new JFileChooser() : new JFileChooser(currentDirectoryPath);
        if (this.getLanguage().contentEquals("JavaScript")) {
            fc.setFileFilter(new FileNameExtensionFilter("Javascript files", "js"));
        } else if (this.getLanguage().contentEquals("Python")) {
            fc.setFileFilter(new FileNameExtensionFilter("Python files", "py"));
        }
        fc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                fc.accept(fc.getSelectedFile());
                fc.removeKeyListener(this);
            }
        });
        if (!defaultName.isEmpty()) {
            fc.setSelectedFile(new File(defaultName));
        }
        if (fc.showSaveDialog((Component)Icy.getMainInterface().getMainFrame()) == 0) {
            File file = fc.getSelectedFile();
            if (FileUtil.getFileExtension((String)file.getAbsolutePath(), (boolean)false).isEmpty()) {
                file = this.addExtension(file);
            }
            return this.saveFileAs(file);
        }
        return false;
    }

    private File addExtension(File file) {
        if (this.getLanguage().contentEquals("JavaScript")) {
            return new File(String.valueOf(file.getAbsolutePath()) + ".js");
        }
        if (this.getLanguage().contentEquals("Python")) {
            return new File(String.valueOf(file.getAbsolutePath()) + ".py");
        }
        return file;
    }

    public void addTitleChangedListener(TitleChangedListener listener) {
        this.titleChangedListeners.add(TitleChangedListener.class, listener);
    }

    public void removeTitleChangedListener(TitleChangedListener listener) {
        this.titleChangedListeners.remove(TitleChangedListener.class, listener);
    }

    protected void fireTitleChanged(String title) {
        TitleChangedListener[] titleChangedListenerArray = this.getTitleChangedListeners();
        int n = titleChangedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TitleChangedListener listener = titleChangedListenerArray[n2];
            listener.titleChanged(this, title);
            ++n2;
        }
    }

    public TitleChangedListener[] getTitleChangedListeners() {
        return (TitleChangedListener[])this.titleChangedListeners.getListeners(TitleChangedListener.class);
    }

    private void updateTitle() {
        String title = this.isDirty() ? String.valueOf(this.panelName) + "*" : this.panelName;
        this.fireTitleChanged(title);
    }

    boolean close() {
        boolean canClose = this.isDirty() ? ConfirmDialog.confirm((String)("Some changes on '" + this.getPanelName() + "' has not been saved, are you sure you want to close ?")) : true;
        if (canClose) {
            this.cleanup();
            PreferencesWindow.getPreferencesWindow().removePreferencesListener(this.applyPrefsListener);
            this.options.removeLanguageListener(this.languageListener);
            this.options.removeRunInSameListener(this.runInSameListener);
            this.options.removeRunInNewListener(this.runInNewListener);
            this.options.removeStopListener(this.stopListener);
            return true;
        }
        return false;
    }

    void cleanup() {
        if (this.scriptHandler != null) {
            this.scriptHandler.stopThreads();
            this.scriptHandler.removeScriptListener(this);
            this.textArea.removeKeyListener((KeyListener)this.scriptHandler);
            PluginRepositoryLoader.removeListener((PluginRepositoryLoader.PluginRepositoryLoaderListener)this.scriptHandler);
        }
        if (this.ac != null) {
            this.ac.uninstall();
        }
    }

    public synchronized void installLanguage(final String language) {
        final Preferences preferences = Preferences.getPreferences();
        this.cleanup();
        if (this.provider == null) {
            this.provider = StringUtil.equals((String)language, (String)"Python") ? new IcyCompletionProviderPython() : new IcyCompletionProvider();
            boolean autoActivate = preferences.isFullAutoCompleteEnabled();
            this.provider.setAutoActivationRules(autoActivate, ".");
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScriptingPanel.this.provider.setListCellRenderer((ListCellRenderer)((Object)new IcyCompletionCellRenderer()));
                }
            });
        }
        this.provider.clear();
        if (StringUtil.equals((String)language, (String)"JavaScript")) {
            this.setSyntax("text/javascript");
            this.ac = new JSAutoCompletion((CompletionProvider)this.provider);
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScriptingPanel.this.options.setRunButtonsEnabled(true);
                }
            });
        } else if (StringUtil.equals((String)language, (String)"Python")) {
            this.setSyntax("text/python");
            this.ac = new PythonAutoCompletion((CompletionProvider)this.provider);
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScriptingPanel.this.options.setRunButtonsEnabled(true);
                }
            });
        } else {
            this.setSyntax("text/plain");
            new AnnounceFrame("This language is not yet supported.");
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScriptingPanel.this.options.setRunButtonsEnabled(false);
                }
            });
            return;
        }
        this.provider.installDefaultCompletions(language);
        this.ac.install((JTextComponent)this.textArea);
        this.ac.setAutoCompleteSingleChoices(false);
        this.ac.setParameterAssistanceEnabled(true);
        this.ac.setAutoActivationEnabled(true);
        this.ac.setAutoActivationDelay(500);
        this.ac.setShowDescWindow(true);
        this.ac.setExternalURLHandler(new ExternalURLHandler(){

            public void urlClicked(HyperlinkEvent e, Completion c, DescWindowCallback callback) {
                if (e.getDescription().contentEquals("SourceCodeLink")) {
                    Class<?> clazz = null;
                    if (c instanceof BasicJavaClassCompletion) {
                        clazz = ((BasicJavaClassCompletion)c).getJavaClass();
                        ScriptingPanel.this.openSource(clazz);
                    } else if (c instanceof ScriptFunctionCompletion) {
                        ScriptFunctionCompletion sfc = (ScriptFunctionCompletion)c;
                        Method m = sfc.getMethod();
                        clazz = m.getDeclaringClass();
                        ClassSource cs = ClassSource.getClassSource(clazz);
                        MethodDeclaration md = cs.getMethods().get(m.toGenericString());
                        ScriptingPanel.this.openSource(clazz, md.getBeginLine() - 1, md.getEndLine() - 1);
                    } else if (c instanceof NewInstanceCompletion) {
                        Constructor<?> cons = ((NewInstanceCompletion)c).getConstructor();
                        clazz = cons.getDeclaringClass();
                        ClassSource cs = ClassSource.getClassSource(clazz);
                        ConstructorDeclaration cd = cs.getConstructors().get(cons.toGenericString());
                        if (cd != null) {
                            ScriptingPanel.this.openSource(clazz, cd.getBeginLine() - 1, cd.getEndLine() - 1);
                        } else {
                            System.out.println(clazz);
                        }
                    }
                } else {
                    System.out.println("Click:" + e.getDescription());
                }
            }
        });
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (StringUtil.equals((String)language, (String)"JavaScript")) {
                    ScriptingPanel.this.scriptHandler = new JSScriptingHandlerRhino((DefaultCompletionProvider)ScriptingPanel.this.provider, (JTextComponent)ScriptingPanel.this.textArea, ScriptingPanel.this.pane.getGutter(), true);
                } else if (StringUtil.equals((String)language, (String)"Python")) {
                    ScriptingPanel.this.scriptHandler = new PythonScriptingHandler((DefaultCompletionProvider)ScriptingPanel.this.provider, (JTextComponent)ScriptingPanel.this.textArea, ScriptingPanel.this.pane.getGutter(), true);
                } else {
                    ScriptingPanel.this.scriptHandler = null;
                }
                if (ScriptingPanel.this.scriptHandler != null) {
                    if (!ScriptingPanel.this.integrated && ScriptingPanel.this.consoleOutput != null) {
                        ScriptingPanel.this.scriptHandler.setOutput(ScriptingPanel.this.consoleOutput);
                    }
                    ScriptingPanel.this.scriptHandler.addScriptListener(ScriptingPanel.this);
                    ScriptingPanel.this.scriptHandler.setVarInterpretation(preferences.isVarInterpretationEnabled());
                    ScriptingPanel.this.scriptHandler.setStrict(preferences.isStrictModeEnabled());
                    ScriptingPanel.this.scriptHandler.setForceRun(preferences.isOverrideEnabled());
                    ScriptingPanel.this.provider.setHandler(ScriptingPanel.this.scriptHandler);
                    ScriptingPanel.this.textArea.addKeyListener((KeyListener)ScriptingPanel.this.scriptHandler);
                    PluginRepositoryLoader.addListener((PluginRepositoryLoader.PluginRepositoryLoaderListener)ScriptingPanel.this.scriptHandler);
                    BindingsScriptFrame frame = BindingsScriptFrame.getInstance();
                    frame.setEngine(ScriptingPanel.this.scriptHandler.getEngine());
                }
                ScriptingPanel.this.rebuildGUI();
                ScriptingPanel.this.textArea.requestFocus();
            }
        });
    }

    public void openSource(Class<?> clazz) {
        this.openSource(clazz, 0, 0);
    }

    public void openSource(Class<?> clazz, int lineBegin, int lineEnd) {
        InputStream jar = JarAccess.getJavaSourceInputStream(clazz);
        if (jar != null) {
            String res = null;
            try {
                byte[] b = new byte[jar.available()];
                jar.read(b);
                res = new String(b);
            }
            catch (IOException b) {
                // empty catch block
            }
            if (res == null) {
                return;
            }
            IcyFrame frame = new IcyFrame("Source code of: [" + clazz.getName() + "]", true, true, true, true);
            JPanel panel = new JPanel(new BorderLayout());
            final RSyntaxTextArea sourceTextArea = new RSyntaxTextArea(200, 200);
            sourceTextArea.setText(res);
            sourceTextArea.setSyntaxEditingStyle("text/java");
            sourceTextArea.setCodeFoldingEnabled(true);
            sourceTextArea.setAntiAliasingEnabled(true);
            sourceTextArea.setAutoIndentEnabled(true);
            sourceTextArea.setCloseCurlyBraces(true);
            sourceTextArea.setMarkOccurrences(true);
            sourceTextArea.setCodeFoldingEnabled(true);
            sourceTextArea.setPaintMarkOccurrencesBorder(true);
            sourceTextArea.setPaintMatchedBracketPair(true);
            sourceTextArea.setPaintTabLines(true);
            sourceTextArea.setTabsEmulated(false);
            try {
                Theme t = Theme.load((InputStream)PluginLoader.getLoader().getResourceAsStream("plugins/tprovoost/scripteditor/resources/themes/eclipse.xml"));
                t.apply(sourceTextArea);
            }
            catch (IOException t) {
                // empty catch block
            }
            RTextScrollPane paneSource = new RTextScrollPane((Component)sourceTextArea);
            panel.add((Component)paneSource);
            frame.setContentPane((Container)panel);
            frame.setSize(720, 640);
            frame.addToDesktopPane();
            frame.setVisible(true);
            int posCaretBegin = 0;
            int posCaretEnd = 0;
            try {
                posCaretBegin = sourceTextArea.getLineStartOffset(lineBegin);
                posCaretEnd = sourceTextArea.getLineStartOffset(lineEnd);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            sourceTextArea.getCaret().setDot(posCaretEnd);
            final int begin = posCaretBegin;
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ThreadUtil.sleep((int)100);
                    sourceTextArea.getCaret().setDot(begin);
                }
            });
        }
    }

    public ScriptingHandler getScriptHandler() {
        return this.scriptHandler;
    }

    public void setScriptHandler(ScriptingHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public boolean isDirty() {
        String currentText = this.textArea.getText();
        return this.saveFile == null && !currentText.isEmpty() || !this.saveFileString.contentEquals(currentText);
    }

    private void rebuildGUI() {
        this.removeAll();
        this.add((Component)this.pane);
        if (!this.integrated) {
            this.add((Component)this.options, "North");
        }
        this.revalidate();
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getLanguage() {
        return this.options.getLanguage();
    }

    public void openFile(File f) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String all = "";
        while ((line = reader.readLine()) != null) {
            all = String.valueOf(all) + line + "\n";
        }
        this.saveFile = f;
        this.saveFileString = all;
        this.textArea.setText(all);
        this.scriptHandler.setFileName(f.getAbsolutePath());
        reader.close();
    }

    public void openStream(InputStream stream) throws IOException {
        byte[] data = new byte[stream.available()];
        stream.read(data);
        String s = "";
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            s = String.valueOf(s) + (char)b;
            ++n2;
        }
        this.textArea.setText(s);
        stream.close();
        ThreadUtil.bgRun((Runnable)new Runnable(){

            @Override
            public void run() {
                while (ScriptingPanel.this.scriptHandler == null) {
                    ThreadUtil.sleep((int)1000);
                }
                ScriptingPanel.this.scriptHandler.autoDownloadPlugins();
            }
        });
    }

    @Override
    public void evaluationStarted() {
    }

    @Override
    public void evaluationOver() {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ScriptingPanel.this.options.setStopButtonEnabled(false);
            }
        });
    }

    public void displayGotoLine() {
        int min = 1;
        int max = this.textArea.getLineCount();
        String res = JOptionPane.showInputDialog((Component)Icy.getMainInterface().getMainFrame(), "Enter line number (" + min + "," + max + ")", "Go to Line", 3);
        try {
            int line = Integer.parseInt(res);
            this.textArea.setCaretPosition(this.textArea.getLineStartOffset(line - 1));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void format() {
        Preferences preferences = Preferences.getPreferences();
        RSyntaxTextArea textArea = this.getTextArea();
        if (preferences.isSoftTabsEnabled()) {
            textArea.convertTabsToSpaces();
        } else {
            textArea.convertSpacesToTabs();
        }
        this.getScriptHandler().format();
    }

    public void addFileDropListener(FileDrop.FileDropListener fileDropListener) {
        new FileDrop((Component)this.textArea, fileDropListener);
    }

    public void removeFileDropListeners() {
        FileDrop.remove((Component)this.textArea);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.textArea.addHyperlinkListener(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.textArea.removeHyperlinkListener(listener);
    }

    public void addLanguageListener(ItemListener listener) {
        this.options.addLanguageListener(listener);
    }

    public void removeLanguageListener(ItemListener listener) {
        this.options.removeLanguageListener(listener);
    }

    protected void runInNew() {
        this.runScript(true);
    }

    protected void runInSame() {
        this.runScript(false);
    }

    protected void runScript(boolean newEngine) {
        if (this.scriptHandler == null) {
            return;
        }
        if (!this.integrated && this.isDirty() && this.saveFile != null) {
            this.saveFile();
        }
        Preferences preferences = Preferences.getPreferences();
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ScriptingPanel.this.options.setStopButtonEnabled(true);
            }
        });
        if (!this.integrated) {
            this.scriptHandler.setNewEngine(newEngine);
            this.scriptHandler.setForceRun(preferences.isOverrideEnabled());
            this.scriptHandler.setStrict(preferences.isStrictModeEnabled());
            this.scriptHandler.setVarInterpretation(preferences.isVarInterpretationEnabled());
            this.scriptHandler.interpret(true);
        }
    }

    protected void stopScript() {
        if (this.scriptHandler == null) {
            return;
        }
        if (this.scriptHandler.isRunning()) {
            this.scriptHandler.killScript();
        }
    }

    public static interface SavedAsListener
    extends EventListener {
        public void savedAs(File var1);
    }

    public static interface TitleChangedListener
    extends EventListener {
        public void titleChanged(ScriptingPanel var1, String var2);
    }
}

