/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.tprovoost.scripteditor.scriptblock.JSScriptBlock;
import plugins.tprovoost.scripteditor.scriptblock.VarMutableScript;
import plugins.tprovoost.scripteditor.scriptblock.VarScript;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;
import plugins.tprovoost.scripteditor.scriptinghandlers.js.JSScriptEngine;

public class OldJavascript
extends Plugin
implements Block,
VarListListener,
TypeChangeListener {
    ArrayList<String> languagesInstalled = new ArrayList();
    private VarScript inputScript = new VarScript("", "// Click on the button\n// to edit in a frame.\n\noutput0 = input0 * 2");
    private VarList inputMap;
    private VarList outputMap;
    private int inputIdx = 0;
    private int outputIdx = 0;
    private VarTrigger triggerInput;
    private VarTrigger triggerOutput;
    private final TypeSelectionModel typeSelector = new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class});

    public OldJavascript() {
        for (ScriptEngineFactory f : ScriptEngineHandler.getEngineManager().getEngineFactories()) {
            this.languagesInstalled.add(ScriptEngineHandler.getLanguageName(f));
        }
    }

    public void run() {
        ScriptingHandler handler = this.inputScript.getEditor().getPanelIn().getScriptHandler();
        JSScriptEngine engine = (JSScriptEngine)handler.createNewEngine();
        for (Var var : this.inputMap) {
            Object value = var.getValue();
            String name = var.getName();
            if (!name.contains("input")) continue;
            value = JSScriptBlock.transformInputForScript(value);
            engine.put(name, value);
        }
        try {
            this.inputScript.evaluate();
        }
        catch (ScriptException e) {
            throw new IcyHandledException(e.getMessage());
        }
        for (Var output : this.outputMap) {
            Object resObject = engine.get(output.getName());
            output.setValue(JSScriptBlock.transformScriptOutput(resObject));
        }
    }

    public void declareInput(VarList inputMap) {
        if (this.inputMap == null) {
            this.inputMap = inputMap;
        }
        inputMap.addVarListListener((VarListListener)this);
        this.triggerInput = new VarTrigger("Add Input", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                OldJavascript.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                OldJavascript.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                String name = "input" + OldJavascript.this.inputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel((VarEditorModel)OldJavascript.this.typeSelector);
                myVariable.addTypeChangeListener(new TypeChangeListener(){

                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                        OldJavascript.this.registerVariables();
                    }
                });
                OldJavascript.this.inputMap.addRuntimeVariable("" + ((Object)((Object)myVariable)).hashCode(), (VarMutable)myVariable);
                OldJavascript.this.registerVariables();
            }
        }});
        this.triggerInput.setReferencingPolicy(VarReferencingPolicy.NONE);
        this.triggerOutput = new VarTrigger("Add output", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                OldJavascript.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                OldJavascript.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                String name = "output" + OldJavascript.this.outputIdx;
                VarMutableScript myVariable = new VarMutableScript(name, Object.class);
                myVariable.setDefaultEditorModel((VarEditorModel)OldJavascript.this.typeSelector);
                myVariable.addTypeChangeListener(new TypeChangeListener(){

                    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                        OldJavascript.this.registerVariables();
                    }
                });
                OldJavascript.this.outputMap.addRuntimeVariable("" + ((Object)((Object)myVariable)).hashCode(), (VarMutable)myVariable);
                OldJavascript.this.registerVariables();
            }
        }});
        this.triggerOutput.setReferencingPolicy(VarReferencingPolicy.NONE);
        this.inputScript.setReferencingPolicy(VarReferencingPolicy.NONE);
        inputMap.add("Script", (Var)this.inputScript);
        inputMap.add("Add Input", (Var)this.triggerInput);
        inputMap.add("Add output", (Var)this.triggerOutput);
        String name = "input" + this.inputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel((VarEditorModel)this.typeSelector);
        myVariable.addTypeChangeListener(this);
        inputMap.add(name, (Var)myVariable);
    }

    public void declareOutput(VarList outputMap) {
        this.outputMap = outputMap;
        outputMap.addVarListListener((VarListListener)this);
        String name = "output" + this.outputIdx;
        VarMutableScript myVariable = new VarMutableScript(name, Object.class);
        myVariable.setDefaultEditorModel((VarEditorModel)this.typeSelector);
        myVariable.addTypeChangeListener(this);
        outputMap.add(name, (Var)myVariable);
        this.registerVariables();
    }

    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
        this.registerVariables();
    }

    private void registerVariables() {
        final ScriptingHandler handlerIn = this.inputScript.getEditor().getPanelIn().getScriptHandler();
        final ScriptingHandler handlerOut = this.inputScript.getEditor().getPanelOut().getScriptHandler();
        HashMap<String, ScriptVariable> variablesInt = handlerIn.getExternalVariables();
        HashMap<String, ScriptVariable> variablesExt = handlerOut.getExternalVariables();
        variablesInt.clear();
        variablesExt.clear();
        if (this.inputMap != null) {
            for (Var v : this.inputMap) {
                if (!(v instanceof VarMutableScript) && !this.inputMap.isRuntimeVariable(v)) continue;
                variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
                variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            }
        }
        if (this.outputMap != null) {
            for (Var v : this.outputMap) {
                if (!(v instanceof VarMutableScript) && !this.outputMap.isRuntimeVariable(v)) continue;
                variablesInt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
                variablesExt.put(v.getName(), new ScriptVariable(new VariableType(v.getType())));
            }
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                handlerIn.interpret(false);
                handlerOut.interpret(false);
            }
        });
    }

    public void variableAdded(VarList list, Var<?> variable) {
        if (list == this.inputMap && variable != this.triggerInput && variable != this.inputScript && variable != this.triggerOutput) {
            ++this.inputIdx;
        } else if (list == this.outputMap) {
            ++this.outputIdx;
        }
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable) {
            VarMutable mutable = (VarMutable)variable;
            Class type = mutable.getType();
            mutable.setDefaultEditorModel((VarEditorModel)this.typeSelector);
            mutable.addTypeChangeListener((TypeChangeListener)this);
            mutable.setType(type);
        }
    }

    public void variableRemoved(VarList list, Var<?> variable) {
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable) {
            ((VarMutable)variable).removeTypeChangeListener((TypeChangeListener)this);
        }
        this.registerVariables();
    }
}

