/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock;

import icy.gui.component.button.IcyButton;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.resource.icon.IcyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;
import plugins.tprovoost.scripteditor.scriptblock.VarScript;

public class VarScriptEditorV3
extends SwingVarEditor<String> {
    protected ScriptingPanel panelOut;
    protected ScriptingPanel panelIn;
    protected IcyFrame frame;
    protected IcyFrameListener frameListener;

    public VarScriptEditorV3(VarScript varScript, String defaultValue) {
        super((Var)varScript);
        this.panelIn.getTextArea().setText(defaultValue);
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    protected JComponent createEditorComponent() {
        this.setNameVisible(false);
        this.panelIn = new ScriptingPanel("Internal Editor", "JavaScript");
        this.panelOut = new ScriptingPanel("External Editor", "JavaScript");
        this.panelOut.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.frame = new IcyFrame("External Editor", true, true, true, true);
        this.frame.setContentPane((Container)this.panelOut);
        this.frame.setSize(500, 500);
        this.frame.addToDesktopPane();
        this.frame.setDefaultCloseOperation(1);
        this.frame.center();
        this.frameListener = new IcyFrameAdapter(){

            public void icyFrameClosing(IcyFrameEvent e) {
                RSyntaxTextArea textArea = VarScriptEditorV3.this.panelIn.getTextArea();
                textArea.setEnabled(true);
                textArea.setText(VarScriptEditorV3.this.panelOut.getTextArea().getText());
                textArea.repaint();
            }
        };
        IcyButton buttonEdit = new IcyButton(new IcyIcon("redo.png", 12));
        buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarScriptEditorV3.this.panelOut.getTextArea().setText(VarScriptEditorV3.this.panelIn.getTextArea().getText());
                VarScriptEditorV3.this.panelIn.getTextArea().setEnabled(false);
                VarScriptEditorV3.this.frame.setVisible(true);
                VarScriptEditorV3.this.frame.requestFocus();
            }
        });
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new BoxLayout(eastPanel, 1));
        eastPanel.add(Box.createVerticalGlue());
        eastPanel.add((Component)buttonEdit);
        eastPanel.add(Box.createVerticalGlue());
        eastPanel.setOpaque(false);
        JPanel toReturn = new JPanel(new BorderLayout());
        toReturn.add((Component)this.panelIn, "Center");
        toReturn.setOpaque(false);
        toReturn.add((Component)eastPanel, "East");
        this.setComponentResizeable(true);
        this.panelIn.getTextArea().setCaretPosition(0);
        this.panelOut.getTextArea().setCaretPosition(0);
        return toReturn;
    }

    public double getComponentVerticalResizeFactor() {
        return 1.0;
    }

    protected void activateListeners() {
        this.frame.addFrameListener(this.frameListener);
    }

    protected void deactivateListeners() {
        this.frame.removeFrameListener(this.frameListener);
        this.frame.close();
    }

    protected void updateInterfaceValue() {
    }

    public String getText() {
        if (this.panelIn == null || this.panelIn.getTextArea() == null) {
            return (String)this.getVariable().getDefaultValue();
        }
        return this.panelIn.getTextArea().getText();
    }

    public void setText(String newValue) {
        this.panelOut.getTextArea().setText(newValue);
        this.panelIn.getTextArea().setText(newValue);
    }

    public ScriptingPanel getPanelIn() {
        return this.panelIn;
    }

    public ScriptingPanel getPanelOut() {
        return this.panelOut;
    }
}

