/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import java.io.PrintWriter;
import java.util.HashMap;
import javax.script.ScriptException;

public abstract class ScriptEngine {
    protected HashMap<String, Object> bindings = new HashMap();
    private PrintWriter pw = new PrintWriter(System.out);
    private PrintWriter pwE = new PrintWriter(System.err);

    protected ScriptEngine() {
    }

    public void setWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void setErrorWriter(PrintWriter pwE) {
        this.pwE = pwE;
    }

    public abstract void eval(String var1) throws ScriptException;

    public abstract void evalFile(String var1) throws ScriptException;

    public PrintWriter getWriter() {
        return this.pw;
    }

    public PrintWriter getErrorWriter() {
        return this.pwE;
    }

    public abstract String getName();

    public void clear() {
        HashMap<String, Object> bindings = this.getBindings();
        for (String s : bindings.keySet()) {
            bindings.put(s, null);
        }
        bindings.clear();
    }

    protected abstract void putInRealEngine(String var1, Object var2);

    protected abstract void removeFromRealEngine(String var1);

    public void put(String name, Object value) {
        this.putInRealEngine(name, value);
        this.bindings.put(name, value);
    }

    public void deleteBinding(String name) {
        this.put(name, null);
        this.bindings.remove(name);
        this.removeFromRealEngine(name);
    }

    public Object get(String name) {
        return this.bindings.get(name);
    }

    public HashMap<String, Object> getBindings() {
        return this.bindings;
    }
}

