/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import icy.gui.frame.progress.ProgressFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.classloader.JarClassLoader;
import icy.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.script.ScriptEngineFactory;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineManager;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;
import plugins.tprovoost.scripteditor.scriptinghandlers.js.JSScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.py.PyScriptEngine;

public class ScriptEngineHandler
implements PluginInstaller.PluginInstallerListener {
    private static final HashMap<String, ScriptEngine> engines = new HashMap();
    public static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private static HashMap<ScriptEngine, ScriptEngineHandler> engineHandlers = new HashMap();
    private static ScriptEngineHandler lastEngineHandler = null;
    private static ArrayList<Method> bindingFunctions;
    private static ArrayList<String> allClasses;
    private HashMap<String, VariableType> engineVariables = new HashMap();
    private HashMap<String, VariableType> engineFunctions = new HashMap();
    private ArrayList<String> engineDeclaredImports = new ArrayList();
    private ArrayList<String> engineDeclaredImportClasses = new ArrayList();
    private HashMap<Class<?>, ArrayList<ScriptFunctionCompletion>> engineTypesMethod = new HashMap();

    static {
        allClasses = new ArrayList();
    }

    private ScriptEngineHandler() {
        if (bindingFunctions == null) {
            bindingFunctions = new ArrayList();
            this.findBindingMethodsPlugins();
        }
    }

    public static ScriptEngineHandler getLastEngineHandler() {
        return lastEngineHandler;
    }

    public static void setEngine(String engineType, ScriptEngine engine) {
        engines.put(engineType, engine);
    }

    public static ScriptEngineHandler getEngineHandler(ScriptEngine engine) {
        ScriptEngineHandler engineHandler = engineHandlers.get(engine);
        if (engineHandler == null) {
            engineHandler = new ScriptEngineHandler();
            engineHandlers.put(engine, engineHandler);
        }
        lastEngineHandler = engineHandler;
        return engineHandler;
    }

    public static ScriptEngine getEngine(String engineType) {
        return ScriptEngineHandler.getEngine(engineType, false);
    }

    public static ScriptEngine getEngine(String engineType, boolean create) {
        String engineTypeL = engineType.toLowerCase();
        ScriptEngine engineHash = engines.get(engineTypeL);
        if (engineHash == null || create) {
            if (engineTypeL.contentEquals("javascript")) {
                engineHash = new JSScriptEngine();
                engines.put(engineTypeL, engineHash);
            } else if (engineTypeL.contentEquals("python")) {
                engineHash = new PyScriptEngine();
                engines.put(engineTypeL, engineHash);
            }
        }
        return engineHash;
    }

    public static void disposeEngine(ScriptEngine engine) {
        engine.clear();
        engineHandlers.remove(engine);
    }

    public ArrayList<String> getEngineDeclaredImportClasses() {
        return this.engineDeclaredImportClasses;
    }

    public ArrayList<String> getEngineDeclaredImports() {
        return this.engineDeclaredImports;
    }

    public HashMap<String, VariableType> getEngineFunctions() {
        return this.engineFunctions;
    }

    public HashMap<String, VariableType> getEngineVariables() {
        return this.engineVariables;
    }

    public HashMap<Class<?>, ArrayList<ScriptFunctionCompletion>> getEngineTypesMethod() {
        return this.engineTypesMethod;
    }

    public static ScriptEngineManager getEngineManager() {
        return engineManager;
    }

    private void findBindingMethodsPlugins() {
        try (ProgressFrame frame = Icy.getMainInterface().isHeadLess() ? null : new ProgressFrame("Loading functions...");){
            try {
                allClasses.addAll(ClassUtil.findClassNamesInPackage((String)"icy", (boolean)true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.getClass().getClassLoader() instanceof JarClassLoader) {
                Collection col = PluginLoader.getLoadedClasses().values();
                if (frame != null) {
                    frame.setLength((double)col.size());
                }
                int i = 0;
                for (Class clazz : new ArrayList(col)) {
                    this.findBindingsMethods(clazz);
                    allClasses.add(clazz.getName());
                    ++i;
                    if (frame == null) continue;
                    frame.setPosition((double)i);
                }
            } else {
                ArrayList list = PluginLoader.getPlugins();
                if (frame != null) {
                    frame.setLength((double)list.size());
                }
                int i = 0;
                for (PluginDescriptor pd : list) {
                    Class clazz = pd.getPluginClass();
                    this.findBindingsMethods(clazz);
                    allClasses.add(clazz.getName());
                    ++i;
                    if (frame == null) continue;
                    frame.setPosition((double)i);
                }
            }
            Collections.sort(allClasses);
        }
    }

    public void findBindingsMethods(Class<?> clazz) {
        Method[] methods;
        if (clazz == null) {
            return;
        }
        try {
            methods = clazz.getDeclaredMethods();
        }
        catch (Error e) {
            return;
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptFunctionCompletion.BindingFunction blockFunction;
            Method method = methodArray[n2];
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && (blockFunction = method.getAnnotation(ScriptFunctionCompletion.BindingFunction.class)) != null) {
                bindingFunctions.add(method);
                ArrayList<ParameterizedCompletion.Parameter> fParams = new ArrayList<ParameterizedCompletion.Parameter>();
                Class<?>[] paramTypes = method.getParameterTypes();
                String params = "";
                String functionName = blockFunction.value();
                int i = 0;
                while (i < paramTypes.length) {
                    fParams.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(paramTypes[i], true), "arg" + i));
                    params = String.valueOf(params) + ",arg" + i;
                    ++i;
                }
                if (params.length() > 0) {
                    params = params.substring(1);
                }
                ScriptFunctionCompletion sfc = Modifier.isStatic(method.getModifiers()) ? new ScriptFunctionCompletion(null, functionName, method) : new ScriptFunctionCompletion(null, method.getName(), method);
                sfc.setDefinedIn(clazz.getName());
                sfc.setParams(fParams);
                sfc.setRelevance(2);
                if (this.engineFunctions != null) {
                    Class<?> returnType = method.getReturnType();
                    if (VariableType.isGeneric(returnType)) {
                        this.engineFunctions.put(functionName, new VariableType(returnType, VariableType.getType(method.getGenericReturnType().toString())));
                    } else {
                        this.engineFunctions.put(functionName, new VariableType(returnType));
                    }
                }
                if (this.engineTypesMethod != null) {
                    ArrayList<ScriptFunctionCompletion> methodsExisting = this.engineTypesMethod.get(clazz);
                    if (methodsExisting == null) {
                        methodsExisting = new ArrayList();
                    }
                    if (methodsExisting.contains((Object)sfc)) {
                        methodsExisting.remove((Object)sfc);
                    }
                    methodsExisting.add(sfc);
                    this.engineTypesMethod.put(clazz, methodsExisting);
                }
            }
            ++n2;
        }
    }

    public ArrayList<Method> getFunctions() {
        return bindingFunctions;
    }

    public void pluginInstalled(PluginDescriptor plugin, boolean success) {
        if (success) {
            bindingFunctions.clear();
            this.engineFunctions.clear();
            this.engineTypesMethod.clear();
            allClasses.clear();
            this.findBindingMethodsPlugins();
        }
    }

    public void pluginRemoved(PluginDescriptor plugin, boolean success) {
        if (success) {
            bindingFunctions.clear();
            this.engineFunctions.clear();
            this.engineTypesMethod.clear();
            allClasses.clear();
            this.findBindingMethodsPlugins();
        }
    }

    public static ArrayList<String> getAllClasses() {
        return allClasses;
    }

    public static String getLanguageName(ScriptEngineFactory factory) {
        String languageName = factory.getLanguageName();
        if (languageName.contentEquals("ECMAScript")) {
            return "JavaScript";
        }
        if (languageName.contentEquals("python")) {
            return "Python";
        }
        return languageName;
    }

    public static void clearEngines() {
        for (ScriptEngine engine : engines.values()) {
            ScriptEngineHandler.disposeEngine(engine);
        }
        engines.clear();
    }
}

