/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.uitools.userdialogs;

import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import plugins.tprovoost.scripteditor.uitools.userdialogs.Item;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemCheckbox;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemCombo;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemMessage;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemNumber;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemSlider;
import plugins.tprovoost.scripteditor.uitools.userdialogs.ItemString;

public class Dialog {
    private static final int DEFAULT_COLUMN_SIZE = 8;
    private ArrayList<Item> listItems = new ArrayList();
    private LinkedList<Item> listNumbers = new LinkedList();
    private LinkedList<Item> listStrings = new LinkedList();
    private LinkedList<Item> listcboxes = new LinkedList();
    private LinkedList<Item> listChoices = new LinkedList();
    private boolean ok = false;
    private JDialog dialog;
    private boolean working;

    public Dialog(final String name) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Dialog.this.dialog = new JDialog((Frame)Icy.getMainInterface().getMainFrame(), name);
            }
        });
    }

    public void addNumber(String label, double defaultValue) {
        this.addNumber(label, defaultValue, 8, "");
    }

    public void addNumber(final String label, final double defaultValue, final int columns, final String unit) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemNumber item = new ItemNumber(label, defaultValue, columns, unit);
                Dialog.this.listItems.add(item);
                Dialog.this.listNumbers.add(item);
            }
        });
    }

    public void show() {
        if (this.isWorking()) {
            return;
        }
        this.setWorking(true);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Dialog.this.dialog.setModal(true);
                JPanel panelMiddle = new JPanel();
                panelMiddle.setLayout(new BoxLayout(panelMiddle, 1));
                for (Item item : Dialog.this.listItems) {
                    panelMiddle.add(item);
                }
                JPanel panelSouth = new JPanel();
                panelSouth.setLayout(new BoxLayout(panelSouth, 0));
                JButton btnOK = new JButton("OK");
                btnOK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.ok = true;
                        Dialog.this.dialog.setVisible(false);
                    }
                });
                JButton btnCancel = new JButton("Cancel");
                btnCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Dialog.this.ok = false;
                        Dialog.this.dialog.setVisible(false);
                    }
                });
                panelSouth.add(Box.createHorizontalGlue());
                panelSouth.add(btnOK);
                panelSouth.add(Box.createHorizontalStrut(4));
                panelSouth.add(btnCancel);
                JPanel contentPane = new JPanel(new BorderLayout());
                contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contentPane.add((Component)panelMiddle, "Center");
                contentPane.add((Component)panelSouth, "South");
                Dialog.this.dialog.setContentPane(contentPane);
                Dialog.this.dialog.pack();
                Dialog.this.dialog.setLocationRelativeTo((Component)Icy.getMainInterface().getMainFrame());
                Dialog.this.dialog.setVisible(true);
                Dialog.this.dialog = null;
                Dialog.this.setWorking(false);
            }
        });
    }

    public boolean getResult() {
        while (this.isWorking()) {
            ThreadUtil.sleep((int)100);
        }
        return this.ok;
    }

    public void addMessage(String label) {
        this.listItems.add(new ItemMessage(label));
    }

    public void addString(final String label, final String initialText) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemString item = new ItemString(label, initialText);
                Dialog.this.listItems.add(item);
                Dialog.this.listStrings.add(item);
            }
        });
    }

    public void addString(final String label, final String initialText, final int columns) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemString item = new ItemString(label, initialText, columns);
                Dialog.this.listItems.add(item);
                Dialog.this.listStrings.add(item);
            }
        });
    }

    public void addSlider(final String label, final int min, final int max, final int defaultValue) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemSlider item = new ItemSlider(label, min, max, defaultValue);
                Dialog.this.listItems.add(item);
                Dialog.this.listNumbers.add(item);
            }
        });
    }

    public void addCheckbox(final String label, final boolean defaultValue) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemCheckbox item = new ItemCheckbox(label, defaultValue);
                Dialog.this.listItems.add(item);
                Dialog.this.listcboxes.add(item);
            }
        });
    }

    public void addChoice(String label, String[] items) {
        this.addChoice(label, items, items[0]);
    }

    public void addChoice(final String label, final String[] items, final String defaultValue) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ItemCombo item = new ItemCombo(label, items, defaultValue);
                Dialog.this.listItems.add(item);
                Dialog.this.listChoices.add(item);
            }
        });
    }

    public Number getNumber() {
        return (Number)this.listNumbers.pop().getValue();
    }

    public String getString() {
        return (String)this.listStrings.pop().getValue();
    }

    public Boolean getCheckBox() {
        return (Boolean)this.listcboxes.pop().getValue();
    }

    public String getChoice() {
        return (String)this.listChoices.pop().getValue();
    }

    private boolean isWorking() {
        return this.working;
    }

    private synchronized void setWorking(boolean working) {
        this.working = working;
    }
}

