/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion;

import icy.gui.frame.progress.ProgressFrame;
import icy.plugin.PluginLoader;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.autocomplete.VariableCompletion;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.JavaFunctionCompletion;
import plugins.tprovoost.scripteditor.completion.types.NewInstanceCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;
import plugins.tprovoost.scripteditor.scriptinghandlers.IcyFunctionBlock;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public class IcyCompletionProvider
extends DefaultCompletionProvider {
    protected ScriptingHandler handler;
    protected boolean advanced = true;
    private static Comparator<Completion> comparatorFull = new Comparator<Completion>(){

        @Override
        public int compare(Completion c1, Completion c2) {
            int compare = Integer.valueOf(c2.getRelevance()).compareTo(c1.getRelevance());
            if (compare == 0) {
                return c1.getInputText().compareTo(c2.getInputText());
            }
            return compare;
        }
    };

    public void setHandler(ScriptingHandler handler) {
        this.handler = handler;
    }

    public void installMethods(ArrayList<Method> methods) {
        for (Method method : methods) {
            ScriptFunctionCompletion.BindingFunction blockFunction;
            Class<?> clazz = method.getDeclaringClass();
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || (blockFunction = method.getAnnotation(ScriptFunctionCompletion.BindingFunction.class)) == null) continue;
            ArrayList<ParameterizedCompletion.Parameter> fParams = new ArrayList<ParameterizedCompletion.Parameter>();
            Class<?>[] paramTypes = method.getParameterTypes();
            String params = "";
            String functionName = blockFunction.value();
            int i = 0;
            while (i < paramTypes.length) {
                fParams.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(paramTypes[i], true), "arg" + i));
                params = String.valueOf(params) + ",arg" + i;
                ++i;
            }
            if (params.length() > 0) {
                params = params.substring(1);
            }
            ScriptFunctionCompletion sfc = Modifier.isStatic(method.getModifiers()) ? new ScriptFunctionCompletion((CompletionProvider)this, functionName, method) : new ScriptFunctionCompletion((CompletionProvider)this, method.getName(), method);
            sfc.setDefinedIn(clazz.getName().replace('$', '.'));
            if (method.getAnnotation(Deprecated.class) != null) {
                sfc.setShortDescription("deprecated");
            }
            sfc.setParams(fParams);
            sfc.setRelevance(2);
            List list = this.getCompletionByInputText(functionName);
            if (list != null) {
                this.removeCompletion((Completion)list.get(0));
            }
            this.addCompletion((Completion)sfc);
            list = this.getCompletionByInputText(clazz.getName());
            if (list != null) continue;
            this.addCompletion((Completion)new BasicJavaClassCompletion((CompletionProvider)this, clazz));
        }
    }

    @Deprecated
    public void findAllMethods(ScriptEngine engine, ProgressFrame frame) {
        ArrayList<String> clazzes;
        ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(engine);
        HashMap<String, VariableType> listFunction = engineHandler.getEngineFunctions();
        HashMap<Class<?>, ArrayList<ScriptFunctionCompletion>> engineTypesMethod = engineHandler.getEngineTypesMethod();
        try {
            clazzes = this.getClassNamesFromPackage("icy");
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        if (frame != null) {
            frame.setLength((double)clazzes.size());
        }
        Collections.sort(clazzes);
        int idxClass = 0;
        while (idxClass < clazzes.size()) {
            if (frame != null) {
                frame.setPosition((double)idxClass);
            }
            String className = clazzes.get(idxClass).replace('/', '.');
            try {
                Method[] methods;
                Class<?> clazz = Class.forName(className);
                Method[] methodArray = methods = clazz.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    ArrayList<ParameterizedCompletion.Parameter> fParams = new ArrayList<ParameterizedCompletion.Parameter>();
                    Class<?>[] paramTypes = method.getParameterTypes();
                    int i = 0;
                    while (i < paramTypes.length) {
                        fParams.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(paramTypes[i], true), "arg" + i));
                        ++i;
                    }
                    ScriptFunctionCompletion sfc = new ScriptFunctionCompletion((CompletionProvider)this, method.getName(), method);
                    sfc.setDefinedIn(clazz.getName().replace('$', '.'));
                    sfc.setParams(fParams);
                    ScriptFunctionCompletion.BindingFunction blockFunction = method.getAnnotation(ScriptFunctionCompletion.BindingFunction.class);
                    if (blockFunction == null) {
                        sfc.setRelevance(2);
                    } else {
                        sfc.setRelevance(4);
                    }
                    this.addCompletion((Completion)sfc);
                    if (this.getCompletionByInputText(clazz.getName()) == null) {
                        this.addCompletion((Completion)new BasicJavaClassCompletion((CompletionProvider)this, clazz));
                    }
                    if (listFunction != null) {
                        Class<?> returnType = method.getReturnType();
                        if (VariableType.isGeneric(returnType)) {
                            listFunction.put(sfc.getMethodCall().substring("packages.".length()), new VariableType(returnType, VariableType.getType(method.getGenericReturnType().toString())));
                        } else {
                            listFunction.put(sfc.getMethodCall().substring("packages.".length()), new VariableType(returnType));
                        }
                    }
                    if (engineTypesMethod != null) {
                        ArrayList<ScriptFunctionCompletion> methodsExisting = engineTypesMethod.get(clazz);
                        if (methodsExisting == null) {
                            methodsExisting = new ArrayList();
                        }
                        methodsExisting.add(sfc);
                        engineTypesMethod.put(clazz, methodsExisting);
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++idxClass;
        }
    }

    public List<Completion> getCompletions(JTextComponent comp) {
        List<Completion> originalList = this.getCompletionsImpl(comp);
        ArrayList<Completion> toReturn = new ArrayList<Completion>();
        ArrayList<Completion> inScriptVariables = new ArrayList<Completion>();
        ArrayList inScriptBasic = new ArrayList();
        ArrayList<FunctionCompletion> inScriptFunctions = new ArrayList<FunctionCompletion>();
        ArrayList<Completion> variables = new ArrayList<Completion>();
        ArrayList<Completion> basic = new ArrayList<Completion>();
        ArrayList<Completion> functions = new ArrayList<Completion>();
        for (Completion c : new ArrayList<Completion>(originalList)) {
            BasicCompletion c2;
            FunctionCompletion co;
            String res;
            String rText = c.getReplacementText();
            int previousDotIdx = 0;
            int nextDotIdx = -1;
            if (c instanceof FunctionCompletion) {
                if (previousDotIdx == 0 && nextDotIdx == -1) {
                    if (!IcyCompletionProvider.isFunctionAlreadyDeclared((FunctionCompletion)c, functions)) {
                        functions.add(c);
                    }
                } else if (nextDotIdx == -1) {
                    FunctionCompletion coDuplicate;
                    res = rText.substring(previousDotIdx);
                    co = (FunctionCompletion)c;
                    if (co instanceof JavaFunctionCompletion) {
                        if (co instanceof ScriptFunctionCompletion) {
                            coDuplicate = new ScriptFunctionCompletion(c.getProvider(), co.getName(), ((ScriptFunctionCompletion)co).getMethod());
                        } else if (co instanceof NewInstanceCompletion) {
                            coDuplicate = new NewInstanceCompletion(c.getProvider(), co.getName(), ((NewInstanceCompletion)co).getConstructor());
                        } else {
                            coDuplicate = null;
                            System.out.println("Unsupported JavaFunctionCompletion Type.");
                        }
                        if (((JavaFunctionCompletion)co).isPopulateDone()) {
                            coDuplicate.setSummary(co.getSummary());
                        }
                    } else {
                        coDuplicate = new FunctionCompletion(c.getProvider(), res, co.getType());
                        coDuplicate.setSummary(co.getSummary());
                    }
                    coDuplicate.setShortDescription(co.getShortDescription());
                    coDuplicate.setReturnValueDescription(co.getReturnValueDescription());
                    coDuplicate.setDefinedIn(co.getDefinedIn());
                    coDuplicate.setRelevance(co.getRelevance());
                    ArrayList<ParameterizedCompletion.Parameter> parameters = new ArrayList<ParameterizedCompletion.Parameter>();
                    int i = 0;
                    while (i < co.getParamCount()) {
                        parameters.add(co.getParam(i));
                        ++i;
                    }
                    if (c instanceof ScriptFunctionCompletion) {
                        inScriptFunctions.add(coDuplicate);
                    } else if (!IcyCompletionProvider.isFunctionAlreadyDeclared(coDuplicate, functions)) {
                        functions.add((Completion)coDuplicate);
                    }
                } else {
                    res = rText.substring(previousDotIdx, nextDotIdx);
                    c2 = this.duplicateBasicCompletion((BasicCompletion)c, res);
                    if (!IcyCompletionProvider.exists((Completion)c2, basic)) {
                        basic.add((Completion)c2);
                    }
                }
                originalList.remove(c);
                continue;
            }
            if (c instanceof VariableCompletion) {
                if (previousDotIdx == 0 && nextDotIdx == -1) {
                    if (c instanceof ScriptFunctionCompletion) {
                        inScriptVariables.add(c);
                    } else {
                        variables.add(c);
                    }
                } else if (nextDotIdx == -1) {
                    res = rText.substring(previousDotIdx);
                    co = (VariableCompletion)c;
                    VariableCompletion c22 = new VariableCompletion(co.getProvider(), res, co.getType());
                    c22.setDefinedIn(co.getDefinedIn());
                    c22.setShortDescription(co.getShortDescription());
                    c22.setSummary(co.getSummary());
                    c22.setRelevance(co.getRelevance());
                    if (!IcyCompletionProvider.isFunctionAlreadyDeclared((FunctionCompletion)c22, variables)) {
                        variables.add((Completion)c22);
                    }
                } else {
                    res = rText.substring(previousDotIdx, nextDotIdx);
                    c2 = this.duplicateBasicCompletion((BasicCompletion)c, res);
                    if (!IcyCompletionProvider.isFunctionAlreadyDeclared((FunctionCompletion)c2, basic)) {
                        basic.add((Completion)c2);
                    }
                }
                originalList.remove(c);
                continue;
            }
            if (!(c instanceof BasicCompletion)) continue;
            if (previousDotIdx == 0 && nextDotIdx == -1) {
                basic.add(c);
            } else {
                res = nextDotIdx == -1 ? rText.substring(previousDotIdx) : rText.substring(previousDotIdx, nextDotIdx);
                c2 = this.duplicateBasicCompletion((BasicCompletion)c, res);
                if (!IcyCompletionProvider.exists((Completion)c2, basic)) {
                    basic.add((Completion)c2);
                }
            }
            originalList.remove(c);
        }
        toReturn.addAll(inScriptVariables);
        toReturn.addAll(inScriptFunctions);
        toReturn.addAll(inScriptBasic);
        toReturn.addAll(variables);
        toReturn.addAll(functions);
        toReturn.addAll(basic);
        toReturn.addAll(originalList);
        Collections.sort(toReturn, comparatorFull);
        return toReturn;
    }

    protected boolean isValidChar(char ch) {
        return super.isValidChar(ch) || ch == '\"';
    }

    protected boolean isValidCharStrict(char ch) {
        return this.isValidCharStrict(ch, false);
    }

    protected boolean isValidCharStrict(char ch, boolean weirdChars) {
        if (weirdChars) {
            return super.isValidChar(ch) || ch == '.' || ch == '(' || ch == ')' || ch == ',' || ch == '\"' || ch == '[' || ch == ']';
        }
        return super.isValidChar(ch) || ch == '.' || ch == '[' || ch == ']';
    }

    public static boolean exists(Completion c, List<Completion> list) {
        boolean found = false;
        for (Completion ctmp : list) {
            if (!ctmp.getReplacementText().contentEquals(c.getReplacementText())) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean isFunctionAlreadyDeclared(FunctionCompletion fc, List<Completion> completions) {
        if (completions.isEmpty()) {
            return false;
        }
        boolean alreadyDeclared = false;
        int i = 0;
        while (i < completions.size() && !alreadyDeclared) {
            FunctionCompletion fctmp;
            Completion c = completions.get(i);
            if (fc.getReplacementText().contentEquals(c.getReplacementText()) && c instanceof FunctionCompletion && (fctmp = (FunctionCompletion)c).getParamCount() == fc.getParamCount()) {
                boolean different = false;
                int paramIdx = 0;
                while (paramIdx < fctmp.getParamCount()) {
                    if (!different && fctmp.getParam(paramIdx).getType() != fc.getParam(paramIdx).getType()) {
                        different = true;
                    }
                    ++paramIdx;
                }
                if (!different) {
                    alreadyDeclared = true;
                }
            }
            ++i;
        }
        return alreadyDeclared;
    }

    public BasicCompletion duplicateBasicCompletion(BasicCompletion c, String res) {
        Object c2;
        BasicCompletion co = c;
        if (co instanceof BasicJavaClassCompletion) {
            BasicJavaClassCompletion basicJavaCO = (BasicJavaClassCompletion)co;
            c2 = new BasicJavaClassCompletion(c.getProvider(), basicJavaCO.getJavaClass());
            if (basicJavaCO.isParsingDone()) {
                c2.setSummary(co.getSummary());
            }
        } else {
            c2 = new BasicCompletion(c.getProvider(), res);
            c2.setSummary(co.getSummary());
        }
        c2.setRelevance(co.getRelevance());
        return c2;
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        ArrayList<Completion> retVal = new ArrayList<Completion>();
        String text = this.getAlreadyEnteredTextWithFunc(comp);
        int lastIdx = text.lastIndexOf(46);
        ScriptEngineHandler engineHandler = ScriptEngineHandler.getLastEngineHandler();
        HashMap<String, VariableType> engineVariables = ScriptEngineHandler.getLastEngineHandler().getEngineVariables();
        HashMap<Class<?>, ArrayList<ScriptFunctionCompletion>> engineTypesMethod = engineHandler.getEngineTypesMethod();
        HashMap<Integer, IcyFunctionBlock> localFunctions = this.handler != null ? this.handler.getBlockFunctions() : new HashMap();
        if (text != null) {
            boolean containsNew;
            if (text.contains("(")) {
                int idx;
                String text2 = String.copyValueOf(text.toCharArray());
                int i = 0;
                int pOpen = 0;
                int pClose = 0;
                while (i < text2.length() - 1 && (idx = text2.indexOf(40, i)) != -1) {
                    ++pOpen;
                    i += idx + 1;
                }
                i = 0;
                while (i < text2.length() - 1 && (idx = text2.indexOf(41, i)) != -1) {
                    ++pClose;
                    i += idx + 1;
                }
                int ppCount = pOpen - pClose;
                if (ppCount > 0) {
                    text = text2.substring(text2.lastIndexOf(40) + 1);
                    lastIdx = text.lastIndexOf(46);
                }
            }
            if (containsNew = text.contains("new ")) {
                if ((text = text.substring("new ".length())).length() > 0 && Character.isUpperCase(text.charAt(0))) {
                    ArrayList<String> classes = ScriptEngineHandler.getAllClasses();
                    for (String s : classes) {
                        String nameFinal = ClassUtil.getSimpleClassName((String)s);
                        int idxD = nameFinal.indexOf(36);
                        if (idxD != -1) {
                            nameFinal = nameFinal.substring(idxD + 1, nameFinal.length());
                        }
                        if (!nameFinal.toLowerCase().startsWith(text.toLowerCase())) continue;
                        try {
                            Class clazz = ClassUtil.findClass((String)s);
                            if (Modifier.isStatic(clazz.getModifiers())) continue;
                            Constructor<?>[] constructorArray = clazz.getConstructors();
                            int n = constructorArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Constructor<?> c = constructorArray[n2];
                                int mod = c.getModifiers();
                                if (Modifier.isPublic(mod)) {
                                    NewInstanceCompletion fc = new NewInstanceCompletion((CompletionProvider)this, nameFinal, c);
                                    fc.setRelevance(10);
                                    fc.setDefinedIn(clazz.toString().replace('$', '.'));
                                    ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
                                    int i = 0;
                                    Class<?>[] classArray = c.getParameterTypes();
                                    int n3 = classArray.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Class<?> clazzParam = classArray[n4];
                                        params.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(clazzParam, true), "arg" + i));
                                        ++i;
                                        ++n4;
                                    }
                                    fc.setParams(params);
                                    retVal.add((Completion)fc);
                                }
                                ++n2;
                            }
                        }
                        catch (ClassNotFoundException clazz) {
                            // empty catch block
                        }
                    }
                }
            } else if (text.isEmpty() || lastIdx == -1) {
                this.doClassicCompletion(text, retVal);
            } else {
                if (text.startsWith("Packages.")) {
                    String clazzWanted = text.substring("Packages.".length());
                    ArrayList<String> classes = ScriptEngineHandler.getAllClasses();
                    for (String s : classes) {
                        int endOffset;
                        if (!(s = s.replace('$', '.')).toLowerCase().startsWith(clazzWanted.toLowerCase())) continue;
                        int startOffset = clazzWanted.lastIndexOf(46);
                        BasicCompletion c = startOffset != -1 ? ((endOffset = s.indexOf(46, startOffset + 1)) != -1 ? new BasicCompletion((CompletionProvider)this, s.substring(startOffset + 1, endOffset)) : new BasicCompletion((CompletionProvider)this, s.substring(startOffset + 1, s.length()))) : ((endOffset = s.indexOf(46, 0)) != -1 ? new BasicCompletion((CompletionProvider)this, s.substring(0, endOffset)) : new BasicCompletion((CompletionProvider)this, s));
                        c.setRelevance(1);
                        if (IcyCompletionProvider.exists((Completion)c, retVal)) continue;
                        retVal.add((Completion)c);
                    }
                }
                if (this.handler != null) {
                    VariableType type;
                    String command;
                    if (lastIdx != -1) {
                        command = text.substring(0, lastIdx);
                        if (lastIdx <= text.length() - 1) {
                            text = text.substring(lastIdx + 1, text.length());
                        }
                    } else {
                        command = text;
                    }
                    ArrayList<ScriptFunctionCompletion> methods = null;
                    Class<?> clazz = this.handler.resolveClassDeclaration(command.replace('.', '$'));
                    if (clazz != null) {
                        if (containsNew) {
                            this.populateWithConstructors(clazz, retVal);
                        } else {
                            methods = engineTypesMethod.get(clazz);
                            if (methods != null && !this.advanced) {
                                for (ScriptFunctionCompletion complete : methods) {
                                    if (!complete.isStatic() || !text.isEmpty() && !complete.getName().toLowerCase().startsWith(text.toLowerCase())) continue;
                                    retVal.add(this.generateSFCCopy(complete, true));
                                }
                            } else {
                                this.populateClassTypes(new VariableType(clazz), text, retVal, true);
                            }
                        }
                    }
                    if ((type = this.handler.getVariableDeclaration(command)) != null && type.getClazz() != null || (type = engineVariables.get(command)) != null && type.getClazz() != null) {
                        methods = engineTypesMethod.get(clazz);
                        if (methods != null && !this.advanced) {
                            for (ScriptFunctionCompletion complete : methods) {
                                if (!complete.getName().toLowerCase().startsWith(text.toLowerCase())) continue;
                                if (complete.isStatic()) {
                                    complete.setRelevance(2);
                                } else if (!complete.isStatic()) {
                                    complete.setRelevance(10);
                                }
                                if (!text.isEmpty() && !complete.getName().toLowerCase().startsWith(text.toLowerCase())) continue;
                                retVal.add(this.generateSFCCopy(complete));
                            }
                        } else {
                            this.populateClassTypes(type, text, retVal);
                        }
                    } else {
                        int startOffset = this.getStartOffset(comp) - 1;
                        IcyFunctionBlock fb = localFunctions.get(startOffset);
                        if (fb != null) {
                            clazz = fb.getReturnType().getClazz();
                            methods = engineTypesMethod.get(clazz);
                            if (methods != null && !this.advanced) {
                                for (ScriptFunctionCompletion complete : methods) {
                                    if (complete.isStatic()) {
                                        complete.setRelevance(2);
                                    } else if (!complete.isStatic()) {
                                        complete.setRelevance(10);
                                    }
                                    if (!text.isEmpty() && !complete.getName().toLowerCase().startsWith(text.toLowerCase())) continue;
                                    retVal.add(this.generateSFCCopy(complete));
                                }
                            } else {
                                Type t = null;
                                if (fb.getMethod() != null) {
                                    t = fb.getMethod().getGenericReturnType();
                                }
                                this.populateClassTypes(fb.getReturnType(), t, text, retVal, false);
                            }
                        }
                    }
                }
            }
        }
        return retVal;
    }

    protected void populateWithConstructors(Class<?> clazz, List<Completion> retVal) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return;
        }
        String name = clazz.isArray() ? clazz.getCanonicalName() : clazz.getName();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            int mod = c.getModifiers();
            if (Modifier.isPublic(mod)) {
                NewInstanceCompletion fc = new NewInstanceCompletion((CompletionProvider)this, name, c);
                fc.setRelevance(10);
                fc.setDefinedIn(clazz.toString().replace('$', '.'));
                ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
                int i = 0;
                Class<?>[] classArray = c.getParameterTypes();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> clazzParam = classArray[n4];
                    params.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(clazzParam, true), "arg" + i));
                    ++i;
                    ++n4;
                }
                if (c.getAnnotation(Deprecated.class) != null) {
                    fc.setSummary("Deprecated");
                    fc.setShortDescription("Deprecated");
                }
                fc.setParams(params);
                retVal.add((Completion)fc);
            }
            ++n2;
        }
    }

    protected void populateClassTypes(VariableType type, String text, List<Completion> retVal) {
        this.populateClassTypes(type, null, text, retVal, false);
    }

    protected void populateClassTypes(VariableType type, String text, List<Completion> retVal, boolean staticOnly) {
        this.populateClassTypes(type, null, text, retVal, staticOnly);
    }

    protected void populateClassTypes(VariableType type2, Type t, String text, List<Completion> retVal, boolean staticOnly) {
        Class<?> type = type2.getClazz();
        if (type == null) {
            return;
        }
        if (!Modifier.isPublic(type.getModifiers())) {
            return;
        }
        ArrayList<VariableCompletion> listFields = new ArrayList<VariableCompletion>();
        ArrayList<ScriptFunctionCompletion> listMethods = new ArrayList<ScriptFunctionCompletion>();
        ArrayList<BasicJavaClassCompletion> listClasses = new ArrayList<BasicJavaClassCompletion>();
        ArrayList listEnums = new ArrayList();
        AnnotatedElement[] annotatedElementArray = type.getFields();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            int mod;
            Field f = annotatedElementArray[n2];
            String name = f.getName();
            if (name.toLowerCase().startsWith(text.toLowerCase()) && Modifier.isPublic(mod = f.getModifiers())) {
                VariableCompletion vc;
                if (!staticOnly) {
                    vc = new VariableCompletion((CompletionProvider)this, name, IcyCompletionProvider.getType(f.getType(), true));
                    if (Modifier.isStatic(mod)) {
                        vc.setRelevance(2);
                    } else {
                        vc.setRelevance(10);
                    }
                    listFields.add(vc);
                } else if (Modifier.isStatic(mod)) {
                    vc = new VariableCompletion((CompletionProvider)this, name, IcyCompletionProvider.getType(f.getType(), true));
                    vc.setRelevance(10);
                    if (f.getAnnotation(Deprecated.class) != null) {
                        vc.setSummary("deprecated");
                    }
                    listFields.add(vc);
                }
            }
            ++n2;
        }
        annotatedElementArray = type.getClasses();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement c = annotatedElementArray[n2];
            if (Modifier.isPublic(((Class)c).getModifiers()) && ((Class)c).getSimpleName().toLowerCase().startsWith(text.toLowerCase())) {
                BasicJavaClassCompletion jcc = new BasicJavaClassCompletion((CompletionProvider)this, (Class<?>)c);
                jcc.setRelevance(1);
                if (!IcyCompletionProvider.exists((Completion)jcc, retVal)) {
                    listClasses.add(jcc);
                }
            }
            ++n2;
        }
        if (type.isArray()) {
            VariableCompletion vc = new VariableCompletion((CompletionProvider)this, "length", Integer.TYPE.getName());
            vc.setRelevance(10);
            listFields.add(vc);
        }
        annotatedElementArray = type.getMethods();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement m = annotatedElementArray[n2];
            if (((Method)m).getName().toLowerCase().startsWith(text.toLowerCase())) {
                Class<?> clazzParam;
                int n3;
                int n4;
                Class<?>[] classArray;
                int i;
                ArrayList<ParameterizedCompletion.Parameter> params;
                int mod = ((Method)m).getModifiers();
                if (!staticOnly) {
                    ScriptFunctionCompletion fc = Pattern.matches("(\\[*)E", ((Method)m).getGenericReturnType().toString()) ? new ScriptFunctionCompletion((CompletionProvider)this, ((Method)m).getName(), (Method)m, type2) : new ScriptFunctionCompletion((CompletionProvider)this, ((Method)m).getName(), (Method)m);
                    if (Modifier.isStatic(mod)) {
                        fc.setRelevance(2);
                    } else {
                        fc.setRelevance(10);
                    }
                    fc.setDefinedIn(type.toString().replace('$', '.'));
                    params = new ArrayList<ParameterizedCompletion.Parameter>();
                    i = 0;
                    classArray = ((Method)m).getParameterTypes();
                    n4 = classArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        clazzParam = classArray[n3];
                        params.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(clazzParam, true), "arg" + i));
                        ++i;
                        ++n3;
                    }
                    fc.setParams(params);
                    if (((Method)m).getAnnotation(Deprecated.class) != null) {
                        fc.setSummary("deprecated");
                        fc.setShortDescription("Deprecated");
                    }
                    listMethods.add(fc);
                } else if (Modifier.isStatic(mod)) {
                    ScriptFunctionCompletion fc = Pattern.matches("(\\[*)E", ((Method)m).getGenericReturnType().toString()) ? new ScriptFunctionCompletion((CompletionProvider)this, ((Method)m).getName(), (Method)m, type2) : new ScriptFunctionCompletion((CompletionProvider)this, ((Method)m).getName(), (Method)m);
                    fc.setRelevance(10);
                    fc.setDefinedIn(type.toString().replace('$', '.'));
                    params = new ArrayList();
                    i = 0;
                    classArray = ((Method)m).getParameterTypes();
                    n4 = classArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        clazzParam = classArray[n3];
                        params.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(clazzParam, true), "arg" + i));
                        ++i;
                        ++n3;
                    }
                    if (((Method)m).getAnnotation(Deprecated.class) != null) {
                        fc.setSummary("deprecated");
                        fc.setShortDescription("Deprecated");
                    }
                    fc.setParams(params);
                    listMethods.add(fc);
                }
            }
            ++n2;
        }
        retVal.addAll(listFields);
        retVal.addAll(listMethods);
        retVal.addAll(listClasses);
        retVal.addAll(listEnums);
    }

    protected Completion generateSFCCopy(ScriptFunctionCompletion complete, boolean b) {
        Method method = complete.getMethod();
        String shortDescript = complete.getShortDescription();
        ScriptFunctionCompletion sfcCopy = new ScriptFunctionCompletion((CompletionProvider)this, method.getName(), method);
        sfcCopy.setDefinedIn(complete.getDefinedIn());
        sfcCopy.setRelevance(complete.getRelevance());
        sfcCopy.setReturnValueDescription(method.getReturnType().toString());
        if (shortDescript != null) {
            sfcCopy.setShortDescription(shortDescript);
        }
        ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
        int i = 0;
        while (i < complete.getParamCount()) {
            params.add(complete.getParam(i));
            ++i;
        }
        sfcCopy.setParams(params);
        return sfcCopy;
    }

    protected Completion generateSFCCopy(ScriptFunctionCompletion complete) {
        return this.generateSFCCopy(complete, false);
    }

    protected void doClassicCompletion(String text, List<Completion> retVal) {
        this.doClassicCompletion(text, retVal, false);
    }

    protected void doClassicCompletion(String text, List<Completion> retVal, boolean importOnly) {
        int index;
        if (text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
            ArrayList<String> classes = ScriptEngineHandler.getAllClasses();
            for (String s : classes) {
                try {
                    Class clazz = ClassUtil.findClass((String)s);
                    if (!Modifier.isPublic(clazz.getModifiers())) continue;
                    String nameFinal = ClassUtil.getSimpleClassName((String)s);
                    int idxDollar = nameFinal.indexOf(36);
                    if (idxDollar != -1) {
                        nameFinal = nameFinal.substring(idxDollar + 1);
                    }
                    Object desc = null;
                    if (!nameFinal.toLowerCase().startsWith(text.toLowerCase())) continue;
                    BasicJavaClassCompletion c = new BasicJavaClassCompletion((CompletionProvider)this, clazz, importOnly);
                    c.setShortDescription(desc == null ? "" : desc);
                    c.setRelevance(1);
                    c.setDefinedIn(s.replace('$', '.'));
                    retVal.add((Completion)c);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if ((index = Collections.binarySearch(this.completions, text, this.comparator)) < 0) {
            index = -index - 1;
        } else {
            int pos = index - 1;
            while (pos > 0 && this.comparator.compare(this.completions.get(pos), (Object)text) == 0) {
                retVal.add((Completion)this.completions.get(pos));
                --pos;
            }
        }
        while (index < this.completions.size()) {
            Completion c = (Completion)this.completions.get(index);
            if (!Util.startsWithIgnoreCase((String)c.getInputText(), (String)text)) break;
            if (c instanceof ScriptFunctionCompletion) {
                if (((ScriptFunctionCompletion)c).isStatic()) {
                    retVal.add(c);
                }
            } else {
                retVal.add(c);
            }
            ++index;
        }
    }

    public String getAlreadyEnteredText(JTextComponent comp) {
        Document doc = comp.getDocument();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = this.seg.offset + len;
        start = segEnd - 1;
        while (start >= this.seg.offset && this.isValidChar(this.seg.array[start])) {
            --start;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(this.seg.array, start, len);
    }

    public String getAlreadyEnteredTextWithFunc(JTextComponent comp) {
        Document doc = comp.getDocument();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = this.seg.offset + len;
        start = segEnd - 1;
        while (start >= this.seg.offset && this.isValidCharStrict(this.seg.array[start], start != segEnd - 1) && (start != segEnd - 1 || this.seg.array[start] != ',')) {
            --start;
        }
        if (start >= this.seg.offset + 3 && this.seg.toString().contains("new") && this.seg.array[start] == ' ' && this.seg.array[start - 1] == 'w' && this.seg.array[start - 2] == 'e' && this.seg.array[start - 3] == 'n') {
            start -= 4;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(this.seg.array, start, len);
    }

    public int getStartOffset(JTextComponent comp) {
        Document doc = comp.getDocument();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, this.seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return -1;
        }
        int segEnd = this.seg.offset + len;
        start = segEnd - 1;
        while (start >= this.seg.offset && this.isValidChar(this.seg.array[start])) {
            --start;
        }
        return ++start;
    }

    public static String getType(Class<?> clazz, boolean simpleName) {
        if (simpleName) {
            if (clazz.isArray()) {
                return clazz.getCanonicalName();
            }
            return clazz.getSimpleName();
        }
        if (clazz.isPrimitive()) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    public ArrayList<String> getClassNamesFromPackage(String packageName) throws IOException {
        ClassLoader classLoader = PluginLoader.getLoader();
        ArrayList<String> names = new ArrayList<String>();
        URL packageURL = classLoader.getResource(packageName = packageName.replace(".", "/"));
        if (packageURL.getProtocol().equals("jar")) {
            String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
            jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
            names.addAll(this.getNames(jarFileName, packageName));
        } else {
            File[] contenuti;
            File folder = new File(packageURL.getFile());
            File[] fileArray = contenuti = folder.listFiles();
            int n = contenuti.length;
            int n2 = 0;
            while (n2 < n) {
                File actual = fileArray[n2];
                String entryName = actual.getName();
                entryName = entryName.substring(0, entryName.lastIndexOf(46));
                names.add(entryName);
                ++n2;
            }
        }
        return names;
    }

    private ArrayList<String> getNames(String jarFileName, String packageName) throws IOException {
        ArrayList<String> toReturn = new ArrayList<String>();
        try (JarFile jf = null;){
            jf = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jf.entries();
            while (jarEntries.hasMoreElements()) {
                Pattern p;
                Matcher m;
                String entryName = jarEntries.nextElement().getName();
                if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() + 5 || !(m = (p = Pattern.compile("((\\w|\\.|\\\\|/)+)(|\\$[a-zA-Z0-9]*[a-zA-Z]).class")).matcher(entryName)).matches()) continue;
                entryName = String.valueOf(m.group(1)) + m.group(3);
                toReturn.add(entryName);
            }
        }
        return toReturn;
    }

    public void installDefaultCompletions(String language) {
        if (StringUtil.isEmpty((String)language)) {
            return;
        }
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("plugins/tprovoost/scripteditor/resources/lang/" + language.toLowerCase() + ".xml");
        try {
            if (in != null) {
                this.loadFromXML(in);
                in.close();
            } else {
                System.out.println("File not found: plugins/tprovoost/scripteditor/resources/lang/" + language.toLowerCase() + ".xml");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

