/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import plugins.tprovoost.scripteditor.gui.ScriptingEditor;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;

public class FindAndReplaceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static FindAndReplaceDialog singleton;
    private JTextField searchField;
    private JTextField replaceField;
    private JCheckBox matchCase;
    private JCheckBox wholeWord;
    private JCheckBox regex;
    private JButton btnFind;
    private JButton btnReplace;
    private JButton btnReplaceFind;
    private JButton btnReplaceAll;
    private JButton btnClose;
    private ScriptingEditor editor;
    private JRadioButton radioForward;
    private JRadioButton rdbtnBackward;

    private FindAndReplaceDialog(Frame parent) {
        super(parent);
        JPanel panelMain = new JPanel();
        panelMain.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.setContentPane(panelMain);
        this.setDefaultCloseOperation(2);
        panelMain.setLayout(new BorderLayout(0, 0));
        JPanel panelTop = new JPanel();
        panelMain.add((Component)panelTop, "North");
        panelTop.setLayout(new BoxLayout(panelTop, 1));
        JPanel panelFind = new JPanel();
        panelTop.add(panelFind);
        panelFind.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelFind.setLayout(new BoxLayout(panelFind, 0));
        JLabel lblFind = new JLabel("Find:");
        panelFind.add(lblFind);
        panelFind.add(Box.createHorizontalStrut(61));
        this.searchField = new JTextField();
        panelFind.add(this.searchField);
        this.searchField.setColumns(10);
        JPanel panelReplace = new JPanel();
        panelTop.add(panelReplace);
        panelReplace.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelReplace.setLayout(new BoxLayout(panelReplace, 0));
        JLabel lblReplace = new JLabel("Replace with:");
        panelReplace.add(lblReplace);
        panelReplace.add(Box.createHorizontalStrut(20));
        this.replaceField = new JTextField();
        this.replaceField.setColumns(10);
        panelReplace.add(this.replaceField);
        JPanel panelDirection = new JPanel();
        panelTop.add(panelDirection);
        panelDirection.setBorder(new TitledBorder(null, "Direction", 4, 2, null, null));
        panelDirection.setLayout(new BoxLayout(panelDirection, 0));
        ButtonGroup group = new ButtonGroup();
        this.radioForward = new JRadioButton("Forward");
        this.radioForward.setSelected(true);
        this.rdbtnBackward = new JRadioButton("Backward");
        group.add(this.radioForward);
        group.add(this.rdbtnBackward);
        panelDirection.add(this.radioForward);
        panelDirection.add(this.rdbtnBackward);
        panelDirection.add(Box.createHorizontalGlue());
        JPanel panelOptions = new JPanel();
        panelTop.add(panelOptions);
        panelOptions.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Options", 4, 2, null, null));
        panelOptions.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panelOptions.add(panel);
        panel.setLayout(new BoxLayout(panel, 0));
        this.matchCase = new JCheckBox("Case sensitive");
        panel.add(this.matchCase);
        this.wholeWord = new JCheckBox("Whole word");
        panel.add(this.wholeWord);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EmptyBorder(2, 2, 2, 2));
        panelOptions.add(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 0));
        this.regex = new JCheckBox("Regular expressions");
        panel_1.add(this.regex);
        JPanel panelSouth = new JPanel();
        panelMain.add((Component)panelSouth, "South");
        panelSouth.setLayout(new BoxLayout(panelSouth, 0));
        panelSouth.add(Box.createHorizontalGlue());
        JPanel panelButtons = new JPanel();
        panelSouth.add(panelButtons);
        panelButtons.setLayout(new GridLayout(0, 2, 0, 0));
        this.btnFind = new JButton("Find");
        panelButtons.add(this.btnFind);
        this.btnReplaceFind = new JButton("Replace/Find");
        panelButtons.add(this.btnReplaceFind);
        this.btnReplace = new JButton("Replace");
        panelButtons.add(this.btnReplace);
        this.btnReplaceAll = new JButton("Replace All");
        panelButtons.add(this.btnReplaceAll);
        JLabel lblFiller = new JLabel("");
        panelButtons.add(lblFiller);
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplaceDialog.this.dispose();
            }
        });
        panelButtons.add(this.btnClose);
        this.setTitle("Find/Replace");
        this.getRootPane().setDefaultButton(this.btnFind);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.btnFind.addActionListener(this);
        this.btnReplace.addActionListener(this);
        this.btnReplaceAll.addActionListener(this);
        this.btnReplaceFind.addActionListener(this);
        panelMain.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        panelMain.getActionMap().put("escape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplaceDialog.this.dispose();
                singleton = null;
            }
        });
    }

    protected RSyntaxTextArea getTextArea() {
        Component comp;
        if (this.editor != null && (comp = this.editor.getTabbedPane().getSelectedComponent()) instanceof ScriptingPanel) {
            return ((ScriptingPanel)comp).getTextArea();
        }
        return null;
    }

    public static void showDialog(ScriptingEditor editor) {
        FindAndReplaceDialog dialog = FindAndReplaceDialog.getInstance();
        dialog.editor = editor;
        RSyntaxTextArea textArea = dialog.getTextArea();
        if (textArea != null) {
            dialog.searchField.setText(textArea.getSelectedText());
        }
        dialog.searchField.selectAll();
        dialog.setVisible(true);
    }

    private static FindAndReplaceDialog getInstance() {
        if (singleton == null) {
            singleton = new FindAndReplaceDialog((Frame)Icy.getMainInterface().getMainFrame());
        }
        return singleton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String text = this.searchField.getText();
        if (text.length() == 0) {
            return;
        }
        RSyntaxTextArea textArea = this.getTextArea();
        if (textArea == null) {
            MessageDialog.showDialog((String)"No text to search in.");
            return;
        }
        if (source == this.btnFind) {
            this.findOrReplace(false);
        } else if (source == this.btnReplace) {
            this.findOrReplace(true);
        } else if (source == this.btnReplaceFind) {
            this.findOrReplace(true);
            this.findOrReplace(false);
        } else if (source == this.btnReplaceAll) {
            SearchContext cx = new SearchContext(text);
            cx.setRegularExpression(this.regex.isSelected());
            cx.setReplaceWith(this.replaceField.getText());
            cx.setMatchCase(this.matchCase.isSelected());
            cx.setWholeWord(this.wholeWord.isSelected());
            SearchResult result = SearchEngine.replaceAll((RTextArea)textArea, (SearchContext)cx);
            JOptionPane.showMessageDialog(this, String.valueOf(result.getCount()) + " replacements made!");
        }
    }

    public boolean findOrReplace(boolean replace) {
        return this.findOrReplace(replace, this.radioForward.isSelected());
    }

    public boolean findOrReplace(boolean replace, boolean forward) {
        if (this.searchOrReplaceFromHere(replace, forward)) {
            return true;
        }
        RSyntaxTextArea textArea = this.getTextArea();
        if (textArea == null) {
            return false;
        }
        int caret = textArea.getCaretPosition();
        textArea.setCaretPosition(forward ? 0 : textArea.getDocument().getLength());
        if (this.searchOrReplaceFromHere(replace, forward)) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "No match found!");
        textArea.setCaretPosition(caret);
        return false;
    }

    protected boolean searchOrReplaceFromHere(boolean replace) {
        return this.searchOrReplaceFromHere(this.radioForward.isSelected());
    }

    protected boolean searchOrReplaceFromHere(boolean replace, boolean forward) {
        SearchContext cx = new SearchContext(this.searchField.getText());
        cx.setRegularExpression(this.regex.isSelected());
        cx.setReplaceWith(this.replaceField.getText());
        cx.setMatchCase(this.matchCase.isSelected());
        cx.setSearchForward(forward);
        cx.setWholeWord(this.wholeWord.isSelected());
        if (replace) {
            return SearchEngine.replace((RTextArea)this.getTextArea(), (SearchContext)cx).wasFound();
        }
        return SearchEngine.find((JTextArea)this.getTextArea(), (SearchContext)cx).wasFound();
    }

    public boolean isReplace() {
        return this.btnReplace.isEnabled();
    }

    public void setSearchPattern(String pattern) {
        this.searchField.setText(pattern);
    }
}

