/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.preferences.GeneralPreferences;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;

public class Preferences {
    private static Preferences singleton = new Preferences();
    private XMLPreferences prefs = PluginsPreferences.getPreferences().node("plugins.tprovoost.scripteditor.main.ScriptEditorPlugin");
    private final String PREF_INDENT_SPACES = "indent";
    private final String PREF_INDENT_SPACES_VALUE = "nbSpaces";
    private final String PREF_FULL_AUTOCOMPLETE = "fullautocomplete";
    private final String PREF_AUTOCLEAR_OUTPUT = "autoclearoutput";
    private final String PREF_FONT_SIZE = "fontSize";
    private int tabWidth;
    private int fontSize;
    private boolean soft;
    private boolean autoClearOutput;
    private boolean fullAutocomplete;

    private Preferences() {
        this.loadPrefs();
    }

    public static Preferences getPreferences() {
        return singleton;
    }

    public boolean isFullAutoCompleteEnabled() {
        return this.fullAutocomplete;
    }

    public boolean isVarInterpretationEnabled() {
        return true;
    }

    public boolean isOverrideEnabled() {
        return true;
    }

    public boolean isAutoBuildEnabled() {
        return true;
    }

    public boolean isStrictModeEnabled() {
        return false;
    }

    public boolean isAutoClearOutputEnabled() {
        return this.autoClearOutput;
    }

    public boolean isSoftTabsEnabled() {
        return this.soft;
    }

    public int indentSpacesCount() {
        return this.tabWidth;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void savePrefs() {
        this.prefs.putBoolean("indent", this.isSoftTabsEnabled());
        this.prefs.putBoolean("fullautocomplete", this.isFullAutoCompleteEnabled());
        this.prefs.putBoolean("autoclearoutput", this.isAutoClearOutputEnabled());
        this.prefs.putInt("nbSpaces", this.indentSpacesCount());
        this.prefs.putInt("fontSize", this.getFontSize());
    }

    public void loadPrefs() {
        this.fullAutocomplete = this.prefs.getBoolean("fullautocomplete", Boolean.TRUE.booleanValue());
        this.autoClearOutput = this.prefs.getBoolean("autoclearoutput", true);
        this.soft = this.prefs.getBoolean("indent", Boolean.FALSE.booleanValue());
        this.tabWidth = this.prefs.getInt("nbSpaces", 8);
        this.fontSize = this.prefs.getInt("fontSize", GeneralPreferences.getGuiFontSize());
    }

    public void setFullAutoCompleteEnabled(boolean enabled) {
        this.fullAutocomplete = enabled;
    }

    public void setAutoClearOutputEnabled(boolean enabled) {
        this.autoClearOutput = enabled;
    }

    public void setSoftTabsEnabled(boolean enabled) {
        this.soft = enabled;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setFontSize(int value) {
        this.fontSize = value;
    }
}

