/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock.var;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarListener;
import plugins.tprovoost.scripteditor.scriptblock.editor.DefaultScriptVarEditorFactory;
import plugins.tprovoost.scripteditor.scriptblock.editor.VarScriptEditor;
import plugins.tprovoost.scripteditor.scriptblock.script.Script;

public abstract class VarScript
extends Var<Script> {
    Set<VarMutable> inputVariables;
    Set<VarMutable> outputVariables;

    public VarScript(String name, Script defaultValue) {
        this(name, defaultValue, Collections.emptySet(), Collections.emptySet());
    }

    public VarScript(String name, Script defaultValue, Collection<VarMutable> inputVariables, Collection<VarMutable> outputVariables) throws NullPointerException {
        this(name, defaultValue, inputVariables, outputVariables, null);
    }

    public VarScript(String name, Script defaultValue, VarListener<Script> defaultListener) throws NullPointerException {
        this(name, defaultValue, Collections.emptyList(), Collections.emptyList(), defaultListener);
    }

    public VarScript(String name, Script defaultValue, Collection<VarMutable> inputVariables, Collection<VarMutable> outputVariables, VarListener<Script> defaultListener) throws NullPointerException {
        super(name, (Object)defaultValue, defaultListener);
        this.setValue(defaultValue);
        this.inputVariables = new HashSet<VarMutable>(inputVariables);
        this.outputVariables = new HashSet<VarMutable>(outputVariables);
    }

    public String getCode() {
        return ((Script)this.getValue()).getCode();
    }

    public Set<VarMutable> getVariables() {
        return ((Script)this.getValue()).getVariables();
    }

    public Set<VarMutable> getInputVariables() {
        return Collections.unmodifiableSet(this.inputVariables);
    }

    public Set<VarMutable> getOutputVariables() {
        return Collections.unmodifiableSet(this.outputVariables);
    }

    public void setValue(Script newValue) throws IllegalArgumentException {
        if (newValue != null && newValue.getCode() != null) {
            super.setValue((Object)newValue);
        }
    }

    public void updateCode(String newCode) {
        if (newCode != null) {
            ((Script)this.getValue()).updateCode(newCode);
            this.fireVariableChanged((Script)this.getValue(), (Script)this.getValue());
        }
    }

    public void setupInputVariables(Collection<VarMutable> variables) {
        ((Script)this.getValue()).removeVariables(this.getInputVariables());
        this.inputVariables.clear();
        this.inputVariables.addAll(variables);
        ((Script)this.getValue()).addVariables(this.getInputVariables());
    }

    public void setupOutputVariables(Collection<VarMutable> variables) {
        ((Script)this.getValue()).removeVariables(this.getOutputVariables());
        this.outputVariables.clear();
        this.outputVariables.addAll(variables);
        ((Script)this.getValue()).addVariables(this.getOutputVariables());
    }

    public void addInputVariable(VarMutable variable) {
        ((Script)this.getValue()).addVariable(variable);
        this.inputVariables.add(variable);
        this.fireVariableChanged((Script)this.getValue(), (Script)this.getValue());
    }

    public void addOutputVariable(VarMutable variable) {
        ((Script)this.getValue()).addVariable(variable);
        this.outputVariables.add(variable);
        this.fireVariableChanged((Script)this.getValue(), (Script)this.getValue());
    }

    public void removeInputVariable(VarMutable variable) {
        ((Script)this.getValue()).removeVariable(variable);
        this.inputVariables.remove(variable);
        this.fireVariableChanged((Script)this.getValue(), (Script)this.getValue());
    }

    public void removeOutputVariable(VarMutable variable) {
        ((Script)this.getValue()).removeVariable(variable);
        this.outputVariables.remove(variable);
        this.fireVariableChanged((Script)this.getValue(), (Script)this.getValue());
    }

    public VarEditor<Script> createVarEditor() {
        DefaultScriptVarEditorFactory factory = DefaultScriptVarEditorFactory.getDefaultFactory();
        VarScriptEditor editor = factory.createScriptEditor(this);
        return editor;
    }
}

