/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import icy.gui.frame.progress.ProgressFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginRepositoryLoader;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.EventUtil;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptException;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;
import plugins.tprovoost.scripteditor.gui.ConsoleOutput;
import plugins.tprovoost.scripteditor.gui.Preferences;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;
import plugins.tprovoost.scripteditor.main.ScriptListener;
import plugins.tprovoost.scripteditor.scriptingconsole.BindingsScriptFrame;
import plugins.tprovoost.scripteditor.scriptinghandlers.IcyFunctionBlock;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingErrors;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public abstract class ScriptingHandler
implements KeyListener,
PluginRepositoryLoader.PluginRepositoryLoaderListener,
LinkGenerator {
    protected ScriptingErrors errors = new ScriptingErrors();
    protected ArrayList<Completion> variableCompletions = new ArrayList();
    protected DefaultCompletionProvider provider;
    private boolean compilationOk = false;
    protected JTextComponent textArea;
    protected HashMap<String, ScriptVariable> localVariables;
    protected HashMap<String, ScriptVariable> externalVariables = new HashMap();
    protected HashMap<String, VariableType> localFunctions = new HashMap();
    protected ArrayList<String> scriptDeclaredImports = new ArrayList();
    protected ArrayList<String> scriptDeclaredImportClasses = new ArrayList();
    protected HashMap<Integer, IcyFunctionBlock> blockFunctions = new HashMap();
    protected ConsoleOutput errorOutput;
    private Gutter gutter;
    protected String fileName = "Untitled";
    private boolean advanced;
    private boolean forceRun = false;
    private boolean newEngine = true;
    private boolean strict = false;
    private boolean varInterpretation = false;
    public EvalThread thread;
    private ArrayList<ScriptListener> listeners = new ArrayList();
    protected static final boolean DEBUG = false;
    private AutoVerify autoverify = new AutoVerify();
    public static final int RELEVANCE_MIN = 1;
    public static final int RELEVANCE_LOW = 2;
    public static final int RELEVANCE_HIGH = 10;
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw, true){

        @Override
        public synchronized void write(final String s) {
            if (ScriptingHandler.this.errorOutput != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptingHandler.this.errorOutput.append(s);
                    }
                });
            } else {
                System.out.print(s);
            }
        }
    };

    public ScriptingHandler(DefaultCompletionProvider provider, String engineType, JTextComponent textArea, Gutter gutter, boolean forceRun, ScriptingPanel scriptingPanel) {
        this.provider = provider;
        this.textArea = textArea;
        this.gutter = gutter;
        this.forceRun = forceRun;
        this.setLanguage(engineType);
        textArea.getDocument().addDocumentListener(this.autoverify);
        if (textArea instanceof RSyntaxTextArea) {
            ((RSyntaxTextArea)textArea).setLinkGenerator((LinkGenerator)this);
        }
        this.localVariables = new HashMap();
        ScriptEngine engine = this.getEngine();
        if (engine == null) {
            return;
        }
        engine.setWriter(this.pw);
        engine.setErrorWriter(this.pw);
    }

    public ScriptingHandler(DefaultCompletionProvider provider, String engineType, JTextComponent textArea, Gutter gutter) {
        this(provider, engineType, textArea, gutter, false);
    }

    public ScriptingHandler(DefaultCompletionProvider provider, String engineType, JTextComponent textArea, Gutter gutter, boolean forceRun) {
        this(provider, engineType, textArea, gutter, forceRun, null);
    }

    public void setOutput(ConsoleOutput consoleOutput) {
        this.errorOutput = consoleOutput;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setLanguage(String engineType) {
        try {
            this.installDefaultLanguageCompletions(engineType);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, VariableType> getLocalFunctions() {
        return this.localFunctions;
    }

    public HashMap<String, ScriptVariable> getLocalVariables() {
        return this.localVariables;
    }

    public HashMap<Integer, IcyFunctionBlock> getBlockFunctions() {
        return this.blockFunctions;
    }

    public HashMap<String, ScriptVariable> getExternalVariables() {
        return this.externalVariables;
    }

    public VariableType getVariableDeclaration(String name) {
        return this.getVariableDeclaration(name, this.textArea.getCaretPosition());
    }

    public VariableType getVariableDeclaration(String name, int offset) {
        ScriptVariable sv;
        boolean isArray = name.contains("[");
        String originalName = name;
        if (isArray) {
            name = name.substring(0, name.indexOf(91));
        }
        if ((sv = this.localVariables.get(name)) == null) {
            return null;
        }
        VariableType type = sv.getVariableClassType(offset);
        Class<?> typeC = null;
        if (type == null) {
            ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
            type = engineHandler.getEngineVariables().get(name);
        }
        if (type != null) {
            typeC = type.getClazz();
        }
        if (typeC != null && isArray) {
            int occ = originalName.split("\\[").length - 1;
            int i = 0;
            while (i < occ) {
                typeC = typeC.getComponentType();
                ++i;
            }
        }
        if (type != null) {
            VariableType vt = new VariableType(typeC);
            vt.setType(type.getType());
            return vt;
        }
        return new VariableType(typeC);
    }

    public abstract void installDefaultLanguageCompletions(String var1) throws ScriptException;

    public void importFunctions() throws ScriptException {
        if (!(this.provider instanceof IcyCompletionProvider)) {
            return;
        }
        this.advanced = false;
        if (this.advanced) {
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressFrame frame = new ProgressFrame("Loading functions...");
                    ((IcyCompletionProvider)ScriptingHandler.this.provider).findAllMethods(ScriptingHandler.this.getEngine(), frame);
                    frame.setVisible(false);
                }
            });
        } else {
            ScriptEngineHandler handler = ScriptEngineHandler.getEngineHandler(this.getEngine());
            ArrayList<Method> functions = handler.getFunctions();
            ((IcyCompletionProvider)this.provider).installMethods(functions);
            this.installMethods(this.getEngine(), functions);
        }
    }

    public abstract void installMethods(ScriptEngine var1, ArrayList<Method> var2);

    public boolean isCompilationOk() {
        return this.compilationOk;
    }

    private void setCompilationOk(boolean compilationOk) {
        this.compilationOk = compilationOk;
    }

    public boolean isNewEngine() {
        return this.newEngine;
    }

    public void setNewEngine(boolean newEngine) {
        this.newEngine = newEngine;
    }

    public boolean isForceRun() {
        return this.forceRun;
    }

    public void setForceRun(boolean forceRun) {
        this.forceRun = forceRun;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setVarInterpretation(boolean varInterpretation) {
        this.varInterpretation = varInterpretation;
    }

    public void interpret(boolean exec) {
        String s = this.textArea.getSelectedText();
        if (s == null) {
            s = this.textArea.getText();
        }
        if (exec && this.forceRun) {
            this.run();
        } else {
            this.interpret(s);
            if (exec && this.isCompilationOk()) {
                this.run();
            }
        }
    }

    protected void updateGutter() {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ScriptingHandler.this.gutter == null || !(ScriptingHandler.this.textArea instanceof JTextArea)) {
                    return;
                }
                ScriptingHandler.this.gutter.removeAllTrackingIcons();
                ScriptingHandler.this.errors.displayOnGutter(ScriptingHandler.this.gutter);
            }
        });
    }

    protected void interpret(String s) {
        RTextArea textArea = new RTextArea();
        textArea.setText(s);
        try {
            this.clearScriptVariables();
            this.registerImports();
            if (this.varInterpretation) {
                this.errors.cleanup();
                this.detectVariables(s);
            }
            this.setCompilationOk(true);
        }
        catch (ScriptException e) {
            this.errors.setRuntimeError(e);
        }
        this.updateGutter();
    }

    protected void addExternalVariables() {
        for (String s : this.externalVariables.keySet()) {
            ScriptVariable sv = this.externalVariables.get(s);
            String type = sv.getVariableClassType(0).toString();
            VariableCompletion c = new VariableCompletion((CompletionProvider)this.provider, s, type);
            c.setRelevance(10);
            this.variableCompletions.add((Completion)c);
        }
        this.localVariables.putAll(this.externalVariables);
    }

    private synchronized void clearScriptVariables() {
        this.localVariables.clear();
        this.localFunctions.clear();
        this.scriptDeclaredImports.clear();
        for (String s : this.scriptDeclaredImportClasses) {
            try {
                BasicJavaClassCompletion c = new BasicJavaClassCompletion((CompletionProvider)this.provider, ClassUtil.findClass((String)s));
                s = c.getName();
                List list = this.provider.getCompletionByInputText(s);
                if (list == null) continue;
                for (Completion c2 : new ArrayList(list)) {
                    if (!(c2 instanceof VariableCompletion) || !((VariableCompletion)c2).getName().contentEquals(s)) continue;
                    this.provider.removeCompletion(c2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.scriptDeclaredImportClasses.clear();
    }

    public void run() {
        ScriptEngine engine;
        if (this.isNewEngine()) {
            if (this.errorOutput != null && Preferences.getPreferences().isAutoClearOutputEnabled()) {
                this.errorOutput.clear();
            }
            engine = this.createNewEngine();
        } else {
            engine = this.getEngine();
        }
        this.thread = new EvalThread(engine, this.textArea.getText());
        this.thread.setPriority(1);
        this.thread.start();
    }

    public ScriptEngine createNewEngine() {
        ScriptEngine oldEngine = this.getEngine();
        if (oldEngine != null) {
            ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(oldEngine);
            ArrayList<Method> functions = engineHandler.getFunctions();
            ScriptEngineHandler.disposeEngine(oldEngine);
            String newEngineType = oldEngine.getName();
            ScriptEngine newEngine = ScriptEngineHandler.getEngine(newEngineType, true);
            this.installMethods(newEngine, functions);
            try {
                this.installDefaultLanguageCompletions(newEngineType);
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
            newEngine.setWriter(this.pw);
            newEngine.setErrorWriter(this.pw);
            return newEngine;
        }
        return null;
    }

    public abstract void registerImports();

    public abstract void autoDownloadPlugins();

    protected abstract void detectVariables(String var1) throws ScriptException;

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 70: {
                if (!EventUtil.isControlDown((InputEvent)e) || !EventUtil.isShiftDown((InputEvent)e)) break;
                this.format();
                break;
            }
            case 10: {
                if (EventUtil.isControlDown((InputEvent)e)) {
                    this.interpret(false);
                    e.consume();
                    break;
                }
                if (!EventUtil.isShiftDown((InputEvent)e)) break;
                break;
            }
            case 82: {
                if (!EventUtil.isControlDown((InputEvent)e)) break;
                this.interpret(true);
                break;
            }
            case 77: {
                break;
            }
        }
    }

    public void organizeImports() {
        this.organizeImports(this.textArea);
    }

    public abstract void organizeImports(JTextComponent var1);

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public Class<?> resolveClassDeclaration(String type) {
        for (String s : this.scriptDeclaredImportClasses) {
            String className = ClassUtil.getSimpleClassName((String)s);
            int idx = className.indexOf(36);
            if (idx != -1) {
                className = className.substring(idx + 1);
            }
            if (className.contentEquals(type)) {
                try {
                    return ClassUtil.findClass((String)s);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            int idxDollar = type.indexOf("$");
            if (!type.contains(className) || idxDollar == -1) continue;
            try {
                return ClassUtil.findClass((String)(String.valueOf(s) + type.substring(idxDollar)));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        for (String s : this.scriptDeclaredImports) {
            try {
                return ClassUtil.findClass((String)(String.valueOf(s) + "." + type));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.strict) {
            ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
            for (String s : engineHandler.getEngineDeclaredImportClasses()) {
                if (!ClassUtil.getSimpleClassName((String)s).contentEquals(type)) continue;
                try {
                    return ClassUtil.findClass((String)s);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
            for (String s : engineHandler.getEngineDeclaredImports()) {
                try {
                    return ClassUtil.findClass((String)(String.valueOf(s) + "." + type));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public abstract ScriptEngine getEngine();

    public void pluginRepositeryLoaderChanged(PluginDescriptor plugin) {
        Class clazz;
        if (plugin == null) {
            return;
        }
        try {
            clazz = ClassUtil.findClass((String)plugin.getPluginClass().toString());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!plugin.isInstalled()) {
            ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
            HashMap<Class<?>, ArrayList<ScriptFunctionCompletion>> engineTypesMethod = engineHandler.getEngineTypesMethod();
            engineTypesMethod.remove(clazz);
        } else {
            boolean cfr_ignored_0 = this.provider instanceof IcyCompletionProvider;
        }
    }

    public abstract void evalEngine(ScriptEngine var1, String var2) throws ScriptException;

    public void killScript() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void fireEvaluationStarted() {
        for (ScriptListener listener : new ArrayList<ScriptListener>(this.listeners)) {
            listener.evaluationStarted();
        }
    }

    public void fireEvaluationOver() {
        for (ScriptListener listener : new ArrayList<ScriptListener>(this.listeners)) {
            listener.evaluationOver();
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public void addScriptListener(ScriptListener listener) {
        this.listeners.add(listener);
    }

    public void removeScriptListener(ScriptListener listener) {
        this.listeners.remove(listener);
    }

    public abstract void format();

    public void stopThreads() {
        this.textArea.getDocument().removeDocumentListener(this.autoverify);
        this.killScript();
    }

    public static Method resolveMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Method m = methodArray[n2];
                Class<?>[] types = m.getParameterTypes();
                if (m.getName().contentEquals(name) && types.length == parameterTypes.length) {
                    int i = 0;
                    while (i < types.length) {
                        if (types[i] == null || parameterTypes[i] == null || parameterTypes[i].isAssignableFrom(types[i]) || types[i].isAssignableFrom(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block7;
                    }
                    return m;
                }
            }
            ++n2;
        }
        return clazz.getMethod(name, parameterTypes);
    }

    public void autoImport() {
    }

    private class AutoVerify
    extends FocusAdapter
    implements DocumentListener,
    ActionListener {
        private Timer timer = new Timer(1000, this);
        private boolean lastChange;

        public AutoVerify() {
            this.timer.setRepeats(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                Document doc = e.getDocument();
                int offset = e.getOffset();
                int len = e.getLength();
                if (doc.getText(offset, len).contentEquals(".")) {
                    this.timer.stop();
                    this.lastChange = false;
                    String fullTxt = doc.getText(0, doc.getLength());
                    String s = fullTxt.substring(0, offset);
                    s = String.valueOf(s) + fullTxt.substring(offset + len, doc.getLength());
                    ScriptingHandler.this.interpret(s);
                }
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.lastChange = true;
            if (Preferences.getPreferences().isAutoBuildEnabled()) {
                this.timer.restart();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.lastChange = false;
            ScriptingHandler.this.interpret(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.timer.stop();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.lastChange) {
                this.timer.restart();
            }
        }
    }

    public class EvalThread
    extends Thread {
        private String s;
        private ScriptEngine evalEngine;

        public EvalThread(ScriptEngine engine, String script) {
            this.evalEngine = engine;
            this.s = script;
        }

        @Override
        public void run() {
            ScriptingHandler.this.fireEvaluationStarted();
            if (this.evalEngine != ScriptingHandler.this.getEngine()) {
                this.evalEngine.setWriter(ScriptingHandler.this.pw);
                this.evalEngine.setErrorWriter(ScriptingHandler.this.pw);
            }
            try {
                try {
                    ScriptingHandler.this.evalEngine(this.evalEngine, this.s);
                    ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(ScriptingHandler.this.getEngine());
                    for (String key : ScriptingHandler.this.localVariables.keySet()) {
                        engineHandler.getEngineVariables().put(key, ScriptingHandler.this.localVariables.get(key).getVariableLastClassType());
                    }
                    engineHandler.getEngineFunctions().putAll(ScriptingHandler.this.localFunctions);
                    engineHandler.getEngineDeclaredImportClasses().addAll(ScriptingHandler.this.scriptDeclaredImportClasses);
                    engineHandler.getEngineDeclaredImports().addAll(ScriptingHandler.this.scriptDeclaredImports);
                    BindingsScriptFrame frame = BindingsScriptFrame.getInstance();
                    frame.setEngine(this.evalEngine);
                    frame.update();
                }
                catch (ThreadDeath td) {
                    System.out.println("shutdown");
                    ScriptingHandler.this.fireEvaluationOver();
                    ScriptingHandler.this.thread = null;
                }
                catch (ScriptException e) {
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((EvalThread)EvalThread.this).ScriptingHandler.this.errors.setRuntimeError(e);
                            ScriptingHandler.this.updateGutter();
                        }
                    });
                    ScriptingHandler.this.fireEvaluationOver();
                    ScriptingHandler.this.thread = null;
                }
            }
            finally {
                ScriptingHandler.this.fireEvaluationOver();
                ScriptingHandler.this.thread = null;
            }
        }
    }
}

