/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion.types;

import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import plugins.tprovoost.scripteditor.completion.types.JavaFunctionCompletion;
import plugins.tprovoost.scripteditor.javasource.ClassSource;
import plugins.tprovoost.scripteditor.javasource.JarAccess;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public class ScriptFunctionCompletion
extends JavaFunctionCompletion {
    private static HashMap<String, MethodDeclaration> cacheMetDecl = new HashMap();
    private static HashMap<String, List<ParameterizedCompletion.Parameter>> cacheParams = new HashMap();
    private Method method;
    private boolean isStatic;

    public ScriptFunctionCompletion(CompletionProvider provider, String name, Method method) {
        super(provider, name, method.getReturnType().isArray() ? method.getReturnType().getCanonicalName() : method.getReturnType().getName());
        this.method = method;
    }

    public ScriptFunctionCompletion(CompletionProvider provider, String name, Method method, VariableType type) {
        super(provider, name, type.getType());
        this.method = method;
    }

    public String getMethodCall() {
        String parametersAsString = "";
        MethodDeclaration methodDecl = cacheMetDecl.get(this.method.toGenericString());
        if (methodDecl != null) {
            List params = methodDecl.getParameters();
            int i = 0;
            while (i < params.size()) {
                Parameter p = (Parameter)params.get(i);
                parametersAsString = i != 0 ? String.valueOf(parametersAsString) + " ," + p.getType() + " " + p.getId().getName() : String.valueOf(parametersAsString) + p.getType() + " " + p.getId().getName();
                ++i;
            }
        } else {
            Class<?>[] paramTypes = this.method.getParameterTypes();
            int i = 0;
            while (i < paramTypes.length) {
                parametersAsString = i != 0 ? String.valueOf(parametersAsString) + " ,arg" + i : String.valueOf(parametersAsString) + "arg" + i;
                ++i;
            }
        }
        return "Packages." + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "(" + parametersAsString + ");";
    }

    public boolean isStatic() {
        if (this.method != null) {
            return Modifier.isStatic(this.method.getModifiers());
        }
        return false;
    }

    public Class<?> getOriginatingClass() {
        if (this.isStatic) {
            return null;
        }
        return this.method.getDeclaringClass();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof ScriptFunctionCompletion)) {
            return false;
        }
        return ((ScriptFunctionCompletion)((Object)arg0)).getName().contentEquals(this.getName());
    }

    public String getAlreadyEntered(JTextComponent comp) {
        Document doc = comp.getDocument();
        Segment seg = new Segment();
        int dot = comp.getCaretPosition();
        Element root = doc.getDefaultRootElement();
        int index = root.getElementIndex(dot);
        Element elem = root.getElement(index);
        int start = elem.getStartOffset();
        int len = dot - start;
        try {
            doc.getText(start, len, seg);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return "";
        }
        int segEnd = seg.offset + len;
        start = segEnd - 1;
        while (start >= seg.offset && this.isValidChar(seg.array[start])) {
            --start;
        }
        return (len = segEnd - ++start) == 0 ? "" : new String(seg.array, start, len);
    }

    private boolean isValidChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '\"';
    }

    public ParameterizedCompletion.Parameter getParam(int index) {
        List<ParameterizedCompletion.Parameter> params = cacheParams.get(this.method.toGenericString());
        if (params != null) {
            return params.get(index);
        }
        if (!this.isParseDone) {
            this.populate();
        }
        return super.getParam(index);
    }

    public String getSummary() {
        this.summary = (String)cacheSummary.get(this.method.toGenericString());
        if (!this.isParseDone && this.summary == null) {
            this.populate();
        }
        StringBuilder sb = new StringBuilder();
        this.addDefinitionString(sb);
        if (!this.possiblyAddDescription(sb)) {
            sb.append("<br><br><br>");
        }
        this.addParameters(sb);
        this.possiblyAddDefinedIn(sb);
        this.possiblyAddSource(sb);
        sb.append("</html>");
        String sumResult = sb.toString();
        return sumResult;
    }

    protected void addParameters(StringBuilder sb) {
        String returnValDesc;
        int paramCount = this.getParamCount();
        if (paramCount > 0) {
            sb.append("<b>Parameters:</b><br>");
            sb.append("<center><table width='90%'><tr><td>");
            int i = 0;
            while (i < paramCount) {
                ParameterizedCompletion.Parameter param = this.getParam(i);
                sb.append("<b>");
                sb.append(param.getName() != null ? param.getName() : param.getType());
                sb.append(" : </b><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                String desc = param.getDescription();
                if (desc != null) {
                    sb.append(desc);
                }
                sb.append("<br>");
                ++i;
            }
            sb.append("</td></tr></table></center><br><br>");
        }
        if ((returnValDesc = this.getReturnValueDescription()) != null) {
            sb.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            sb.append(returnValDesc);
            sb.append("</td></tr></table></center><br><br>");
        }
    }

    private void possiblyAddSource(StringBuilder sb) {
        InputStream is = JarAccess.getJavaSourceInputStream(this.method.getDeclaringClass());
        if (is != null) {
            sb.append("<hr><a href=\"SourceCodeLink\">View Source</a>");
        }
    }

    protected void populate() {
        MethodDeclaration md = cacheMetDecl.get(this.method.toGenericString());
        if (md == null) {
            Class<?> currentClass = this.method.getDeclaringClass();
            while (md == null && currentClass != null) {
                try {
                    Method m = currentClass.getDeclaredMethod(this.method.getName(), this.method.getParameterTypes());
                    ClassSource cs = ClassSource.getClassSource(currentClass);
                    if (!cs.isMethodsSet()) {
                        cs.populateMethods();
                    }
                    md = cs.getMethods().get(m.toGenericString());
                }
                catch (SecurityException m) {
                }
                catch (NoSuchMethodException m) {
                    // empty catch block
                }
                currentClass = currentClass.getSuperclass();
            }
        }
        if (md != null) {
            HashMap<String, String> paramsHash;
            JavadocComment comment = md.getJavaDoc();
            if (comment != null) {
                String content = comment.getContent();
                this.summary = content = ClassSource.docCommentToHtml("/**" + content + "*/");
            }
            if ((paramsHash = ClassSource.getParameters(this.summary)).size() > 0 && this.summary != null) {
                int idx = this.summary.indexOf("<p><b>Parameters:</b><p class='indented'>");
                int idxEnd = this.summary.indexOf("</p>", idx);
                this.summary = String.valueOf(this.summary.substring(0, idx)) + this.summary.substring(idxEnd + "</p>".length());
            }
            ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
            List list = md.getParameters();
            int size = this.getParamCount();
            if (list != null && list.size() == size) {
                int i = 0;
                while (i < this.getParamCount()) {
                    Parameter sourceParam = (Parameter)list.get(i);
                    String name = sourceParam.getId().getName();
                    ParameterizedCompletion.Parameter param = new ParameterizedCompletion.Parameter((Object)sourceParam.getType(), name);
                    params.add(param);
                    String desc = paramsHash.get(name);
                    if (desc != null) {
                        param.setDescription(desc);
                    }
                    ++i;
                }
                super.setParams(params);
                cacheParams.put(this.method.toGenericString(), params);
            }
            cacheSummary.put(this.method.toGenericString(), this.summary);
        } else {
            this.summary = "";
        }
        this.isParseDone = true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BindingFunction {
        public String value();
    }
}

