/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.gui.component.button.IcyButton;
import icy.image.ImageUtil;
import icy.plugin.PluginLoader;
import icy.resource.icon.IcyIcon;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import javax.script.ScriptEngineFactory;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import plugins.tprovoost.scripteditor.gui.JSplitButton;
import plugins.tprovoost.scripteditor.gui.action.SplitButtonActionListener;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;

class CommandPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final BufferedImage imgPlayback2 = ImageUtil.load((InputStream)PluginLoader.getResourceAsStream((String)"plugins/tprovoost/scripteditor/resources/icons/playback_erase_play_alpha.png"));
    private static final int STRUT_SIZE = 4;
    private JComboBox comboLanguages;
    private JMenuItem btnRun;
    private JMenuItem btnRunNew2;
    private JSplitButton btnSplitRun;
    private JButton btnStop;
    private ActionListener runInNewListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!CommandPanel.this.lastIsNew) {
                CommandPanel.this.lastIsNew = true;
                CommandPanel.this.btnSplitRun.setIcon((Icon)new IcyIcon("playback_play", 16));
                CommandPanel.this.btnSplitRun.setToolTipText("Creates a new context and run the script. The previous context will be lost.");
                CommandPanel.this.btnSplitRun.repaint();
            }
        }
    };
    private ActionListener runInSameListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommandPanel.this.lastIsNew) {
                CommandPanel.this.lastIsNew = false;
                CommandPanel.this.btnSplitRun.setIcon((Icon)new IcyIcon((Image)imgPlayback2, 16));
                CommandPanel.this.btnSplitRun.setToolTipText("All variables in the bindings are re-usable.");
                CommandPanel.this.btnSplitRun.repaint();
            }
        }
    };
    protected boolean lastIsNew = true;

    public CommandPanel() {
        this("JavaScript");
    }

    public CommandPanel(String language) {
        this.btnRun = new JMenuItem("Run in Current Context", (Icon)new IcyIcon((Image)imgPlayback2, 16));
        this.btnRun.setToolTipText("All variables in the bindings are re-usable.");
        this.btnSplitRun = new JSplitButton("  ", (Icon)new IcyIcon("playback_play", 16));
        this.btnSplitRun.setPreferredSize(new Dimension(45, 20));
        this.btnSplitRun.setToolTipText("Creates a new context and run the script. The previous context will be lost.");
        this.btnRunNew2 = new JMenuItem("Run in New Context", (Icon)new IcyIcon("playback_play", 16));
        this.btnRunNew2.setToolTipText("Creates a new context and run the script. The previous context and its bindings will be lost.");
        JPopupMenu popupRun = new JPopupMenu();
        popupRun.add(this.btnRunNew2);
        popupRun.add(this.btnRun);
        this.btnSplitRun.setPopupMenu(popupRun);
        this.btnStop = new IcyButton(new IcyIcon("square_shape", 16));
        this.btnStop.setToolTipText("Stops the current script.");
        this.btnStop.setEnabled(false);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        ArrayList<String> values = new ArrayList<String>();
        for (ScriptEngineFactory factory : ScriptEngineHandler.getEngineManager().getEngineFactories()) {
            values.add(ScriptEngineHandler.getLanguageName(factory));
        }
        this.comboLanguages = new JComboBox<String>(values.toArray(new String[values.size()]));
        this.comboLanguages.setSelectedItem(language);
        this.comboLanguages.setMaximumSize(this.comboLanguages.getPreferredSize());
        this.btnRun.addActionListener(this.runInSameListener);
        this.btnSplitRun.addSplitButtonActionListener(new SplitButtonActionListener(){

            @Override
            public void splitButtonClicked(ActionEvent e) {
            }

            @Override
            public void buttonClicked(ActionEvent e) {
                if (CommandPanel.this.lastIsNew) {
                    CommandPanel.this.btnRunNew2.doClick();
                } else {
                    CommandPanel.this.btnRun.doClick();
                }
            }
        });
        this.btnRunNew2.addActionListener(this.runInNewListener);
        this.add(new JLabel("Lang: "));
        this.add(this.comboLanguages);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.btnSplitRun);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.btnStop);
        this.add(Box.createHorizontalGlue());
    }

    public void setRunButtonsEnabled(boolean b) {
        this.btnRun.setEnabled(b);
        this.btnSplitRun.setEnabled(b);
    }

    public void setStopButtonEnabled(boolean b) {
        this.btnRun.setEnabled(!b);
        this.btnSplitRun.setEnabled(!b);
        this.btnStop.setEnabled(b);
    }

    public void addLanguageListener(ItemListener listener) {
        this.comboLanguages.addItemListener(listener);
    }

    public void removeLanguageListener(ItemListener listener) {
        this.comboLanguages.removeItemListener(listener);
    }

    public String getLanguage() {
        return (String)this.comboLanguages.getSelectedItem();
    }

    public void removeRunInSameListener(ActionListener listener) {
        this.btnRun.removeActionListener(listener);
    }

    public void removeRunInNewListener(ActionListener listener) {
        this.btnRunNew2.removeActionListener(listener);
    }

    public void addRunInSameListener(ActionListener listener) {
        this.btnRun.addActionListener(listener);
    }

    public void addRunInNewListener(ActionListener listener) {
        this.btnRunNew2.addActionListener(listener);
    }

    public void addStopListener(ActionListener listener) {
        this.btnStop.addActionListener(listener);
    }

    public void removeStopListener(ActionListener listener) {
        this.btnStop.removeActionListener(listener);
    }
}

