/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.common.listener.AcceptListener;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginLoader;
import icy.preferences.IcyPreferences;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.icon.IcyIcon;
import icy.system.FileDrop;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Node;
import plugins.tprovoost.scripteditor.gui.ConsoleOutput;
import plugins.tprovoost.scripteditor.gui.FindAndReplaceDialog;
import plugins.tprovoost.scripteditor.gui.PreferencesWindow;
import plugins.tprovoost.scripteditor.gui.RecentFiles;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;
import plugins.tprovoost.scripteditor.gui.TabComponentButton;
import plugins.tprovoost.scripteditor.scriptingconsole.BindingsScriptFrame;
import plugins.tprovoost.scripteditor.scriptingconsole.PythonScriptingconsole;
import plugins.tprovoost.scripteditor.scriptingconsole.Scriptingconsole;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;

public class ScriptingEditor
extends IcyFrame
implements ActionListener {
    JTabbedPane tabbedPane;
    private JPanel addPanePanel;
    private ConsoleOutput consoleOutput;
    private Scriptingconsole console;
    private JButton btnClearConsole;
    private JMenu menuOpenRecent;
    static String currentDirectoryPath = "";
    private static final int ctrlMask = SystemUtil.getMenuCtrlMask();
    private static final String STRING_LAST_DIRECTORY = "lastDirectory";
    private XMLPreferences prefs = PluginsPreferences.getPreferences().node("plugins.tprovoost.scripteditor.main.ScriptEditorPlugin");
    private final RecentFiles recentFiles = new RecentFiles(this.prefs);
    protected volatile boolean saveStateEnabled = true;
    private static final boolean IS_PYTHON_INSTALLED = ScriptEngineHandler.getEngineManager().getEngineByExtension("py") != null;
    private static final String PREF_IDX = "idxTab";
    private IcyFrameListener frameListener = new IcyFrameAdapter(){

        public void icyFrameClosing(IcyFrameEvent e) {
            if (IcyFrame.getAllFrames(ScriptingEditor.class).size() == 1) {
                ScriptEngineHandler.clearEngines();
                BindingsScriptFrame scriptFrame = BindingsScriptFrame.getInstance();
                if (scriptFrame != null) {
                    scriptFrame.setVisible(false);
                    scriptFrame.setEngine(null);
                }
            }
            if (ScriptingEditor.this.console != null) {
                ScriptingEditor.this.console.close();
            }
            ScriptingEditor.this.saveStateEnabled = false;
            ScriptingEditor.this.closeAll();
            ScriptingEditor.this.saveStateEnabled = true;
        }
    };
    private AcceptListener acceptlistener = new AcceptListener(){

        public boolean accept(Object source) {
            ScriptingEditor.this.saveStateEnabled = false;
            boolean canClose = ScriptingEditor.this.closeAll();
            ScriptingEditor.this.saveStateEnabled = true;
            return canClose;
        }
    };
    private ScriptingPanel.SavedAsListener savedAsListener = new ScriptingPanel.SavedAsListener(){

        @Override
        public void savedAs(File f) {
            ScriptingEditor.this.addRecentFile(f);
        }
    };
    private ScriptingPanel.TitleChangedListener titleChangedListener = new ScriptingPanel.TitleChangedListener(){

        @Override
        public void titleChanged(ScriptingPanel panel, String title) {
            int idx = ScriptingEditor.this.tabbedPane.indexOfComponent(panel);
            if (idx != -1) {
                ScriptingEditor.this.tabbedPane.setTitleAt(idx, title);
                Component c = ScriptingEditor.this.tabbedPane.getTabComponentAt(idx);
                if (c instanceof JComponent) {
                    ((JComponent)c).revalidate();
                } else {
                    c.repaint();
                }
            }
        }
    };
    private FileDrop.FileDropListener fileDropListener = new FileDrop.FileDropListener(){

        public void filesDropped(File[] files) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".js") || f.getName().endsWith(".py")) {
                    try {
                        ScriptingEditor.this.openFile(f);
                    }
                    catch (IOException iOException) {}
                } else {
                    Loader.load((String)f.toString(), (boolean)true);
                }
                ++n2;
            }
        }
    };
    private HyperlinkListener hyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL url = e.getURL();
                String res = url == null ? e.getDescription() : url.getFile();
                try {
                    ScriptingEditor.this.openFile(new File(res));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    };
    public ItemListener languageListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String language = (String)e.getItem();
                ScriptingEditor.this.changeConsoleLanguage(language);
            }
        }
    };
    private JPanel panelSouth;

    public ScriptingEditor() {
        super("Script Editor", true, true, true, true);
        this.setJMenuBar(this.createJMenuBar());
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Component comp = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (!(comp instanceof ScriptingPanel)) {
                    ScriptingEditor.this.createNewPane();
                    return;
                }
                ScriptingPanel panel = (ScriptingPanel)comp;
                ScriptingEditor.this.saveEditorState();
                ScriptingEditor.this.changeConsoleLanguage(panel.getLanguage());
                File f = panel.getSaveFile();
                String s = f != null ? f.getAbsolutePath() : panel.getPanelName();
                ScriptingEditor.this.setTitle("Script Editor - " + s);
            }
        });
        new FileDrop((Component)this.getExternalFrame(), this.fileDropListener);
        new FileDrop((Component)this.getInternalFrame(), this.fileDropListener);
        this.addPanePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.addPanePanel.setOpaque(false);
        this.addPanePanel.add(new JLabel((Icon)new IcyIcon("plus")));
        this.consoleOutput = new ConsoleOutput();
        if (this.btnClearConsole != null) {
            this.btnClearConsole.removeActionListener(this);
        }
        this.btnClearConsole = new JButton("Clear");
        this.btnClearConsole.addActionListener(this);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.consoleOutput, "Center");
        this.panelSouth = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.panelSouth, "South");
        JSplitPane split = new JSplitPane(0, this.tabbedPane, bottomPanel);
        split.setDividerLocation(0.75);
        split.setResizeWeight(0.75);
        split.setOneTouchExpandable(true);
        this.add(split, "Center");
        mainPanel.add(split);
        this.setContentPane(mainPanel);
        Icy.getMainInterface().addCanExitListener(this.acceptlistener);
        this.restoreEditorState();
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    void restoreEditorState() {
        currentDirectoryPath = this.prefs.get(STRING_LAST_DIRECTORY, "");
        final XMLPreferences openedFiles = this.prefs.node("openedFiles");
        final ArrayList<String> toOpen = new ArrayList<String>();
        for (XMLPreferences key : openedFiles.getChildren()) {
            String fileName = key.get("file0", "");
            toOpen.add(fileName);
        }
        this.recentFiles.load();
        this.updateRecentFilesMenu();
        if (toOpen.isEmpty()) {
            this.createNewPane();
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int maxIdx;
                ScriptingEditor.this.saveStateEnabled = false;
                for (String s : toOpen) {
                    try {
                        ScriptingEditor.this.openFile(new File(s));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                int idx = openedFiles.getInt(ScriptingEditor.PREF_IDX, 0);
                if (idx <= (maxIdx = ScriptingEditor.this.tabbedPane.getTabCount() - 2)) {
                    ScriptingEditor.this.tabbedPane.setSelectedIndex(idx);
                }
                ScriptingEditor.this.saveStateEnabled = true;
            }
        });
    }

    private void saveEditorState() {
        if (!this.saveStateEnabled) {
            return;
        }
        int idx = this.tabbedPane.getSelectedIndex();
        XMLPreferences openedFiles = this.prefs.node("openedFiles");
        XMLUtil.removeAllChildren((Node)openedFiles.getXMLNode());
        int i = 0;
        while (i < this.tabbedPane.getTabCount() - 1) {
            File f;
            Component c = this.tabbedPane.getComponentAt(i);
            if (c instanceof ScriptingPanel && (f = ((ScriptingPanel)c).getSaveFile()) != null) {
                XMLPreferences key = openedFiles.node("entry" + i);
                key.put("file0", f.getAbsolutePath());
            }
            ++i;
        }
        openedFiles.putInt(PREF_IDX, idx);
        this.recentFiles.save();
        IcyPreferences.save();
    }

    private boolean closeAll() {
        if (this.getInternalFrame().getDefaultCloseOperation() == 0) {
            if (!this.closeAllTabs()) {
                return false;
            }
            this.setDefaultCloseOperation(2);
            this.close();
        }
        return true;
    }

    public ScriptingPanel createNewPane() {
        return this.createNewPane("Untitled");
    }

    public ScriptingPanel createNewPane(String name) {
        String ext = FileUtil.getFileExtension((String)name, (boolean)false);
        ScriptingPanel panelCreated = ext.contentEquals("py") ? new ScriptingPanel(name, "Python", this.consoleOutput) : new ScriptingPanel(name, "JavaScript", this.consoleOutput);
        panelCreated.addSavedAsListener(this.savedAsListener);
        panelCreated.addTitleChangedListener(this.titleChangedListener);
        panelCreated.addFileDropListener(this.fileDropListener);
        panelCreated.addHyperlinkListener(this.hyperlinkListener);
        panelCreated.addLanguageListener(this.languageListener);
        this.changeConsoleLanguage(panelCreated.getLanguage());
        int idx = this.tabbedPane.getTabCount() - 1;
        if (idx != -1) {
            this.tabbedPane.removeTabAt(idx);
        } else {
            idx = 0;
        }
        this.tabbedPane.addTab(name, panelCreated);
        this.tabbedPane.setTitleAt(idx, name);
        this.tabbedPane.repaint();
        this.tabbedPane.setTabComponentAt(idx, new TabComponentButton(this, panelCreated));
        this.tabbedPane.addTab("+", new JLabel());
        this.tabbedPane.setTabComponentAt(idx + 1, this.addPanePanel);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 2);
        Insets i = this.addPanePanel.getInsets();
        i.bottom = 0;
        i.left = 0;
        i.right = 0;
        i.top = 0;
        return panelCreated;
    }

    public void openFile(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        String filename = f.getName();
        boolean exists = false;
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (this.tabbedPane.getTitleAt(i).contentEquals(filename)) {
                this.tabbedPane.setSelectedIndex(i);
                exists = true;
            }
            ++i;
        }
        if (exists) {
            return;
        }
        ScriptingPanel panel = this.createNewPane(filename);
        panel.openFile(f);
        this.addRecentFile(f);
        this.removeUntitledFirstPane();
        this.saveEditorState();
    }

    private void removeUntitledFirstPane() {
        if (this.tabbedPane.getTabCount() <= 2) {
            return;
        }
        ScriptingPanel panel = (ScriptingPanel)this.tabbedPane.getComponentAt(0);
        if (this.tabbedPane.getTitleAt(0).contentEquals("Untitled") && panel.getTextArea().getText().isEmpty() && !panel.isDirty()) {
            this.closeTab(0);
        }
    }

    private void updateRecentFilesMenu() {
        this.menuOpenRecent.removeAll();
        int i = 0;
        while (i < this.recentFiles.getFiles().size()) {
            String path = this.recentFiles.getFiles().get(i);
            JMenuItem item = this.createRecentFileItem(path);
            if (item != null) {
                this.menuOpenRecent.add(item);
            }
            ++i;
        }
    }

    private JMenuItem createRecentFileItem(String filename) {
        final File f = new File(filename);
        JMenuItem toReturn = null;
        if (f.exists()) {
            toReturn = new JMenuItem(String.valueOf(f.getName()) + " - " + f.getParent());
            toReturn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ScriptingEditor.this.openFile(f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return toReturn;
    }

    public void openStream(String tabName, InputStream stream) throws IOException {
        ScriptingPanel panel = this.createNewPane(tabName);
        panel.openStream(stream);
        this.removeUntitledFirstPane();
        this.saveEditorState();
    }

    public void showOpenFileDialog() {
        JFileChooser fc = currentDirectoryPath == "" ? new JFileChooser() : new JFileChooser(currentDirectoryPath);
        fc.setMultiSelectionEnabled(true);
        if (fc.showOpenDialog(this.getFrame()) == 0) {
            File[] files;
            File[] fileArray = files = fc.getSelectedFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                File f = fileArray[n2];
                currentDirectoryPath = path = FileUtil.getDirectory((String)f.getAbsolutePath());
                this.prefs.put(STRING_LAST_DIRECTORY, path);
                try {
                    this.openFile(f);
                }
                catch (IOException e) {
                    new FailedAnnounceFrame(String.valueOf(f.getName()) + " is not a valid file");
                }
                ++n2;
            }
        }
    }

    private JMenuBar createJMenuBar() {
        JMenuBar toReturn = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        JMenuItem menuNew = new JMenuItem("New");
        menuNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.createNewPane("Untitled");
            }
        });
        menuFile.add(menuNew);
        menuNew.setAccelerator(KeyStroke.getKeyStroke(78, ctrlMask));
        JMenuItem menuOpen = new JMenuItem("Open...");
        menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.showOpenFileDialog();
            }
        });
        menuOpen.setAccelerator(KeyStroke.getKeyStroke(79, ctrlMask));
        menuOpen.setDisplayedMnemonicIndex(0);
        menuFile.add(menuOpen);
        this.menuOpenRecent = new JMenu("Open Recent");
        menuFile.add(this.menuOpenRecent);
        JMenuItem menuSave = new JMenuItem("Save");
        menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingPanel panel;
                Component comp = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (comp instanceof ScriptingPanel && (panel = (ScriptingPanel)comp).isDirty()) {
                    if (panel.getSaveFile() == null) {
                        panel.showSaveFileDialog(currentDirectoryPath);
                    } else {
                        panel.saveFile();
                    }
                }
            }
        });
        menuSave.setAccelerator(KeyStroke.getKeyStroke(83, ctrlMask));
        menuFile.add(menuSave);
        JMenuItem menuSaveAs = new JMenuItem("Save As...");
        menuSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (comp instanceof ScriptingPanel) {
                    ((ScriptingPanel)comp).showSaveFileDialog(currentDirectoryPath);
                }
            }
        });
        menuSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, ctrlMask | 0x40));
        menuFile.add(menuSaveAs);
        menuFile.add(new JSeparator());
        JMenuItem menuClose = new JMenuItem("Close Tab");
        menuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = ScriptingEditor.this.tabbedPane.getSelectedIndex();
                if (i >= 0 && i < ScriptingEditor.this.tabbedPane.getTabCount() - 1) {
                    ScriptingEditor.this.closeTab(i);
                }
            }
        });
        menuClose.setAccelerator(KeyStroke.getKeyStroke(87, ctrlMask));
        menuFile.add(menuClose);
        JMenuItem menuCloseAll = new JMenuItem("Close All Tabs");
        menuCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.closeAllTabs();
            }
        });
        menuFile.add(menuCloseAll);
        JMenuItem menuCloseAllOthers = new JMenuItem("Close Other Tabs");
        menuCloseAllOthers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = ScriptingEditor.this.tabbedPane.getSelectedIndex();
                int N = ScriptingEditor.this.tabbedPane.getTabCount() - 1;
                ArrayList<Integer> tabsToClose = new ArrayList<Integer>();
                int i = 0;
                while (i < N) {
                    tabsToClose.add(i);
                    ++i;
                }
                tabsToClose.remove(idx);
                ListIterator iterator = tabsToClose.listIterator(tabsToClose.size());
                while (iterator.hasPrevious()) {
                    if (!ScriptingEditor.this.closeTab((Integer)iterator.previous())) break;
                }
            }
        });
        menuFile.add(menuCloseAllOthers);
        JMenu menuEdit = new JMenu("Edit");
        JMenuItem menuUndo = new JMenuItem("Undo");
        menuUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = ScriptingEditor.this.tabbedPane.getTabComponentAt(0);
                if (!(comp instanceof ScriptingPanel)) {
                    return;
                }
                ScriptingPanel panel = (ScriptingPanel)comp;
                panel.getTextArea().getActionForKeyStroke(KeyStroke.getKeyStroke(90, ctrlMask)).actionPerformed(e);
            }
        });
        menuUndo.setAccelerator(KeyStroke.getKeyStroke(90, ctrlMask));
        menuEdit.add(menuUndo);
        JMenuItem menuRedo = new JMenuItem("Redo");
        menuRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component comp = ScriptingEditor.this.tabbedPane.getTabComponentAt(0);
                if (!(comp instanceof ScriptingPanel)) {
                    return;
                }
                ScriptingPanel panel = (ScriptingPanel)comp;
                panel.getTextArea().getActionForKeyStroke(KeyStroke.getKeyStroke(89, ctrlMask)).actionPerformed(e);
            }
        });
        menuRedo.setAccelerator(KeyStroke.getKeyStroke(89, ctrlMask));
        menuEdit.add(menuRedo);
        menuEdit.add(new JSeparator());
        JMenuItem menuFormat = new JMenuItem("Format");
        menuFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (c instanceof ScriptingPanel) {
                    ScriptingPanel panel = (ScriptingPanel)c;
                    panel.format();
                }
            }
        });
        menuFormat.setAccelerator(KeyStroke.getKeyStroke(70, ctrlMask | 0x40));
        menuEdit.add(menuFormat);
        JMenuItem menuAutoImport = new JMenuItem("Auto-Import");
        menuAutoImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (c instanceof ScriptingPanel) {
                    ScriptingPanel panel = (ScriptingPanel)c;
                    panel.getScriptHandler().autoImport();
                }
            }
        });
        menuEdit.add(menuAutoImport);
        menuEdit.add(new JSeparator());
        JMenuItem menuFind = new JMenuItem("Find");
        menuFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.displayFindReplace();
            }
        });
        menuFind.setAccelerator(KeyStroke.getKeyStroke(70, ctrlMask));
        menuEdit.add(menuFind);
        JMenuItem menuReplace = new JMenuItem("Replace");
        menuReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.displayFindReplace();
            }
        });
        menuReplace.setAccelerator(KeyStroke.getKeyStroke(72, ctrlMask));
        menuEdit.add(menuReplace);
        JMenuItem menuGotoLine = new JMenuItem("Go to Line...");
        menuGotoLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component c = ScriptingEditor.this.tabbedPane.getSelectedComponent();
                if (c instanceof ScriptingPanel) {
                    ((ScriptingPanel)c).displayGotoLine();
                }
            }
        });
        menuGotoLine.setAccelerator(KeyStroke.getKeyStroke(76, ctrlMask));
        menuEdit.add(menuGotoLine);
        JMenu menuTemplate = new JMenu("Templates");
        this.populateMenuTemplate(menuTemplate);
        JMenu menuOptions = new JMenu("Options");
        JMenuItem menuPreferences = new JMenuItem("Preferences");
        menuPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindow prefs = PreferencesWindow.getPreferencesWindow();
                prefs.addToDesktopPane();
                prefs.setVisible(true);
            }
        });
        menuOptions.add(menuPreferences);
        JMenuItem menuBindingsFrame = new JMenuItem("Bindings Frame");
        menuBindingsFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingsScriptFrame frame = BindingsScriptFrame.getInstance();
                frame.update();
                if (frame.isVisible()) {
                    frame.setVisible(false);
                } else {
                    frame.setVisible(true);
                }
            }
        });
        menuOptions.add(menuBindingsFrame);
        JMenuItem menuHelp = new JMenuItem("Help (online)");
        menuHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkUtil.openBrowser((String)"http://icy.bioimageanalysis.org/plugin/Script_Editor#documentation");
            }
        });
        menuOptions.add(menuHelp);
        toReturn.add(menuFile);
        toReturn.add(menuEdit);
        toReturn.add(menuTemplate);
        toReturn.add(menuOptions);
        this.updateRecentFilesMenu();
        this.setDefaultCloseOperation(0);
        this.addFrameListener(this.frameListener);
        return toReturn;
    }

    public void displayFindReplace() {
        FindAndReplaceDialog.showDialog(this);
    }

    private boolean closeAllTabs() {
        boolean ok = true;
        int N = this.tabbedPane.getTabCount() - 1;
        int i = 0;
        while (i < N) {
            if (!this.closeTab(0)) {
                ok = false;
                break;
            }
            ++i;
        }
        return ok;
    }

    protected boolean closeTab(final int i) {
        Component c = this.tabbedPane.getTabComponentAt(i);
        if (c instanceof TabComponentButton) {
            ScriptingPanel panel = ((TabComponentButton)c).getPanel();
            boolean ok = panel.close();
            if (ok) {
                panel.removeSavedAsListener(this.savedAsListener);
                panel.removeTitleChangedListener(this.titleChangedListener);
                panel.removeFileDropListeners();
                panel.removeHyperlinkListener(this.hyperlinkListener);
                panel.removeLanguageListener(this.languageListener);
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (i == ScriptingEditor.this.tabbedPane.getSelectedIndex() && i >= ScriptingEditor.this.tabbedPane.getTabCount() - 2) {
                            ScriptingEditor.this.tabbedPane.setSelectedIndex(i - 1);
                        }
                        if (i != -1) {
                            ScriptingEditor.this.tabbedPane.remove(i);
                        }
                    }
                });
                this.saveEditorState();
            }
            return ok;
        }
        return true;
    }

    protected boolean closeTab(TabComponentButton tabComponent) {
        int i = this.tabbedPane.indexOfTabComponent(tabComponent);
        return this.closeTab(i);
    }

    private void populateMenuTemplate(JMenu menuTemplate) {
        JMenu menuTemplateJS = new JMenu("JavaScript");
        JMenuItem itemJSDuplicateSequence = new JMenuItem("Duplicate Sequence");
        itemJSDuplicateSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.openJSTemplate("duplicateSequence.js");
            }
        });
        menuTemplateJS.add(itemJSDuplicateSequence);
        JMenuItem itemThreshold = new JMenuItem("Threshold");
        itemThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.openJSTemplate("threshold.js");
            }
        });
        menuTemplateJS.add(itemThreshold);
        JMenu menuTemplatePython = new JMenu("Python");
        JMenuItem itemPythonDuplicateSequence = new JMenuItem("Duplicate Sequence");
        itemPythonDuplicateSequence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptingEditor.this.openPythonTemplate("duplicateSequence.py");
            }
        });
        menuTemplatePython.add(itemPythonDuplicateSequence);
        menuTemplate.add(menuTemplateJS);
        if (IS_PYTHON_INSTALLED) {
            menuTemplate.add(menuTemplatePython);
        }
    }

    private void openJSTemplate(String templateName) {
        this.openTemplate("js", templateName);
    }

    private void openPythonTemplate(String templateName) {
        this.openTemplate("python", templateName);
    }

    private void openTemplate(String type, String templateName) {
        String current = new File(".").getAbsolutePath();
        current = current.substring(0, current.length() - 1);
        try {
            InputStream is = PluginLoader.getResourceAsStream((String)("plugins/tprovoost/scripteditor/resources/templates/" + type + "/" + templateName));
            this.openStream(templateName, is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getCurrentDirectory() {
        return currentDirectoryPath;
    }

    public void changeConsoleLanguage(String language) {
        this.console = language.contentEquals("Python") ? new PythonScriptingconsole() : new Scriptingconsole();
        this.console.setLanguage(language);
        this.console.setOutput(this.consoleOutput);
        if (this.panelSouth != null) {
            this.panelSouth.removeAll();
            this.panelSouth.add((Component)this.console, "Center");
            this.panelSouth.add((Component)this.btnClearConsole, "East");
            this.panelSouth.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClearConsole && this.console != null) {
            this.console.clear();
        }
    }

    public void addRecentFile(File f) {
        this.recentFiles.add(f);
        this.updateRecentFilesMenu();
    }

    public static String getDefaultFolder() {
        return "";
    }

    public ConsoleOutput getConsoleOutput() {
        return this.consoleOutput;
    }
}

