/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptingconsole;

import icy.util.DateUtil;
import icy.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.python.core.PyException;
import org.python.util.InteractiveConsole;
import org.python.util.InteractiveInterpreter;
import plugins.tprovoost.scripteditor.gui.ConsoleOutput;
import plugins.tprovoost.scripteditor.scriptingconsole.BindingsScriptFrame;
import plugins.tprovoost.scripteditor.scriptingconsole.Scriptingconsole;
import plugins.tprovoost.scripteditor.scriptinghandlers.py.PythonScriptingHandler;

public class PythonScriptingconsole
extends Scriptingconsole {
    private static final long serialVersionUID = 1L;
    private static final String STRING_INPUT = ">>> ";
    private static final String STRING_INPUT_MORE = "... ";
    private InteractiveConsole console = new InteractiveConsole();
    private boolean waitingForMore;

    public PythonScriptingconsole() {
        if (PythonScriptingHandler.getInterpreter() == null) {
            PythonScriptingHandler.setInterpreter((InteractiveInterpreter)this.console);
        }
        this.setMinimumSize(new Dimension(0, 25));
        this.setPreferredSize(new Dimension(0, 25));
        Insets insets = this.getMargin();
        if (insets != null) {
            this.setMargin(new Insets(insets.top, 30, insets.bottom, insets.right));
        } else {
            this.setMargin(new Insets(0, 30, 0, 0));
        }
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    @Override
    public void setLanguage(String language) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void keyPressed(KeyEvent e) {
        text = this.getText();
        switch (e.getKeyCode()) {
            case 38: {
                if (this.posInHistory >= this.history.size() - 1) break;
                ++this.posInHistory;
                this.setText((String)this.history.get(this.posInHistory));
                e.consume();
                break;
            }
            case 40: {
                if (this.posInHistory <= 0) break;
                --this.posInHistory;
                this.setText((String)this.history.get(this.posInHistory));
                e.consume();
                break;
            }
            case 10: {
                if (text.isEmpty()) break;
                time = DateUtil.now((String)"HH:mm:ss");
                if (this.output != null) {
                    if (this.waitingForMore) {
                        this.output.append("... " + this.getText() + "\n");
                    } else {
                        this.output.append(">>> " + this.getText() + "\n");
                    }
                } else {
                    System.out.println(String.valueOf(time) + ": " + text);
                }
                try {
                    this.waitingForMore = this.console.push(text);
                }
                catch (PyException pe) {
                    if (this.scriptHandler == null) ** GOTO lbl31
                    this.scriptHandler.getEngine().getWriter().write(pe.toString());
                }
lbl31:
                // 3 sources

                this.history.add(0, text);
                this.setText("");
                this.posInHistory = -1;
                BindingsScriptFrame.getInstance().update();
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void setOutput(ConsoleOutput outputNew) {
        this.output = outputNew;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw, true){

            @Override
            public void write(String s) {
                if (PythonScriptingconsole.this.output != null) {
                    PythonScriptingconsole.this.output.append(s);
                }
            }
        };
        this.console.setOut((Writer)pw);
        this.console.setErr((Writer)pw);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        if (this.waitingForMore) {
            GraphicsUtil.drawCenteredString((Graphics)g2, (String)STRING_INPUT_MORE, (int)(this.getMargin().left - 10), (int)(this.getHeight() / 2), (boolean)false);
        } else {
            GraphicsUtil.drawCenteredString((Graphics)g2, (String)STRING_INPUT, (int)(this.getMargin().left - 10), (int)(this.getHeight() / 2), (boolean)false);
        }
        g2.dispose();
    }
}

