/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginScriptFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    private HashSet<ScriptEngineFactory> engineSpis = new HashSet();
    private HashMap<String, ScriptEngineFactory> nameAssociations = new HashMap();
    private HashMap<String, ScriptEngineFactory> extensionAssociations = new HashMap();
    private HashMap<String, ScriptEngineFactory> mimeTypeAssociations = new HashMap();
    private Bindings globalScope = new SimpleBindings();

    public ScriptEngineManager() {
        for (PluginDescriptor plugin : PluginLoader.getPlugins(PluginScriptFactory.class, (boolean)true, (boolean)false, (boolean)false)) {
            try {
                PluginScriptFactory psf = (PluginScriptFactory)PluginLauncher.create((PluginDescriptor)plugin);
                this.engineSpis.add(psf.getScriptEngineFactory());
            }
            catch (Throwable t) {
                System.err.println("Error while retrieving ScriptEngineFactory from " + plugin.getName() + ":");
                System.err.println(t.getMessage());
            }
        }
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = bindings;
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void put(String key, Object value) {
        this.globalScope.put(key, value);
    }

    public Object get(String key) {
        return this.globalScope.get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.nameAssociations.get(shortName);
        if (obj != null) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> names = null;
            try {
                names = spi.getNames();
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
            if (names == null) continue;
            for (String name : names) {
                if (!shortName.equals(name)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exp) {
                    ScriptEngineManager.debugPrint(exp);
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.extensionAssociations.get(extension);
        if (obj != null) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> exts = null;
            try {
                exts = spi.getExtensions();
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
            if (exts == null) continue;
            for (String ext : exts) {
                if (!extension.equals(ext)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exp) {
                    ScriptEngineManager.debugPrint(exp);
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory obj = this.mimeTypeAssociations.get(mimeType);
        if (obj != null) {
            ScriptEngineFactory spi = obj;
            try {
                ScriptEngine engine = spi.getScriptEngine();
                engine.setBindings(this.getBindings(), 200);
                return engine;
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
        }
        for (ScriptEngineFactory spi : this.engineSpis) {
            List<String> types = null;
            try {
                types = spi.getMimeTypes();
            }
            catch (Exception exp) {
                ScriptEngineManager.debugPrint(exp);
            }
            if (types == null) continue;
            for (String type : types) {
                if (!mimeType.equals(type)) continue;
                try {
                    ScriptEngine engine = spi.getScriptEngine();
                    engine.setBindings(this.getBindings(), 200);
                    return engine;
                }
                catch (Exception exp) {
                    ScriptEngineManager.debugPrint(exp);
                }
            }
        }
        return null;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> res = new ArrayList<ScriptEngineFactory>(this.engineSpis.size());
        for (ScriptEngineFactory spi : this.engineSpis) {
            res.add(spi);
        }
        return Collections.unmodifiableList(res);
    }

    public void registerEngineName(String name, ScriptEngineFactory factory) {
        if (name == null || factory == null) {
            throw new NullPointerException();
        }
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String type, ScriptEngineFactory factory) {
        if (type == null || factory == null) {
            throw new NullPointerException();
        }
        this.mimeTypeAssociations.put(type, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension == null || factory == null) {
            throw new NullPointerException();
        }
        this.extensionAssociations.put(extension, factory);
    }

    private static void debugPrint(Throwable exp) {
        exp.printStackTrace();
    }
}

