/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import icy.image.ImageUtil;
import icy.plugin.PluginLoader;
import icy.resource.icon.IcyIcon;
import java.awt.Image;
import java.io.InputStream;
import java.util.ArrayList;
import javax.script.ScriptException;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import org.fife.ui.rtextarea.Gutter;

public class ScriptingErrors {
    private static final IcyIcon ICON_ERROR_TOOLTIP = new IcyIcon((Image)ImageUtil.load((InputStream)PluginLoader.getResourceAsStream((String)"plugins/tprovoost/scripteditor/resources/icons/quickfix_warning_obj.gif")), 16, false);
    private static final IcyIcon ICON_ERROR = new IcyIcon((Image)ImageUtil.load((InputStream)PluginLoader.getResourceAsStream((String)"plugins/tprovoost/scripteditor/resources/icons/error.gif")), 15, false);
    private final ArrayList<ScriptException> errors = new ArrayList();
    private final ArrayList<ScriptException> warnings = new ArrayList();
    private ScriptException runtimeError = null;

    public void displayOnGutter(Gutter gutter) {
        String message;
        int index;
        String normalizedMessage;
        ArrayList<Integer> lines = new ArrayList<Integer>();
        ArrayList<Boolean> areWarning = new ArrayList<Boolean>();
        ArrayList<String> messages = new ArrayList<String>();
        if (this.runtimeError != null) {
            lines.add(this.runtimeError.getLineNumber());
            areWarning.add(false);
            String normalizedMessage2 = this.runtimeError.getMessage().replaceAll("<", "").replaceAll(">", "");
            messages.add(normalizedMessage2);
        }
        for (ScriptException see : this.errors) {
            normalizedMessage = see.getMessage().replaceAll("<", "").replaceAll(">", "");
            if (lines.contains(see.getLineNumber())) {
                index = lines.indexOf(see.getLineNumber());
                message = String.valueOf((String)messages.get(index)) + "<br>" + normalizedMessage;
                messages.set(index, message);
                areWarning.set(index, false);
                continue;
            }
            lines.add(see.getLineNumber());
            areWarning.add(false);
            messages.add(normalizedMessage);
        }
        for (ScriptException see : this.warnings) {
            normalizedMessage = see.getMessage().replaceAll("<", "").replaceAll(">", "");
            if (lines.contains(see.getLineNumber())) {
                index = lines.indexOf(see.getLineNumber());
                message = String.valueOf((String)messages.get(index)) + "<br>" + normalizedMessage;
                messages.set(index, message);
                continue;
            }
            lines.add(see.getLineNumber());
            areWarning.add(false);
            messages.add(normalizedMessage);
        }
        int i = 0;
        while (i < lines.size()) {
            IcyIcon icon = (Boolean)areWarning.get(i) != false ? ICON_ERROR_TOOLTIP : ICON_ERROR;
            String tooltip = "<html>" + (String)messages.get(i) + "</html>";
            int textAreaLineNumber = (Integer)lines.get(i) - 1;
            try {
                gutter.addLineTrackingIcon(textAreaLineNumber, (Icon)icon, tooltip);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                System.out.println(tooltip);
            }
            gutter.repaint();
            ++i;
        }
    }

    public void setRuntimeError(ScriptException e) {
        this.runtimeError = e;
    }

    public void cleanup() {
        this.errors.clear();
        this.warnings.clear();
        this.runtimeError = null;
    }

    public void addWarning(ScriptException se) {
        this.warnings.add(se);
    }

    public void addError(ScriptException se) {
        this.errors.add(se);
    }
}

