/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyException;
import org.python.core.PyObject;

class NextFunction
extends PyBuiltinFunction {
    NextFunction() {
        super("next", "next(iterator[, default])\n\nReturn the next item from the iterator. If default is given and the iterator\nis exhausted, it is returned instead of raising StopIteration.");
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("next", args, kwds, new String[]{"iterator", "default"}, 1);
        ap.noKeywords();
        PyObject it = ap.getPyObject(0);
        PyObject def = ap.getPyObject(1, null);
        PyObject next = it.__findattr__("next");
        if (next == null) {
            throw Py.TypeError(String.format("'%.200s' object is not an iterator", it.getType().fastGetName()));
        }
        try {
            return next.__call__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.StopIteration) || def == null) {
                throw pye;
            }
            return def;
        }
    }
}

