/*
 * Decompiled with CFR 0.152.
 */
package plugins.tlecomte.jythonForIcy;

import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginDaemon;
import icy.plugin.interface_.PluginLibrary;
import icy.plugin.interface_.PluginScriptFactory;
import icy.util.ClassUtil;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.script.ScriptEngineFactory;
import org.python.core.Py;
import org.python.core.PySystemState;
import org.python.jsr223.PyScriptEngineFactory;
import plugins.tlecomte.jythonForIcy.ExtractionHelper;
import plugins.tlecomte.jythonForIcy.ExtractionTimestamps;
import plugins.tlecomte.jythonForIcy.PythonLibraries;

@PythonLibraries
public class JythonForIcy
extends Plugin
implements PluginDaemon,
PluginLibrary,
PluginScriptFactory {
    final String TIMESTAMPS_FILENAME = "ExtractDescriptor";

    public void init() {
        File file;
        System.setProperty("python.console.encoding", "UTF-8");
        ExtractionTimestamps timestamps = new ExtractionTimestamps();
        String qualifiedDir = new File(ClassUtil.getPathFromQualifiedName((String)this.getDescriptor().getClassName())).getParent();
        String timestampsFile = qualifiedDir + File.separator + "ExtractDescriptor" + ".xml";
        boolean loadSuccess = XMLPersistentHelper.loadFromXML((XMLPersistent)timestamps, (String)timestampsFile);
        if (!loadSuccess && (file = new File(timestampsFile)).exists()) {
            System.err.println("Failed to load the Python extraction timestamp file from " + timestampsFile);
        }
        ExtractionHelper.extractPyFiles(timestamps);
        boolean saveSucess = XMLPersistentHelper.saveToXML((XMLPersistent)timestamps, (String)timestampsFile);
        if (!saveSucess) {
            System.err.println("Failed to save the Python extraction timestamp file to " + timestampsFile);
        }
    }

    public void run() {
    }

    public void stop() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                new PySystemState().cleanup();
                Py.defaultSystemState.cleanup();
            }
        };
        Future<?> future = executor.submit(runnable);
        executor.shutdown();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public ScriptEngineFactory getScriptEngineFactory() {
        return new PyScriptEngineFactory();
    }
}

