/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class JBandControlPanel
extends AbstractBandControlPanel
implements UIResource {
    private Map<String, JRibbonGallery> galleryNameMap;
    private LinkedList<ControlPanelGroup> controlPanelGroups = new LinkedList();
    public static final List<AbstractCommandButton> EMPTY_GALLERY_BUTTONS_LIST = new LinkedList<AbstractCommandButton>();
    public static final List<JRibbonGallery> EMPTY_RIBBON_GALLERIES_LIST = new LinkedList<JRibbonGallery>();
    public static final String uiClassID = "BandControlPanelUI";

    public JBandControlPanel() {
        this.galleryNameMap = new HashMap<String, JRibbonGallery>();
    }

    public void setUI(BandControlPanelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BandControlPanelUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBandControlPanelUI());
        }
    }

    @Override
    public BandControlPanelUI getUI() {
        return (BandControlPanelUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public synchronized void addCommandButton(AbstractCommandButton ribbonButton, RibbonElementPriority priority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.addCommandButton(this.controlPanelGroups.size() - 1, ribbonButton, priority);
    }

    public synchronized void addCommandButton(int index, AbstractCommandButton ribbonButton, RibbonElementPriority priority) {
        this.controlPanelGroups.get(index).addCommandButton(ribbonButton, priority);
        super.add(ribbonButton);
    }

    public synchronized void addRibbonGallery(JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.addRibbonGallery(this.controlPanelGroups.size() - 1, ribbonGallery, priority);
    }

    public synchronized void addRibbonGallery(int index, JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
        String galleryName = ribbonGallery.getName();
        if (galleryName == null || galleryName.isEmpty()) {
            throw new IllegalArgumentException("Ribbon gallery name null or empty");
        }
        if (this.galleryNameMap.containsKey(galleryName)) {
            throw new IllegalArgumentException("Another riboon gallery with the same name already exists");
        }
        this.controlPanelGroups.get(index).addRibbonGallery(ribbonGallery, priority);
        this.galleryNameMap.put(galleryName, ribbonGallery);
        super.add(ribbonGallery);
    }

    public void addRibbonComponent(JRibbonComponent comp) {
        this.addRibbonComponent(comp, 1);
    }

    public void addRibbonComponent(JRibbonComponent comp, int rowSpan) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.addRibbonComponent(this.controlPanelGroups.size() - 1, comp, rowSpan);
    }

    public void addRibbonComponent(int index, JRibbonComponent comp, int rowSpan) {
        this.controlPanelGroups.get(index).addRibbonComponent(comp, rowSpan);
        super.add(comp);
    }

    public synchronized int getCommandButtonGroupIndex(AbstractCommandButton button) {
        int i = 0;
        while (i < this.controlPanelGroups.size()) {
            if (this.controlPanelGroups.get(i).getPriority(button) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int getRibbonGalleryGroupIndex(JRibbonGallery gallery) {
        int i = 0;
        while (i < this.controlPanelGroups.size()) {
            if (this.controlPanelGroups.get(i).getPriority(gallery) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized int getRibbonComponentGroupIndex(JRibbonComponent comp) {
        int i = 0;
        while (i < this.controlPanelGroups.size()) {
            if (this.controlPanelGroups.get(i).getRibbonComps().contains(comp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized void removeCommandButton(AbstractCommandButton button) {
        int ind = this.getCommandButtonGroupIndex(button);
        if (ind != -1) {
            ControlPanelGroup cpg = this.controlPanelGroups.get(ind);
            cpg.removeCommandButton(button, cpg.getPriority(button));
            super.remove(button);
            this.revalidate();
        }
    }

    public synchronized void removeRibbonGallery(JRibbonGallery gallery) {
        int ind = this.getRibbonGalleryGroupIndex(gallery);
        if (ind != -1) {
            ControlPanelGroup cpg = this.controlPanelGroups.get(ind);
            cpg.removeRibbonGallery(gallery, cpg.getPriority(gallery));
            this.galleryNameMap.remove(gallery.getName());
            super.remove(gallery);
            this.revalidate();
        }
    }

    public void removeRibbonComponent(JRibbonComponent comp) {
        int ind = this.getRibbonComponentGroupIndex(comp);
        if (ind != -1) {
            ControlPanelGroup cpg = this.controlPanelGroups.get(ind);
            cpg.removeRibbonComponent(comp);
            super.remove(comp);
            this.revalidate();
        }
    }

    public void removeAllCommandButtons() {
        List<AbstractCommandButton> buttons = this.getAllCommandButtons();
        for (AbstractCommandButton button : buttons) {
            this.removeCommandButton(button);
        }
    }

    public void removeAllRibbonGalleries() {
        List<JRibbonGallery> galleries = this.getAllRibbonGalleries();
        for (JRibbonGallery gallery : galleries) {
            this.removeRibbonGallery(gallery);
        }
    }

    public void removeAllRibbonComps() {
        List<JRibbonComponent> comps = this.getAllRibbonComps();
        for (JRibbonComponent comp : comps) {
            this.removeRibbonComponent(comp);
        }
    }

    public synchronized RibbonElementPriority getPriority(AbstractCommandButton button) {
        for (ControlPanelGroup cpg : this.controlPanelGroups) {
            RibbonElementPriority result = cpg.getPriority(button);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public synchronized RibbonElementPriority getPriority(JRibbonGallery gallery) {
        for (ControlPanelGroup cpg : this.controlPanelGroups) {
            RibbonElementPriority result = cpg.getPriority(gallery);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public synchronized void setPriority(JCommandButton ribbonButton, RibbonElementPriority newPriority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().setPriority(ribbonButton, newPriority);
    }

    public synchronized void setPriority(JRibbonGallery ribbonGallery, RibbonElementPriority newPriority) {
        if (this.controlPanelGroups.size() == 0) {
            this.startGroup();
        }
        this.controlPanelGroups.getLast().setPriority(ribbonGallery, newPriority);
    }

    public List<AbstractCommandButton> getAllCommandButtons() {
        ArrayList<AbstractCommandButton> result = new ArrayList<AbstractCommandButton>();
        for (ControlPanelGroup cpg : this.controlPanelGroups) {
            result.addAll(cpg.getAllCommandButtons());
        }
        return result;
    }

    public List<JRibbonGallery> getAllRibbonGalleries() {
        ArrayList<JRibbonGallery> result = new ArrayList<JRibbonGallery>();
        for (ControlPanelGroup cpg : this.controlPanelGroups) {
            result.addAll(cpg.getAllRibbonGalleries());
        }
        return result;
    }

    public List<JRibbonComponent> getAllRibbonComps() {
        ArrayList<JRibbonComponent> result = new ArrayList<JRibbonComponent>();
        for (ControlPanelGroup cpg : this.controlPanelGroups) {
            result.addAll(cpg.getRibbonComps());
        }
        return result;
    }

    public List<ControlPanelGroup> getControlPanelGroups() {
        return Collections.unmodifiableList(this.controlPanelGroups);
    }

    public int getControlPanelGroupCount() {
        if (this.controlPanelGroups == null) {
            return 1;
        }
        return this.controlPanelGroups.size();
    }

    public String getControlPanelGroupTitle(int controlPanelGroupIndex) {
        if (this.controlPanelGroups == null) {
            return null;
        }
        return this.controlPanelGroups.get((int)controlPanelGroupIndex).groupTitle;
    }

    public int startGroup() {
        return this.startGroup(null);
    }

    public int startGroup(String groupTitle) {
        ControlPanelGroup controlPanelGroup = new ControlPanelGroup(groupTitle);
        this.controlPanelGroups.addLast(controlPanelGroup);
        this.fireChanged();
        return this.controlPanelGroups.size() - 1;
    }

    public void setGroupTitle(int groupIndex, String groupTitle) {
        this.controlPanelGroups.get(groupIndex).setGroupTitle(groupTitle);
        this.fireChanged();
    }

    public JRibbonGallery getRibbonGallery(String galleryName) {
        return this.galleryNameMap.get(galleryName);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent ce = new ChangeEvent(this);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(ce);
            }
            i -= 2;
        }
    }

    public List<JRibbonComponent> getRibbonComponents(int groupIndex) {
        return Collections.unmodifiableList(this.controlPanelGroups.get(groupIndex).getRibbonComps());
    }

    public static class ControlPanelGroup {
        public String groupTitle;
        private boolean hasGalleries;
        private int galleryCount;
        private Map<RibbonElementPriority, List<JRibbonGallery>> ribbonGalleries;
        private Map<JRibbonGallery, RibbonElementPriority> ribbonGalleriesPriorities;
        private Map<RibbonElementPriority, List<AbstractCommandButton>> ribbonButtons;
        private Map<AbstractCommandButton, RibbonElementPriority> ribbonButtonsPriorities;
        private List<JRibbonComponent> coreComps;
        private Map<JRibbonComponent, Integer> coreCompRowSpans;

        public ControlPanelGroup(String groupTitle) {
            this.groupTitle = groupTitle;
            this.ribbonButtons = new HashMap<RibbonElementPriority, List<AbstractCommandButton>>();
            this.ribbonButtonsPriorities = new HashMap<AbstractCommandButton, RibbonElementPriority>();
            this.ribbonGalleries = new HashMap<RibbonElementPriority, List<JRibbonGallery>>();
            this.ribbonGalleriesPriorities = new HashMap<JRibbonGallery, RibbonElementPriority>();
            this.hasGalleries = false;
            this.galleryCount = 0;
            this.coreComps = new ArrayList<JRibbonComponent>();
            this.coreCompRowSpans = new HashMap<JRibbonComponent, Integer>();
        }

        public String getGroupTitle() {
            return this.groupTitle;
        }

        public void setGroupTitle(String newTitle) {
            if (this.groupTitle == null && newTitle != null) {
                throw new IllegalArgumentException("Cannot set a title for an unnamed group");
            }
            if (this.groupTitle != null && newTitle == null) {
                throw new IllegalArgumentException("Cannot remove a title from a named group");
            }
            this.groupTitle = newTitle;
        }

        public boolean isCoreContent() {
            return !this.coreComps.isEmpty();
        }

        public synchronized void addCommandButton(AbstractCommandButton ribbonButton, RibbonElementPriority priority) {
            if (this.groupTitle != null) {
                throw new UnsupportedOperationException("Can't add command buttons to ribbon band group with non-null title");
            }
            if (this.isCoreContent()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            if (!this.ribbonButtons.containsKey((Object)priority)) {
                this.ribbonButtons.put(priority, new LinkedList());
            }
            List<AbstractCommandButton> al = this.ribbonButtons.get((Object)priority);
            al.add(ribbonButton);
            this.ribbonButtonsPriorities.put(ribbonButton, priority);
            ribbonButton.setDisplayState(CommandButtonDisplayState.BIG);
        }

        public synchronized void addRibbonGallery(JRibbonGallery ribbonGallery, RibbonElementPriority priority) {
            if (this.groupTitle != null) {
                throw new UnsupportedOperationException("Can't add galleries to ribbon band group with non-null title");
            }
            if (this.isCoreContent()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            if (!this.ribbonGalleries.containsKey((Object)priority)) {
                this.ribbonGalleries.put(priority, new LinkedList());
            }
            List<JRibbonGallery> al = this.ribbonGalleries.get((Object)priority);
            al.add(ribbonGallery);
            this.ribbonGalleriesPriorities.put(ribbonGallery, priority);
            ribbonGallery.setDisplayPriority(RibbonElementPriority.TOP);
            this.hasGalleries = true;
            ++this.galleryCount;
        }

        public synchronized void removeCommandButton(AbstractCommandButton button, RibbonElementPriority priority) {
            if (button != null && priority != null) {
                this.getRibbonButtons(priority).remove(button);
                this.ribbonButtonsPriorities.remove(button);
            }
        }

        public synchronized void removeRibbonGallery(JRibbonGallery gallery, RibbonElementPriority priority) {
            if (gallery != null && priority != null) {
                this.getRibbonGalleries(priority).remove(gallery);
                this.ribbonGalleriesPriorities.remove(gallery);
                if (this.galleryCount > 0) {
                    --this.galleryCount;
                }
                this.hasGalleries = this.galleryCount > 0;
            }
        }

        public synchronized void removeRibbonComponent(JRibbonComponent comp) {
            if (comp != null) {
                this.coreComps.remove(comp);
                this.coreCompRowSpans.remove(comp);
            }
        }

        public synchronized void setPriority(JCommandButton ribbonButton, RibbonElementPriority newPriority) {
            RibbonElementPriority oldPriority = this.ribbonButtonsPriorities.get(ribbonButton);
            if (newPriority == oldPriority) {
                return;
            }
            this.ribbonButtons.get((Object)oldPriority).remove(ribbonButton);
            if (!this.ribbonButtons.containsKey((Object)newPriority)) {
                this.ribbonButtons.put(newPriority, new ArrayList());
            }
            this.ribbonButtons.get((Object)newPriority).add(ribbonButton);
        }

        public synchronized void setPriority(JRibbonGallery ribbonGallery, RibbonElementPriority newPriority) {
            RibbonElementPriority oldPriority = this.ribbonGalleriesPriorities.get(ribbonGallery);
            if (newPriority == oldPriority) {
                return;
            }
            this.ribbonGalleries.get((Object)oldPriority).remove(ribbonGallery);
            if (!this.ribbonGalleries.containsKey((Object)newPriority)) {
                this.ribbonGalleries.put(newPriority, new ArrayList());
            }
            this.ribbonGalleries.get((Object)newPriority).add(ribbonGallery);
        }

        public void addRibbonComponent(JRibbonComponent comp, int rowSpan) {
            if (!this.ribbonButtonsPriorities.isEmpty() || !this.ribbonGalleries.isEmpty()) {
                throw new UnsupportedOperationException("Ribbon band groups do not support mixing JRibbonComponents and custom Flamingo components");
            }
            comp.setOpaque(false);
            this.coreComps.add(comp);
            this.coreCompRowSpans.put(comp, rowSpan);
        }

        public List<AbstractCommandButton> getAllCommandButtons() {
            ArrayList<AbstractCommandButton> result = new ArrayList<AbstractCommandButton>();
            result.addAll(this.getRibbonButtons(RibbonElementPriority.LOW));
            result.addAll(this.getRibbonButtons(RibbonElementPriority.MEDIUM));
            result.addAll(this.getRibbonButtons(RibbonElementPriority.TOP));
            return result;
        }

        public List<AbstractCommandButton> getRibbonButtons(RibbonElementPriority priority) {
            List<AbstractCommandButton> result = this.ribbonButtons.get((Object)priority);
            if (result == null) {
                return EMPTY_GALLERY_BUTTONS_LIST;
            }
            return result;
        }

        public RibbonElementPriority getPriority(AbstractCommandButton button) {
            if (this.getRibbonButtons(RibbonElementPriority.LOW).indexOf(button) != -1) {
                return RibbonElementPriority.LOW;
            }
            if (this.getRibbonButtons(RibbonElementPriority.MEDIUM).indexOf(button) != -1) {
                return RibbonElementPriority.MEDIUM;
            }
            if (this.getRibbonButtons(RibbonElementPriority.TOP).indexOf(button) != -1) {
                return RibbonElementPriority.TOP;
            }
            return null;
        }

        public List<JRibbonGallery> getAllRibbonGalleries() {
            ArrayList<JRibbonGallery> result = new ArrayList<JRibbonGallery>();
            result.addAll(this.getRibbonGalleries(RibbonElementPriority.LOW));
            result.addAll(this.getRibbonGalleries(RibbonElementPriority.MEDIUM));
            result.addAll(this.getRibbonGalleries(RibbonElementPriority.TOP));
            return result;
        }

        public List<JRibbonGallery> getRibbonGalleries(RibbonElementPriority priority) {
            List<JRibbonGallery> result = this.ribbonGalleries.get((Object)priority);
            if (result == null) {
                return EMPTY_RIBBON_GALLERIES_LIST;
            }
            return result;
        }

        public RibbonElementPriority getPriority(JRibbonGallery gallery) {
            if (this.getRibbonGalleries(RibbonElementPriority.LOW).indexOf(gallery) != -1) {
                return RibbonElementPriority.LOW;
            }
            if (this.getRibbonGalleries(RibbonElementPriority.MEDIUM).indexOf(gallery) != -1) {
                return RibbonElementPriority.MEDIUM;
            }
            if (this.getRibbonGalleries(RibbonElementPriority.TOP).indexOf(gallery) != -1) {
                return RibbonElementPriority.TOP;
            }
            return null;
        }

        public boolean isEmpty() {
            return this.getCommandButtonsCount() == 0 && this.getRibbonGalleriesCount() == 0 && this.getRibbonCompsCount() == 0;
        }

        public boolean hasCommandButtons() {
            return this.getCommandButtonsCount() > 0;
        }

        public int getCommandButtonsCount() {
            return this.getRibbonButtons(RibbonElementPriority.LOW).size() + this.getRibbonButtons(RibbonElementPriority.LOW).size() + this.getRibbonButtons(RibbonElementPriority.LOW).size();
        }

        public boolean hasRibbonGalleries() {
            return this.hasGalleries;
        }

        public int getRibbonGalleriesCount() {
            return this.galleryCount;
        }

        public boolean hasRibbonComps() {
            return this.getRibbonCompsCount() > 0;
        }

        public int getRibbonCompsCount() {
            return this.getRibbonComps().size();
        }

        public List<JRibbonComponent> getRibbonComps() {
            return this.coreComps;
        }

        public Map<JRibbonComponent, Integer> getRibbonCompsRowSpans() {
            return this.coreCompRowSpans;
        }
    }
}

