/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentSet;
import clojure.lang.ATransientSet;
import clojure.lang.IEditableCollection;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.ISeq;
import clojure.lang.ITransientCollection;
import clojure.lang.ITransientMap;
import clojure.lang.PersistentHashMap;
import java.util.List;

public class PersistentHashSet
extends APersistentSet
implements IObj,
IEditableCollection {
    public static final PersistentHashSet EMPTY = new PersistentHashSet(null, PersistentHashMap.EMPTY);
    final IPersistentMap _meta;

    public static PersistentHashSet create(Object ... init) {
        PersistentHashSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            ret = (PersistentHashSet)ret.cons(init[i]);
        }
        return ret;
    }

    public static PersistentHashSet create(List init) {
        PersistentHashSet ret = EMPTY;
        for (Object key2 : init) {
            ret = (PersistentHashSet)ret.cons(key2);
        }
        return ret;
    }

    public static PersistentHashSet create(ISeq items) {
        PersistentHashSet ret = EMPTY;
        while (items != null) {
            ret = (PersistentHashSet)ret.cons(items.first());
            items = items.next();
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(Object ... init) {
        PersistentHashSet ret = EMPTY;
        for (int i = 0; i < init.length; ++i) {
            if ((ret = (PersistentHashSet)ret.cons(init[i])).count() == i + 1) continue;
            throw new IllegalArgumentException("Duplicate key: " + init[i]);
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(List init) {
        PersistentHashSet ret = EMPTY;
        int i = 0;
        for (Object key2 : init) {
            if ((ret = (PersistentHashSet)ret.cons(key2)).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + key2);
            }
            ++i;
        }
        return ret;
    }

    public static PersistentHashSet createWithCheck(ISeq items) {
        PersistentHashSet ret = EMPTY;
        int i = 0;
        while (items != null) {
            if ((ret = (PersistentHashSet)ret.cons(items.first())).count() != i + 1) {
                throw new IllegalArgumentException("Duplicate key: " + items.first());
            }
            items = items.next();
            ++i;
        }
        return ret;
    }

    PersistentHashSet(IPersistentMap meta2, IPersistentMap impl) {
        super(impl);
        this._meta = meta2;
    }

    public IPersistentSet disjoin(Object key2) {
        if (this.contains(key2)) {
            return new PersistentHashSet(this.meta(), this.impl.without(key2));
        }
        return this;
    }

    public IPersistentSet cons(Object o) {
        if (this.contains(o)) {
            return this;
        }
        return new PersistentHashSet(this.meta(), this.impl.assoc(o, o));
    }

    public IPersistentCollection empty() {
        return EMPTY.withMeta(this.meta());
    }

    public PersistentHashSet withMeta(IPersistentMap meta2) {
        return new PersistentHashSet(meta2, this.impl);
    }

    public ITransientCollection asTransient() {
        return new TransientHashSet(((PersistentHashMap)this.impl).asTransient());
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    static final class TransientHashSet
    extends ATransientSet {
        TransientHashSet(ITransientMap impl) {
            super(impl);
        }

        public IPersistentCollection persistent() {
            return new PersistentHashSet(null, this.impl.persistent());
        }
    }
}

