/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.macro.Debugger;
import ij.macro.Functions;
import ij.macro.MacroConstants;
import ij.macro.MacroException;
import ij.macro.Program;
import ij.macro.ReturnException;
import ij.macro.Symbol;
import ij.macro.Tokenizer;
import ij.macro.Variable;
import ij.measure.ResultsTable;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.process.ColorProcessor;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class Interpreter
implements MacroConstants {
    static final int STACK_SIZE = 1000;
    static final int MAX_ARGS = 20;
    int pc;
    int token;
    int tokenAddress;
    double tokenValue;
    String tokenString;
    boolean looseSyntax = true;
    int lineNumber;
    boolean statusUpdated;
    boolean showingProgress;
    boolean keysSet;
    boolean checkingType;
    int prefixValue;
    Variable[] stack;
    int topOfStack = -1;
    int topOfGlobals = -1;
    int startOfLocals = 0;
    static volatile Interpreter instance;
    static volatile Interpreter previousInstance;
    public static boolean batchMode;
    static Vector imageTable;
    static Vector imageActivations;
    volatile boolean done;
    Program pgm;
    Functions func;
    boolean inFunction;
    String macroName;
    String argument;
    String returnValue;
    boolean calledMacro;
    boolean batchMacro;
    double[] rgbWeights;
    boolean inPrint;
    static String additionalFunctions;
    Debugger debugger;
    int debugMode = 0;
    boolean showDebugFunctions;
    static boolean showVariables;
    boolean wasError;
    ImagePlus batchMacroImage;
    boolean inLoop;
    int loopDepth;
    static boolean tempShowMode;
    boolean waitingForUser;
    int selectCount;
    static TextWindow arrayWindow;
    int inspectStkIndex = -1;
    int inspectSymIndex = -1;
    boolean evaluating;
    ResultsTable applyMacroTable;
    int errorCount;
    volatile boolean ignoreErrors;
    String errorMessage;
    String evalOutput;
    int[] callStack;
    int callDepth = 0;
    ReturnException returnException;
    private static String[] prevVars;
    private static Interpreter lastInterp;

    public void run(String macro) {
        if (additionalFunctions != null) {
            macro = !macro.endsWith("\n") && !additionalFunctions.startsWith("\n") ? macro + "\n" + additionalFunctions : macro + additionalFunctions;
        }
        IJ.resetEscape();
        Tokenizer tok = new Tokenizer();
        Program pgm = tok.tokenize(macro);
        if (pgm.hasVars && pgm.hasFunctions) {
            this.saveGlobals2(pgm);
        }
        this.run(pgm);
    }

    public String run(String macro, String arg) {
        this.argument = arg;
        this.calledMacro = true;
        if (IJ.getInstance() == null) {
            Interpreter.setBatchMode(true);
        }
        Interpreter saveInstance = instance;
        this.run(macro);
        instance = saveInstance;
        return this.returnValue;
    }

    public String eval(String code) {
        Interpreter saveInstance = instance;
        if (this.pgm != null) {
            this.reuseSymbolTable();
        }
        Tokenizer tok = new Tokenizer();
        Program pgm = tok.tokenize(code);
        if (pgm.hasVars && pgm.hasFunctions) {
            this.saveGlobals2(pgm);
        }
        this.evaluating = true;
        this.evalOutput = null;
        this.ignoreErrors = true;
        this.calledMacro = true;
        this.run(pgm);
        instance = saveInstance;
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return this.evalOutput;
    }

    private void reuseSymbolTable() {
        if (this.pgm == null) {
            return;
        }
        Symbol[] table1 = this.pgm.getSymbolTable();
        Symbol[] table2 = new Symbol[this.pgm.stLoc + 1];
        for (int i = 0; i <= this.pgm.stLoc; ++i) {
            table2[i] = table1[i];
        }
        Program.systemTable = table2;
    }

    public void run(Program pgm) {
        this.pgm = pgm;
        this.pc = -1;
        this.callDepth = 0;
        instance = this;
        if (!this.calledMacro) {
            batchMode = false;
            imageActivations = null;
            imageTable = null;
        }
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, pgm);
        } else {
            this.func.pgm = pgm;
        }
        this.func.plot = null;
        this.done = false;
        this.errorMessage = null;
        this.doStatements();
        this.finishUp();
    }

    public void run(int location) {
        this.topOfStack = this.topOfGlobals;
        this.done = false;
        this.pc = location - 1;
        this.doStatements();
    }

    public void runMacro(Program pgm, int macroLoc, String macroName) {
        this.calledMacro = true;
        this.pgm = pgm;
        this.macroName = macroName;
        this.pc = macroLoc - 1;
        previousInstance = instance;
        instance = this;
        this.pushGlobals();
        if (this.func == null) {
            this.func = new Functions(this, pgm);
        }
        this.func.plot = null;
        if (macroLoc == 0) {
            this.doStatements();
        } else {
            this.doBlock();
        }
        this.finishUp();
        Recorder.recordInMacros = false;
    }

    public ImagePlus runBatchMacro(String macro, ImagePlus imp) {
        this.calledMacro = true;
        this.batchMacro = true;
        Interpreter.setBatchMode(true);
        Interpreter.addBatchModeImage(imp);
        this.batchMacroImage = null;
        this.run(macro);
        IJ.showStatus("");
        return this.batchMacroImage;
    }

    public void saveGlobals(Program pgm) {
        Interpreter saveInstance = instance;
        this.saveGlobals2(pgm);
        instance = saveInstance;
    }

    void saveGlobals2(Program pgm) {
        this.pgm = pgm;
        this.pc = -1;
        instance = this;
        this.func = new Functions(this, pgm);
        block5: while (!this.done) {
            this.getToken();
            switch (this.token) {
                case 201: {
                    this.doVar();
                    continue block5;
                }
                case 200: {
                    this.skipMacro();
                    continue block5;
                }
                case 207: {
                    this.skipFunction();
                    continue block5;
                }
            }
        }
        instance = null;
        pgm.saveGlobals(this);
        this.pc = -1;
        this.topOfStack = -1;
        this.done = false;
    }

    final void getToken() {
        if (this.done) {
            return;
        }
        this.token = this.pgm.code[++this.pc];
        if (this.token <= 127) {
            return;
        }
        this.tokenAddress = this.token >> 12;
        this.token &= 0xFFF;
        Symbol sym = this.pgm.table[this.tokenAddress];
        this.tokenString = sym.str;
        this.tokenValue = sym.value;
        this.done = this.token == 128;
    }

    final int nextToken() {
        return this.pgm.code[this.pc + 1] & 0xFFF;
    }

    final int nextNextToken() {
        return this.pgm.code[this.pc + 2] & 0xFFF;
    }

    final void putTokenBack() {
        --this.pc;
        if (this.pc < 0) {
            this.pc = -1;
        }
        if (this.token == 128) {
            this.done = false;
        }
    }

    void doStatements() {
        while (!this.done) {
            this.doStatement();
        }
    }

    final void doStatement() {
        this.getToken();
        if (this.debugMode != 0 && this.debugger != null && !this.done && this.token != 59 && this.token != 207) {
            this.debugger.debug(this, this.debugMode);
            if (this.done) {
                return;
            }
        }
        switch (this.token) {
            case 201: {
                this.doVar();
                break;
            }
            case 134: {
                this.func.doFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 138: {
                this.runUserFunction();
                break;
            }
            case 208: {
                this.doReturn();
                break;
            }
            case 213: {
                if (!this.inLoop) break;
                throw new MacroException(213);
            }
            case 214: {
                if (!this.inLoop) break;
                throw new MacroException(214);
            }
            case 129: {
                if (this.pgm.code[this.pc + 1] == 46) {
                    this.doStringFunction();
                    break;
                }
                this.doAssignment();
                break;
            }
            case 202: {
                this.doIf();
                return;
            }
            case 203: {
                this.error("Else without if");
                return;
            }
            case 206: {
                this.doFor();
                return;
            }
            case 204: {
                this.doWhile();
                return;
            }
            case 205: {
                this.doDo();
                return;
            }
            case 200: {
                this.runFirstMacro();
                return;
            }
            case 207: {
                this.skipFunction();
                return;
            }
            case 59: {
                return;
            }
            case 123: {
                this.putTokenBack();
                this.doBlock();
                return;
            }
            case 40: 
            case 130: 
            case 133: 
            case 135: 
            case 136: 
            case 140: {
                this.putTokenBack();
                this.inPrint = true;
                String s = this.getString();
                this.inPrint = false;
                if (s != null && s.length() > 0 && !s.equals("NaN") && !s.equals("[aborted]")) {
                    this.log(s);
                }
                return;
            }
            case 137: {
                this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 128: {
                break;
            }
            default: {
                if (this.evaluating && this.token == 211) {
                    this.putTokenBack();
                    this.log("" + this.getExpression());
                    break;
                }
                this.error("Statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
        if (!this.looseSyntax) {
            this.getToken();
            if (this.token != 59 && !this.done) {
                this.error("';' expected");
            }
        }
    }

    private void doStringFunction() {
        String s;
        boolean stringFunction = (this.pgm.code[this.pc + 2] & 0xFF) == 136;
        this.putTokenBack();
        String string = s = stringFunction ? this.getString() : "" + this.getExpression();
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        IJ.log(s);
    }

    void log(String s) {
        if (this.evaluating) {
            this.evalOutput = s;
        } else {
            IJ.log(s);
        }
    }

    private void growCallStack(int grow) {
        if (this.callStack == null) {
            this.callStack = new int[10];
            this.callDepth = 0;
        }
        if (this.callDepth < 0 || this.callDepth > 8) {
            return;
        }
        if (grow == 1) {
            int line = this.pgm.lineNumbers[this.pc];
            this.callStack[this.callDepth++] = line;
        }
        if (grow == -1 && this.callDepth > 0) {
            --this.callDepth;
        }
    }

    Variable runUserFunction() {
        boolean saveInFunction;
        Variable value;
        int savePC;
        int saveTOS;
        int saveStartOfLocals;
        block2: {
            this.growCallStack(1);
            int newPC = (int)this.tokenValue;
            saveStartOfLocals = this.startOfLocals;
            this.startOfLocals = this.topOfStack + 1;
            saveTOS = this.topOfStack;
            int nArgs = this.pushArgs();
            savePC = this.pc;
            value = null;
            this.pc = newPC;
            this.setupArgs(nArgs);
            saveInFunction = this.inFunction;
            this.inFunction = true;
            try {
                this.doBlock();
            }
            catch (ReturnException e) {
                value = new Variable(0, e.value, e.str, e.array);
                if (value.getArray() == null || e.arraySize == 0) break block2;
                value.setArraySize(e.arraySize);
            }
        }
        this.inFunction = saveInFunction;
        this.pc = savePC;
        this.trimStack(saveTOS, saveStartOfLocals);
        this.growCallStack(-1);
        return value;
    }

    int pushArgs() {
        this.getLeftParen();
        int count = 0;
        Variable[] args = new Variable[20];
        if (this.nextToken() != 41) {
            do {
                if (count == 20) {
                    this.error("Too many arguments");
                }
                int next = this.nextToken();
                int nextPlus = this.pgm.code[this.pc + 2] & 0xFF;
                if (next == 133 || next == 136) {
                    args[count] = new Variable(0, 0.0, this.getString());
                } else if (next == 138) {
                    int savePC = this.pc;
                    this.getToken();
                    boolean simpleFunctionCall = this.isSimpleFunctionCall(false);
                    this.pc = savePC;
                    if (simpleFunctionCall) {
                        this.getToken();
                        Variable v2 = this.runUserFunction();
                        if (v2 == null) {
                            this.error("No return value");
                        }
                        args[count] = v2;
                    } else {
                        args[count] = new Variable(0, this.getExpression(), null);
                    }
                } else if (next == 129 && (nextPlus == 44 || nextPlus == 41)) {
                    double value = 0.0;
                    Variable[] array = null;
                    int arraySize = 0;
                    String str = null;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    if (v != null) {
                        int type = v.getType();
                        if (type == 0) {
                            value = v.getValue();
                        } else if (type == 1) {
                            array = v.getArray();
                            arraySize = v.getArraySize();
                        } else {
                            str = v.getString();
                        }
                    }
                    args[count] = new Variable(0, value, str, array);
                    if (array != null) {
                        args[count].setArraySize(arraySize);
                    }
                } else if (next == 129 && nextPlus == 91) {
                    int savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    v = this.getArrayElement(v);
                    if (v.getString() != null) {
                        args[count] = new Variable(0, 0.0, v.getString(), null);
                    } else {
                        this.pc = savePC;
                        args[count] = new Variable(0, this.getExpression(), null);
                    }
                } else if (next == 129 && nextPlus == 46) {
                    boolean stringFunction;
                    boolean bl = stringFunction = (this.pgm.code[this.pc + 3] & 0xFF) == 136;
                    args[count] = stringFunction ? new Variable(0, 0.0, this.func.getString(), null) : new Variable(0, this.getExpression(), null);
                } else if (nextPlus == 43 && next == 129) {
                    int savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    boolean isString = v != null && v.getType() == 2;
                    this.pc = savePC;
                    args[count] = isString ? new Variable(0, 0.0, this.getString()) : new Variable(0, this.getExpression(), null);
                } else if (next == 137) {
                    this.getToken();
                    Variable[] array = this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
                    args[count] = new Variable(0, 0.0, null, array);
                } else {
                    args[count] = new Variable(0, this.getExpression(), null);
                }
                ++count;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        int nArgs = count;
        while (count > 0) {
            this.push(args[--count], this);
        }
        this.getRightParen();
        return nArgs;
    }

    void setupArgs(int nArgs) {
        this.getLeftParen();
        int i = this.topOfStack;
        int count = nArgs;
        if (this.nextToken() != 41) {
            do {
                this.getToken();
                if (i >= 0) {
                    this.stack[i].symTabIndex = this.tokenAddress;
                }
                --i;
                --count;
                this.getToken();
            } while (this.token == 44);
            this.putTokenBack();
        }
        if (count != 0) {
            this.error(nArgs + " argument" + (nArgs == 1 ? "" : "s") + " expected");
        }
        this.getRightParen();
    }

    void doReturn() {
        int next;
        double value = 0.0;
        String str = null;
        Variable[] array = null;
        int arraySize = 0;
        this.getToken();
        if (this.token == 40 && (((next = this.pgm.code[this.pc + 1]) & 0xFFF) == 133 || (next & 0xFFF) == 136 || this.isString(this.pc + 1))) {
            this.error("String enclosed in parens");
        }
        if (this.token != 59) {
            boolean isArrayFunction;
            boolean isString = this.token == 133 || this.token == 136;
            boolean bl = isArrayFunction = this.token == 137;
            if (this.token == 129) {
                Variable v = this.lookupLocalVariable(this.tokenAddress);
                if (v != null && this.nextToken() == 59) {
                    array = v.getArray();
                    if (array != null) {
                        arraySize = v.getArraySize();
                    }
                    isString = v.getString() != null;
                } else if (v != null && this.nextToken() == 43) {
                    isString = v.getType() == 2;
                }
            }
            this.putTokenBack();
            if (isString) {
                str = this.getString();
            } else if (isArrayFunction) {
                this.getToken();
                array = this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type);
            } else if (array == null) {
                if ((this.pgm.code[this.pc + 2] & 0xFF) == 91 && this.nextToken() == 129) {
                    int savePC = this.pc;
                    this.getToken();
                    Variable v = this.lookupVariable();
                    v = this.getArrayElement(v);
                    this.pc = savePC;
                    if (v.getString() != null) {
                        str = this.getString();
                    } else {
                        value = this.getExpression();
                    }
                } else {
                    value = this.getExpression();
                }
            }
        }
        if (this.inFunction) {
            if (this.returnException == null) {
                this.returnException = new ReturnException();
            }
            this.returnException.value = value;
            this.returnException.str = str;
            this.returnException.array = array;
            this.returnException.arraySize = arraySize;
            throw this.returnException;
        }
        this.finishUp();
        if (value != 0.0 || array != null) {
            this.error("Macros can only return strings");
        }
        this.returnValue = str;
        this.done = true;
    }

    void doFor() {
        boolean saveLooseSyntax = this.looseSyntax;
        this.looseSyntax = false;
        ++this.loopDepth;
        this.inLoop = true;
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
        this.getToken();
        if (this.token != 201) {
            this.putTokenBack();
        }
        do {
            if (this.nextToken() != 59) {
                this.getAssignmentExpression();
            }
            this.getToken();
        } while (this.token == 44);
        if (this.token != 59) {
            this.error("';' expected");
        }
        int condPC = this.pc;
        int startPC = 0;
        double cond = 1.0;
        while (true) {
            int incPC;
            block19: {
                if (this.pgm.code[this.pc + 1] != 59) {
                    cond = this.getLogicalExpression();
                }
                if (startPC == 0) {
                    this.checkBoolean(cond);
                }
                this.getToken();
                if (this.token != 59) {
                    this.error("';' expected");
                }
                incPC = this.pc;
                if (startPC != 0) {
                    this.pc = startPC;
                } else {
                    while (this.token != 41) {
                        this.getToken();
                        if (this.token != 123 && this.token != 59 && this.token != 40 && !this.done) continue;
                        this.error("')' expected");
                    }
                }
                startPC = this.pc;
                if (cond == 1.0) {
                    try {
                        this.doStatement();
                        break block19;
                    }
                    catch (MacroException e) {
                        if (e.getType() == 213) {
                            this.pc = startPC;
                            this.skipStatement();
                            break;
                        }
                        break block19;
                    }
                }
                this.skipStatement();
                break;
            }
            this.pc = incPC;
            do {
                if (this.nextToken() != 41) {
                    this.getAssignmentExpression();
                }
                this.getToken();
            } while (this.token == 44);
            this.pc = condPC;
        }
        this.looseSyntax = saveLooseSyntax;
        --this.loopDepth;
        if (this.loopDepth == 0) {
            this.inLoop = false;
        }
    }

    void doWhile() {
        boolean isTrue;
        this.looseSyntax = false;
        ++this.loopDepth;
        this.inLoop = true;
        int savePC = this.pc;
        do {
            this.pc = savePC;
            isTrue = this.getBoolean();
            if (isTrue) {
                try {
                    this.doStatement();
                    continue;
                }
                catch (MacroException e) {
                    if (e.getType() != 213) continue;
                    this.pc = savePC;
                    this.getBoolean();
                    this.skipStatement();
                    break;
                }
            }
            this.skipStatement();
        } while (isTrue && !this.done);
        --this.loopDepth;
        if (this.loopDepth == 0) {
            this.inLoop = false;
        }
    }

    void doDo() {
        boolean isTrue;
        this.looseSyntax = false;
        int savePC = this.pc;
        do {
            this.doStatement();
            this.getToken();
            if (this.token != 204) {
                this.error("'while' expected");
            }
            if (!(isTrue = this.getBoolean())) continue;
            this.pc = savePC;
        } while (isTrue && !this.done);
    }

    final void doBlock() {
        this.getToken();
        if (this.token != 123) {
            this.error("'{' expected");
        }
        while (!this.done) {
            this.getToken();
            if (this.token == 125) break;
            this.putTokenBack();
            this.doStatement();
        }
        if (this.token != 125) {
            this.error("'}' expected");
        }
    }

    final void skipStatement() {
        if (this.done) {
            return;
        }
        this.getToken();
        switch (this.token) {
            case 1: 
            case 40: 
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 201: 
            case 208: {
                this.skipSimpleStatement();
                break;
            }
            case 202: {
                this.skipParens();
                this.skipStatement();
                this.getToken();
                if (this.token == 203) {
                    this.skipStatement();
                    break;
                }
                this.putTokenBack();
                break;
            }
            case 206: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 204: {
                this.skipParens();
                this.skipStatement();
                break;
            }
            case 205: {
                this.skipStatement();
                this.getToken();
                this.skipParens();
                break;
            }
            case 59: 
            case 213: 
            case 214: {
                break;
            }
            case 123: {
                this.putTokenBack();
                this.skipBlock();
                break;
            }
            default: {
                this.error("Skipped statement cannot begin with '" + this.pgm.decodeToken(this.token, this.tokenAddress) + "'");
            }
        }
    }

    final void skipBlock() {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 123) {
                ++count;
                continue;
            }
            if (this.token == 125) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("'}' expected");
            return;
        } while (count > 0);
    }

    final void skipParens() {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++count;
                continue;
            }
            if (this.token == 41) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
            return;
        } while (count > 0);
    }

    final void skipSimpleStatement() {
        boolean finished = this.done;
        this.getToken();
        while (!finished && !this.done) {
            if (this.token == 59) {
                finished = true;
                continue;
            }
            if (this.token == 203 || this.token == 134 && this.pgm.code[this.pc - 1] != 46) {
                this.error("';' expected");
                continue;
            }
            this.getToken();
        }
    }

    void skipFunction() {
        this.getToken();
        this.skipParens();
        this.skipBlock();
    }

    void runFirstMacro() {
        this.getToken();
        this.doBlock();
        this.done = true;
        this.finishUp();
    }

    void skipMacro() {
        this.getToken();
        this.skipBlock();
    }

    final void doAssignment() {
        int next = this.pgm.code[this.pc + 1] & 0xFF;
        if (next == 91) {
            this.doArrayElementAssignment();
            return;
        }
        int type = this.getExpressionType();
        switch (type) {
            case 2: {
                this.doStringAssignment();
                break;
            }
            case 1: {
                this.doArrayAssignment();
                break;
            }
            case 138: {
                this.doUserFunctionAssignment();
                break;
            }
            case 136: {
                this.doNumericStringAssignment();
                break;
            }
            default: {
                this.putTokenBack();
                double value = this.getAssignmentExpression();
                if (!this.evaluating) break;
                this.log("" + value);
            }
        }
    }

    int getExpressionType() {
        int type;
        int rightSideToken = this.pgm.code[this.pc + 2];
        int tok = rightSideToken & 0xFF;
        if (tok == 133) {
            return 2;
        }
        if (tok == 136) {
            int address = rightSideToken >> 12;
            int type2 = this.pgm.table[address].type;
            if (type2 == 2017) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("getNumber") || name.equals("getCheckbox")) {
                    return 136;
                }
            } else if (type2 == 2019) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("exists") || name.equals("isDirectory") || name.equals("length") || name.equals("getLength") || name.equals("rename") || name.equals("delete")) {
                    return 136;
                }
            } else if (type2 == 2027) {
                int token2 = this.pgm.code[this.pc + 4];
                String name = this.pgm.table[token2 >> 12].str;
                if (name.equals("getValue")) {
                    return 136;
                }
            } else if (this.numericStringFunction(this.pc + 2)) {
                return 0;
            }
            return 2;
        }
        if (tok == 137) {
            return 1;
        }
        if (tok == 138) {
            return 138;
        }
        if (tok == 140) {
            int address = rightSideToken >> 12;
            type = this.pgm.table[address].type;
            if (this.isString(this.pc + 2)) {
                return 2;
            }
            int token2 = this.pgm.code[this.pc + 4];
            String name = this.pgm.table[token2 >> 12].str;
            if (name.equals("getColumn") || name.equals("toArray")) {
                return 1;
            }
        }
        if (tok != 129) {
            return 0;
        }
        Variable v = this.lookupVariable(rightSideToken >> 12);
        if (v == null) {
            return 0;
        }
        type = v.getType();
        if (type == 0) {
            return 0;
        }
        if (type == 2) {
            if (this.isString(this.pc + 2)) {
                return 2;
            }
            return 0;
        }
        if (this.pgm.code[this.pc + 3] == 46) {
            return 0;
        }
        if (this.pgm.code[this.pc + 3] != 91) {
            return 1;
        }
        int savePC = this.pc;
        this.getToken();
        this.getToken();
        this.checkingType = true;
        int index = this.getIndex();
        this.checkingType = false;
        this.pc = savePC - 1;
        this.getToken();
        Variable[] array = v.getArray();
        if (index < 0 || index >= array.length) {
            return 0;
        }
        return array[index].getType();
    }

    final void doNumericStringAssignment() {
        this.putTokenBack();
        this.getToken();
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            v = this.push(this.tokenAddress, 0.0, null, this);
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
        }
        v.setValue(this.getExpression());
    }

    final void doArrayElementAssignment() {
        int size;
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            this.error("Undefined identifier");
        }
        if (this.pgm.code[this.pc + 5] == 59 && (this.pgm.code[this.pc + 4] == 1 || this.pgm.code[this.pc + 4] == 2)) {
            this.putTokenBack();
            this.getFactor();
            return;
        }
        int index = this.getIndex();
        int expressionType = this.getExpressionType();
        if (expressionType == 1) {
            this.error("Arrays of arrays not supported");
        }
        this.getToken();
        int op = this.token;
        if (op != 61 && op != 9 && op != 10 && op != 11 && op != 12) {
            this.error("'=', '+=', '-=', '*=' or '/=' expected");
            return;
        }
        if (op != 61 && (expressionType == 2 || expressionType == 1)) {
            this.error("'=' expected");
            return;
        }
        Variable[] array = v.getArray();
        if (array == null) {
            this.error("Array expected");
        }
        if (index < 0) {
            this.error("Negative index");
        }
        if (index >= array.length) {
            if (!this.func.expandableArrays) {
                this.error("Index (" + index + ") out of range");
            }
            Variable[] array2 = new Variable[index + array.length / 2 + 1];
            boolean strings = array.length > 0 && array[0].getString() != null;
            for (int i = 0; i < array2.length; ++i) {
                if (i < array.length) {
                    array2[i] = array[i];
                    continue;
                }
                array2[i] = new Variable(Double.NaN);
                if (!strings) continue;
                array2[i].setString("undefined");
            }
            v.setArray(array2);
            v.setArraySize(index + 1);
            array = v.getArray();
        }
        if (index + 1 > (size = v.getArraySize())) {
            v.setArraySize(index + 1);
        }
        int next = this.nextToken();
        block0 : switch (expressionType) {
            case 2: {
                array[index].setString(this.getString());
                break;
            }
            case 1: {
                this.getToken();
                if (this.token != 137) break;
                array[index].setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
                break;
            }
            case 138: {
                int savePC = this.pc;
                this.getToken();
                boolean simpleFunctionCall = this.isSimpleFunctionCall(true);
                this.pc = savePC;
                if (simpleFunctionCall) {
                    this.getToken();
                    Variable v2 = this.runUserFunction();
                    if (v2 == null) {
                        this.error("No return value");
                    }
                    if (this.done) {
                        return;
                    }
                    int type = v2.getType();
                    if (type == 0) {
                        array[index].setValue(v2.getValue());
                        break;
                    }
                    array[index].setString(v2.getString());
                    break;
                }
                array[index].setValue(this.getExpression());
                break;
            }
            default: {
                switch (op) {
                    case 61: {
                        array[index].setValue(this.getExpression());
                        break block0;
                    }
                    case 9: {
                        array[index].setValue(array[index].getValue() + this.getExpression());
                        break block0;
                    }
                    case 10: {
                        array[index].setValue(array[index].getValue() - this.getExpression());
                        break block0;
                    }
                    case 11: {
                        array[index].setValue(array[index].getValue() * this.getExpression());
                        break block0;
                    }
                    case 12: {
                        array[index].setValue(array[index].getValue() / this.getExpression());
                    }
                }
            }
        }
    }

    final void doUserFunctionAssignment() {
        this.putTokenBack();
        int savePC = this.pc;
        this.getToken();
        this.getToken();
        this.getToken();
        boolean simpleAssignment = this.isSimpleFunctionCall(true);
        this.pc = savePC;
        if (!simpleAssignment) {
            this.getAssignmentExpression();
        } else {
            this.getToken();
            Variable v1 = this.lookupLocalVariable(this.tokenAddress);
            if (v1 == null) {
                v1 = this.push(this.tokenAddress, 0.0, null, this);
            }
            this.getToken();
            if (this.token != 61) {
                this.error("'=' expected");
            }
            this.getToken();
            Variable v2 = this.runUserFunction();
            if (v2 == null) {
                this.error("No return value");
            }
            if (this.done) {
                return;
            }
            int type = v2.getType();
            if (type == 0) {
                v1.setValue(v2.getValue());
            } else if (type == 1) {
                v1.setArray(v2.getArray());
                v1.setArraySize(v2.getArraySize());
            } else {
                v1.setString(v2.getString());
            }
        }
    }

    boolean isSimpleFunctionCall(boolean assignment) {
        int count = 0;
        do {
            this.getToken();
            if (this.token == 40) {
                ++count;
                continue;
            }
            if (this.token == 41) {
                --count;
                continue;
            }
            if (!this.done) continue;
            this.error("')' expected");
        } while (count > 0);
        this.getToken();
        if (assignment) {
            return this.token == 59;
        }
        return this.token == 44 || this.token == 41;
    }

    final void doStringAssignment() {
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            if (this.nextToken() == 61) {
                v = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token == 61) {
            v.setString(this.getString());
        } else if (this.token == 9) {
            v.setString(v.getString() + this.getString());
        } else {
            this.error("'=' or '+=' expected");
        }
    }

    final void doArrayAssignment() {
        Variable v = this.lookupLocalVariable(this.tokenAddress);
        if (v == null) {
            if (this.nextToken() == 61) {
                v = this.push(this.tokenAddress, 0.0, null, this);
            } else {
                this.error("Undefined identifier");
            }
        }
        this.getToken();
        if (this.token != 61) {
            this.error("'=' expected");
            return;
        }
        this.getToken();
        if (this.token == 137) {
            v.setArray(this.func.getArrayFunction(this.pgm.table[this.tokenAddress].type));
        } else if (this.token == 129) {
            Variable v2 = this.lookupVariable();
            v.setArray(v2.getArray());
            v.setArraySize(v2.getArraySize());
        } else if (this.token == 140) {
            Variable v2 = this.func.getVariableFunction(this.pgm.table[this.tokenAddress].type);
            Variable[] array = v2.getArray();
            if (array == null) {
                this.error("Array expected");
            }
            v.setArray(array);
        } else {
            this.error("Array expected");
        }
    }

    final void doIf() {
        this.looseSyntax = false;
        boolean b = this.getBoolean();
        if (b) {
            this.doStatement();
        } else {
            this.skipStatement();
        }
        int next = this.nextToken();
        if (next == 59) {
            this.getToken();
            next = this.nextToken();
        }
        if (next == 203) {
            this.getToken();
            if (b) {
                this.skipStatement();
            } else {
                this.doStatement();
            }
        }
    }

    final boolean getBoolean() {
        this.getLeftParen();
        double value = this.getLogicalExpression();
        this.checkBoolean(value);
        this.getRightParen();
        return value != 0.0;
    }

    final double getLogicalExpression() {
        double v1 = this.getBooleanExpression();
        int next = this.nextToken();
        if (next != 13 && next != 14) {
            return v1;
        }
        this.checkBoolean(v1);
        this.getToken();
        int op = this.token;
        double v2 = this.getLogicalExpression();
        this.checkBoolean(v2);
        if (op == 13) {
            return (int)v1 & (int)v2;
        }
        if (op == 14) {
            return (int)v1 | (int)v2;
        }
        return v1;
    }

    final double getBooleanExpression() {
        double v1 = 0.0;
        String s1 = null;
        int next = this.pgm.code[this.pc + 1];
        int tok = next & 0xFFF;
        if (tok == 133 || tok == 136 || this.isString(this.pc + 1)) {
            if (this.numericStringFunction(this.pc + 1)) {
                v1 = this.getExpression();
            } else {
                s1 = this.getString();
            }
        } else {
            v1 = this.getExpression();
        }
        next = this.nextToken();
        if (next >= 3 && next <= 8) {
            this.getToken();
            int op = this.token;
            if (s1 != null) {
                return this.compareStrings(s1, this.getString(), op);
            }
            double v2 = this.getExpression();
            switch (op) {
                case 3: {
                    v1 = v1 == v2 ? 1.0 : 0.0;
                    break;
                }
                case 4: {
                    v1 = v1 != v2 ? 1.0 : 0.0;
                    break;
                }
                case 5: {
                    v1 = v1 > v2 ? 1.0 : 0.0;
                    break;
                }
                case 6: {
                    v1 = v1 >= v2 ? 1.0 : 0.0;
                    break;
                }
                case 7: {
                    v1 = v1 < v2 ? 1.0 : 0.0;
                    break;
                }
                case 8: {
                    v1 = v1 <= v2 ? 1.0 : 0.0;
                }
            }
        } else if (s1 != null) {
            v1 = s1.equals("true") ? 1.0 : (s1.equals("false") ? 0.0 : Tools.parseDouble(s1, Double.NaN));
        }
        return v1;
    }

    private boolean numericStringFunction(int loc) {
        if ((this.pgm.code[loc] & 0xFFF) != 136) {
            return false;
        }
        int address = this.pgm.code[loc] >> 12;
        int type = this.pgm.table[address].type;
        if (type == 140 || type == 2017 || type == 2019 || type == 2024 || type == 2025 || type == 2027 || type == 2029) {
            return false;
        }
        if (this.pgm.code[loc + 1] == 46 && (this.pgm.code[loc + 2] & 0xFF) != 136) {
            return true;
        }
        return this.pgm.code[loc + 1] == 40 && this.pgm.code[loc + 2] == 41 && this.pgm.code[loc + 3] == 46 && (this.pgm.code[loc + 4] & 0xFF) != 136;
    }

    boolean isString(int pcLoc) {
        Variable[] array;
        int type;
        int tok = this.pgm.code[pcLoc];
        if ((tok & 0xFF) == 140) {
            int address = tok >> 12;
            type = this.pgm.table[address].type;
            int token2 = this.pgm.code[pcLoc + 2];
            String name = this.pgm.table[token2 >> 12].str;
            if (Functions.isStringFunction(name, type)) {
                return true;
            }
        }
        if ((tok & 0xFFF) != 129) {
            return false;
        }
        Variable v = this.lookupVariable(tok >> 12);
        if (v == null) {
            return false;
        }
        if (this.pgm.code[pcLoc + 1] == 91 && (array = v.getArray()) != null && array.length > 0) {
            return array[0].getType() == 2;
        }
        type = v.getType();
        if (type == 2 && (this.pgm.code[pcLoc + 1] & 0xFF) == 46 && (this.pgm.code[pcLoc + 2] & 0xFF) != 136) {
            return false;
        }
        return type == 2;
    }

    double compareStrings(String s1, String s2, int op) {
        int result = s1.compareToIgnoreCase(s2);
        double v1 = 0.0;
        switch (op) {
            case 3: {
                v1 = result == 0 ? 1.0 : 0.0;
                break;
            }
            case 4: {
                v1 = result != 0 ? 1.0 : 0.0;
                break;
            }
            case 5: {
                v1 = result > 0 ? 1.0 : 0.0;
                break;
            }
            case 6: {
                v1 = result >= 0 ? 1.0 : 0.0;
                break;
            }
            case 7: {
                v1 = result < 0 ? 1.0 : 0.0;
                break;
            }
            case 8: {
                v1 = result <= 0 ? 1.0 : 0.0;
            }
        }
        return v1;
    }

    final double getAssignmentExpression() {
        int tokPlus2 = this.pgm.code[this.pc + 2];
        if ((this.pgm.code[this.pc + 1] & 0xFF) == 129 && (tokPlus2 == 61 || tokPlus2 == 9 || tokPlus2 == 10 || tokPlus2 == 11 || tokPlus2 == 12)) {
            this.getToken();
            Variable v = this.lookupLocalVariable(this.tokenAddress);
            int saveAddress = this.tokenAddress;
            this.getToken();
            double value = 0.0;
            if (this.token == 61) {
                value = this.getAssignmentExpression();
            } else {
                value = v != null ? v.getValue() : 0.0;
                switch (this.token) {
                    case 9: {
                        value += this.getAssignmentExpression();
                        break;
                    }
                    case 10: {
                        value -= this.getAssignmentExpression();
                        break;
                    }
                    case 11: {
                        value *= this.getAssignmentExpression();
                        break;
                    }
                    case 12: {
                        value /= this.getAssignmentExpression();
                    }
                }
            }
            if (v == null) {
                v = this.push(saveAddress, 0.0, null, this);
            }
            v.setValue(value);
            return value;
        }
        return this.getLogicalExpression();
    }

    final void checkBoolean(double value) {
        if (value != 0.0 && value != 1.0) {
            this.error("Boolean expression expected: " + value);
        }
    }

    void doVar() {
        this.getToken();
        while (this.token == 129) {
            if (this.nextToken() == 61) {
                this.doAssignment();
            } else {
                Variable v = this.lookupVariable(this.tokenAddress);
                if (v == null) {
                    this.push(this.tokenAddress, 0.0, null, this);
                }
            }
            this.getToken();
            if (this.token == 44) {
                this.getToken();
                continue;
            }
            this.putTokenBack();
            break;
        }
    }

    final void getLeftParen() {
        this.getToken();
        if (this.token != 40) {
            this.error("'(' expected");
        }
    }

    final void getRightParen() {
        this.getToken();
        if (this.token != 41) {
            this.error("')' expected");
        }
    }

    final void getParens() {
        if (this.nextToken() == 40) {
            this.getLeftParen();
            this.getRightParen();
        }
    }

    final void getComma() {
        this.getToken();
        if (this.token != 44) {
            if (this.looseSyntax) {
                this.putTokenBack();
            } else {
                this.error("',' expected");
            }
        }
    }

    void error(String message) {
        this.errorMessage = message;
        if (this.ignoreErrors) {
            return;
        }
        ++this.errorCount;
        boolean showMessage = !this.done;
        String[] variables = showMessage ? this.getVariables() : null;
        this.token = 128;
        this.tokenString = "";
        IJ.showStatus("");
        IJ.showProgress(0, 0);
        batchMode = false;
        imageActivations = null;
        imageTable = null;
        WindowManager.setTempCurrentImage(null);
        this.wasError = true;
        if (!this.evaluating) {
            instance = null;
        }
        if (showMessage && message != null) {
            TextWindow debugWindow;
            String line = this.getErrorLine();
            this.done = true;
            if (line.length() > 120) {
                line = line.substring(0, 119) + "...";
            }
            Frame f = WindowManager.getFrame("Debug");
            TextPanel panel = null;
            if (showVariables && f != null && f instanceof TextWindow && (debugWindow = (TextWindow)f) != null) {
                panel = debugWindow.getTextPanel();
                panel.clear();
            }
            String calledFrom = "";
            if (this.callDepth > 0 && this.callStack != null) {
                for (int jj = this.callDepth - 1; jj >= 0; --jj) {
                    int theline = this.callStack[jj];
                    calledFrom = calledFrom + "\t\t(called from line " + theline + ")\n";
                }
            }
            this.showError("Macro Error", message + " in line " + this.lineNumber + "\n" + calledFrom + " \n" + line, variables);
            f = WindowManager.getFrame("Debug");
            if (showVariables && f != null && f instanceof TextWindow) {
                TextWindow debugWindow2 = (TextWindow)f;
                debugWindow2.append("\n---\t\t---\nError:\t\t" + message + " in line " + this.lineNumber + ":");
                debugWindow2.append(calledFrom + "\t\t");
                debugWindow2.append("\t\t" + line);
            }
            throw new RuntimeException("Macro canceled");
        }
        this.done = true;
        if (this.errorCount > 10) {
            throw new RuntimeException("Macro canceled");
        }
    }

    void showError(String title, String msg, String[] variables) {
        boolean noImages = msg.startsWith("There are no images open");
        if (noImages) {
            title = "No Image";
        }
        Macro.setOptions(null);
        GenericDialog gd = new GenericDialog(title);
        gd.setInsets(6, 5, 0);
        gd.addMessage(msg);
        gd.setInsets(15, 30, 5);
        if (!noImages) {
            gd.addCheckbox("Show \"Debug\" Window", showVariables);
        }
        gd.hideCancelButton();
        gd.showDialog();
        showVariables = !noImages ? gd.getNextBoolean() : false;
        if (!gd.wasCanceled() && showVariables) {
            this.updateDebugWindow(variables, null);
        }
    }

    public TextWindow updateDebugWindow(String[] variables, TextWindow debugWindow) {
        int i;
        Frame f;
        if (debugWindow == null && (f = WindowManager.getFrame("Debug")) != null && f instanceof TextWindow) {
            debugWindow = (TextWindow)f;
            debugWindow.toFront();
        }
        if (debugWindow == null) {
            debugWindow = new TextWindow("Debug", "Name\t*\tValue", "", 300, 400);
        }
        TextPanel panel = debugWindow.getTextPanel();
        int n = variables.length;
        if (n == 0) {
            panel.clear();
            return debugWindow;
        }
        int lines = panel.getLineCount();
        String[] markedVariables = this.markChanges(variables);
        for (i = 0; i < lines; ++i) {
            if (i < n) {
                panel.setLine(i, markedVariables[i]);
                continue;
            }
            panel.setLine(i, "");
        }
        for (i = lines; i < n; ++i) {
            debugWindow.append(markedVariables[i]);
        }
        return debugWindow;
    }

    private String[] markChanges(String[] newVars) {
        int len = newVars.length;
        String[] copyOfNew = new String[len];
        String[] hilitedVars = new String[len];
        for (int jj = 0; jj < len; ++jj) {
            copyOfNew[jj] = newVars[jj];
            String marker = "\t*\t";
            if (prevVars != null && jj < prevVars.length && jj < len && prevVars[jj].equals(newVars[jj])) {
                marker = "\t\t";
            }
            hilitedVars[jj] = newVars[jj].replaceFirst("\t", marker);
        }
        prevVars = copyOfNew;
        return hilitedVars;
    }

    String getErrorLine() {
        int savePC = this.pc;
        this.lineNumber = this.pgm.lineNumbers[this.pc];
        while (this.pc >= 0 && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            --this.pc;
        }
        if (this.lineNumber <= 1) {
            this.pc = -1;
        }
        String line = "";
        this.getToken();
        while (!this.done && this.lineNumber == this.pgm.lineNumbers[this.pc]) {
            String str = this.pgm.decodeToken(this.token, this.tokenAddress);
            if (this.pc == savePC) {
                str = "<" + str + ">";
            }
            line = line + str + " ";
            this.getToken();
        }
        return line;
    }

    final String getString() {
        String str = this.getStringTerm();
        while (true) {
            this.getToken();
            if (this.token != 43) break;
            str = str + this.getStringTerm();
        }
        this.putTokenBack();
        return str;
    }

    final String getStringTerm() {
        String str;
        this.getToken();
        switch (this.token) {
            case 133: {
                str = this.tokenString;
                break;
            }
            case 136: {
                str = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 140: {
                if (!this.isString(this.pc)) {
                    this.putTokenBack();
                    str = this.toString(this.getStringExpression());
                    break;
                }
                Variable v = this.func.getVariableFunction(this.pgm.table[this.tokenAddress].type);
                str = v.getString();
                if (str != null) break;
                double value = v.getValue();
                if ((double)((int)value) == value) {
                    str = IJ.d2s(value, 0);
                    break;
                }
                str = "" + value;
                break;
            }
            case 138: {
                Variable v = this.runUserFunction();
                if (v == null) {
                    this.error("No return value");
                }
                if ((str = v.getString()) != null) break;
                double value = v.getValue();
                if ((double)((int)value) == value) {
                    str = IJ.d2s(value, 0);
                    break;
                }
                str = "" + value;
                break;
            }
            case 129: {
                str = this.lookupStringVariable();
                if (str != null) break;
            }
            default: {
                this.putTokenBack();
                str = this.toString(this.getStringExpression());
            }
        }
        return str;
    }

    private String toString(double x) {
        if ((double)((int)x) == x) {
            return IJ.d2s(x, 0);
        }
        if (this.evaluating) {
            return "" + x;
        }
        String str = IJ.d2s(x, 4, 9);
        while (str.endsWith("0") && str.contains(".") && !str.contains("E")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.endsWith(".")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.tokenAddress];
        return symbol.type == 2000;
    }

    final double getExpression() {
        double value = this.getTerm();
        while (true) {
            int next;
            if ((next = this.nextToken()) == 43) {
                this.getToken();
                value += this.getTerm();
                continue;
            }
            if (next != 45) break;
            this.getToken();
            value -= this.getTerm();
        }
        return value;
    }

    final double getTerm() {
        double value = this.getFactor();
        boolean done = false;
        block10: while (!done) {
            int next = this.nextToken();
            switch (next) {
                case 42: {
                    this.getToken();
                    value *= this.getFactor();
                    continue block10;
                }
                case 47: {
                    this.getToken();
                    value /= this.getFactor();
                    continue block10;
                }
                case 37: {
                    this.getToken();
                    value %= this.getFactor();
                    continue block10;
                }
                case 38: {
                    this.getToken();
                    value = (int)value & (int)this.getFactor();
                    continue block10;
                }
                case 124: {
                    this.getToken();
                    value = (int)value | (int)this.getFactor();
                    continue block10;
                }
                case 94: {
                    this.getToken();
                    value = (int)value ^ (int)this.getFactor();
                    continue block10;
                }
                case 15: {
                    this.getToken();
                    value = (int)value >> (int)this.getFactor();
                    continue block10;
                }
                case 16: {
                    this.getToken();
                    value = (int)value << (int)this.getFactor();
                    continue block10;
                }
            }
            done = true;
        }
        return value;
    }

    final double getFactor() {
        double value = 0.0;
        Variable v = null;
        this.getToken();
        switch (this.token) {
            case 130: {
                value = this.tokenValue;
                break;
            }
            case 133: {
                value = Tools.parseDouble(this.tokenString, Double.NaN);
                break;
            }
            case 135: {
                value = this.func.getFunctionValue(this.pgm.table[this.tokenAddress].type);
                break;
            }
            case 136: {
                String str = this.func.getStringFunction(this.pgm.table[this.tokenAddress].type);
                if (this.nextToken() == 46) {
                    this.getToken();
                    this.getToken();
                    value = this.getNumericStringFunction(str);
                } else {
                    value = Tools.parseDouble(str);
                }
                if ("NaN".equals(str)) {
                    value = Double.NaN;
                    break;
                }
                if (!Double.isNaN(value)) break;
                this.error("Numeric value expected");
                break;
            }
            case 140: {
                v = this.func.getVariableFunction(this.pgm.table[this.tokenAddress].type);
                if (v == null) {
                    this.error("No return value");
                }
                if (v.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                value = v.getValue();
                break;
            }
            case 138: {
                v = this.runUserFunction();
                if (v == null) {
                    this.error("No return value");
                }
                if (this.done) {
                    value = 0.0;
                    break;
                }
                if (v.getString() != null) {
                    this.error("Numeric return value expected");
                    break;
                }
                value = v.getValue();
                break;
            }
            case 209: {
                value = 1.0;
                break;
            }
            case 210: {
                value = 0.0;
                break;
            }
            case 211: {
                value = Math.PI;
                break;
            }
            case 212: {
                value = Double.NaN;
                break;
            }
            case 129: {
                v = this.lookupVariable();
                if (v == null) {
                    return 0.0;
                }
                int next = this.nextToken();
                if (next == 91) {
                    v = this.getArrayElement(v);
                    value = v.getValue();
                    next = this.nextToken();
                    if (next == 46) {
                        value = this.runNumericFunction(v);
                        next = this.nextToken();
                    }
                } else if (next == 46) {
                    value = this.runNumericFunction(v);
                    next = this.nextToken();
                } else {
                    if (v.getArray() != null) {
                        this.getToken();
                        this.error("'[' or '.' expected");
                    }
                    if (this.prefixValue != 0 && !this.checkingType) {
                        v.setValue(v.getValue() + (double)this.prefixValue);
                        this.prefixValue = 0;
                    }
                    value = v.getValue();
                }
                if (next != 1 && next != 2) break;
                this.getToken();
                if (this.token == 1) {
                    v.setValue(v.getValue() + (double)(!this.checkingType ? 1 : 0));
                    break;
                }
                v.setValue(v.getValue() - (double)(!this.checkingType ? 1 : 0));
                break;
            }
            case 40: {
                value = this.getLogicalExpression();
                this.getRightParen();
                break;
            }
            case 1: {
                this.prefixValue = 1;
                value = this.getFactor();
                break;
            }
            case 2: {
                this.prefixValue = -1;
                value = this.getFactor();
                break;
            }
            case 33: {
                value = this.getFactor();
                if (value == 0.0 || value == 1.0) {
                    value = value == 0.0 ? 1.0 : 0.0;
                    break;
                }
                this.error("Boolean expected");
                break;
            }
            case 45: {
                value = -this.getFactor();
                break;
            }
            case 126: {
                value = ~((int)this.getFactor());
                break;
            }
            default: {
                this.error("Number or numeric function expected");
            }
        }
        return value;
    }

    private double getNumericStringFunction(String str) {
        double value = Double.NaN;
        if (this.token == 129) {
            if (this.tokenString.equals("length")) {
                this.getParens();
                value = str.length();
            } else if (this.tokenString.equals("contains")) {
                value = str.contains(this.func.getStringArg()) ? 1.0 : 0.0;
            } else if (this.tokenString.equals("charAt")) {
                value = str.charAt((int)this.func.getArg());
            }
        } else if (this.token == 135) {
            int type = this.pgm.table[this.tokenAddress].type;
            switch (type) {
                case 1030: {
                    value = this.func.indexOf(str);
                    break;
                }
                case 1031: {
                    value = str.lastIndexOf(this.func.getStringArg());
                    break;
                }
                case 1034: {
                    value = str.startsWith(this.func.getStringArg()) ? 1.0 : 0.0;
                    break;
                }
                case 1035: {
                    value = str.endsWith(this.func.getStringArg()) ? 1.0 : 0.0;
                    break;
                }
                case 1053: {
                    value = this.func.matches(str);
                }
            }
        } else {
            this.error("Numeric function expected");
        }
        return value;
    }

    final Variable getArrayElement(Variable v) {
        int index = this.getIndex();
        Variable[] array = v.getArray();
        if (array == null) {
            this.error("Array expected");
        }
        if (index < 0 || index >= array.length) {
            if (array.length == 0) {
                this.error("Empty array");
            } else {
                this.error("Index (" + index + ") out of 0-" + (array.length - 1) + " range");
            }
        }
        return array[index];
    }

    final double runNumericFunction(Variable v) {
        this.getToken();
        this.getToken();
        if (this.token == 129 && v.getArray() != null && this.tokenString.equals("length")) {
            return v.getArraySize();
        }
        String str = v.getString();
        if (str == null) {
            this.error("Array or string expected");
        }
        return this.getNumericStringFunction(str);
    }

    final double getStringExpression() {
        double value;
        block4: {
            value = this.getTerm();
            while (true) {
                this.getToken();
                if (this.token == 43) {
                    Variable v;
                    this.getToken();
                    if (this.token == 133 || this.token == 136) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    if (this.token == 129 && (v = this.lookupVariable(this.tokenAddress)) != null && v.getString() != null) {
                        this.putTokenBack();
                        this.putTokenBack();
                        break block4;
                    }
                    this.putTokenBack();
                    value += this.getTerm();
                    continue;
                }
                if (this.token != 45) break;
                value -= this.getTerm();
            }
            this.putTokenBack();
        }
        return value;
    }

    final Variable lookupLocalVariable(int symTabAddress) {
        int i;
        Variable v = null;
        for (i = this.topOfStack; i >= this.startOfLocals; --i) {
            if (this.stack[i].symTabIndex != symTabAddress) continue;
            v = this.stack[i];
            break;
        }
        if (v == null) {
            for (i = this.topOfGlobals; i >= 0; --i) {
                if (this.stack[i].symTabIndex != symTabAddress) continue;
                v = this.stack[i];
                break;
            }
        }
        return v;
    }

    final Variable lookupVariable(int symTabAddress) {
        Variable v = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != symTabAddress) continue;
            v = this.stack[i];
            break;
        }
        return v;
    }

    Variable push(Variable var, Interpreter interp) {
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interp.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = var;
        return var;
    }

    void pushGlobals() {
        if (this.pgm.globals == null) {
            return;
        }
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        for (int i = 0; i < this.pgm.globals.length; ++i) {
            ++this.topOfStack;
            this.stack[this.topOfStack] = this.pgm.globals[i];
        }
        this.topOfGlobals = this.topOfStack;
    }

    Variable push(int symTabLoc, double value, String str, Interpreter interp) {
        Variable var = new Variable(symTabLoc, value, str);
        if (this.stack == null) {
            this.stack = new Variable[1000];
        }
        if (this.topOfStack >= 998) {
            interp.error("Stack overflow");
        } else {
            ++this.topOfStack;
        }
        this.stack[this.topOfStack] = var;
        return var;
    }

    void trimStack(int previousTOS, int previousStartOfLocals) {
        for (int i = previousTOS + 1; i <= this.topOfStack; ++i) {
            this.stack[i] = null;
        }
        this.topOfStack = previousTOS;
        this.startOfLocals = previousStartOfLocals;
    }

    final Variable lookupVariable() {
        Variable v = null;
        if (this.stack == null) {
            this.undefined();
            return v;
        }
        boolean found = false;
        for (int i = this.topOfStack; i >= 0; --i) {
            v = this.stack[i];
            if (v.symTabIndex != this.tokenAddress) continue;
            found = true;
            break;
        }
        if (!found) {
            this.undefined();
        }
        return v;
    }

    final String lookupStringVariable() {
        if (this.stack == null) {
            this.undefined();
            return "";
        }
        boolean found = false;
        String str = null;
        for (int i = this.topOfStack; i >= 0; --i) {
            if (this.stack[i].symTabIndex != this.tokenAddress) continue;
            Variable v = this.stack[i];
            found = true;
            int next = this.nextToken();
            if (next == 91) {
                int savePC = this.pc;
                int index = this.getIndex();
                Variable[] array = v.getArray();
                if (array == null) {
                    this.error("Array expected");
                }
                if (index < 0 || index >= array.length) {
                    this.error("Index (" + index + ") out of 0-" + (array.length - 1) + " range");
                }
                str = array[index].getString();
                int next2 = this.nextToken();
                if (str != null) {
                    if (next2 != 46) break;
                    str = this.runStringFunction(str);
                    break;
                }
                if (next2 == 41 || next2 == 59) {
                    str = this.toString(array[index].getValue());
                    break;
                }
                this.pc = savePC - 1;
                this.getToken();
                break;
            }
            if (next == 46) {
                if (v.getString() == null) break;
                str = this.runStringFunction(v.getString());
                break;
            }
            if (v.getArray() != null) {
                this.getToken();
                this.error("'[' or '.' expected");
            }
            str = v.getString();
            break;
        }
        if (!found) {
            this.undefined();
        }
        return str;
    }

    private String runStringFunction(String str) {
        this.getToken();
        this.getToken();
        if (this.token == 129) {
            if (this.tokenString.equals("length")) {
                this.getParens();
                str = "" + str.length();
            } else {
                str = this.tokenString.equals("contains") ? "" + str.contains(this.func.getStringArg()) : (this.tokenString.equals("charAt") ? "" + str.charAt((int)this.func.getArg()) : (this.tokenString.equals("replaceAll") ? this.func.replace(str) : null));
            }
        } else if (this.token == 135) {
            int type = this.pgm.table[this.tokenAddress].type;
            switch (type) {
                case 1030: {
                    str = "" + this.func.indexOf(str);
                    break;
                }
                case 1031: {
                    str = "" + str.lastIndexOf(this.func.getStringArg());
                    break;
                }
                case 1034: {
                    str = "" + str.startsWith(this.func.getStringArg());
                    break;
                }
                case 1035: {
                    str = "" + str.endsWith(this.func.getStringArg());
                    break;
                }
                case 1053: {
                    str = "" + this.func.matches(str);
                    break;
                }
                default: {
                    str = null;
                    break;
                }
            }
        } else if (this.token == 136) {
            int type = this.pgm.table[this.tokenAddress].type;
            switch (type) {
                case 2005: {
                    str = this.func.substring(str);
                    break;
                }
                case 2011: {
                    this.getParens();
                    str = str.toLowerCase(Locale.US);
                    break;
                }
                case 2012: {
                    this.getParens();
                    str = str.toUpperCase(Locale.US);
                    break;
                }
                case 2016: {
                    str = this.func.replace(str);
                    break;
                }
                case 2032: {
                    this.getParens();
                    str = str.trim();
                    break;
                }
                default: {
                    str = null;
                    break;
                }
            }
        } else {
            str = null;
        }
        if (str == null) {
            this.error("String function expected");
        }
        return str;
    }

    int getIndex() {
        this.getToken();
        if (this.token != 91) {
            this.error("'['expected");
        }
        int index = (int)this.getExpression();
        this.getToken();
        if (this.token != 93) {
            this.error("']' expected");
        }
        return index;
    }

    void undefined() {
        if (this.nextToken() == 40) {
            this.error("Undefined identifier");
        } else if (this.pgm.getSize() == 1) {
            String cmd = this.pgm.decodeToken(this.pgm.code[0]);
            cmd = cmd.replaceAll("_", " ");
            Hashtable commands = Menus.getCommands();
            if (commands != null && commands.get(cmd) != null) {
                IJ.run(cmd);
            } else {
                this.error("Undefined variable");
            }
        } else {
            this.error("Undefined variable");
        }
    }

    void dump() {
        this.getParens();
        if (!this.done) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
            this.dumpStack();
        }
    }

    void dumpStack() {
        IJ.log("");
        IJ.log("Stack");
        if (this.stack != null) {
            for (int i = this.topOfStack; i >= 0; --i) {
                Variable v = this.stack[i];
                Symbol symbol = v != null ? this.pgm.table[v.symTabIndex] : null;
                IJ.log(i + " " + (symbol != null ? symbol.str : "null") + " " + v);
            }
        }
    }

    void finishUp() {
        Frame frame;
        ResultsTable rt;
        if (this.batchMacro) {
            this.batchMacroImage = WindowManager.getCurrentImage();
        }
        this.func.updateDisplay();
        instance = null;
        if (!this.calledMacro || this.batchMacro) {
            if (batchMode) {
                this.showingProgress = true;
            }
            batchMode = false;
            imageActivations = null;
            imageTable = null;
            WindowManager.setTempCurrentImage(null);
        }
        if (this.func.plot != null) {
            this.func.plot.show();
            this.func.plot = null;
        }
        if (this.showingProgress) {
            IJ.showProgress(0, 0);
        }
        if (this.keysSet) {
            IJ.setKeyUp(18);
            IJ.setKeyUp(16);
            IJ.setKeyUp(32);
        }
        if (this.rgbWeights != null) {
            ColorProcessor.setWeightingFactors(this.rgbWeights[0], this.rgbWeights[1], this.rgbWeights[2]);
        }
        if (this.func.writer != null) {
            this.func.writer.close();
        }
        this.func.roiManager = null;
        if (this.func.resultsPending && (rt = ResultsTable.getResultsTable()) != null && rt.size() > 0) {
            rt.show("Results");
        }
        if (this.func.unUpdatedTable != null) {
            this.func.unUpdatedTable.show(this.func.unUpdatedTable.getTitle());
        }
        if (IJ.isMacOSX() && this.selectCount > 0 && this.debugger == null && (frame = WindowManager.getFrontWindow()) != null && frame instanceof ImageWindow) {
            ImageWindow.setImageJMenuBar((ImageWindow)frame);
        }
    }

    public static void abort() {
        if (instance != null) {
            instance.abortMacro();
        }
    }

    static void abortPrevious() {
        if (previousInstance != null) {
            previousInstance.abortMacro();
            IJ.beep();
            previousInstance = null;
        }
    }

    public static void abort(Interpreter interp) {
        if (interp != null) {
            interp.abortMacro();
        }
    }

    public void abortMacro() {
        if (!this.calledMacro || this.batchMacro) {
            batchMode = false;
            imageActivations = null;
            imageTable = null;
        }
        if (this.func != null && (this.macroName == null || this.macroName.indexOf(" Tool") == -1)) {
            this.func.abortDialog();
        }
        IJ.showStatus("Macro aborted");
        this.shutdown();
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < 2000L && instance != null) {
            IJ.wait(5);
        }
        if (instance != null) {
            this.abortAllMacroThreads();
            Interpreter.setInstance(null);
        }
    }

    public void abort(String message) {
        this.errorMessage = message;
        if (this.ignoreErrors) {
            this.done = true;
            this.finishUp();
        } else {
            this.error(message);
        }
    }

    private synchronized void shutdown() {
        this.ignoreErrors = true;
        for (int i = 0; i < 10; ++i) {
            this.done = true;
        }
    }

    private void abortAllMacroThreads() {
        try {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            int activeCount = group.activeCount();
            Thread[] threads = new Thread[activeCount];
            group.enumerate(threads);
            for (int i = 0; i < activeCount; ++i) {
                String name = threads[i].getName();
                if (name == null || !name.endsWith("Macro$")) continue;
                threads[i].stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Interpreter getInstance() {
        return instance;
    }

    static void setInstance(Interpreter i) {
        instance = i;
    }

    static void setBatchMode(boolean b) {
        batchMode = b;
        if (!b) {
            imageActivations = null;
            imageTable = null;
        }
    }

    public static boolean isBatchMode() {
        return batchMode && !tempShowMode;
    }

    public static void addBatchModeImage(ImagePlus imp) {
        if (!batchMode || imp == null) {
            return;
        }
        if (imageTable == null) {
            imageTable = new Vector();
        }
        imageTable.add(imp);
        Interpreter.activateImage(imp);
    }

    public static void removeBatchModeImage(ImagePlus imp) {
        int index;
        if (imageTable != null && imp != null && (index = imageTable.indexOf(imp)) != -1) {
            imageTable.remove(index);
            imageActivations.remove(imp);
            WindowManager.setTempCurrentImage(Interpreter.getLastBatchModeImage());
        }
    }

    public static void activateImage(ImagePlus imp) {
        if (imageTable != null && imp != null) {
            if (imageActivations == null) {
                imageActivations = new Vector();
            }
            imageActivations.remove(imp);
            imageActivations.add(imp);
        }
    }

    public static int[] getBatchModeImageIDs() {
        if (!batchMode || imageTable == null) {
            return new int[0];
        }
        int n = imageTable.size();
        int[] imageIDs = new int[n];
        for (int i = 0; i < n; ++i) {
            ImagePlus imp = (ImagePlus)imageTable.get(i);
            imageIDs[i] = imp.getID();
        }
        return imageIDs;
    }

    public static int getBatchModeImageCount() {
        if (!batchMode || imageTable == null) {
            return 0;
        }
        return imageTable.size();
    }

    public static ImagePlus getBatchModeImage(int id) {
        if (!batchMode || imageTable == null) {
            return null;
        }
        Enumeration en = imageTable.elements();
        while (en.hasMoreElements()) {
            ImagePlus imp = (ImagePlus)en.nextElement();
            if (id != imp.getID()) continue;
            return imp;
        }
        return null;
    }

    public static ImagePlus getLastBatchModeImage() {
        if (!batchMode || imageTable == null) {
            return null;
        }
        ImagePlus imp2 = null;
        try {
            int size = imageTable.size();
            if (size == 0) {
                return null;
            }
            if (imageActivations != null && imageActivations.size() > 0) {
                imp2 = (ImagePlus)imageActivations.get(imageActivations.size() - 1);
            }
            if (imp2 == null) {
                imp2 = (ImagePlus)imageTable.get(size - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp2;
    }

    public static void setAdditionalFunctions(String functions) {
        additionalFunctions = functions;
    }

    public static String getAdditionalFunctions() {
        return additionalFunctions;
    }

    public static RoiManager getBatchModeRoiManager() {
        Interpreter interp = Interpreter.getInstance();
        if (interp != null && Interpreter.isBatchMode() && RoiManager.getRawInstance() == null) {
            if (interp.func.roiManager == null) {
                interp.func.roiManager = new RoiManager(true);
            }
            return interp.func.roiManager;
        }
        return null;
    }

    public static boolean isBatchModeRoiManager() {
        Interpreter interp = Interpreter.getInstance();
        return interp != null && Interpreter.isBatchMode() && interp.func.roiManager != null;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
        this.debugMode = debugger != null ? 1 : 0;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugMode(int mode) {
        this.debugMode = mode;
    }

    public int getLineNumber() {
        return this.pgm.lineNumbers[this.pc];
    }

    public String[] getVariables() {
        int nImages = WindowManager.getImageCount();
        if (nImages > 0) {
            this.showDebugFunctions = true;
        }
        int nFunctions = this.showDebugFunctions ? 3 : 0;
        String[] variables = new String[this.topOfStack + 1 + nFunctions];
        if (this.showDebugFunctions) {
            ImagePlus imp;
            String title = null;
            if (nImages > 0 && (imp = WindowManager.getCurrentImage()) != null) {
                title = imp.getTitle();
            }
            if (this.debugMode == 1) {
                System.gc();
            }
            variables[0] = "Memory\t" + IJ.freeMemory();
            variables[1] = "nImages()\t" + nImages;
            variables[2] = "getTitle()\t" + (title != null ? "\"" + title + "\"" : "");
        }
        int index = nFunctions;
        for (int i = 0; i <= this.topOfStack; ++i) {
            String name = this.pgm.table[this.stack[i].symTabIndex].str;
            if (i <= this.topOfGlobals) {
                name = name + " (g)";
            }
            variables[index++] = name + "\t" + this.stack[i];
        }
        return variables;
    }

    public String[] getVariableNames() {
        String[] variables = new String[this.topOfStack + 1];
        for (int i = 0; i <= this.topOfStack; ++i) {
            variables[i] = this.pgm.table[this.stack[i].symTabIndex].str;
        }
        return variables;
    }

    public boolean done() {
        return this.done;
    }

    public boolean wasError() {
        return this.wasError;
    }

    public void setVariable(String name, double value) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            this.stack[i].setValue(value);
            break;
        }
    }

    public void setVariable(String name, String str) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            this.stack[i].setString(str);
            break;
        }
    }

    public double getVariable(String name) {
        for (int i = 0; i <= this.topOfStack; ++i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public double getVariable2(String name) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getValue();
        }
        return Double.NaN;
    }

    public String getStringVariable(String name) {
        for (int i = this.topOfStack; i >= 0; --i) {
            int index = this.stack[i].symTabIndex;
            if (!this.pgm.table[index].str.equals(name)) continue;
            return this.stack[i].getString();
        }
        return null;
    }

    public String getVariableAsString(String name) {
        double value;
        String s = this.getStringVariable(name);
        if (s == null && !Double.isNaN(value = this.getVariable2(name))) {
            s = "" + value;
        }
        return s;
    }

    public void showArrayInspector(int row) {
        if (this.stack == null) {
            return;
        }
        int nFunctions = this.showDebugFunctions ? 3 : 0;
        int stkPos = row - nFunctions;
        if (this.stack.length > stkPos && stkPos >= 0) {
            Variable var = this.stack[stkPos];
            if (var == null) {
                return;
            }
            if (var.getType() != 1 && arrayWindow != null) {
                arrayWindow.setVisible(false);
            }
            if (var.getType() == 1) {
                String headings = "Index\t*\tValue";
                if (arrayWindow == null) {
                    arrayWindow = new TextWindow("Array", "", "", 170, 300);
                }
                arrayWindow.setVisible(true);
                int symIndex = var.symTabIndex;
                String arrName = this.pgm.table[symIndex].str;
                this.inspectStkIndex = stkPos;
                this.inspectSymIndex = symIndex;
                TextPanel txtPanel = arrayWindow.getTextPanel();
                String oldText = txtPanel.getText();
                String[] oldLines = oldText.split("\n");
                txtPanel.clear();
                txtPanel.setColumnHeadings(headings);
                Variable[] elements = var.getArray();
                String title = arrName + "[" + elements.length + "]";
                arrayWindow.setTitle(title);
                arrayWindow.rename(title);
                String newText = "";
                String valueStr = "";
                for (int jj = 0; jj < elements.length; ++jj) {
                    String[] parts;
                    String oldValue;
                    Variable element = elements[jj];
                    if (element.getType() == 2) {
                        valueStr = elements[jj].getString();
                        valueStr = valueStr.replaceAll("\n", "\\\\n");
                        valueStr = "\"" + valueStr + "\"";
                    } else if (element.getType() == 0) {
                        double v = elements[jj].getValue();
                        valueStr = (double)((int)v) == v ? IJ.d2s(v, 0) : ResultsTable.d2s(v, 4);
                    }
                    String flag = " ";
                    if (oldLines.length > jj + 1 && !valueStr.equals(oldValue = (parts = oldLines[jj + 1].split("\t"))[2])) {
                        flag = "*";
                    }
                    String ss = "" + jj + "\t" + flag + "\t" + valueStr + "\n";
                    newText = newText + ss;
                }
                txtPanel.append(newText);
                txtPanel.scrollToTop();
                if (this.debugger != null && this.debugger instanceof Window) {
                    ((Window)((Object)this.debugger)).toFront();
                }
            }
        }
    }

    public void updateArrayInspector() {
        boolean varExists = false;
        if (arrayWindow != null && arrayWindow.isVisible()) {
            for (int stkIndex = 0; stkIndex <= this.topOfStack; ++stkIndex) {
                Variable var = this.stack[stkIndex];
                int symIndex = var.symTabIndex;
                if (this.inspectStkIndex != stkIndex || this.inspectSymIndex != symIndex || var.getType() != 1) continue;
                varExists = true;
                break;
            }
            if (varExists) {
                this.showArrayInspector(this.inspectStkIndex + (this.showDebugFunctions ? 3 : 0));
            } else {
                arrayWindow.setVisible(false);
                arrayWindow.getTextPanel().clear();
            }
        }
    }

    static void setTempShowMode(boolean mode) {
        tempShowMode = mode;
    }

    public static boolean nonBatchMacroRunning() {
        Interpreter interp = Interpreter.getInstance();
        if (interp == null) {
            return false;
        }
        int count = interp.selectCount++;
        if (interp == lastInterp) {
            // empty if block
        }
        lastInterp = interp;
        return !interp.waitingForUser && interp.debugger == null && count > 0 && !Interpreter.isBatchMode();
    }

    public void setApplyMacroTable(ResultsTable rt) {
        this.applyMacroTable = rt;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

