/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(ScaleDialog.class);
        return 159;
    }

    @Override
    public void run(ImageProcessor ip) {
        double measured = 0.0;
        double known = 0.0;
        double aspectRatio = 1.0;
        String unit = "pixel";
        boolean global1 = this.imp.getGlobalCalibration() != null;
        Calibration cal = this.imp.getCalibration();
        Calibration calOrig = cal.copy();
        boolean isCalibrated = cal.scaled();
        String length = "0.00";
        String scale = "<no scale>";
        int digits = 2;
        Roi roi = this.imp.getRoi();
        if (roi != null) {
            if (roi instanceof Line) {
                measured = ((Line)roi).getRawLength();
                length = IJ.d2s(measured, 2);
            } else if (roi.getType() == 0) {
                Rectangle2D.Double r = roi.getFloatBounds();
                measured = Math.max(((RectangularShape)r).getWidth(), ((RectangularShape)r).getHeight());
                length = IJ.d2s(measured, 2);
            }
        }
        if (isCalibrated) {
            if (measured != 0.0) {
                known = measured * cal.pixelWidth;
            } else {
                measured = 1.0 / cal.pixelWidth;
                known = 1.0;
            }
            double dscale = measured / known;
            digits = Tools.getDecimalPlaces(dscale);
            unit = cal.getUnit();
            scale = IJ.d2s(dscale, digits) + " pixels/" + unit;
            aspectRatio = cal.pixelHeight / cal.pixelWidth;
        }
        digits = Tools.getDecimalPlaces(measured);
        int asDigits = aspectRatio == 1.0 ? 1 : 3;
        SetScaleDialog gd = new SetScaleDialog("Set Scale", scale, length);
        gd.addNumericField("Distance in pixels:", measured, digits, 8, null);
        gd.addNumericField("Known distance:", known, 2, 8, null);
        gd.addNumericField("Pixel aspect ratio:", aspectRatio, asDigits, 8, null);
        gd.addStringField("Unit of length:", unit);
        gd.addPanel(this.makeButtonPanel(gd), 13, new Insets(5, 0, 0, 0));
        gd.setInsets(0, 30, 0);
        gd.addCheckbox("Global", global1);
        gd.setInsets(10, 0, 0);
        gd.addMessage("Scale: 12345.789 pixels per centimeter");
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#scale");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        measured = gd.getNextNumber();
        known = gd.getNextNumber();
        if (aspectRatio == 1.0) {
            gd.setSmartRecording(true);
        }
        aspectRatio = gd.getNextNumber();
        gd.setSmartRecording(false);
        unit = gd.getNextString();
        if (unit.equals("A")) {
            unit = "\u00c5";
        }
        boolean global2 = gd.getNextBoolean();
        if (measured == known && unit.equals("unit")) {
            unit = "pixel";
        }
        if (measured <= 0.0 || known <= 0.0 || unit.startsWith("pixel") || unit.startsWith("Pixel") || unit.equals("")) {
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
            cal.pixelDepth = 1.0;
            cal.setUnit("pixel");
        } else {
            if (gd.scaleChanged || IJ.macroRunning()) {
                cal.pixelWidth = known / measured;
                if (cal.pixelDepth == 1.0) {
                    cal.pixelDepth = cal.pixelWidth;
                }
            }
            cal.pixelHeight = aspectRatio != 0.0 ? cal.pixelWidth * aspectRatio : cal.pixelWidth;
            cal.setUnit(unit);
        }
        if (!cal.equals(calOrig)) {
            this.imp.setCalibration(cal);
            this.imp.changes = true;
        }
        this.imp.setGlobalCalibration(global2 ? cal : null);
        if (global2 || global2 != global1) {
            WindowManager.repaintImageWindows();
        } else {
            this.imp.repaintWindow();
        }
        if (global2 && global2 != global1) {
            FileOpener.setShowConflictMessage(true);
        }
    }

    Panel makeButtonPanel(SetScaleDialog gd) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        gd.unscaleButton = new Button("Click to Remove Scale");
        gd.unscaleButton.addActionListener(gd);
        panel.add(gd.unscaleButton);
        return panel;
    }
}

