/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.vecmath.Point3i;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class UDWTWaveletCore {
    ArrayList<UDWTScale> UDWTScaleArrayList = null;
    Sequence binarySequence;

    int getNumberOfMaxEnabledScale() {
        int maxScale = 0;
        for (UDWTScale scale : this.UDWTScaleArrayList) {
            if (!scale.isEnabled() || scale.scaleNumber <= maxScale) continue;
            maxScale = scale.scaleNumber;
        }
        return maxScale;
    }

    private int getNumberOfScale() {
        return this.UDWTScaleArrayList.size();
    }

    private double getScaleThreshold(int scale) {
        return this.UDWTScaleArrayList.get(scale).getThreshold();
    }

    private boolean isScaleEnabled(int scale) {
        return this.UDWTScaleArrayList.get(scale).isEnabled();
    }

    private void addConnectedComponentDetection(VolumetricImage vOut, List<DetectionSpot> detectionList, int frame, Sequence originalSequence) {
        IcyBufferedImage img = vOut.getFirstImage();
        VolumetricImage workVol = new VolumetricImage();
        for (int z = 0; z < vOut.getSize(); ++z) {
            workVol.setImage(z, new IcyBufferedImage(img.getSizeX(), img.getSizeY(), 1, DataType.UINT));
        }
        List result = ConnectedComponents.extractConnectedComponents((VolumetricImage)vOut, (double)0.0, (ConnectedComponents.ExtractionType)ConnectedComponents.ExtractionType.BACKGROUND, (boolean)false, (boolean)false, (boolean)false, (int)0, (int)Integer.MAX_VALUE, (VolumetricImage)workVol);
        detectionList.addAll(this.convert2detectionList(originalSequence, result, frame));
    }

    public Sequence getBinarySequence() {
        return this.binarySequence;
    }

    public ArrayList<DetectionSpot> computeDetection(boolean computeBinaryDetection, ArrayList<UDWTScale> UDWTScaleArrayList, Sequence sequenceIn, boolean detectNegative, boolean useROIforWATcomputation) throws InterruptedException {
        return this.computeDetection(computeBinaryDetection, UDWTScaleArrayList, sequenceIn, detectNegative, useROIforWATcomputation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DetectionSpot> computeDetection(boolean computeBinaryDetection, ArrayList<UDWTScale> UDWTScaleArrayList, Sequence sequenceIn, boolean detectNegative, boolean useROIforWATcomputation, boolean force2DWaveletsFor3D) throws InterruptedException {
        int t;
        this.UDWTScaleArrayList = UDWTScaleArrayList;
        ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
        int numScales = this.getNumberOfMaxEnabledScale();
        if (sequenceIn == null) {
            return detectionList;
        }
        if (sequenceIn.getAllImage().size() == 0) {
            return detectionList;
        }
        this.binarySequence = new Sequence();
        this.binarySequence.setName("Binary Sequence");
        Processor processor = new Processor(Math.max(256, sequenceIn.getSizeT()), SystemUtil.getNumberOfCPUs() * 2);
        ArrayList<Future> tasks = new ArrayList<Future>();
        if (sequenceIn.getSizeZ() == 1) {
            if (!B3SplineUDWT.isNumberOfScaleOkForImage2D(sequenceIn.getSizeX(), sequenceIn.getSizeY(), this.getNumberOfMaxEnabledScale())) {
                System.err.println("Scale configuration error");
                return detectionList;
            }
            for (t = 0; t < sequenceIn.getSizeT(); ++t) {
                tasks.add(processor.submit((Callable)new UDWTWaveletCore2DProcessor(sequenceIn, t, numScales, detectNegative, useROIforWATcomputation, computeBinaryDetection)));
            }
        }
        if (sequenceIn.getSizeZ() > 1 && force2DWaveletsFor3D) {
            System.out.println("Entering force 2D wavelet for 3D");
            if (!B3SplineUDWT.isNumberOfScaleOkForImage2D(sequenceIn.getSizeX(), sequenceIn.getSizeY(), this.getNumberOfMaxEnabledScale())) {
                System.err.println("Scale configuration error (your image is too small for this scale)");
                return detectionList;
            }
            for (t = 0; t < sequenceIn.getSizeT(); ++t) {
                tasks.add(processor.submit((Callable)new UDWTWaveletCore2D3DProcessor(sequenceIn, t, numScales, detectNegative, useROIforWATcomputation, computeBinaryDetection)));
            }
        }
        if (sequenceIn.getSizeZ() > 1 && !force2DWaveletsFor3D) {
            if (!B3SplineUDWT.isNumberOfScaleOkForImage3D(sequenceIn.getSizeX(), sequenceIn.getSizeY(), sequenceIn.getSizeZ(), this.getNumberOfMaxEnabledScale())) {
                int scale2 = B3SplineUDWT.getMinSize(2);
                int scale3 = B3SplineUDWT.getMinSize(3);
                int scale4 = B3SplineUDWT.getMinSize(4);
                MessageDialog.showDialog((String)("<html><center>There is a problem with the scale configuration (but don't worry, read this):<br><br>To run in 3D, the wavelet algorithm needs a number of slices depending on the scale(s) you enabled:<br><br>Scale 2 : " + scale2 + " slices<br>Scale 3 : " + scale3 + " slices<br>Scale 4 : " + scale4 + " slices<br><br>To use those parameters you need more Z in your stack.<br>Still, you can bypass this problem by selecting<br>the option <b>Force use of 2D Wavelets for 3D</b> in the detector panel<br>In this case, each 2D slices will be computed separately and results will be merged to create the resulting stack,<br>(and you don't need to add more Z slices),<br>The sequence file name is: " + sequenceIn.getFilename() + "</center></html>"), (int)2);
                return detectionList;
            }
            for (t = 0; t < sequenceIn.getSizeT(); ++t) {
                tasks.add(processor.submit((Callable)new UDWTWaveletCore3DProcessor(sequenceIn, t, numScales, detectNegative, useROIforWATcomputation, computeBinaryDetection)));
            }
        }
        this.binarySequence.beginUpdate();
        try {
            boolean exception = false;
            for (Future task : tasks) {
                try {
                    List spots = (List)task.get();
                    if (spots == null || spots.isEmpty()) continue;
                    detectionList.addAll(spots);
                }
                catch (InterruptedException ex) {
                    processor.removeAllWaitingTasks();
                    processor.shutdownNow();
                    throw new InterruptedException("SpotDetector.computeDetection(..) process interrupted.");
                }
                catch (ExecutionException e) {
                    if (exception) continue;
                    e.getCause().printStackTrace();
                    exception = true;
                }
            }
        }
        finally {
            this.binarySequence.dataChanged();
            this.binarySequence.endUpdate();
        }
        if (computeBinaryDetection) {
            // empty if block
        }
        return detectionList;
    }

    static boolean[] buildBinaryMask(Rectangle bounds, List<ROI> rois, int t, int z) throws InterruptedException {
        if (rois.isEmpty()) {
            return null;
        }
        BooleanMask2D result = new BooleanMask2D(bounds, new boolean[bounds.width * bounds.height]);
        for (ROI roi : rois) {
            result.add(roi.getBooleanMask2D(z, t, -1, true));
        }
        return result.mask;
    }

    private void filter_wat(float[] data, int depth, int width, int height, boolean[] mask) {
        if (!this.isScaleEnabled(depth)) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0.0f;
            }
            return;
        }
        double[] lambdac = new double[this.getNumberOfScale() + 2];
        for (int i = 0; i < this.getNumberOfScale() + 2; ++i) {
            lambdac[i] = Math.sqrt(2.0 * Math.log(width * height / (1 << 2 * i)));
        }
        float mad = UDWTWaveletCore.avesigma(data, mask);
        double[] dcoeff = new double[this.getNumberOfMaxEnabledScale()];
        for (int i = 0; i < this.getNumberOfMaxEnabledScale(); ++i) {
            dcoeff[i] = this.getScaleThreshold(i) / 100.0;
        }
        double coeffThr = lambdac[depth + 1] * (double)mad / dcoeff[depth];
        for (int i = 0; i < data.length; ++i) {
            if ((double)data[i] >= coeffThr) continue;
            data[i] = 0.0f;
        }
    }

    private static float avesigma(float[] image, boolean[] mask) {
        return UDWTWaveletCore.getMeanAverageDistance(image, mask);
    }

    private static float getMeanAverageDistance(float[] data, boolean[] mask) {
        float mean = UDWTWaveletCore.getMean(data, mask);
        float a = 0.0f;
        if (mask == null) {
            for (int i = 0; i < data.length; ++i) {
                float s = data[i] - mean;
                a += Math.abs(s);
            }
            if (data.length > 0) {
                return a / (float)data.length;
            }
        } else {
            float nbValue = 0.0f;
            for (int i = 0; i < data.length; ++i) {
                if (!mask[i]) continue;
                float s = data[i] - mean;
                a += Math.abs(s);
                nbValue += 1.0f;
            }
            if (nbValue > 0.0f) {
                return a / nbValue;
            }
        }
        return 0.0f;
    }

    private static float getVar(float[] data) {
        if (data.length <= 1) {
            return 0.0f;
        }
        float sum = 0.0f;
        float sum2 = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            float val = data[i];
            sum2 += val * val;
            sum += val;
        }
        return (sum2 - sum * sum / (float)data.length) / (float)(data.length - 1);
    }

    private static float getMean(float[] data, boolean[] mask) {
        float mean = 0.0f;
        float sum = 0.0f;
        if (mask == null) {
            for (int i = 0; i < data.length; ++i) {
                sum += data[i];
            }
            if (data.length > 0) {
                mean = sum / (float)data.length;
            }
        } else {
            float nbValue = 0.0f;
            for (int i = 0; i < data.length; ++i) {
                if (!mask[i]) continue;
                sum += data[i];
                nbValue += 1.0f;
            }
            if (nbValue > 0.0f) {
                mean = sum / nbValue;
            }
        }
        return mean;
    }

    private List<DetectionSpot> convert2detectionList(Sequence originalSequence, List<ConnectedComponent> components, int t) {
        ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
        for (ConnectedComponent cc : components) {
            DetectionSpot detection = new DetectionSpot();
            for (Point3i point : cc.getIterablePoints()) {
                detection.points.add(new Point3D(point.x, point.y, point.z));
            }
            detection.setT(t);
            detection.computeMassCenter();
            this.computeMinMeanMaxIntensity(detection, originalSequence);
            detectionList.add(detection);
        }
        return detectionList;
    }

    private void computeMinMeanMaxIntensity(DetectionSpot detection, Sequence originalSequence) {
        double minIntensity = Double.MAX_VALUE;
        double maxIntensity = Double.MIN_VALUE;
        double sumIntensity = 0.0;
        boolean signed = originalSequence.isSignedDataType();
        int w = originalSequence.getSizeX();
        int z = -1;
        Object data = null;
        for (Point3D point : detection.points) {
            double value;
            if (z != (int)point.z) {
                z = (int)point.z;
                data = originalSequence.getDataXY(detection.getT(), (int)point.z, 0);
            }
            if ((value = Array1DUtil.getValue(data, (int)((int)point.y * w + (int)point.x), (boolean)signed)) < minIntensity) {
                minIntensity = value;
            }
            if (value > maxIntensity) {
                maxIntensity = value;
            }
            sumIntensity += value;
        }
        detection.maxIntensity = maxIntensity;
        detection.minIntensity = minIntensity;
        double averageIntensity = 0.0;
        if (detection.points.size() > 0) {
            averageIntensity = sumIntensity / (double)detection.points.size();
        }
        detection.meanIntensity = averageIntensity;
    }

    public class UDWTWaveletCore3DProcessor
    implements Callable<List<DetectionSpot>> {
        final Sequence sequence;
        final int frame;
        final int numScales;
        final boolean negative;
        final boolean useROIWat;
        final boolean doBinary;

        public UDWTWaveletCore3DProcessor(Sequence in, int t, int ns, boolean neg, boolean useROIWat, boolean doBinary) {
            this.sequence = in;
            this.frame = t;
            this.numScales = ns;
            this.negative = neg;
            this.useROIWat = useROIWat;
            this.doBinary = doBinary;
        }

        @Override
        public List<DetectionSpot> call() throws Exception {
            int z;
            float[][][] scales;
            ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
            ArrayList<ROI> rois = new ArrayList<ROI>();
            Rectangle bounds = this.sequence.getBounds2D();
            if (this.useROIWat) {
                rois.addAll(this.sequence.getROIs());
                if (rois.isEmpty()) {
                    rois.add((ROI)new ROI2DRectangle((Rectangle2D)bounds));
                }
            }
            float[][] dataIn = new float[this.sequence.getSizeZ()][];
            for (int z2 = 0; z2 < this.sequence.getSizeZ(); ++z2) {
                dataIn[z2] = Array1DUtil.arrayToFloatArray((Object)this.sequence.getDataXY(this.frame, z2, 0), (boolean)this.sequence.isSignedDataType());
            }
            B3SplineUDWT waveletTransform = new B3SplineUDWT();
            try {
                scales = waveletTransform.b3WaveletScales3D(dataIn, this.sequence.getSizeX(), this.sequence.getSizeY(), this.sequence.getSizeZ(), this.numScales);
            }
            catch (WaveletConfigException e1) {
                e1.printStackTrace();
                return detectionList;
            }
            float[][][] coefficients = waveletTransform.b3WaveletCoefficients3D(scales, dataIn, this.numScales, this.sequence.getSizeX() * this.sequence.getSizeY(), this.sequence.getSizeZ());
            boolean[][] masks = new boolean[this.sequence.getSizeZ()][];
            for (int z3 = 0; z3 < masks.length; ++z3) {
                masks[z3] = UDWTWaveletCore.buildBinaryMask(bounds, rois, this.frame, z3);
            }
            for (int scale = 0; scale < coefficients.length - 1; ++scale) {
                for (z = 0; z < coefficients[scale].length; ++z) {
                    if (this.negative) {
                        for (int ii = 0; ii < coefficients[scale][z].length; ++ii) {
                            coefficients[scale][z][ii] = -coefficients[scale][z][ii];
                        }
                    }
                    UDWTWaveletCore.this.filter_wat(coefficients[scale][z], scale, this.sequence.getWidth(), this.sequence.getHeight(), masks[z]);
                }
            }
            float[][] c = coefficients[coefficients.length - 1];
            for (z = 0; z < c.length; ++z) {
                Arrays.fill(c[z], 0.0f);
            }
            float[][] reconstruction = new float[this.sequence.getSizeZ()][this.sequence.getSizeX() * this.sequence.getSizeY()];
            waveletTransform.b3SpotConstruction3D(coefficients, reconstruction, this.numScales, this.sequence.getSizeX() * this.sequence.getSizeY(), this.sequence.getSizeZ(), UDWTWaveletCore.this.UDWTScaleArrayList);
            for (int z4 = 0; z4 < reconstruction.length; ++z4) {
                float[] binaryDetectionResult = reconstruction[z4];
                for (int i = 0; i < binaryDetectionResult.length; ++i) {
                    binaryDetectionResult[i] = binaryDetectionResult[i] != 0.0f ? 255.0f : 0.0f;
                }
            }
            VolumetricImage vOut = new VolumetricImage();
            for (int z5 = 0; z5 < this.sequence.getSizeZ(); ++z5) {
                IcyBufferedImage imageOut = new IcyBufferedImage(this.sequence.getSizeX(), this.sequence.getSizeY(), 1, DataType.UBYTE);
                ArrayUtil.arrayToArray((Object)reconstruction[z5], (Object)imageOut.getDataXY(0), (boolean)true);
                vOut.setImage(z5, imageOut);
            }
            UDWTWaveletCore.this.addConnectedComponentDetection(vOut, detectionList, this.frame, this.sequence);
            if (this.doBinary) {
                UDWTWaveletCore.this.binarySequence.addVolumetricImage(this.frame, vOut);
            }
            return detectionList;
        }
    }

    public class UDWTWaveletCore2D3DProcessor
    implements Callable<List<DetectionSpot>> {
        final Sequence sequence;
        final int frame;
        final int numScales;
        final boolean negative;
        final boolean useROIWat;
        final boolean doBinary;

        public UDWTWaveletCore2D3DProcessor(Sequence in, int t, int ns, boolean neg, boolean useROIWat, boolean doBinary) {
            this.sequence = in;
            this.frame = t;
            this.numScales = ns;
            this.negative = neg;
            this.useROIWat = useROIWat;
            this.doBinary = doBinary;
        }

        @Override
        public List<DetectionSpot> call() throws Exception {
            ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
            ArrayList<ROI> rois = new ArrayList<ROI>();
            Rectangle bounds = this.sequence.getBounds2D();
            if (this.useROIWat) {
                rois.addAll(this.sequence.getROIs());
                if (rois.isEmpty()) {
                    rois.add((ROI)new ROI2DRectangle((Rectangle2D)bounds));
                }
            }
            Sequence binary3DOutput = new Sequence();
            for (int z = 0; z < this.sequence.getSizeZ(); ++z) {
                float[][] scales;
                boolean[] mask = UDWTWaveletCore.buildBinaryMask(bounds, rois, this.frame, z);
                IcyBufferedImage image = this.sequence.getImage(this.frame, z);
                float[] dataIn = Array1DUtil.arrayToFloatArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                B3SplineUDWT waveletTransform = new B3SplineUDWT();
                try {
                    scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), this.numScales);
                }
                catch (WaveletConfigException e1) {
                    e1.printStackTrace();
                    return detectionList;
                }
                float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, this.numScales, image.getWidth() * image.getHeight());
                for (int i = 0; i < coefficients.length - 1; ++i) {
                    if (this.negative) {
                        for (int ii = 0; ii < coefficients[i].length; ++ii) {
                            coefficients[i][ii] = -coefficients[i][ii];
                        }
                    }
                    UDWTWaveletCore.this.filter_wat(coefficients[i], i, this.sequence.getWidth(), this.sequence.getHeight(), mask);
                }
                Arrays.fill(coefficients[coefficients.length - 1], 0.0f);
                IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.UBYTE);
                float[] binaryDetectionResult = new float[image.getWidth() * image.getHeight()];
                waveletTransform.b3SpotConstruction2D(coefficients, binaryDetectionResult, this.numScales, image.getWidth() * image.getHeight(), UDWTWaveletCore.this.UDWTScaleArrayList);
                for (int i = 0; i < binaryDetectionResult.length; ++i) {
                    binaryDetectionResult[i] = binaryDetectionResult[i] != 0.0f ? 255.0f : 0.0f;
                }
                ArrayUtil.arrayToArray((Object)binaryDetectionResult, (Object)imageOut.getDataXY(0), (boolean)image.isSignedDataType());
                binary3DOutput.setImage(0, z, (BufferedImage)imageOut);
                if (!this.doBinary) continue;
                UDWTWaveletCore.this.binarySequence.setImage(this.frame, z, (BufferedImage)imageOut);
            }
            UDWTWaveletCore.this.addConnectedComponentDetection(binary3DOutput.getVolumetricImage(0), detectionList, this.frame, this.sequence);
            return detectionList;
        }
    }

    public class UDWTWaveletCore2DProcessor
    implements Callable<List<DetectionSpot>> {
        final Sequence sequence;
        final int frame;
        final int numScales;
        final boolean negative;
        final boolean useROIWat;
        final boolean doBinary;

        public UDWTWaveletCore2DProcessor(Sequence in, int t, int ns, boolean neg, boolean useROIWat, boolean doBinary) {
            this.sequence = in;
            this.frame = t;
            this.numScales = ns;
            this.negative = neg;
            this.useROIWat = useROIWat;
            this.doBinary = doBinary;
        }

        @Override
        public List<DetectionSpot> call() throws Exception {
            IcyBufferedImage image;
            ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
            ArrayList<ROI> rois = new ArrayList<ROI>();
            Rectangle bounds = this.sequence.getBounds2D();
            if (this.useROIWat) {
                rois.addAll(this.sequence.getROIs());
                if (rois.isEmpty()) {
                    rois.add((ROI)new ROI2DRectangle((Rectangle2D)bounds));
                }
            }
            if ((image = this.sequence.getImage(this.frame, 0)) != null) {
                float[][] scales;
                boolean[] mask = UDWTWaveletCore.buildBinaryMask(bounds, rois, this.frame, 0);
                float[] dataIn = Array1DUtil.arrayToFloatArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                B3SplineUDWT waveletTransform = new B3SplineUDWT();
                try {
                    scales = waveletTransform.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), this.numScales);
                }
                catch (WaveletConfigException e1) {
                    e1.printStackTrace();
                    return detectionList;
                }
                float[][] coefficients = waveletTransform.b3WaveletCoefficients2D(scales, dataIn, this.numScales, image.getWidth() * image.getHeight());
                for (int i = 0; i < coefficients.length - 1; ++i) {
                    if (this.negative) {
                        for (int ii = 0; ii < coefficients[i].length; ++ii) {
                            coefficients[i][ii] = -coefficients[i][ii];
                        }
                    }
                    UDWTWaveletCore.this.filter_wat(coefficients[i], i, this.sequence.getWidth(), this.sequence.getHeight(), mask);
                }
                Arrays.fill(coefficients[coefficients.length - 1], 0.0f);
                IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, DataType.UBYTE);
                float[] binaryDetectionResult = new float[image.getWidth() * image.getHeight()];
                waveletTransform.b3SpotConstruction2D(coefficients, binaryDetectionResult, this.numScales, image.getWidth() * image.getHeight(), UDWTWaveletCore.this.UDWTScaleArrayList);
                for (int i = 0; i < binaryDetectionResult.length; ++i) {
                    binaryDetectionResult[i] = binaryDetectionResult[i] != 0.0f ? 255.0f : 0.0f;
                }
                ArrayUtil.arrayToArray((Object)binaryDetectionResult, (Object)imageOut.getDataXY(0), (boolean)image.isSignedDataType());
                Sequence seq = new Sequence(imageOut);
                UDWTWaveletCore.this.addConnectedComponentDetection(seq.getVolumetricImage(0), detectionList, this.frame, this.sequence);
                if (this.doBinary) {
                    UDWTWaveletCore.this.binarySequence.setImage(this.frame, 0, (BufferedImage)imageOut);
                }
            }
            return detectionList;
        }
    }
}

