/*
 * Decompiled with CFR 0.152.
 */
package plugins.agaspard.rigidregistration;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import flanagan.complex.Complex;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStatus;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarFrame;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarSlice;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class RigidRegistration
extends EzPlug
implements EzStoppable,
Block {
    EzVarEnum<RegMode> mode = new EzVarEnum("Mode", (Enum[])RegMode.values(), (Enum)RegMode.Simple);
    EzVarEnum<RegType> type = new EzVarEnum("Correct", (Enum[])RegType.values());
    EzVarSequence seq = new EzVarSequence("Dataset");
    EzVarChannel refC = new EzVarChannel("Ref. channel", (Var)this.seq.getVariable(), false);
    EzVarFrame refT = new EzVarFrame("Ref. frame", (Var)this.seq.getVariable(), false);
    EzVarSlice refZ = new EzVarSlice("Ref. slice", (Var)this.seq.getVariable(), false);
    EzVarSequence applyToSimple = new EzVarSequence("Apply transform to");
    VarSequence seqVar = new VarSequence("Registered sequence", null);
    VarSequence applyToSimpleVar = new VarSequence("Registered apply to sequence", null);
    EzVarBoolean regToPrevT = new EzVarBoolean("Reg. to previous frame", false);
    EzVarEnum<ResizePolicy> resizePolicy = new EzVarEnum("Resize policy", (Enum[])ResizePolicy.values());
    EzVarSequence refSeq = new EzVarSequence("Reference");
    EzVarChannel refSeqC = new EzVarChannel("Ref. channel", (Var)this.refSeq.getVariable(), false);
    EzVarSequence objSeq = new EzVarSequence("Candidate");
    EzVarChannel objSeqC = new EzVarChannel("Candidate channel", (Var)this.objSeq.getVariable(), false);
    EzVarSequence applyTo = new EzVarSequence("Apply transform to");
    EzVarChannel applyToC = new EzVarChannel("Channel(s)", (Var)this.applyTo.getVariable(), true);
    EzVarBoolean preserveSize = new EzVarBoolean("Preserve size", true);

    protected void initialize() {
        this.setTimeDisplay(true);
        this.addEzComponent((EzComponent)this.type);
        this.addEzComponent((EzComponent)this.mode);
        EzLabel simpleLabel = new EzLabel("Registers a dataset based on a specific channel / slice / frame");
        final EzGroup simple = new EzGroup("Simple mode", new EzComponent[]{simpleLabel, this.seq, this.refC, this.refT, this.refZ, this.regToPrevT, this.resizePolicy, this.applyToSimple});
        this.type.addVisibilityTriggerTo(this.resizePolicy, (Object[])new RegType[]{RegType.Temporal2D});
        this.type.addVisibilityTriggerTo((EzComponent)this.regToPrevT, (Object[])new RegType[]{RegType.Temporal2D});
        this.regToPrevT.addVisibilityTriggerTo((EzComponent)this.refT, (Object[])new Boolean[]{false});
        this.addEzComponent((EzComponent)simple);
        this.mode.addVisibilityTriggerTo((EzComponent)simple, (Object[])new RegMode[]{RegMode.Simple});
        EzLabel advancedLabel = new EzLabel("Calculates the transform between two datasets, and applies it to a third dataset");
        EzGroup advanced = new EzGroup("Advanced mode", new EzComponent[]{advancedLabel, this.refSeq, this.refSeqC, this.objSeq, this.objSeqC, this.applyTo, this.applyToC, this.preserveSize});
        this.addEzComponent((EzComponent)advanced);
        this.mode.addVisibilityTriggerTo((EzComponent)advanced, (Object[])new RegMode[]{RegMode.Advanced});
        this.type.addVarChangeListener((EzVarListener)new EzVarListener<RegType>(){

            public void variableChanged(EzVar<RegType> source, RegType newValue) {
                if (newValue == RegType.Chromatic2D) {
                    RigidRegistration.this.mode.setVisible(true);
                    if (RigidRegistration.this.mode.getValue() == RegMode.Simple) {
                        RigidRegistration.this.applyToSimple.setVisible(false);
                    }
                } else {
                    RigidRegistration.this.mode.setVisible(false);
                    RigidRegistration.this.mode.setValue((Object)RegMode.Simple);
                    simple.setVisible(true);
                    RigidRegistration.this.applyToSimple.setVisible(true);
                }
            }
        });
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.seq.name, (Var)this.seq.getVariable());
        inputMap.add(this.refC.name, this.refC.getVariable());
        inputMap.add(this.refT.name, this.refT.getVariable());
        inputMap.add(this.refZ.name, this.refZ.getVariable());
        inputMap.add(this.regToPrevT.name, this.regToPrevT.getVariable());
        inputMap.add(this.resizePolicy.name, this.resizePolicy.getVariable());
        inputMap.add(this.applyToSimple.name, (Var)this.applyToSimple.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.seqVar.getName(), (Var)this.seqVar);
        outputMap.add(this.applyToSimpleVar.getName(), (Var)this.applyToSimpleVar);
    }

    protected void execute() {
        boolean rotate = false;
        if (this.isHeadLess()) {
            this.mode.setValue((Object)RegMode.Simple);
            this.type.setValue((Object)RegType.Temporal2D);
        }
        if (this.mode.getValue() == RegMode.Simple) {
            Sequence s = (Sequence)this.seq.getValue(true);
            switch ((RegType)((Object)this.type.getValue())) {
                case Chromatic2D: {
                    RigidRegistration.correctChromaticTranslation2D(s, (Integer)this.refC.getValue(), (Integer)this.refT.getValue(), (Integer)this.refZ.getValue());
                    rotate = RigidRegistration.correctChromaticRotation2D(s, (Integer)this.refC.getValue(), (Integer)this.refT.getValue(), (Integer)this.refZ.getValue());
                    if (!rotate) break;
                    RigidRegistration.correctChromaticTranslation2D(s, (Integer)this.refC.getValue(), (Integer)this.refT.getValue(), (Integer)this.refZ.getValue());
                    break;
                }
                case Temporal2D: {
                    Sequence applyToSeq = (Sequence)this.applyToSimple.getValue(false);
                    if (((Boolean)this.regToPrevT.getValue()).booleanValue()) {
                        RigidRegistration.correctTemporalTranslation2D(s, (int)((Integer)this.refC.getValue()), (int)((Integer)this.refZ.getValue()), applyToSeq);
                        rotate = RigidRegistration.correctTemporalRotation2D(s, (int)((Integer)this.refC.getValue()), (int)((Integer)this.refZ.getValue()), applyToSeq);
                        if (rotate) {
                            RigidRegistration.correctTemporalTranslation2D(s, (int)((Integer)this.refC.getValue()), (int)((Integer)this.refZ.getValue()), applyToSeq);
                        }
                    } else {
                        RigidRegistration.correctTemporalTranslation2D(s, (int)((Integer)this.refT.getValue()), (int)((Integer)this.refC.getValue()), (Integer)this.refZ.getValue(), applyToSeq);
                        rotate = RigidRegistration.correctTemporalRotation2D(s, (Integer)this.refT.getValue(), (Integer)this.refC.getValue(), (Integer)this.refZ.getValue(), applyToSeq);
                        if (rotate) {
                            RigidRegistration.correctTemporalTranslation2D(s, (int)((Integer)this.refT.getValue()), (int)((Integer)this.refC.getValue()), (Integer)this.refZ.getValue(), applyToSeq);
                        }
                    }
                    this.seqVar.setValue(s);
                    this.applyToSimpleVar.setValue(applyToSeq);
                }
            }
        } else {
            double angle;
            Sequence referenceSeq = (Sequence)this.refSeq.getValue(true);
            int referenceChannel = (Integer)this.refSeqC.getValue();
            Sequence candidateSeq = (Sequence)this.objSeq.getValue(true);
            int candidateChannel = (Integer)this.objSeqC.getValue();
            Sequence applyToSeq = (Sequence)this.applyTo.getValue(true);
            int applyToChannel = (Integer)this.applyToC.getValue();
            Sequence tmpCandidate = SequenceUtil.getCopy((Sequence)candidateSeq);
            Vector2d translation = RigidRegistration.findChromaticTranslation2D(tmpCandidate, candidateChannel, referenceSeq, referenceChannel);
            if (translation.lengthSquared() != 0.0) {
                RigidRegistration.applyTranslation2D(tmpCandidate, -1, -1, candidateChannel, translation, (Boolean)this.preserveSize.getValue());
                RigidRegistration.applyTranslation2D(applyToSeq, -1, -1, applyToChannel, translation, (Boolean)this.preserveSize.getValue());
            }
            if (((Boolean)this.preserveSize.getValue()).booleanValue() || translation.lengthSquared() == 0.0) {
                translation = null;
            }
            if (Math.abs((angle = RigidRegistration.findChromaticRotation2D(tmpCandidate, candidateChannel, referenceSeq, referenceChannel, translation)) % Math.PI) > 1.0E-10) {
                RigidRegistration.applyRotation2D(tmpCandidate, -1, -1, candidateChannel, angle, (Boolean)this.preserveSize.getValue());
                RigidRegistration.applyRotation2D(applyToSeq, -1, -1, applyToChannel, angle, (Boolean)this.preserveSize.getValue());
                translation = RigidRegistration.findChromaticTranslation2D(tmpCandidate, candidateChannel, referenceSeq, referenceChannel);
                if (translation.lengthSquared() != 0.0) {
                    RigidRegistration.applyTranslation2D(applyToSeq, -1, -1, applyToChannel, translation, (Boolean)this.preserveSize.getValue());
                }
            }
        }
    }

    public void clean() {
    }

    public static boolean correctChromaticRotation2D(Sequence sequence, int referenceChannel, int referenceFrame, int referenceSlice) {
        boolean change = false;
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            int t;
            if (c == referenceChannel) continue;
            double angle = 0.0;
            int n = 0;
            int minT = referenceFrame == -1 ? 0 : referenceFrame;
            int maxT = referenceFrame == -1 ? sequence.getSizeT() : referenceFrame;
            for (t = minT; t <= maxT; ++t) {
                if (Thread.currentThread().isInterrupted()) {
                    return change;
                }
                int minZ = referenceSlice == -1 ? 0 : referenceSlice;
                int maxZ = referenceSlice == -1 ? sequence.getSizeZ(t) : referenceSlice;
                for (int z = minZ; z <= maxZ; ++z) {
                    IcyBufferedImage img = sequence.getImage(t, z);
                    angle += RigidRegistration.findRotation2D(img, c, img, referenceChannel);
                    ++n;
                }
            }
            System.out.println("[Rigid Registration] Angle: " + (angle /= (double)n));
            if (angle == 0.0) continue;
            change = true;
            for (t = 0; t < sequence.getSizeT(); ++t) {
                for (int z = 0; z < sequence.getSizeZ(t); ++z) {
                    sequence.setImage(t, z, (BufferedImage)RigidRegistration.applyRotation2D(sequence.getImage(t, z), c, angle, true));
                }
            }
        }
        return change;
    }

    public static boolean correctTemporalRotation2D(Sequence sequence, int referenceChannel, int referenceSlice) {
        return RigidRegistration.correctTemporalRotation2D(sequence, referenceChannel, referenceSlice, null);
    }

    public static boolean correctTemporalRotation2D(Sequence sequence, int referenceChannel, int referenceSlice, Sequence applyToSeq) {
        boolean change = false;
        for (int t = 1; t < sequence.getSizeT(); ++t) {
            int z;
            int referenceFrame = t - 1;
            if (Thread.currentThread().isInterrupted()) {
                return change;
            }
            double angle = 0.0;
            int n = 0;
            int minZ = referenceSlice == -1 ? 0 : referenceSlice;
            int maxZ = referenceSlice == -1 ? sequence.getSizeZ(t) : referenceSlice;
            for (z = minZ; z <= maxZ; ++z) {
                int minC = referenceChannel == -1 ? 0 : referenceChannel;
                int maxC = referenceChannel == -1 ? sequence.getSizeC() : referenceChannel;
                for (int c = minC; c <= maxC; ++c) {
                    IcyBufferedImage img = sequence.getImage(t, z);
                    IcyBufferedImage ref = sequence.getImage(referenceFrame, z);
                    angle += RigidRegistration.findRotation2D(img, c, ref, c);
                    ++n;
                }
            }
            System.out.println("[Rigid Registration] Angle: " + (angle /= (double)n));
            if (angle == 0.0) continue;
            change = true;
            for (z = 0; z < sequence.getSizeZ(t); ++z) {
                sequence.setImage(t, z, (BufferedImage)RigidRegistration.applyRotation2D(sequence.getImage(t, z), -1, angle, true));
            }
            if (applyToSeq == null) continue;
            for (z = 0; z < applyToSeq.getSizeZ(t); ++z) {
                applyToSeq.setImage(t, z, (BufferedImage)RigidRegistration.applyRotation2D(applyToSeq.getImage(t, z), -1, angle, true));
            }
        }
        return change;
    }

    public static boolean correctTemporalRotation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice) {
        return RigidRegistration.correctTemporalRotation2D(sequence, referenceFrame, referenceChannel, referenceSlice, null);
    }

    public static boolean correctTemporalRotation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice, Sequence applyToSeq) {
        boolean change = false;
        for (int t = 0; t < sequence.getSizeT(); ++t) {
            int z;
            if (Thread.currentThread().isInterrupted()) {
                return change;
            }
            if (t == referenceFrame) continue;
            double angle = 0.0;
            int n = 0;
            int minZ = referenceSlice == -1 ? 0 : referenceSlice;
            int maxZ = referenceSlice == -1 ? sequence.getSizeZ(t) : referenceSlice;
            for (z = minZ; z <= maxZ; ++z) {
                int minC = referenceChannel == -1 ? 0 : referenceChannel;
                int maxC = referenceChannel == -1 ? sequence.getSizeC() : referenceChannel;
                for (int c = minC; c <= maxC; ++c) {
                    IcyBufferedImage img = sequence.getImage(t, z);
                    IcyBufferedImage ref = sequence.getImage(referenceFrame, z);
                    angle += RigidRegistration.findRotation2D(img, c, ref, c);
                    ++n;
                }
            }
            System.out.println("[Rigid Registration] Angle: " + (angle /= (double)n));
            if (angle == 0.0) continue;
            change = true;
            for (z = 0; z < sequence.getSizeZ(t); ++z) {
                sequence.setImage(t, z, (BufferedImage)RigidRegistration.applyRotation2D(sequence.getImage(t, z), -1, angle, true));
            }
            if (applyToSeq == null) continue;
            for (z = 0; z < applyToSeq.getSizeZ(t); ++z) {
                applyToSeq.setImage(t, z, (BufferedImage)RigidRegistration.applyRotation2D(applyToSeq.getImage(t, z), -1, angle, true));
            }
        }
        return change;
    }

    public static boolean correctChromaticTranslation2D(Sequence sequence, int referenceChannel, int referenceFrame, int referenceSlice) {
        boolean change = false;
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            int t;
            if (c == referenceChannel) continue;
            Vector2d translation = new Vector2d();
            int n = 0;
            int minT = referenceFrame == -1 ? 0 : referenceFrame;
            int maxT = referenceFrame == -1 ? sequence.getSizeT() : referenceFrame;
            for (t = minT; t <= maxT; ++t) {
                if (Thread.currentThread().isInterrupted()) {
                    return change;
                }
                int minZ = referenceSlice == -1 ? 0 : referenceSlice;
                int maxZ = referenceSlice == -1 ? sequence.getSizeZ(t) : referenceSlice;
                for (int z = minZ; z <= maxZ; ++z) {
                    IcyBufferedImage img = sequence.getImage(t, z);
                    translation.add((Tuple2d)RigidRegistration.findTranslation2D(img, c, img, referenceChannel));
                    ++n;
                }
            }
            translation.scale(1.0 / (double)n);
            System.out.println("[Rigid Registration] Translation: " + StringUtil.toString((double)translation.x, (int)2) + " / " + StringUtil.toString((double)translation.y, (int)2));
            if (translation.lengthSquared() == 0.0) continue;
            change = true;
            for (t = 0; t < sequence.getSizeT(); ++t) {
                for (int z = 0; z < sequence.getSizeZ(t); ++z) {
                    sequence.setImage(t, z, (BufferedImage)RigidRegistration.applyTranslation2D(sequence.getImage(t, z), c, translation, true));
                }
            }
        }
        return change;
    }

    public static boolean correctTemporalTranslation2D(Sequence sequence, int referenceChannel, int referenceSlice) {
        return RigidRegistration.correctTemporalTranslation2D(sequence, referenceChannel, referenceSlice, null);
    }

    public static boolean correctTemporalTranslation2D(Sequence sequence, int referenceChannel, int referenceSlice, Sequence applyToSeq) {
        boolean change = false;
        for (int t = 1; t < sequence.getSizeT(); ++t) {
            int z;
            int referenceFrame = t - 1;
            if (Thread.currentThread().isInterrupted()) {
                return change;
            }
            Vector2d translation = new Vector2d();
            int n = 0;
            int minZ = referenceSlice == -1 ? 0 : referenceSlice;
            int maxZ = referenceSlice == -1 ? sequence.getSizeZ(t) : referenceSlice;
            for (z = minZ; z <= maxZ; ++z) {
                int minC = referenceChannel == -1 ? 0 : referenceChannel;
                int maxC = referenceChannel == -1 ? sequence.getSizeC() - 1 : referenceChannel;
                for (int c = minC; c <= maxC; ++c) {
                    IcyBufferedImage img = sequence.getImage(t, z);
                    IcyBufferedImage ref = sequence.getImage(referenceFrame, z);
                    translation.add((Tuple2d)RigidRegistration.findTranslation2D(img, c, ref, c));
                    ++n;
                }
            }
            translation.scale(1.0 / (double)n);
            System.out.println("[Rigid Registration] Translation: " + StringUtil.toString((double)translation.x, (int)2) + " / " + StringUtil.toString((double)translation.y, (int)2));
            if (translation.lengthSquared() == 0.0) continue;
            change = true;
            for (z = 0; z < sequence.getSizeZ(t); ++z) {
                sequence.setImage(t, z, (BufferedImage)RigidRegistration.applyTranslation2D(sequence.getImage(t, z), -1, translation, true));
            }
            if (applyToSeq == null) continue;
            for (z = 0; z < applyToSeq.getSizeZ(t); ++z) {
                applyToSeq.setImage(t, z, (BufferedImage)RigidRegistration.applyTranslation2D(applyToSeq.getImage(t, z), -1, translation, true));
            }
        }
        return change;
    }

    public static boolean correctTemporalTranslation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice) {
        return RigidRegistration.correctTemporalTranslation2D(sequence, referenceFrame, referenceChannel, referenceSlice, (Sequence)null);
    }

    public static boolean correctTemporalTranslation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice, Sequence applyToSeq) {
        Rectangle newBounds = RigidRegistration.correctTemporalTranslation2D(sequence, referenceFrame, referenceChannel, referenceSlice, ResizePolicy.PRESERVE_SIZE, null, applyToSeq);
        return newBounds.equals(sequence.getBounds2D());
    }

    public static Rectangle correctTemporalTranslation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice, ResizePolicy policy, EzStatus status) {
        return RigidRegistration.correctTemporalTranslation2D(sequence, referenceFrame, referenceChannel, referenceSlice, policy, status, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Rectangle correctTemporalTranslation2D(Sequence sequence, int referenceFrame, int referenceChannel, int referenceSlice, ResizePolicy policy, EzStatus status, Sequence applyToSeq) {
        void var21_29;
        if (status == null) {
            status = new EzStatus();
        }
        Rectangle initialBounds = sequence.getBounds2D();
        int sizeT = sequence.getSizeT();
        int sizeC = sequence.getSizeC();
        DataType dataType = sequence.getDataType_();
        Sequence output = policy == ResizePolicy.PRESERVE_SIZE ? sequence : new Sequence();
        Rectangle initialBoundsApplySeq = null;
        int sizeTApplySeq = 0;
        int sizeCApplySeq = 0;
        DataType dataTypeApplySeq = null;
        Sequence outputApplySeq = null;
        if (applyToSeq != null) {
            initialBoundsApplySeq = applyToSeq.getBounds2D();
            sizeTApplySeq = applyToSeq.getSizeT();
            sizeCApplySeq = applyToSeq.getSizeC();
            dataTypeApplySeq = applyToSeq.getDataType_();
            outputApplySeq = policy == ResizePolicy.PRESERVE_SIZE ? applyToSeq : new Sequence();
        }
        ArrayList<Rectangle> translatedBounds = new ArrayList<Rectangle>(sizeT);
        ArrayList<Rectangle> translatedBoundsApplySeq = null;
        if (applyToSeq != null) {
            translatedBoundsApplySeq = new ArrayList<Rectangle>(sizeTApplySeq);
        }
        int t = 0;
        while (t < sizeT) {
            if (Thread.currentThread().isInterrupted()) {
                return initialBounds;
            }
            if (t == referenceFrame) {
                translatedBounds.add(initialBounds);
                if (applyToSeq != null) {
                    translatedBoundsApplySeq.add(initialBoundsApplySeq);
                }
            } else {
                Iterator translation = RigidRegistration.findTranslation2D(sequence, referenceChannel, referenceSlice, t, referenceFrame);
                if (((Point)((Object)translation)).x != 0 || ((Point)((Object)translation)).y != 0) {
                    translatedBounds.add(new Rectangle(((Point)((Object)translation)).x, ((Point)((Object)translation)).y, initialBounds.width, initialBounds.height));
                    if (applyToSeq != null) {
                        translatedBoundsApplySeq.add(new Rectangle(((Point)((Object)translation)).x, ((Point)((Object)translation)).y, initialBoundsApplySeq.width, initialBoundsApplySeq.height));
                    }
                } else {
                    translatedBounds.add(initialBounds);
                    if (applyToSeq != null) {
                        translatedBoundsApplySeq.add(initialBoundsApplySeq);
                    }
                }
            }
            status.setCompletion((double)(++t) / (double)sizeT);
        }
        Rectangle finalBounds = new Rectangle(initialBounds);
        if (policy == ResizePolicy.INTERSECT_BOUNDS) {
            for (Rectangle rectangle : translatedBounds) {
                finalBounds = finalBounds.intersection(rectangle);
            }
        } else if (policy == ResizePolicy.UNITE_BOUNDS) {
            for (Rectangle rectangle : translatedBounds) {
                finalBounds = finalBounds.union(rectangle);
            }
        }
        Rectangle finalBoundsApplySeq = null;
        if (applyToSeq != null) {
            finalBoundsApplySeq = new Rectangle(initialBoundsApplySeq);
            if (policy == ResizePolicy.INTERSECT_BOUNDS) {
                for (Rectangle bounds : translatedBoundsApplySeq) {
                    finalBoundsApplySeq = finalBoundsApplySeq.intersection(bounds);
                }
            } else if (policy == ResizePolicy.UNITE_BOUNDS) {
                for (Rectangle bounds : translatedBoundsApplySeq) {
                    finalBoundsApplySeq = finalBoundsApplySeq.union(bounds);
                }
            }
        }
        boolean bl = false;
        while (var21_29 < sizeT) {
            IcyBufferedImage translatedImage;
            int z;
            if (Thread.currentThread().isInterrupted()) {
                return initialBounds;
            }
            Point newOrigin = ((Rectangle)translatedBounds.get((int)var21_29)).getLocation();
            newOrigin.translate(-finalBounds.x, -finalBounds.y);
            Point newOriginApplySeq = null;
            if (applyToSeq != null) {
                newOriginApplySeq = ((Rectangle)translatedBoundsApplySeq.get((int)var21_29)).getLocation();
                newOriginApplySeq.translate(-finalBoundsApplySeq.x, -finalBoundsApplySeq.y);
            }
            for (z = 0; z < sequence.getSizeZ((int)var21_29); ++z) {
                translatedImage = new IcyBufferedImage(finalBounds.width, finalBounds.height, sizeC, dataType);
                translatedImage.copyData(sequence.getImage((int)var21_29, z), null, newOrigin);
                output.setImage((int)var21_29, z, (BufferedImage)translatedImage);
            }
            if (applyToSeq != null) {
                for (z = 0; z < applyToSeq.getSizeZ((int)var21_29); ++z) {
                    translatedImage = new IcyBufferedImage(finalBoundsApplySeq.width, finalBoundsApplySeq.height, sizeCApplySeq, dataTypeApplySeq);
                    translatedImage.copyData(applyToSeq.getImage((int)var21_29, z), null, newOriginApplySeq);
                    outputApplySeq.setImage((int)var21_29, z, (BufferedImage)translatedImage);
                }
            }
            status.setCompletion((double)(++var21_29) / (double)sizeT);
        }
        if (policy != ResizePolicy.PRESERVE_SIZE) {
            sequence.copyDataFrom(output);
            if (applyToSeq != null) {
                applyToSeq.copyDataFrom(outputApplySeq);
            }
        }
        return finalBounds;
    }

    public static Rectangle correctTemporalTranslation2D(Sequence sequence, int referenceChannel, int referenceSlice, ResizePolicy policy, EzStatus status) {
        if (status == null) {
            status = new EzStatus();
        }
        Rectangle initialBounds = sequence.getBounds2D();
        int sizeT = sequence.getSizeT();
        int sizeC = sequence.getSizeC();
        DataType dataType = sequence.getDataType_();
        Sequence output = policy == ResizePolicy.PRESERVE_SIZE ? sequence : new Sequence();
        ArrayList<Rectangle> translatedBounds = new ArrayList<Rectangle>(sizeT);
        translatedBounds.add(initialBounds);
        int t = 1;
        while (t < sizeT) {
            if (Thread.currentThread().isInterrupted()) {
                return initialBounds;
            }
            Point translation = RigidRegistration.findTranslation2D(sequence, referenceChannel, referenceSlice, t, t - 1);
            if (translation.x != 0 || translation.y != 0) {
                translatedBounds.add(new Rectangle(translation.x, translation.y, initialBounds.width, initialBounds.height));
            } else {
                translatedBounds.add(initialBounds);
            }
            status.setCompletion((double)(++t) / (double)sizeT);
        }
        Rectangle cumulativeBounds = new Rectangle(initialBounds);
        Rectangle finalBounds = new Rectangle(initialBounds);
        if (policy == ResizePolicy.INTERSECT_BOUNDS) {
            for (Rectangle bounds : translatedBounds) {
                cumulativeBounds.translate(bounds.x, bounds.y);
                finalBounds = finalBounds.intersection(cumulativeBounds);
            }
        } else if (policy == ResizePolicy.UNITE_BOUNDS) {
            for (Rectangle bounds : translatedBounds) {
                cumulativeBounds.translate(bounds.x, bounds.y);
                finalBounds = finalBounds.union(cumulativeBounds);
            }
        }
        cumulativeBounds.setBounds(initialBounds);
        int t2 = 0;
        while (t2 < sizeT) {
            if (Thread.currentThread().isInterrupted()) {
                return initialBounds;
            }
            Rectangle translated = (Rectangle)translatedBounds.get(t2);
            cumulativeBounds.translate(translated.x, translated.y);
            for (int z = 0; z < sequence.getSizeZ(t2); ++z) {
                IcyBufferedImage translatedImage = new IcyBufferedImage(finalBounds.width, finalBounds.height, sizeC, dataType);
                translatedImage.copyData(sequence.getImage(t2, z), null, new Point(cumulativeBounds.x - finalBounds.x, cumulativeBounds.y - finalBounds.y));
                output.setImage(t2, z, (BufferedImage)translatedImage);
            }
            status.setCompletion((double)(++t2) / (double)sizeT);
        }
        if (policy != ResizePolicy.PRESERVE_SIZE) {
            sequence.copyDataFrom(output);
        }
        return finalBounds;
    }

    private static Point findTranslation2D(Sequence sequence, int referenceChannel, int referenceSlice, int candidateFrame, int referenceFrame) {
        Vector2d translation = new Vector2d();
        int n = 0;
        int minZ = referenceSlice == -1 ? 0 : referenceSlice;
        int maxZ = referenceSlice == -1 ? sequence.getSizeZ(candidateFrame) : referenceSlice;
        for (int z = minZ; z <= maxZ; ++z) {
            int minC = referenceChannel == -1 ? 0 : referenceChannel;
            int maxC = referenceChannel == -1 ? sequence.getSizeC() - 1 : referenceChannel;
            for (int c = minC; c <= maxC; ++c) {
                IcyBufferedImage img = sequence.getImage(candidateFrame, z);
                IcyBufferedImage ref = sequence.getImage(referenceFrame, z);
                translation.add((Tuple2d)RigidRegistration.findTranslation2D(img, c, ref, c));
                ++n;
            }
        }
        if (n > 1) {
            translation.scale(1.0 / (double)n);
        }
        return new Point((int)Math.round(translation.x), (int)Math.round(translation.y));
    }

    public static double findChromaticRotation2D(Sequence source, int sourceC, Sequence target, int targetC) {
        return RigidRegistration.findChromaticRotation2D(source, sourceC, target, targetC, null);
    }

    public static double findChromaticRotation2D(Sequence source, int sourceC, Sequence target, int targetC, Vector2d previousTranslation) {
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        if (sizeT != target.getSizeT() || sizeZ != target.getSizeZ()) {
            throw new IllegalArgumentException("Source and target sequences have different (Z,T) dimensions");
        }
        double angle = 0.0;
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                IcyBufferedImage srcImg = source.getImage(t, z);
                IcyBufferedImage tgtImg = target.getImage(t, z);
                angle += RigidRegistration.findRotation2D(srcImg, sourceC, tgtImg, targetC, previousTranslation);
            }
        }
        return angle /= (double)(sizeT * sizeZ);
    }

    public static Vector2d findChromaticTranslation2D(Sequence source, int sourceC, Sequence target, int targetC) {
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        if (sizeT != target.getSizeT() || sizeZ != target.getSizeZ()) {
            throw new IllegalArgumentException("Source and target sequences have different (Z,T) dimensions");
        }
        Vector2d vector = new Vector2d();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                IcyBufferedImage srcImg = source.getImage(t, z);
                IcyBufferedImage tgtImg = target.getImage(t, z);
                vector.add((Tuple2d)RigidRegistration.findTranslation2D(srcImg, sourceC, tgtImg, targetC));
            }
        }
        vector.scale(1.0 / (double)(sizeT * sizeZ));
        return vector;
    }

    public static double findRotation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC) {
        return RigidRegistration.findRotation2D(source, sourceC, target, targetC, null);
    }

    public static double findRotation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC, Vector2d previousTranslation) {
        float[] _targetLogPol;
        if (!source.getBounds().equals(target.getBounds())) {
            if (previousTranslation != null) {
                int xAlign = previousTranslation.x > 0.0 ? 2 : 4;
                int yAlign = previousTranslation.y > 0.0 ? 1 : 3;
                target = IcyBufferedImageUtil.scale((IcyBufferedImage)target, (int)source.getSizeX(), (int)source.getSizeY(), (boolean)false, (int)xAlign, (int)yAlign);
            } else {
                throw new UnsupportedOperationException("Cannot register images of different size (yet)");
            }
        }
        IcyBufferedImage sourceLogPol = RigidRegistration.toLogPolar(source.getImage(sourceC));
        IcyBufferedImage targetLogPol = RigidRegistration.toLogPolar(target.getImage(targetC));
        int width = sourceLogPol.getWidth();
        int height = sourceLogPol.getHeight();
        float[] _sourceLogPol = sourceLogPol.getDataXYAsFloat(0);
        float[] correlationMap = RigidRegistration.spectralCorrelation(_sourceLogPol, _targetLogPol = targetLogPol.getDataXYAsFloat(0), width, height);
        int argMax = RigidRegistration.argMax(correlationMap, correlationMap.length / 2);
        int rotX = argMax % width;
        if (rotX > width / 2) {
            rotX -= width;
        }
        return (double)(-rotX * 2) * Math.PI / (double)width;
    }

    public static Vector2d findTranslation2D(IcyBufferedImage source, int sourceC, IcyBufferedImage target, int targetC) {
        if (!source.getBounds().equals(target.getBounds())) {
            throw new UnsupportedOperationException("Cannot register images of different size (yet)");
        }
        int width = source.getWidth();
        int height = source.getHeight();
        float[] _source = Array1DUtil.arrayToFloatArray((Object)source.getDataXY(sourceC), (boolean)source.isSignedDataType());
        float[] _target = Array1DUtil.arrayToFloatArray((Object)target.getDataXY(targetC), (boolean)target.isSignedDataType());
        float[] correlationMap = RigidRegistration.spectralCorrelation(_source, _target, width, height);
        int argMax = RigidRegistration.argMax(correlationMap, correlationMap.length);
        int transX = argMax % width;
        int transY = argMax / width;
        if (transX > width / 2) {
            transX -= width;
        }
        if (transY > height / 2) {
            transY -= height;
        }
        return new Vector2d((double)(-transX), (double)(-transY));
    }

    public static void applyRotation2D(Sequence seq, int t, int z, int c, double angle, boolean preserveImageSize) {
        if (angle == 0.0) {
            return;
        }
        int minT = t == -1 ? 0 : t;
        int maxT = t == -1 ? seq.getSizeT() - 1 : t;
        int minZ = z == -1 ? 0 : z;
        int maxZ = z == -1 ? seq.getSizeZ() - 1 : z;
        for (int time = minT; time <= maxT; ++time) {
            for (int slice = minZ; slice <= maxZ; ++slice) {
                IcyBufferedImage image = seq.getImage(time, slice);
                image = RigidRegistration.applyRotation2D(image, c, angle, preserveImageSize);
                seq.setImage(time, slice, (BufferedImage)image);
            }
        }
    }

    public static IcyBufferedImage applyRotation2D(IcyBufferedImage img, int channel, double angle, boolean preserveImageSize) {
        if (angle == 0.0) {
            return img;
        }
        IcyBufferedImage rotImg = IcyBufferedImageUtil.rotate((IcyBufferedImage)img.getImage(channel), (double)angle);
        Rectangle oldSize = img.getBounds();
        Rectangle newSize = rotImg.getBounds();
        int dw = (newSize.width - oldSize.width) / 2;
        int dh = (newSize.height - oldSize.height) / 2;
        if (channel == -1 || img.getSizeC() == 1) {
            if (preserveImageSize) {
                oldSize.translate(dw, dh);
                return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)rotImg, (Rectangle)oldSize);
            }
            return rotImg;
        }
        IcyBufferedImage[] newImages = new IcyBufferedImage[img.getSizeC()];
        if (preserveImageSize) {
            for (int c = 0; c < newImages.length; ++c) {
                if (c == channel) {
                    oldSize.translate(dw, dh);
                    newImages[c] = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)rotImg, (Rectangle)oldSize);
                    continue;
                }
                newImages[c] = img.getImage(c);
            }
        } else {
            for (int c = 0; c < newImages.length; ++c) {
                if (c != channel) {
                    newImages[c] = new IcyBufferedImage(newSize.width, newSize.height, 1, img.getDataType_());
                    newImages[c].copyData(img.getImage(c), null, new Point(dw, dh));
                    continue;
                }
                newImages[channel] = rotImg;
            }
        }
        return IcyBufferedImage.createFrom(Arrays.asList(newImages));
    }

    public static void applyTranslation2D(Sequence seq, int t, int z, int c, Vector2d vector, boolean preserveImageSize) {
        if (vector.lengthSquared() == 0.0) {
            return;
        }
        int minT = t == -1 ? 0 : t;
        int maxT = t == -1 ? seq.getSizeT() - 1 : t;
        int minZ = z == -1 ? 0 : z;
        int maxZ = z == -1 ? seq.getSizeZ() - 1 : z;
        for (int time = minT; time <= maxT; ++time) {
            for (int slice = minZ; slice <= maxZ; ++slice) {
                IcyBufferedImage image = seq.getImage(time, slice);
                image = RigidRegistration.applyTranslation2D(image, c, vector, preserveImageSize);
                seq.setImage(time, slice, (BufferedImage)image);
            }
        }
    }

    public static IcyBufferedImage applyTranslation2D(IcyBufferedImage image, int channel, Vector2d vector, boolean preserveImageSize) {
        int dx = (int)Math.round(vector.x);
        int dy = (int)Math.round(vector.y);
        if (dx == 0 && dy == 0) {
            return image;
        }
        Rectangle newSize = image.getBounds();
        newSize.width += Math.abs(dx);
        newSize.height += Math.abs(dy);
        Point dstPoint_shiftedChannel = new Point(Math.max(0, dx), Math.max(0, dy));
        Point dstPoint_otherChannels = new Point(Math.max(0, -dx), Math.max(0, -dy));
        IcyBufferedImage newImage = new IcyBufferedImage(newSize.width, newSize.height, image.getSizeC(), image.getDataType_());
        for (int c = 0; c < image.getSizeC(); ++c) {
            Point dstPoint = channel == -1 || c == channel ? dstPoint_shiftedChannel : dstPoint_otherChannels;
            newImage.copyData(image, null, dstPoint, c, c);
        }
        if (preserveImageSize) {
            newSize = image.getBounds();
            newSize.x = Math.max(0, -dx);
            newSize.y = Math.max(0, -dy);
            return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)newImage, (Rectangle)newSize);
        }
        return newImage;
    }

    private static int argMax(float[] array, int n) {
        int argMax = 0;
        float max = array[0];
        for (int i = 1; i < n; ++i) {
            float val = array[i];
            if (!(val > max)) continue;
            max = val;
            argMax = i;
        }
        return argMax;
    }

    private static IcyBufferedImage toLogPolar(IcyBufferedImage image) {
        return RigidRegistration.toLogPolar(image, image.getWidth() / 2, image.getHeight() / 2, 1080, 360);
    }

    private static IcyBufferedImage toLogPolar(IcyBufferedImage image, int centerX, int centerY, int sizeTheta, int sizeRho) {
        int sizeC = image.getSizeC();
        double theta = 0.0;
        double dtheta = Math.PI * 2 / (double)sizeTheta;
        float[] cosTheta = new float[sizeTheta];
        float[] sinTheta = new float[sizeTheta];
        int thetaIndex = 0;
        while (thetaIndex < sizeTheta) {
            cosTheta[thetaIndex] = (float)Math.cos(theta);
            sinTheta[thetaIndex] = (float)Math.sin(theta);
            ++thetaIndex;
            theta += dtheta;
        }
        float drho = (float)(Math.sqrt(centerX * centerX + centerY * centerY) / (double)sizeRho);
        IcyBufferedImage logPol = new IcyBufferedImage(sizeTheta, sizeRho, sizeC, DataType.FLOAT);
        for (int c = 0; c < sizeC; ++c) {
            float[] out = logPol.getDataXYAsFloat(c);
            Array1DUtil.fill((float[])out, (int)0, (int)sizeTheta, (float)RigidRegistration.getPixelValue(image, centerX, centerY, c));
            float rho = drho;
            int outOffset = sizeTheta;
            int rhoIndex = 1;
            while (rhoIndex < sizeRho) {
                int thetaIndex2 = 0;
                while (thetaIndex2 < sizeTheta) {
                    double x = (float)centerX + rho * cosTheta[thetaIndex2];
                    double y = (float)centerY + rho * sinTheta[thetaIndex2];
                    out[outOffset] = RigidRegistration.getPixelValue(image, x, y, c);
                    ++thetaIndex2;
                    ++outOffset;
                }
                ++rhoIndex;
                rho += drho;
            }
        }
        logPol.updateChannelsBounds();
        return logPol;
    }

    private static float getPixelValue(IcyBufferedImage img, double x, double y, int c) {
        int width = img.getWidth();
        int height = img.getHeight();
        Object data = img.getDataXY(c);
        DataType type = img.getDataType_();
        int i = (int)Math.floor(x -= 0.5);
        int j = (int)Math.floor(y -= 0.5);
        if (i <= 0 || i >= width - 1 || j <= 0 || j >= height - 1) {
            return 0.0f;
        }
        float value = 0.0f;
        int offset = i + j * width;
        int offset_plus_1 = offset + 1;
        double mx = 1.0 - (x -= (double)i);
        double my = 1.0 - (y -= (double)j);
        value = (float)((double)value + mx * my * (double)Array1DUtil.getValueAsFloat((Object)data, (int)offset, (DataType)type));
        value = (float)((double)value + x * my * (double)Array1DUtil.getValueAsFloat((Object)data, (int)offset_plus_1, (DataType)type));
        value = (float)((double)value + mx * y * (double)Array1DUtil.getValueAsFloat((Object)data, (int)(offset + width), (DataType)type));
        value = (float)((double)value + x * y * (double)Array1DUtil.getValueAsFloat((Object)data, (int)(offset_plus_1 + width), (DataType)type));
        return value;
    }

    private static float[] forwardFFT(float[] realData, FloatFFT_2D fft) {
        float[] out = new float[realData.length * 2];
        int i = 0;
        int j = 0;
        while (i < realData.length) {
            out[j] = realData[i];
            ++i;
            j += 2;
        }
        fft.complexForward(out);
        return out;
    }

    private static float[] inverseFFT(float[] cplxData, FloatFFT_2D fft) {
        float[] out = new float[cplxData.length / 2];
        fft.complexInverse(cplxData, true);
        int i = 0;
        int j = 0;
        while (i < cplxData.length) {
            out[j] = cplxData[i];
            i += 2;
            ++j;
        }
        return out;
    }

    private static float[] spectralCorrelation(float[] a1, float[] a2, int width, int height) {
        FloatFFT_2D fft = new FloatFFT_2D(height, width);
        return RigidRegistration.spectralCorrelation(a1, a2, width, height, fft);
    }

    private static float[] spectralCorrelation(float[] a1, float[] a2, int width, int height, FloatFFT_2D fft) {
        float[] sourceFFT = RigidRegistration.forwardFFT(a1, fft);
        float[] targetFFT = RigidRegistration.forwardFFT(a2, fft);
        Complex c1 = new Complex();
        Complex c2 = new Complex();
        for (int i = 0; i < sourceFFT.length; i += 2) {
            c1.setReal((double)sourceFFT[i]);
            c1.setImag((double)sourceFFT[i + 1]);
            c2.setReal((double)targetFFT[i]);
            c2.setImag((double)targetFFT[i + 1]);
            c1.timesEquals(c2.conjugate());
            sourceFFT[i] = (float)c1.getReal();
            sourceFFT[i + 1] = (float)c1.getImag();
        }
        return RigidRegistration.inverseFFT(sourceFFT, fft);
    }

    public static enum ResizePolicy {
        UNITE_BOUNDS,
        PRESERVE_SIZE,
        INTERSECT_BOUNDS;


        public String toString() {
            return super.toString().toLowerCase().replace('_', ' ');
        }
    }

    private static enum RegType {
        Chromatic2D("Chromatic shift (2D)"),
        Temporal2D("Temporal drift (2D)");

        private final String method;

        private RegType(String method) {
            this.method = method;
        }

        public String toString() {
            return this.method;
        }
    }

    private static enum RegMode {
        Simple,
        Advanced;

    }
}

