/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock;

import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarTrigger;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.tprovoost.scripteditor.scriptblock.script.Script;
import plugins.tprovoost.scripteditor.scriptblock.script.ScriptType;
import plugins.tprovoost.scripteditor.scriptblock.var.VarScript;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;

public abstract class ScriptBlock
extends Plugin
implements Block,
VarListListener,
TypeChangeListener {
    private List<String> languagesInstalled;
    private VarScript script;
    private VarList inputMap;
    private int inputVarIdx = 0;
    private VarTrigger inputVarTrigger;
    private VarList outputMap;
    private int outputVarIdx = 0;
    private VarTrigger outputVarTrigger;
    private final TypeSelectionModel typeSelector = new TypeSelectionModel(new Class[]{Object.class, Object[].class, Sequence.class, ROI[].class, Integer.class, Double.class, int[].class, double[].class, String.class, File.class, File[].class});

    public ScriptBlock(VarScript script) {
        this.script = script;
    }

    protected VarScript getVarScript() {
        return this.script;
    }

    public void declareInput(VarList inputMap) {
        this.languagesInstalled = new ArrayList<String>();
        for (ScriptEngineFactory f : ScriptEngineHandler.getEngineManager().getEngineFactories()) {
            this.languagesInstalled.add(ScriptEngineHandler.getLanguageName(f));
        }
        if (this.inputMap == null) {
            this.inputMap = inputMap;
        }
        this.script.setReferencingPolicy(VarReferencingPolicy.NONE);
        this.createAddInputVarTrigger();
        this.createAddOutputVarTrigger();
        inputMap.addVarListListener((VarListListener)this);
        inputMap.add("Script", (Var)this.script);
        inputMap.add("Add Input", (Var)this.inputVarTrigger);
        inputMap.add("Add output", (Var)this.outputVarTrigger);
        VarMutable firstInputVariable = this.createInputVariable(this.inputVarIdx);
        inputMap.add(firstInputVariable.getName(), (Var)firstInputVariable);
    }

    private void createAddInputVarTrigger() {
        this.inputVarTrigger = new VarTrigger("Add Input", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                ScriptBlock.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                ScriptBlock.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                VarMutable newVariable = ScriptBlock.this.createInputVariable(ScriptBlock.this.inputVarIdx);
                ScriptBlock.this.inputMap.addRuntimeVariable("" + newVariable.hashCode(), newVariable);
                ScriptBlock.this.registerVariables();
            }
        }});
        this.inputVarTrigger.setReferencingPolicy(VarReferencingPolicy.NONE);
    }

    private void createAddOutputVarTrigger() {
        this.outputVarTrigger = new VarTrigger("Add Output", new VarTrigger.TriggerListener[]{new VarTrigger.TriggerListener(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                ScriptBlock.this.registerVariables();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
                ScriptBlock.this.registerVariables();
            }

            public void triggered(VarTrigger source) {
                VarMutable newVariable = ScriptBlock.this.createOutputVariable(ScriptBlock.this.outputVarIdx);
                ScriptBlock.this.outputMap.addRuntimeVariable("" + newVariable.hashCode(), newVariable);
                ScriptBlock.this.registerVariables();
            }
        }});
        this.outputVarTrigger.setReferencingPolicy(VarReferencingPolicy.NONE);
    }

    private VarMutable createInputVariable(int varIdx) {
        VarMutable newVariable = new VarMutable("input" + varIdx, Object.class);
        this.setupVariable(newVariable);
        return newVariable;
    }

    public void declareOutput(VarList outputMap) {
        if (this.outputMap == null) {
            this.outputMap = outputMap;
        }
        outputMap.addVarListListener((VarListListener)this);
        VarMutable firstOutputVariable = this.createOutputVariable(this.outputVarIdx);
        outputMap.add(firstOutputVariable.getName(), (Var)firstOutputVariable);
        this.registerVariables();
    }

    private VarMutable createOutputVariable(int varIdx) {
        VarMutable newVariable = new VarMutable("output" + varIdx, Object.class);
        this.setupVariable(newVariable);
        return newVariable;
    }

    private void setupVariable(VarMutable newVariable) {
        newVariable.setDefaultEditorModel((VarEditorModel)this.typeSelector);
        newVariable.addTypeChangeListener((TypeChangeListener)this);
    }

    public void variableAdded(VarList list, Var<?> variable) {
        if (list == this.inputMap && variable != this.script && variable != this.inputVarTrigger && variable != this.outputVarTrigger) {
            ++this.inputVarIdx;
        } else if (list == this.outputMap) {
            ++this.outputVarIdx;
        }
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable) {
            VarMutable mutable = (VarMutable)variable;
            Class type = mutable.getType();
            mutable.setDefaultEditorModel((VarEditorModel)this.typeSelector);
            mutable.addTypeChangeListener((TypeChangeListener)this);
            mutable.setType(type);
        }
    }

    public void variableRemoved(VarList list, Var<?> variable) {
        if (list.isRuntimeVariable(variable) && variable instanceof VarMutable) {
            ((VarMutable)variable).removeTypeChangeListener((TypeChangeListener)this);
        }
        this.registerVariables();
    }

    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
        this.registerVariables();
    }

    private void registerVariables() {
        HashSet<VarMutable> inputVars = new HashSet<VarMutable>();
        HashSet<VarMutable> outputVars = new HashSet<VarMutable>();
        if (this.inputMap != null) {
            for (Var v : this.inputMap) {
                if (!(v instanceof VarMutable) && !this.inputMap.isRuntimeVariable(v)) continue;
                inputVars.add((VarMutable)v);
            }
        }
        if (this.outputMap != null) {
            for (Var v : this.outputMap) {
                if (!(v instanceof VarMutable) && !this.outputMap.isRuntimeVariable(v)) continue;
                outputVars.add((VarMutable)v);
            }
        }
        this.script.setupInputVariables(inputVars);
        this.script.setupOutputVariables(outputVars);
    }

    public void run() {
        ScriptEngine engine = this.createEngine();
        this.injectInputVariables(engine);
        try {
            this.evaluateCode(engine, this.script.getCode());
        }
        catch (ScriptException e) {
            e.printStackTrace();
            throw new IcyHandledException(e.getMessage(), (Throwable)e);
        }
        this.setOutputVariables(engine);
    }

    private ScriptEngine createEngine() {
        ScriptEngine oldEngine = ScriptEngineHandler.getEngine(this.getScriptType().toString());
        if (oldEngine != null) {
            ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(oldEngine);
            ArrayList<Method> functions = engineHandler.getFunctions();
            ScriptEngineHandler.disposeEngine(oldEngine);
            String newEngineType = oldEngine.getName();
            ScriptEngine newEngine = ScriptEngineHandler.getEngine(newEngineType, true);
            this.installEngineMethods(newEngine, functions);
            newEngine.setWriter(new PrintWriter(System.out));
            newEngine.setErrorWriter(new PrintWriter(System.err));
            return newEngine;
        }
        return null;
    }

    private ScriptType getScriptType() {
        return ((Script)this.script.getValue()).getScriptType();
    }

    protected abstract void installEngineMethods(ScriptEngine var1, ArrayList<Method> var2);

    protected abstract void injectInputVariables(ScriptEngine var1);

    private void evaluateCode(ScriptEngine engine, String code) throws ScriptException {
        engine.eval(this.script.getCode());
    }

    protected abstract void setOutputVariables(ScriptEngine var1);
}

