/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock.script;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import plugins.adufour.vars.lang.VarMutable;
import plugins.tprovoost.scripteditor.scriptblock.script.Script;

public abstract class DefaultScript
implements Script {
    private String code;
    private Set<VarMutable> variables;

    public DefaultScript() {
        this("");
    }

    public DefaultScript(String code) {
        this(code, Collections.emptyList());
    }

    public DefaultScript(String code, Collection<VarMutable> variables) {
        this.code = code;
        this.variables = new HashSet<VarMutable>(variables);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Set<VarMutable> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    @Override
    public void updateCode(String newCode) {
        this.code = newCode;
    }

    @Override
    public void addVariable(VarMutable variable) {
        this.variables.add(variable);
    }

    @Override
    public void addVariables(Collection<VarMutable> variables) {
        this.variables.addAll(variables);
    }

    @Override
    public void removeVariable(VarMutable variable) {
        this.variables.remove(variable);
    }

    @Override
    public void removeVariables(Collection<VarMutable> variables) {
        this.variables.removeAll(variables);
    }

    public String toString() {
        return this.getCode();
    }
}

