/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptingconsole;

import icy.gui.util.FontUtil;
import icy.util.DateUtil;
import icy.util.EventUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.gui.ConsoleOutput;
import plugins.tprovoost.scripteditor.gui.Preferences;
import plugins.tprovoost.scripteditor.scriptingconsole.BindingsScriptFrame;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.js.JSScriptingHandlerRhino;
import plugins.tprovoost.scripteditor.scriptinghandlers.py.PythonScriptingHandler;

public class Scriptingconsole
extends JTextField
implements KeyListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_PER_LINE = 5;
    protected IcyCompletionProvider provider;
    protected ScriptingHandler scriptHandler;
    protected ArrayList<String> history = new ArrayList();
    protected int posInHistory = 0;
    protected ConsoleOutput output;

    public Scriptingconsole() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.provider = new IcyCompletionProvider();
        this.provider.installDefaultCompletions("JavaScript");
        this.scriptHandler = new JSScriptingHandlerRhino((DefaultCompletionProvider)this.provider, this, null, false);
        this.scriptHandler.setNewEngine(false);
        this.scriptHandler.setForceRun(false);
        this.scriptHandler.setStrict(false);
        this.scriptHandler.setVarInterpretation(false);
        this.setFont(FontUtil.setSize((Font)this.getFont(), (int)Preferences.getPreferences().getFontSize()));
        this.setMinimumSize(new Dimension(0, 25));
        this.setPreferredSize(new Dimension(0, 25));
    }

    public void close() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
    }

    public void setLanguage(String language) {
        this.provider.clear();
        if (language.contentEquals("JavaScript")) {
            this.provider = new IcyCompletionProvider();
            this.provider.installDefaultCompletions("javascript");
            this.scriptHandler = new JSScriptingHandlerRhino((DefaultCompletionProvider)this.provider, this, null, false);
        } else if (language.contentEquals("Python")) {
            this.provider = new IcyCompletionProvider();
            this.provider.installDefaultCompletions("Python");
            this.scriptHandler = new PythonScriptingHandler((DefaultCompletionProvider)this.provider, this, null, false);
        } else {
            this.scriptHandler = null;
        }
        if (this.scriptHandler != null) {
            this.scriptHandler.setNewEngine(false);
            this.scriptHandler.setForceRun(false);
            this.scriptHandler.setStrict(false);
            this.scriptHandler.setVarInterpretation(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        String text = this.getText();
        switch (e.getKeyCode()) {
            case 32: {
                e.consume();
                List<Completion> completions = this.provider.getCompletions(this);
                if (completions == null || !e.isControlDown()) {
                    return;
                }
                if (completions.size() == 1) {
                    this.setText(completions.get(0).getReplacementText());
                    break;
                }
                int i = 0;
                String s = "";
                for (Completion c : completions) {
                    s = String.valueOf(s) + c.getReplacementText() + "\t";
                    if (i != 0 && i % 5 == 0) {
                        s = String.valueOf(s) + "\n";
                    }
                    ++i;
                }
                if (!s.endsWith("\n")) {
                    s = String.valueOf(s) + "\n";
                }
                this.output.append(s);
                System.out.println(s);
                break;
            }
            case 38: {
                if (this.posInHistory >= this.history.size() - 1) break;
                ++this.posInHistory;
                this.setText(this.history.get(this.posInHistory));
                e.consume();
                break;
            }
            case 40: {
                if (this.posInHistory <= 0) break;
                --this.posInHistory;
                this.setText(this.history.get(this.posInHistory));
                e.consume();
                break;
            }
            case 10: {
                if (text.isEmpty()) break;
                String time = DateUtil.now((String)"HH:mm:ss");
                if (this.output != null) {
                    this.output.append("> " + text + "\n");
                } else {
                    System.out.println(String.valueOf(time) + ": " + text);
                }
                if (this.scriptHandler != null) {
                    this.scriptHandler.interpret(true);
                }
                this.history.add(0, text);
                this.setText("");
                this.posInHistory = -1;
                BindingsScriptFrame.getInstance().update();
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setOutput(ConsoleOutput consoleOutput) {
        this.output = consoleOutput;
        if (this.scriptHandler != null) {
            this.scriptHandler.setOutput(consoleOutput);
        }
    }

    public void clear() {
        if (this.output != null) {
            this.output.clear();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (EventUtil.isRightMouseButton((MouseEvent)e)) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem itemPaste = new JMenuItem("Paste");
            itemPaste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Scriptingconsole.this.paste();
                }
            });
            popup.add(itemPaste);
            popup.show(this, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

