/*
 * Decompiled with CFR 0.152.
 */
package icy.image.cache;

import icy.file.FileUtil;
import icy.image.cache.AbstractCache;
import icy.image.cache.CacheException;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.MemoryUnit;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.statistics.StatisticsGateway;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class EHCache2
extends AbstractCache {
    final Set<Integer> eternalStoredKeys = new HashSet<Integer>();
    CacheManager cacheManager;
    Cache cache;

    public EHCache2(int cacheSizeMB, String path) {
        String[] oldFiles;
        for (String file : oldFiles = FileUtil.getFiles(FileUtil.getTempDirectory(), new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileUtil.getFileName(pathname.getAbsolutePath(), false).startsWith("ehcache");
            }
        }, false, false, false)) {
            FileUtil.delete(file, false);
        }
        FileUtil.delete(path, true);
        DiskStoreConfiguration diskConfig = new DiskStoreConfiguration().path(path);
        Configuration cacheManagerConfig = new Configuration().diskStore(diskConfig);
        PersistenceConfiguration persistenceConfig = new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP);
        long freeBytes = new File(FileUtil.getDrive(path)).getUsableSpace();
        long freeMB = freeBytes <= 0L ? Long.MAX_VALUE : Math.max(64L, freeBytes / 0x100000L - 200L);
        CacheConfiguration cacheConfig = new CacheConfiguration().name("ehCache2").maxBytesLocalHeap(cacheSizeMB, MemoryUnit.MEGABYTES).maxBytesLocalDisk(Math.min(freeMB, 500000L), MemoryUnit.MEGABYTES).diskSpoolBufferSizeMB(Math.max(32, Math.min(256, cacheSizeMB / 16))).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU).timeToIdleSeconds(300L).timeToLiveSeconds(3600L).diskExpiryThreadIntervalSeconds(120L).persistence(persistenceConfig);
        cacheManagerConfig.addCache(cacheConfig);
        this.cacheManager = CacheManager.create(cacheManagerConfig);
        this.cache = this.cacheManager.getCache("ehCache2");
        this.cache.getCacheEventNotificationService().registerListener(new CustomCacheEventListener());
    }

    @Override
    public void end() {
        try {
            this.clear();
        }
        catch (CacheException e) {
            System.err.println(e.getMessage());
        }
        this.cacheManager.shutdown();
    }

    @Override
    public long usedMemory() {
        return this.cache.calculateInMemorySize() + this.cache.calculateOffHeapSize();
    }

    @Override
    public long usedDisk() {
        return this.cache.calculateOnDiskSize();
    }

    @Override
    public boolean isOnMemoryCache(Integer key) {
        if (this.profiling) {
            this.startProf();
        }
        try {
            boolean bl = this.cache.isElementInMemory(key) | this.cache.isElementOffHeap(key);
            return bl;
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    @Override
    public boolean isOnDiskCache(Integer key) {
        if (this.profiling) {
            this.startProf();
        }
        try {
            boolean bl = this.cache.isElementOnDisk(key);
            return bl;
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    @Override
    public boolean isInCache(Integer key) {
        if (this.profiling) {
            this.startProf();
        }
        try {
            boolean bl = this.cache.isKeyInCache(key);
            return bl;
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cache.getKeysNoDuplicateCheck().size() == 0;
    }

    @Override
    public Collection<Integer> getAllKeys() throws CacheException {
        if (this.profiling) {
            this.startProf();
        }
        try {
            List list = this.cache.getKeys();
            return list;
        }
        catch (Exception e) {
            throw new CacheException("ImageCache: an error occured while retrieving all keys from cache", e);
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Integer key) throws CacheException {
        boolean checkNull;
        if (this.profiling) {
            this.startProf();
        }
        Object result = null;
        Set<Integer> set = this.eternalStoredKeys;
        synchronized (set) {
            checkNull = this.eternalStoredKeys.contains(key);
        }
        try {
            Element e = this.cache.get(key);
            if (e != null) {
                result = e.getObjectValue();
            }
            if (checkNull && result == null) {
                throw new CacheException("ImageCache error: data '" + key + "' couldn't be retrieved (data lost)");
            }
            Object object = result;
            return object;
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Integer key, Object object, boolean eternal) throws CacheException {
        if (this.profiling) {
            this.startProf();
        }
        Set<Integer> set = this.eternalStoredKeys;
        synchronized (set) {
            if (object != null && eternal) {
                this.eternalStoredKeys.add(key);
            } else {
                this.eternalStoredKeys.remove(key);
            }
        }
        try {
            this.cache.put(new Element((Object)key, object, eternal));
        }
        catch (Exception e) {
            throw new CacheException("ImageCache error: data '" + key + "' couldn't be saved in cache", e);
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    @Override
    public void clean() {
        System.gc();
        this.cache.evictExpiredElements();
        System.gc();
        this.cache.evictExpiredElements();
        List keys = this.cache.getKeysNoDuplicateCheck();
        keys.removeAll(this.eternalStoredKeys);
        this.cache.removeAll(keys);
        System.gc();
    }

    @Override
    public void clear() throws CacheException {
        if (this.profiling) {
            this.startProf();
        }
        this.eternalStoredKeys.clear();
        try {
            this.cache.removeAll();
        }
        catch (Exception e) {
            throw new CacheException("ImageCache: an error occured while clearing cache", e);
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Integer key) throws CacheException {
        if (this.profiling) {
            this.startProf();
        }
        Set<Integer> set = this.eternalStoredKeys;
        synchronized (set) {
            this.eternalStoredKeys.remove(key);
        }
        try {
            this.cache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException("ImageCache: an error occured while removing data '" + key + "' from cache", e);
        }
        finally {
            if (this.profiling) {
                this.endProf();
            }
        }
    }

    public StatisticsGateway getStats() {
        return this.cache.getStatistics();
    }

    @Override
    public String getName() {
        return "EHCache 2";
    }

    private class CustomCacheEventListener
    implements CacheEventListener {
        @Override
        public void dispose() {
            System.out.println("EHCache disposed");
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public void notifyElementEvicted(Ehcache ehCache, Element element) {
            if (element.isEternal()) {
                EHCache2.this.cache.put(new Element(element.getObjectKey(), element.getObjectValue(), true));
            }
        }

        @Override
        public void notifyElementExpired(Ehcache ehCache, Element element) {
            if (element.isEternal()) {
                EHCache2.this.cache.put(new Element(element.getObjectKey(), element.getObjectValue(), true));
            }
        }

        @Override
        public void notifyElementPut(Ehcache ehCache, Element element) throws net.sf.ehcache.CacheException {
        }

        @Override
        public void notifyElementRemoved(Ehcache ehCache, Element element) throws net.sf.ehcache.CacheException {
        }

        @Override
        public void notifyElementUpdated(Ehcache ehCache, Element element) throws net.sf.ehcache.CacheException {
        }

        @Override
        public void notifyRemoveAll(Ehcache ehCache) {
        }
    }
}

