/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIsEdit;
import icy.sequence.Sequence;
import java.util.List;
import java.util.Set;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PropertyROIsEdit
extends AbstractROIsEdit {
    String propertyName;
    List<Object> previousValues;
    Object currentValue;

    public PropertyROIsEdit(List<? extends ROI> rois, String propertyName, List<Object> previousValues, Object currentValue, boolean mergeable) {
        super(rois, rois.size() > 1 ? "ROIs " + propertyName + " changed" : "ROI " + propertyName + " changed");
        if (rois.size() != previousValues.size()) {
            throw new IllegalArgumentException("ROI list and previous values list size do not match (" + rois.size() + " != " + previousValues.size() + ")");
        }
        this.propertyName = propertyName;
        this.previousValues = previousValues;
        this.currentValue = currentValue;
        this.setMergeable(mergeable);
    }

    public PropertyROIsEdit(List<? extends ROI> rois, String propertyName, List<Object> previousValues, Object currentValue) {
        this(rois, propertyName, previousValues, currentValue, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Set<Sequence> sequences = this.getSequences();
        for (Sequence sequence : sequences) {
            sequence.beginUpdate();
        }
        try {
            int ind = 0;
            for (ROI rOI : this.getROIs()) {
                rOI.setPropertyValue(this.propertyName, this.previousValues.get(ind++));
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Set<Sequence> sequences = this.getSequences();
        for (Sequence sequence : sequences) {
            sequence.beginUpdate();
        }
        try {
            for (ROI rOI : this.getROIs()) {
                rOI.setPropertyValue(this.propertyName, this.currentValue);
            }
        }
        catch (Throwable throwable) {
            for (Sequence sequence : sequences) {
                sequence.endUpdate();
            }
            throw throwable;
        }
        for (Sequence sequence : sequences) {
            sequence.endUpdate();
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof PropertyROIsEdit) {
            PropertyROIsEdit propEdit = (PropertyROIsEdit)edit;
            if (propEdit.propertyName.equals(this.propertyName) && propEdit.getROIs().equals(this.getROIs())) {
                this.currentValue = propEdit.currentValue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.previousValues = null;
        this.currentValue = null;
    }
}

