/*
 * Decompiled with CFR 0.152.
 */
package icy.type.point;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;

public abstract class Point3D
implements Cloneable {
    int hash = 0;

    public static double getDistance(Point3D pt1, Point3D pt2, double factorX, double factorY, double factorZ) {
        double px = (pt2.getX() - pt1.getX()) * factorX;
        double py = (pt2.getY() - pt1.getY()) * factorY;
        double pz = (pt2.getZ() - pt1.getZ()) * factorZ;
        return Math.sqrt(px * px + py * py + pz * pz);
    }

    public static double getTotalDistance(List<Point3D> points, double factorX, double factorY, double factorZ, boolean connectLastPoint) {
        int size = points.size();
        double result = 0.0;
        if (size > 1) {
            for (int i = 0; i < size - 1; ++i) {
                result += Point3D.getDistance(points.get(i), points.get(i + 1), factorX, factorY, factorZ);
            }
            if (connectLastPoint) {
                result += Point3D.getDistance(points.get(size - 1), points.get(0), factorX, factorY, factorZ);
            }
        }
        return result;
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getZ();

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    public abstract void setZ(double var1);

    public void setLocation(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public void setLocation(Point3D p) {
        this.setLocation(p.getX(), p.getY(), p.getZ());
    }

    public void translate(double x, double y, double z) {
        this.setX(this.getX() + x);
        this.setY(this.getY() + y);
        this.setZ(this.getZ() + z);
    }

    public void translate(Point3D p) {
        this.translate(p.getX(), p.getY(), p.getZ());
    }

    public abstract Point2D toPoint2D();

    public double distance(double x1, double y1, double z1) {
        double a = this.getX() - x1;
        double b = this.getY() - y1;
        double c = this.getZ() - z1;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public double distance(Point3D point) {
        return this.distance(point.getX(), point.getY(), point.getZ());
    }

    public Point3D normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Double(0.0, 0.0, 0.0);
        }
        return new Double(this.getX() / mag, this.getY() / mag, this.getZ() / mag);
    }

    public Point3D midpoint(double x, double y, double z) {
        return new Double(x + (this.getX() - x) / 2.0, y + (this.getY() - y) / 2.0, z + (this.getZ() - z) / 2.0);
    }

    public Point3D midpoint(Point3D point) {
        return this.midpoint(point.getX(), point.getY(), point.getZ());
    }

    public double angle(double x, double y, double z) {
        double az;
        double ay;
        double ax = this.getX();
        double delta = (ax * x + (ay = this.getY()) * y + (az = this.getZ()) * z) / Math.sqrt((ax * ax + ay * ay + az * az) * (x * x + y * y + z * z));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Point3D vector) {
        return this.angle(vector.getX(), vector.getY(), vector.getZ());
    }

    public double angle(Point3D p1, Point3D p2) {
        double bz;
        double by;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double ax = p1.getX() - x;
        double ay = p1.getY() - y;
        double az = p1.getZ() - z;
        double bx = p2.getX() - x;
        double delta = (ax * bx + ay * (by = p2.getY() - y) + az * (bz = p2.getZ() - z)) / Math.sqrt((ax * ax + ay * ay + az * az) * (bx * bx + by * by + bz * bz));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double norm2() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return x * x + y * y + z * z;
    }

    public double length() {
        return Math.sqrt(this.norm2());
    }

    public double magnitude() {
        return this.length();
    }

    public double dotProduct(double x, double y, double z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    public double dotProduct(Point3D vector) {
        return this.dotProduct(vector.getX(), vector.getY(), vector.getZ());
    }

    public Point3D crossProduct(double x, double y, double z) {
        double ax = this.getX();
        double ay = this.getY();
        double az = this.getZ();
        return new Double(ay * z - az * y, az * x - ax * z, ax * y - ay * x);
    }

    public Point3D crossProduct(Point3D vector) {
        return this.crossProduct(vector.getX(), vector.getY(), vector.getZ());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point3D) {
            Point3D pt = (Point3D)obj;
            return this.getX() == pt.getX() && this.getY() == pt.getY() && this.getZ() == pt.getZ();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + java.lang.Double.doubleToLongBits(this.getX());
            bits = 31L * bits + java.lang.Double.doubleToLongBits(this.getY());
            bits = 31L * bits + java.lang.Double.doubleToLongBits(this.getZ());
            this.hash = (int)(bits ^ bits >> 32);
            this.hash |= 1;
        }
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + "]";
    }

    public static class Double
    extends Point3D {
        public double x;
        public double y;
        public double z;

        public static Double[] toPoint3D(double[] input) {
            Double[] result = new Double[input.length / 3];
            int pt = 0;
            for (int i = 0; i < input.length; i += 3) {
                result[pt++] = new Double(input[i + 0], input[i + 1], input[i + 2]);
            }
            return result;
        }

        public static double[] toDoubleArray(Double[] input) {
            double[] result = new double[input.length * 3];
            int off = 0;
            for (Double pt : input) {
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
            }
            return result;
        }

        public Double(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Double(double[] xyz) {
            int len = xyz.length;
            if (len > 0) {
                this.x = xyz[0];
            }
            if (len > 1) {
                this.y = xyz[1];
            }
            if (len > 2) {
                this.z = xyz[2];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = x;
            this.hash = 0;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = y;
            this.hash = 0;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = z;
            this.hash = 0;
        }

        @Override
        public String toString() {
            return "Point3D.Double[" + this.x + "," + this.y + "," + this.z + "]";
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Double(this.x, this.y);
        }
    }

    public static class Integer
    extends Point3D {
        public int x;
        public int y;
        public int z;

        public static Integer[] toPoint3D(int[] input) {
            Integer[] result = new Integer[input.length / 3];
            int pt = 0;
            for (int i = 0; i < input.length; i += 3) {
                result[pt++] = new Integer(input[i + 0], input[i + 1], input[i + 2]);
            }
            return result;
        }

        public static int[] toIntegerArray(Integer[] input) {
            int[] result = new int[input.length * 3];
            int off = 0;
            for (Integer pt : input) {
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
            }
            return result;
        }

        public Integer(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Integer(int[] xyz) {
            int len = xyz.length;
            if (len > 0) {
                this.x = xyz[0];
            }
            if (len > 1) {
                this.y = xyz[1];
            }
            if (len > 2) {
                this.z = xyz[2];
            }
        }

        public Integer() {
            this(0, 0, 0);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (int)x;
            this.hash = 0;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (int)y;
            this.hash = 0;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (int)z;
            this.hash = 0;
        }

        @Override
        public String toString() {
            return "Point3D.Integer[" + this.x + "," + this.y + "," + this.z + "]";
        }

        @Override
        public Point2D toPoint2D() {
            return new Point(this.x, this.y);
        }
    }

    public static class Float
    extends Point3D {
        public float x;
        public float y;
        public float z;

        public static Float[] toPoint3D(float[] input) {
            Float[] result = new Float[input.length / 3];
            int pt = 0;
            for (int i = 0; i < input.length; i += 3) {
                result[pt++] = new Float(input[i + 0], input[i + 1], input[i + 2]);
            }
            return result;
        }

        public static float[] toFloatArray(Float[] input) {
            float[] result = new float[input.length * 3];
            int off = 0;
            for (Float pt : input) {
                result[off++] = pt.x;
                result[off++] = pt.y;
                result[off++] = pt.z;
            }
            return result;
        }

        public Float(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Float(float[] xyz) {
            int len = xyz.length;
            if (len > 0) {
                this.x = xyz[0];
            }
            if (len > 1) {
                this.y = xyz[1];
            }
            if (len > 2) {
                this.z = xyz[2];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double x) {
            this.x = (float)x;
            this.hash = 0;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double y) {
            this.y = (float)y;
            this.hash = 0;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double z) {
            this.z = (float)z;
            this.hash = 0;
        }

        @Override
        public String toString() {
            return "Point3D.Float[" + this.x + "," + this.y + "," + this.z + "]";
        }

        @Override
        public Point2D toPoint2D() {
            return new Point2D.Float(this.x, this.y);
        }
    }
}

