/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static Method getMethod(Class<?> objectClass, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method result = null;
        for (Class<?> clazz = objectClass; clazz != null && result == null; clazz = clazz.getSuperclass()) {
            try {
                result = clazz.getDeclaredMethod(methodName, parameterTypes);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new NoSuchMethodException("Method " + methodName + "(..) not found in class " + objectClass.getName());
        }
        return result;
    }

    @Deprecated
    public static Method getMethod(Class<?> objectClass, String methodName, boolean forceAccess, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method result = null;
        for (Class<?> clazz = objectClass; clazz != null && result == null; clazz = clazz.getSuperclass()) {
            try {
                result = clazz.getDeclaredMethod(methodName, parameterTypes);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new NoSuchMethodException("Method " + methodName + "(..) not found in class " + objectClass.getName());
        }
        if (forceAccess) {
            result.setAccessible(true);
        }
        return result;
    }

    @Deprecated
    public static Method getMethod(Object object, String methodName, boolean forceAccess, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        return ReflectionUtil.getMethod(object.getClass(), methodName, forceAccess, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        Method method = ReflectionUtil.getMethod(object.getClass(), methodName, parameterTypes);
        return method.invoke(object, args);
    }

    @Deprecated
    public static Object invokeMethod(Object object, String methodName, boolean forceAccess, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        Method method = ReflectionUtil.getMethod(object.getClass(), methodName, forceAccess, parameterTypes);
        return method.invoke(object, args);
    }

    public static Field getField(Class<?> objectClass, String fieldName) throws SecurityException, NoSuchFieldException {
        Field result = null;
        for (Class<?> clazz = objectClass; clazz != null && result == null; clazz = clazz.getSuperclass()) {
            try {
                result = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new NoSuchFieldException(" Field " + fieldName + " not found in class " + objectClass.getName());
        }
        return result;
    }

    @Deprecated
    public static Field getField(Class<?> objectClass, String fieldName, boolean forceAccess) throws SecurityException, NoSuchFieldException {
        Field result = null;
        for (Class<?> clazz = objectClass; clazz != null && result == null; clazz = clazz.getSuperclass()) {
            try {
                result = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new NoSuchFieldException(" Field " + fieldName + " not found in class " + objectClass.getName());
        }
        if (forceAccess) {
            result.setAccessible(true);
        }
        return result;
    }

    @Deprecated
    public static Field getField(Object object, String fieldName, boolean forceAccess) throws SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object.getClass(), fieldName, forceAccess);
    }

    public static Object getFieldObject(Object object, String fieldName) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object.getClass(), fieldName).get(object);
    }

    @Deprecated
    public static Object getFieldObject(Object object, String fieldName, boolean forceAccess) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object.getClass(), fieldName, forceAccess).get(object);
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).set(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, boolean value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setBoolean(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, byte value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setByte(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, char value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setChar(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, short value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setShort(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, int value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setInt(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, long value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setLong(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, float value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setFloat(object, value);
    }

    public static void setFieldValue(Object object, String fieldName, double value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        ReflectionUtil.getField(object.getClass(), fieldName).setDouble(object, value);
    }
}

