/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._io;

import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._io.PyIOBase;
import org.python.modules._io.PyRawIOBase$PyExposer;
import org.python.modules._io.PyRawIOBaseDerived;
import org.python.modules._io._io;

@ExposedType(name="_io._RawIOBase", doc="Base class for raw binary I/O.", base=PyIOBase.class)
public class PyRawIOBase
extends PyIOBase {
    public static final PyType TYPE;
    public static final String read_doc = "Read up to n bytes from the object and return them.\nAs a convenience, if n is unspecified or -1, readall() is called.";
    public static final String readall_doc = "Read and return all the bytes from the stream until EOF, using multiple\ncalls to the stream if necessary.";
    public static final String readinto_doc = "Read up to len(b) bytes into bytearray b and return the number of bytes read.\nIf the object is in non-blocking mode and no bytes are available,\nNone is returned.";
    public static final String write_doc = "Write the given bytes or bytearray object, b, to the underlying raw\nstream and return the number of bytes written.";
    static final String doc = "Base class for raw binary I/O.";

    public PyRawIOBase() {
        this(TYPE);
    }

    public PyRawIOBase(PyType subtype) {
        super(subtype);
    }

    @ExposedNew
    static PyObject _RawIOBase__new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (new_.for_type == subtype) {
            return new PyRawIOBase();
        }
        return new PyRawIOBaseDerived(subtype);
    }

    public PyObject read(int n) {
        return this._read(n);
    }

    final PyObject _RawIOBase_read(PyObject n) {
        if (n == null || n == Py.None) {
            return this._read(-1);
        }
        if (n.isIndex()) {
            return this._read(n.asInt());
        }
        throw PyRawIOBase.tailoredTypeError("integer", n);
    }

    private PyObject _read(int n) {
        if (n < 0) {
            return this.invoke("readall");
        }
        PyByteArray b = new PyByteArray(n);
        PyObject m = this.invoke("readinto", b);
        if (m.isIndex()) {
            int count2 = m.asIndex();
            PyBuffer view = b.getBuffer(284);
            if (count2 < n) {
                view = view.getBufferSlice(284, 0, count2);
            }
            return new PyString(((Object)view).toString());
        }
        return m;
    }

    public PyObject readall() {
        return this._RawIOBase_readall();
    }

    final synchronized PyObject _RawIOBase_readall() {
        PyObject readMethod = this.__getattr__("read");
        PyObject prev = readMethod.__call__(_io.DEFAULT_BUFFER_SIZE);
        if (!prev.__nonzero__()) {
            return prev;
        }
        PyObject curr = readMethod.__call__(_io.DEFAULT_BUFFER_SIZE);
        if (!curr.__nonzero__()) {
            return prev;
        }
        PyList list = new PyList();
        list.add(prev);
        do {
            list.add(curr);
        } while ((curr = readMethod.__call__(_io.DEFAULT_BUFFER_SIZE)).__nonzero__());
        return Py.EmptyString.join(list);
    }

    public PyObject readinto(PyObject b) {
        return this._RawIOBase_readinto(b);
    }

    final synchronized PyLong _RawIOBase_readinto(PyObject b) {
        throw this.unsupported("readinto");
    }

    public PyObject write(PyObject b) {
        return this._RawIOBase_write(b);
    }

    final PyLong _RawIOBase_write(PyObject b) {
        throw this.unsupported("write");
    }

    static {
        PyType.addBuilder(PyRawIOBase.class, new PyRawIOBase$PyExposer());
        TYPE = PyType.fromClass(PyRawIOBase.class);
    }
}

