/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.file.FileUtil;
import icy.gui.component.PopupPanel;
import icy.gui.component.sequence.SequenceChooser;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.resource.ResourceUtil;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import icy.swimmingPool.SwimmingPoolListener;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.trackmanager.Link;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackLengthDialog;
import plugins.fab.trackmanager.TrackPanel;
import plugins.fab.trackmanager.TrackPool;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackManager
extends PluginActionable
implements AdjustmentListener,
ActionListener,
SwimmingPoolListener,
IcyFrameListener {
    boolean trackManagerDestroyed = false;
    JButton addTrackProcessorButton = new JButton("add Track Processor...");
    JPanel deetPanel = new JPanel();
    JMenuItem deleteLinkMenuItem = new JMenuItem("Delete links on selected tracks");
    JMenuItem deleteSelectionMenuItem = new JMenuItem("Delete Selection");
    String node = "plugins/fab/trackmanager/displaytrackpanel";
    Preferences preferences = Preferences.userRoot().node(this.node);
    boolean displayTrackManagerBoolean = Boolean.parseBoolean(this.preferences.get("displaytrackpanel", "1"));
    JCheckBoxMenuItem displayTrackPanelCheckBoxMenuItem = new JCheckBoxMenuItem("Display Track Panel", this.displayTrackManagerBoolean);
    JMenuItem fuseTracksMenuItem = new JMenuItem("Fuse All track-segments");
    JMenuItem selectTrackByLengthMenuItem = new JMenuItem("Select track by length...");
    JMenuItem invertSelectionMenuItem = new JMenuItem("Invert Selection");
    JMenuItem debugMenuItem = new JMenuItem("Debug");
    JPanel leftPanel;
    JMenuItem loadMenuItem = new JMenuItem("Load...");
    JMenuItem loadFromTrackMateMenuItem = new JMenuItem("Import from TrackMate...");
    JPanel mainPanel = GuiUtil.generatePanel();
    IcyFrame mainFrame = GuiUtil.generateTitleFrame((String)"TrackManager", (JPanel)this.mainPanel, (Dimension)new Dimension(400, 0), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
    JMenuBar menuBar = new JMenuBar();
    JPopupMenu pluginPopupMenu = new JPopupMenu("Add plugin to queue");
    JMenuItem reOrganizeMenuItem = new JMenuItem("Organize track by parent/child");
    JPanel rightContentPanel;
    JPanel rightPanel;
    JMenuItem saveMenuItem = new JMenuItem("Save as...");
    JScrollPane scrollPane;
    JMenuItem selectAllMenuItem = new JMenuItem("Select all tracks");
    JCheckBoxMenuItem externaliseCheckBoxMenuItem = new JCheckBoxMenuItem("Externalize window", false);
    JButton TestButton;
    TrackPanel trackPanel;
    TrackPool trackPool;
    JMenuItem unselectAllMenuItem = new JMenuItem("Unselect all tracks");
    JButton zoomLessButton = new JButton("Zoom -");
    JButton zoomMoreButton = new JButton("Zoom +");
    JToggleButton showHideTrackPoolSourcesPanel = new JToggleButton("Display TrackPool Sources", true);
    PopupPanel trackGroupSourceInnerPanel = new PopupPanel("Track pool sources");
    SequenceChooser sequenceSelector = new SequenceChooser();
    JMenu trackingGroupSourceMenu;
    JMenuItem trackingGroupSourceHelpMenuItem;
    JMenuItem onlineHelpMenuItem;
    int currentT = 0;

    public boolean isTrackManagerDestroyed() {
        return this.trackManagerDestroyed;
    }

    void loadTrackProcessor(PluginDescriptor pluginDescriptor) {
        PluginTrackManagerProcessor ptep = null;
        try {
            ptep = (PluginTrackManagerProcessor)((Object)pluginDescriptor.getPluginClass().newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ptep == null) {
            System.out.println("Can't load processor.");
            return;
        }
        ptep.setTrackPool(this.trackPool);
        this.trackPool.addTrackProcessor(ptep);
        this.rebuildTrackProcessorDisplay();
    }

    public TrackPool getTrackPool() {
        return this.trackPool;
    }

    void rebuildTrackProcessorDisplay() {
        this.rightContentPanel.removeAll();
        for (PluginTrackManagerProcessor trackProcessor : this.trackPool.getTrackManagerProcessorList()) {
            this.rightContentPanel.add(trackProcessor.getPanel());
        }
        this.rightContentPanel.revalidate();
        ((JPanel)this.rightContentPanel.getParent()).revalidate();
    }

    public TrackManager() {
        this.mainFrame.addFrameListener((IcyFrameListener)this);
        this.trackPool = new TrackPool();
        this.trackPool.trackManager = this;
        this.trackPanel = new TrackPanel(this.trackPool, this.displayTrackPanelCheckBoxMenuItem.isSelected());
        this.trackPanel.setPreferredSize(new Dimension(1000, 1000));
        this.trackPanel.setLayout(null);
        this.scrollPane = new JScrollPane(this.trackPanel, 22, 32);
        this.scrollPane.setPreferredSize(new Dimension(800, 300));
        this.scrollPane.setBorder(new TitledBorder("Track View"));
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        JPanel optionTrackPanel = new JPanel();
        optionTrackPanel.setLayout(new GridLayout(1, 4));
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.loadMenuItem);
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.loadFromTrackMateMenuItem);
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem.addActionListener(this);
        this.loadFromTrackMateMenuItem.addActionListener(this);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(this.selectAllMenuItem);
        editMenu.add(this.unselectAllMenuItem);
        editMenu.add(this.invertSelectionMenuItem);
        editMenu.add(this.selectTrackByLengthMenuItem);
        editMenu.addSeparator();
        editMenu.add(this.reOrganizeMenuItem);
        editMenu.add(this.deleteSelectionMenuItem);
        editMenu.add(this.deleteLinkMenuItem);
        editMenu.add(this.fuseTracksMenuItem);
        editMenu.addSeparator();
        this.debugMenuItem.addActionListener(this);
        this.selectTrackByLengthMenuItem.addActionListener(this);
        this.invertSelectionMenuItem.addActionListener(this);
        this.unselectAllMenuItem.addActionListener(this);
        this.reOrganizeMenuItem.addActionListener(this);
        this.selectAllMenuItem.addActionListener(this);
        this.deleteSelectionMenuItem.addActionListener(this);
        this.deleteLinkMenuItem.addActionListener(this);
        this.fuseTracksMenuItem.addActionListener(this);
        this.externaliseCheckBoxMenuItem.addActionListener(this);
        JMenu displayMenu = new JMenu("Display");
        displayMenu.add(this.displayTrackPanelCheckBoxMenuItem);
        displayMenu.add(this.externaliseCheckBoxMenuItem);
        this.displayTrackPanelCheckBoxMenuItem.addActionListener(this);
        this.trackingGroupSourceMenu = new JMenu("Tracking groups");
        this.trackingGroupSourceHelpMenuItem = new JMenuItem("No track group available: use either file/load, a tracker or a benchmark generator to generate tracks.");
        this.trackingGroupSourceMenu.add(this.trackingGroupSourceHelpMenuItem);
        this.trackingGroupSourceHelpMenuItem.setEnabled(false);
        JMenu helpMenu = new JMenu("Help");
        this.onlineHelpMenuItem = new JMenuItem("Help...");
        helpMenu.add(this.onlineHelpMenuItem);
        this.onlineHelpMenuItem.addActionListener(this);
        this.menuBar.add(fileMenu);
        this.menuBar.add(editMenu);
        this.menuBar.add(this.trackingGroupSourceMenu);
        this.menuBar.add(displayMenu);
        this.menuBar.add(helpMenu);
        this.mainFrame.setJMenuBar(this.menuBar);
        ComponentUtil.setFixedWidth((Component)this.zoomLessButton, (int)150);
        ComponentUtil.setFixedWidth((Component)this.zoomMoreButton, (int)150);
        optionTrackPanel.add(this.zoomLessButton);
        optionTrackPanel.add(this.zoomMoreButton);
        this.zoomLessButton.addActionListener(this);
        this.zoomMoreButton.addActionListener(this);
        JPanel trackPoolSourcePanel = GuiUtil.generatePanelWithoutBorder();
        trackPoolSourcePanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Display results on sequence:"), this.sequenceSelector}));
        JPanel tpp = GuiUtil.generatePanel();
        this.showHideTrackPoolSourcesPanel.addActionListener(this);
        tpp.add(GuiUtil.besidesPanel((Component[])new Component[]{trackPoolSourcePanel}));
        tpp.add(GuiUtil.besidesPanel((Component[])new Component[]{this.addTrackProcessorButton}));
        this.addTrackProcessorButton.addActionListener(this);
        this.leftPanel = new JPanel(new BorderLayout());
        JPanel southPanel = new JPanel(new BorderLayout());
        this.deetPanel.setSize(400, 200);
        this.deetPanel.add(new JLabel("-----------------"));
        southPanel.add((Component)this.deetPanel, "North");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.scrollPane, "Center");
        northPanel.add((Component)optionTrackPanel, "South");
        this.leftPanel.add((Component)northPanel, "Center");
        this.rightContentPanel = new JPanel();
        this.rightContentPanel.setLayout(new BoxLayout(this.rightContentPanel, 3));
        JPanel intermediatePanel = new JPanel(new BorderLayout());
        intermediatePanel.add((Component)this.rightContentPanel, "North");
        intermediatePanel.add(Box.createGlue(), "Center");
        JScrollPane rightScrollPanel = new JScrollPane(intermediatePanel, 22, 32);
        rightScrollPanel.setBorder(new TitledBorder("Track Processor Rack"));
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add((Component)tpp, "North");
        this.rightPanel.add((Component)rightScrollPanel, "Center");
        this.rightPanel.validate();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        JSplitPane mainSplitPane = new JSplitPane(1, this.leftPanel, this.rightPanel);
        this.mainPanel.add(mainSplitPane);
        this.mainPanel.setPreferredSize(new Dimension(800, 400));
        this.trackPool.fireTrackEditorProcessorChange();
        this.buildPluginMenu();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.mainFrame.addToDesktopPane();
        this.mainFrame.center();
        this.initTrackPoolInnerPanel();
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
        this.mainFrame.requestFocus();
        this.sequenceSelector.addActionListener((ActionListener)this);
        PluginDescriptor pd = PluginLoader.getPlugin((String)"plugins.fab.trackmanager.processors.TrackProcessorColorTrack");
        this.loadTrackProcessor(pd);
    }

    public void swimmingPoolChangeEvent(SwimmingPoolEvent swimmingPoolEvent) {
        if (swimmingPoolEvent.getType() == SwimmingPoolEventType.ELEMENT_ADDED && swimmingPoolEvent.getResult().getObject() instanceof TrackGroup) {
            CheckBoxResultSource checkBoxResultSource = new CheckBoxResultSource(swimmingPoolEvent.getResult(), true);
            this.trackingGroupSourceMenu.add(checkBoxResultSource);
            this.trackingGroupSourceHelpMenuItem.setVisible(false);
        }
        if (swimmingPoolEvent.getType() == SwimmingPoolEventType.ELEMENT_REMOVED) {
            this.trackPool.removeResult(swimmingPoolEvent.getResult());
            if (this.trackingGroupSourceMenu.getItemCount() == 2) {
                this.trackingGroupSourceHelpMenuItem.setVisible(true);
            }
            for (int i = 0; i < this.trackingGroupSourceMenu.getItemCount(); ++i) {
                JMenuItem mi = this.trackingGroupSourceMenu.getItem(i);
                if (!(mi instanceof CheckBoxResultSource)) continue;
                CheckBoxResultSource cbrs = (CheckBoxResultSource)mi;
                if (cbrs.result != swimmingPoolEvent.getResult()) continue;
                cbrs.destroy();
                return;
            }
        }
    }

    private void initTrackPoolInnerPanel() {
        ArrayList swimmingPoolArrayList = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject result : swimmingPoolArrayList) {
            if (!(result.getObject() instanceof TrackGroup)) continue;
            boolean enabled = true;
            CheckBoxResultSource checkBoxResultResource = new CheckBoxResultSource(result, enabled);
            this.trackingGroupSourceMenu.add(checkBoxResultResource);
            this.trackingGroupSourceHelpMenuItem.setVisible(false);
        }
    }

    private ArrayList<SwimmingObject> getResultList() {
        return this.trackPool.resultList;
    }

    public int getCurrentPositionT() {
        return this.currentT;
    }

    public void setCurrentPositionT(int t) {
        this.currentT = t;
        this.reSynchroTSequence();
        this.trackPool.fireTrackEditorProcessorChange();
    }

    void timeCursorChanged(int t) {
        this.setCurrentPositionT(t);
    }

    private void reSynchroTSequence() {
        Sequence sequence = this.sequenceSelector.getSelectedSequence();
        if (sequence != null) {
            for (Viewer viewer : Icy.getMainInterface().getViewers(sequence)) {
                viewer.setPositionT(this.currentT);
            }
        }
    }

    private void loadTracks() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select track.xml file.");
        chooser.setFileFilter(new FileNameExtensionFilter("XML track file", "xml"));
        String node = "plugins/fab/trackmanager/browser";
        Preferences preferences = Preferences.userRoot().node(node);
        String path = preferences.get("path", "");
        chooser.setCurrentDirectory(new File(path));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        preferences.put("path", chooser.getCurrentDirectory().getAbsolutePath());
        try {
            List<TrackGroup> groups = TrackManager.loadTracks(chooser.getSelectedFile().getAbsolutePath());
            for (TrackGroup group : groups) {
                SwimmingObject so = new SwimmingObject((Object)group);
                Icy.getMainInterface().getSwimmingPool().add(so);
            }
            this.trackPool.fireTrackEditorProcessorChange();
        }
        catch (IllegalArgumentException ex) {
            MessageDialog.showDialog((String)ex.getMessage(), (int)0);
            return;
        }
    }

    public static List<TrackGroup> loadTracks(String path) throws IllegalArgumentException {
        Document document = XMLUtil.loadDocument((String)path, (boolean)false);
        return TrackManager.loadTracks(document);
    }

    public static List<TrackGroup> loadTracks(Document document) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException("Invalid track file !");
        }
        Element rootElement = document.getDocumentElement();
        if (XMLUtil.getElement((Node)rootElement, (String)"trackfile") == null) {
            throw new IllegalArgumentException("Invalid track file: the tag trackfile is missing.");
        }
        ArrayList<TrackGroup> result = new ArrayList<TrackGroup>();
        for (Element trackGroupElement : XMLUtil.getElements((Node)rootElement, (String)"trackgroup")) {
            TrackGroup trackGroup = new TrackGroup(null);
            trackGroup.setDescription(XMLUtil.getAttributeValue((Element)trackGroupElement, (String)"description", (String)"no description"));
            for (Element trackSegmentElement : XMLUtil.getElements((Node)trackGroupElement)) {
                TrackSegment trackSegment = new TrackSegment();
                int id = XMLUtil.getAttributeIntValue((Element)trackSegmentElement, (String)"id", (int)-1);
                if (id == -1) {
                    trackSegment.generateId();
                } else {
                    trackSegment.setId(id);
                }
                for (Element detectionElement : XMLUtil.getElements((Node)trackSegmentElement)) {
                    Detection detection = Detection.createDetection((String)XMLUtil.getAttributeValue((Element)detectionElement, (String)"classname", (String)"plugins.nchenouard.spot.Detection"));
                    detection.loadFromXML((Node)detectionElement);
                    trackSegment.addDetection(detection);
                }
                trackGroup.addTrackSegment(trackSegment);
            }
            result.add(trackGroup);
        }
        for (Element linkListElement : XMLUtil.getElements((Node)rootElement, (String)"linklist")) {
            for (Element link : XMLUtil.getElements((Node)linkListElement)) {
                int idFrom = XMLUtil.getAttributeIntValue((Element)link, (String)"from", (int)-1);
                int idTo = XMLUtil.getAttributeIntValue((Element)link, (String)"to", (int)-1);
                TrackSegment from = TrackSegment.getTrackSegmentById(idFrom);
                TrackSegment to = TrackSegment.getTrackSegmentById(idTo);
                if (from == null || to == null) continue;
                TrackPool.createLink(result, from, to);
            }
        }
        return result;
    }

    private void loadTracksFromTrackMate() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Import TrackMate xml track file.");
        chooser.setFileFilter(new FileNameExtensionFilter("TrackMate XML track file", "xml"));
        String node = "plugins/fab/trackmanager/browser";
        Preferences preferences = Preferences.userRoot().node(node);
        String path = preferences.get("path", "");
        chooser.setCurrentDirectory(new File(path));
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        preferences.put("path", chooser.getCurrentDirectory().getAbsolutePath());
        try {
            List<TrackGroup> groups = TrackManager.loadTracksFromTrackMate(chooser.getSelectedFile().getAbsolutePath());
            for (TrackGroup group : groups) {
                SwimmingObject so = new SwimmingObject((Object)group);
                Icy.getMainInterface().getSwimmingPool().add(so);
            }
            this.trackPool.fireTrackEditorProcessorChange();
        }
        catch (IllegalArgumentException ex) {
            MessageDialog.showDialog((String)ex.getMessage(), (int)0);
            return;
        }
    }

    public static List<TrackGroup> loadTracksFromTrackMate(String path) {
        Document document = XMLUtil.loadDocument((String)path, (boolean)false);
        return TrackManager.loadTracksFromTrackMate(document);
    }

    public static List<TrackGroup> loadTracksFromTrackMate(Document document) throws IllegalArgumentException {
        if (document == null) {
            throw new IllegalArgumentException("Invalid track file !");
        }
        Element trackNode = XMLUtil.getElement((Node)document.getDocumentElement().getParentNode(), (String)"Tracks");
        if (trackNode == null) {
            throw new IllegalArgumentException("Unsupported version of TrackMate XML file !\nTry to use the Icy XML export in TrackMate instead and directly load it with 'TrackManager-->File->Load...' command.");
        }
        ArrayList<TrackGroup> result = new ArrayList<TrackGroup>();
        String unit = XMLUtil.getAttributeValue((Element)trackNode, (String)"spaceUnits", (String)"pixel");
        double unitMultiplicator = 1.0;
        if (unit == "micron") {
            unitMultiplicator = 1.0E-6;
        }
        for (Element trackElement : XMLUtil.getElements((Node)document.getDocumentElement().getParentNode(), (String)"Tracks")) {
            TrackGroup trackGroup = new TrackGroup(null);
            trackGroup.setDescription(XMLUtil.getAttributeValue((Element)trackElement, (String)"description", (String)"no description"));
            for (Element trackSegmentElement : XMLUtil.getElements((Node)trackElement)) {
                TrackSegment trackSegment = new TrackSegment();
                int id = XMLUtil.getAttributeIntValue((Element)trackSegmentElement, (String)"id", (int)-1);
                if (id == -1) {
                    trackSegment.generateId();
                } else {
                    trackSegment.setId(id);
                }
                for (Element detectionElement : XMLUtil.getElements((Node)trackSegmentElement)) {
                    Detection detection = Detection.createDetection((String)"plugins.nchenouard.spot.Detection");
                    detection.loadFromXML((Node)detectionElement);
                    trackSegment.addDetection(detection);
                }
                trackGroup.addTrackSegment(trackSegment);
            }
            result.add(trackGroup);
        }
        return result;
    }

    private void debug() {
        System.out.println("--- debug");
    }

    private void saveTracks() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select track.xml file.");
        chooser.setFileFilter(new FileNameExtensionFilter("XML track file", "xml"));
        String node = "plugins/fab/trackmanager/browser";
        Preferences preferences = Preferences.userRoot().node(node);
        String path = preferences.get("path", "");
        chooser.setCurrentDirectory(new File(path));
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        preferences.put("path", chooser.getCurrentDirectory().getAbsolutePath());
        TrackManager.saveTracks(chooser.getSelectedFile().getAbsolutePath(), this.trackPool.getTrackGroupList());
    }

    public static void saveTracks(String path, List<TrackGroup> groups) {
        File file = new File(FileUtil.setExtension((String)path, (String)".xml"));
        Document document = TrackManager.saveTracks(groups);
        XMLUtil.saveDocument((Document)document, (File)file);
    }

    public static Document saveTracks(List<TrackGroup> groups) {
        Document result = XMLUtil.createDocument((boolean)true);
        Element rootElement = result.getDocumentElement();
        Element versionElement = XMLUtil.addElement((Node)rootElement, (String)"trackfile");
        versionElement.setAttribute("version", "1");
        for (TrackGroup trackGroup : groups) {
            Element trackGroupElement = XMLUtil.addElement((Node)rootElement, (String)"trackgroup");
            trackGroupElement.setAttribute("description", trackGroup.getDescription());
            for (TrackSegment trackSegment : trackGroup.getTrackSegmentList()) {
                Element trackElement = XMLUtil.addElement((Node)trackGroupElement, (String)"track");
                trackElement.setAttribute("id", "" + trackSegment.getId());
                for (Detection detection : trackSegment.getDetectionList()) {
                    Element detectionElement = XMLUtil.addElement((Node)trackElement, (String)"detection");
                    detectionElement.setAttribute("classname", detection.getClass().getName());
                    detection.saveToXML((Node)detectionElement);
                }
            }
        }
        Element linklistElement = XMLUtil.addElement((Node)rootElement, (String)"linklist");
        for (Link link : TrackPool.getLinks(groups)) {
            Element trackElement = XMLUtil.addElement((Node)linklistElement, (String)"link");
            trackElement.setAttribute("from", "" + link.getStartSegment().getId());
            trackElement.setAttribute("to", "" + link.getEndSegment().getId());
        }
        return result;
    }

    public void reOrganize() {
        for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            ArrayList trackSegmentList = (ArrayList)trackGroup.getTrackSegmentList().clone();
            ArrayList trackSegmentListOrganized = (ArrayList)trackGroup.getTrackSegmentList().clone();
            int tMax = this.trackPool.getLastDetectionTimePoint();
            for (int t = 0; t < tMax; ++t) {
                for (TrackSegment ts : trackSegmentList) {
                    if (ts.getFirstDetection().getT() != t) continue;
                    for (int index = 0; index < ts.nextList.size(); ++index) {
                        TrackSegment ts2 = ts.nextList.get(index);
                        trackSegmentListOrganized.remove(ts2);
                        int targetIndex = trackSegmentListOrganized.indexOf(ts) - ts.nextList.size() / 2 + index + 1;
                        if (targetIndex < 0) {
                            targetIndex = 0;
                        }
                        trackSegmentListOrganized.add(targetIndex, ts2);
                    }
                }
            }
            trackGroup.getTrackSegmentList().clear();
            trackGroup.getTrackSegmentList().addAll(trackSegmentListOrganized);
        }
        this.trackPool.fireTrackEditorProcessorChange();
        new AnnounceFrame("Track reorganized by parents / childs", 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object node;
        if (e.getSource() == this.onlineHelpMenuItem) {
            NetworkUtil.openBrowser((String)"http://icy.bioimageanalysis.org/index.php?display=detailPlugin&pluginId=88");
        }
        if (e.getSource() == this.loadMenuItem) {
            this.loadTracks();
        }
        if (e.getSource() == this.loadFromTrackMateMenuItem) {
            this.loadTracksFromTrackMate();
        }
        if (e.getSource() == this.saveMenuItem) {
            this.saveTracks();
        }
        if (e.getSource() == this.sequenceSelector) {
            this.trackPool.setDisplaySequence(this.sequenceSelector.getSelectedSequence());
        }
        if (e.getSource() == this.reOrganizeMenuItem) {
            this.reOrganize();
        }
        if (e.getSource() == this.displayTrackPanelCheckBoxMenuItem) {
            this.trackPanel.setEnableLeftPanelTrackDisplay(this.displayTrackPanelCheckBoxMenuItem.isSelected());
            node = "plugins/fab/trackmanager/displaytrackpanel";
            Preferences preferences = Preferences.userRoot().node((String)node);
            preferences.putBoolean("displaytrackpanel", this.displayTrackPanelCheckBoxMenuItem.isSelected());
        }
        if (e.getSource() == this.externaliseCheckBoxMenuItem) {
            if (this.externaliseCheckBoxMenuItem.isSelected()) {
                this.mainFrame.externalize();
            } else {
                this.mainFrame.internalize();
            }
        }
        if (e.getSource() == this.addTrackProcessorButton) {
            this.pluginPopupMenu.show(this.addTrackProcessorButton, 0, 0);
        }
        if (e.getSource() == this.showHideTrackPoolSourcesPanel) {
            this.trackGroupSourceInnerPanel.setVisible(this.showHideTrackPoolSourcesPanel.isSelected());
        }
        if (e.getSource() == this.selectAllMenuItem) {
            this.trackPool.selectAllTracks();
        }
        if (e.getSource() == this.unselectAllMenuItem) {
            this.trackPool.unselectAllTracks();
        }
        if (e.getSource() == this.selectTrackByLengthMenuItem) {
            node = new TrackLengthDialog(this.trackPool);
        }
        if (e.getSource() == this.invertSelectionMenuItem) {
            this.trackPool.invertSelection();
        }
        if (e.getSource() == this.deleteLinkMenuItem) {
            this.trackPool.deleteSelectedLink();
        }
        if (e.getSource() == this.deleteSelectionMenuItem) {
            this.trackPool.deleteSelectedTracks();
        }
        if (e.getSource() == this.debugMenuItem) {
            this.debug();
        }
        if (e.getSource() == this.fuseTracksMenuItem) {
            this.trackPool.fuseAllTracks();
        }
        if (e.getSource() == this.zoomLessButton) {
            int newX = (int)this.trackPanel.getDetectDim().getWidth() - 5;
            if (newX <= 0) {
                newX = 5;
            }
            this.trackPanel.setDetectDim(new Dimension(newX, newX));
            this.trackPool.fireTrackEditorProcessorChange();
        }
        if (e.getSource() == this.zoomMoreButton) {
            this.trackPanel.setDetectDim(new Dimension((int)this.trackPanel.getDetectDim().getWidth() + 5, (int)this.trackPanel.getDetectDim().getHeight() + 5));
            this.trackPool.fireTrackEditorProcessorChange();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent arg0) {
    }

    private void buildPluginMenu() {
        this.pluginPopupMenu.removeAll();
        JMenuItem menuItem = new JMenuItem("Add Track Processor Plugin...");
        menuItem.setEnabled(false);
        this.pluginPopupMenu.add(menuItem);
        this.pluginPopupMenu.addSeparator();
        for (PluginDescriptor plugin : PluginLoader.getPlugins()) {
            if (!plugin.isInstanceOf(PluginTrackManagerProcessor.class) || plugin.isAbstract()) continue;
            JMenuItem menuItem2 = new JMenuItem(plugin.getName(), ResourceUtil.scaleIcon((ImageIcon)plugin.getIcon(), (int)24));
            this.pluginPopupMenu.add(menuItem2);
            menuItem2.addActionListener(new MenuItemActionListener(plugin, PluginTrackManagerProcessor.class));
        }
    }

    public void moveTrackProcessor(PluginTrackManagerProcessor trackEditorProcessor, int i) {
        int newIndex = this.trackPool.getTrackManagerProcessorList().indexOf((Object)trackEditorProcessor);
        if ((newIndex += i) < 0) {
            newIndex = 0;
        }
        if (newIndex > this.trackPool.getTrackManagerProcessorList().size() - 1) {
            newIndex = this.trackPool.getTrackManagerProcessorList().size() - 1;
        }
        this.trackPool.getTrackManagerProcessorList().remove((Object)trackEditorProcessor);
        this.trackPool.getTrackManagerProcessorList().add(newIndex, trackEditorProcessor);
        this.rebuildTrackProcessorDisplay();
        this.trackPool.fireTrackEditorProcessorChange();
    }

    public void icyFrameActivated(IcyFrameEvent e) {
    }

    public void icyFrameClosed(IcyFrameEvent e) {
        ArrayList processorList = (ArrayList)this.trackPool.getTrackManagerProcessorList().clone();
        for (PluginTrackManagerProcessor tep : processorList) {
            tep.Close();
        }
        this.trackPool.removePainter();
        this.trackPool.trackManager = null;
        this.trackPool.resultList.clear();
        this.trackManagerDestroyed = true;
    }

    public void icyFrameClosing(IcyFrameEvent e) {
    }

    public void icyFrameDeactivated(IcyFrameEvent e) {
    }

    public void icyFrameDeiconified(IcyFrameEvent e) {
    }

    public void icyFrameIconified(IcyFrameEvent e) {
    }

    public void icyFrameOpened(IcyFrameEvent e) {
    }

    public void icyFrameExternalized(IcyFrameEvent e) {
    }

    public void icyFrameInternalized(IcyFrameEvent e) {
    }

    public void compute() {
    }

    public Sequence getDisplaySequence() {
        return this.sequenceSelector.getSelectedSequence();
    }

    public void setDisplaySequence(Sequence sequence) {
        this.sequenceSelector.setSelectedSequence(sequence);
    }

    public void run() {
    }

    class CheckBoxResultSource
    extends JCheckBoxMenuItem
    implements ActionListener {
        private static final long serialVersionUID = -2021713434786505514L;
        SwimmingObject result;

        public CheckBoxResultSource(SwimmingObject result, boolean enabled) {
            if (!(result.getObject() instanceof TrackGroup)) {
                System.out.println("Result object type not supported.");
                return;
            }
            TrackGroup trackGroup = (TrackGroup)result.getObject();
            int nbTracks = trackGroup.getTrackSegmentList().size();
            String label = "" + result.getObject().toString() + " (" + nbTracks + " Tracks)";
            this.setText(label);
            this.result = result;
            this.setEnabled(enabled);
            this.addActionListener(this);
            this.setSelected(true);
            TrackManager.this.trackPool.addResult(result);
            TrackManager.this.trackPool.fireTrackEditorProcessorChange();
        }

        public void destroy() {
            TrackManager.this.trackingGroupSourceMenu.remove(this);
            TrackManager.this.trackPool.removeResult(this.result);
            TrackManager.this.trackPool.fireTrackEditorProcessorChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this) {
                if (this.isSelected()) {
                    TrackManager.this.trackPool.addResult(this.result);
                } else {
                    TrackManager.this.trackPool.removeResult(this.result);
                }
                TrackManager.this.trackPool.fireTrackEditorProcessorChange();
            }
        }
    }

    private class MenuItemActionListener
    implements ActionListener {
        Class<? extends PluginTrackManagerProcessor> pluginTrackManagerProcessor;
        PluginDescriptor pluginDescriptor;

        public MenuItemActionListener(PluginDescriptor pluginDescriptor, Class<? extends PluginTrackManagerProcessor> pluginTrackEditorProcessor) {
            this.pluginTrackManagerProcessor = pluginTrackEditorProcessor;
            this.pluginDescriptor = pluginDescriptor;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TrackManager.this.loadTrackProcessor(this.pluginDescriptor);
        }
    }
}

