/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.KeyTipManager;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

public class BasicRibbonUI
extends RibbonUI {
    public static final String IS_USING_TITLE_PANE = "ribbon.internal.isUsingTitlePane";
    public static final String HELP_PANEL_COMPONENTS = "HelpPanelComponents";
    private static final String JUST_MINIMIZED = "ribbon.internal.justMinimized";
    protected JRibbon ribbon;
    protected JPanel taskBarPanel;
    protected JScrollablePanel<BandHostPanel> bandScrollablePanel;
    protected JScrollablePanel<TaskToggleButtonsHostPanel> taskToggleButtonsScrollablePanel;
    protected JRibbonApplicationMenuButton applicationMenuButton;
    protected JComponent helpPanel;
    protected JCommandButton helpButton;
    protected Map<RibbonTask, JRibbonTaskToggleButton> taskToggleButtons = new HashMap<RibbonTask, JRibbonTaskToggleButton>();
    protected CommandToggleButtonGroup taskToggleButtonGroup = new CommandToggleButtonGroup();
    protected ChangeListener ribbonChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ContainerListener ribbonContainerListener;
    protected ComponentListener ribbonComponentListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonUI();
    }

    public BasicRibbonUI() {
        this.taskToggleButtonGroup.setAllowsClearingSelection(false);
    }

    @Override
    public void installUI(JComponent c) {
        this.ribbon = (JRibbon)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.ribbon = null;
    }

    protected void installListeners() {
        this.ribbonChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BasicRibbonUI.this.syncRibbonState();
            }
        };
        this.ribbon.addChangeListener(this.ribbonChangeListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedTask".equals(evt.getPropertyName())) {
                    JRibbonTaskToggleButton toggleButton;
                    RibbonTask old = (RibbonTask)evt.getOldValue();
                    final RibbonTask curr = (RibbonTask)evt.getNewValue();
                    if (old != null && BasicRibbonUI.this.taskToggleButtons.get(old) != null) {
                        BasicRibbonUI.this.taskToggleButtons.get(old).getActionModel().setSelected(false);
                    }
                    if (curr != null && BasicRibbonUI.this.taskToggleButtons.get(curr) != null) {
                        BasicRibbonUI.this.taskToggleButtons.get(curr).getActionModel().setSelected(true);
                    }
                    if (BasicRibbonUI.this.isShowingScrollsForTaskToggleButtons() && curr != null && (toggleButton = BasicRibbonUI.this.taskToggleButtons.get(curr)) != null) {
                        BasicRibbonUI.this.scrollAndRevealTaskToggleButton(toggleButton);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyTipManager ktm = KeyTipManager.defaultManager();
                            if (ktm.isShowingKeyTips()) {
                                KeyTipManager.KeyTipChain chain = ktm.getCurrentlyShownKeyTipChain();
                                if (chain.chainParentComponent == (this).BasicRibbonUI.this.taskToggleButtons.get(curr)) {
                                    ktm.refreshCurrentChain();
                                }
                            }
                        }
                    });
                }
                if ("applicationMenuRichTooltip".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenuKeyTip".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.syncApplicationMenuTips();
                }
                if ("applicationMenu".equals(evt.getPropertyName())) {
                    BasicRibbonUI.this.ribbon.revalidate();
                    BasicRibbonUI.this.ribbon.doLayout();
                    BasicRibbonUI.this.ribbon.repaint();
                    Window windowAncestor = SwingUtilities.getWindowAncestor(BasicRibbonUI.this.ribbon);
                    if (windowAncestor instanceof JRibbonFrame) {
                        FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)windowAncestor);
                    }
                }
                if ("minimized".equals(evt.getPropertyName())) {
                    PopupPanelManager.defaultManager().hidePopups(null);
                    BasicRibbonUI.this.ribbon.revalidate();
                    BasicRibbonUI.this.ribbon.doLayout();
                    BasicRibbonUI.this.ribbon.repaint();
                }
            }
        };
        this.ribbon.addPropertyChangeListener(this.propertyChangeListener);
        this.ribbonContainerListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (BasicRibbonUI.this.isUsingTitlePane()) {
                    return;
                }
                Component added = e.getComponent();
                if (added != BasicRibbonUI.this.applicationMenuButton) {
                    BasicRibbonUI.this.ribbon.setComponentZOrder(BasicRibbonUI.this.applicationMenuButton, BasicRibbonUI.this.ribbon.getComponentCount() - 1);
                }
            }
        };
        this.ribbon.addContainerListener(this.ribbonContainerListener);
        this.ribbonComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                KeyTipManager.defaultManager().hideAllKeyTips();
            }
        };
        this.ribbon.addComponentListener(this.ribbonComponentListener);
    }

    protected void uninstallListeners() {
        this.ribbon.removeChangeListener(this.ribbonChangeListener);
        this.ribbonChangeListener = null;
        this.ribbon.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbon.removeContainerListener(this.ribbonContainerListener);
        this.ribbonContainerListener = null;
        this.ribbon.removeComponentListener(this.ribbonComponentListener);
        this.ribbonComponentListener = null;
    }

    protected void installDefaults() {
        Border b = this.ribbon.getBorder();
        if (b == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("Ribbon.border");
            if (toSet == null) {
                toSet = new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2);
            }
            this.ribbon.setBorder(toSet);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.taskBarPanel = new TaskbarPanel();
        this.taskBarPanel.setName("JRibbon Task Bar");
        this.taskBarPanel.setLayout(this.createTaskbarLayoutManager());
        this.ribbon.add(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.createBandHostPanel();
        bandHostPanel.setLayout(this.createBandHostPanelLayoutManager());
        this.bandScrollablePanel = new JScrollablePanel<BandHostPanel>(bandHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.bandScrollablePanel.setScrollOnRollover(false);
        this.ribbon.add(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.createTaskToggleButtonsHostPanel();
        taskToggleButtonsHostPanel.setLayout(this.createTaskToggleButtonsHostPanelLayoutManager());
        this.taskToggleButtonsScrollablePanel = new JScrollablePanel<TaskToggleButtonsHostPanel>(taskToggleButtonsHostPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.taskToggleButtonsScrollablePanel.setScrollOnRollover(false);
        this.taskToggleButtonsScrollablePanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BasicRibbonUI.this.ribbon.repaint();
            }
        });
        this.ribbon.add(this.taskToggleButtonsScrollablePanel);
        this.ribbon.setLayout(this.createLayoutManager());
        this.syncRibbonState();
        this.applicationMenuButton = new JRibbonApplicationMenuButton(this.ribbon);
        this.syncApplicationMenuTips();
        this.ribbon.add(this.applicationMenuButton);
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.ribbon);
        if (windowAncestor instanceof JRibbonFrame) {
            FlamingoUtilities.updateRibbonFrameIconImages((JRibbonFrame)windowAncestor);
        }
    }

    protected LayoutManager createTaskToggleButtonsHostPanelLayoutManager() {
        return new TaskToggleButtonsHostPanelLayout();
    }

    protected TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new TaskToggleButtonsHostPanel();
    }

    protected BandHostPanel createBandHostPanel() {
        return new BandHostPanel();
    }

    protected LayoutManager createBandHostPanelLayoutManager() {
        return new BandHostPanelLayout();
    }

    protected void uninstallComponents() {
        this.taskBarPanel.removeAll();
        this.taskBarPanel.setLayout(null);
        this.ribbon.remove(this.taskBarPanel);
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        bandHostPanel.setLayout(null);
        this.ribbon.remove(this.bandScrollablePanel);
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        taskToggleButtonsHostPanel.setLayout(null);
        this.ribbon.remove(this.taskToggleButtonsScrollablePanel);
        this.ribbon.remove(this.applicationMenuButton);
        if (this.helpPanel != null) {
            this.ribbon.remove(this.helpPanel);
        }
        this.ribbon.setLayout(null);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        super.update(g2d, c);
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g);
        if (!this.ribbon.isMinimized()) {
            Insets ins = c.getInsets();
            int extraHeight = this.getTaskToggleButtonHeight();
            if (!this.isUsingTitlePane()) {
                extraHeight += this.getTaskbarHeight();
            }
            this.paintTaskArea(g, 0, ins.top + extraHeight, c.getWidth(), c.getHeight() - extraHeight - ins.top - ins.bottom);
        } else {
            this.paintMinimizedRibbonSeparator(g);
        }
    }

    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Color borderColor = FlamingoUtilities.getBorderColor();
        g.setColor(borderColor);
        Insets ins = this.ribbon.getInsets();
        g.drawLine(0, this.ribbon.getHeight() - ins.bottom, this.ribbon.getWidth(), this.ribbon.getHeight() - ins.bottom);
    }

    protected void paintBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(FlamingoUtilities.getColor(Color.lightGray, "Panel.background"));
        g2d.fillRect(0, 0, this.ribbon.getWidth(), this.ribbon.getHeight());
        g2d.dispose();
    }

    protected void paintTaskArea(Graphics g, int x, int y, int width, int height) {
        if (this.ribbon.getTaskCount() == 0) {
            return;
        }
        JRibbonTaskToggleButton selectedTaskButton = this.taskToggleButtons.get(this.ribbon.getSelectedTask());
        Rectangle selectedTaskButtonBounds = selectedTaskButton.getBounds();
        Point converted = SwingUtilities.convertPoint(selectedTaskButton.getParent(), selectedTaskButtonBounds.getLocation(), this.ribbon);
        Rectangle taskToggleButtonsViewportBounds = this.taskToggleButtonsScrollablePanel.getView().getParent().getBounds();
        taskToggleButtonsViewportBounds.setLocation(SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel, taskToggleButtonsViewportBounds.getLocation(), this.ribbon));
        int startSelectedX = Math.max(converted.x + 1, (int)taskToggleButtonsViewportBounds.getMinX());
        startSelectedX = Math.min(startSelectedX, (int)taskToggleButtonsViewportBounds.getMaxX());
        int endSelectedX = Math.min(converted.x + selectedTaskButtonBounds.width - 1, (int)taskToggleButtonsViewportBounds.getMaxX());
        endSelectedX = Math.max(endSelectedX, (int)taskToggleButtonsViewportBounds.getMinX());
        GeneralPath outerContour = FlamingoUtilities.getRibbonBorderOutline(x + 1, x + width - 3, startSelectedX, endSelectedX, converted.y, y, y + height, 2.0f);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(FlamingoUtilities.getBorderColor());
        g2d.draw(outerContour);
        RibbonTask selected = this.ribbon.getSelectedTask();
        RibbonContextualTaskGroup contextualGroup = selected.getContextualGroup();
        if (contextualGroup != null) {
            Insets ins = this.ribbon.getInsets();
            int topY = ins.top + this.getTaskbarHeight();
            int bottomY = topY + 5;
            Color hueColor = contextualGroup.getHueColor();
            GradientPaint paint = new GradientPaint(0.0f, topY, FlamingoUtilities.getAlphaColor(hueColor, 63), 0.0f, bottomY, FlamingoUtilities.getAlphaColor(hueColor, 0));
            g2d.setPaint(paint);
            g2d.clip(outerContour);
            g2d.fillRect(0, topY, width, bottomY - topY + 1);
        }
        g2d.dispose();
    }

    @Override
    public Rectangle getContextualTaskGroupBounds(RibbonContextualTaskGroup group) {
        Rectangle rect = null;
        int j = 0;
        while (j < group.getTaskCount()) {
            JRibbonTaskToggleButton button = this.taskToggleButtons.get(group.getTask(j));
            rect = rect == null ? button.getBounds() : rect.union(button.getBounds());
            ++j;
        }
        int buttonGap = this.getTabButtonGap();
        Point location = SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel.getView(), rect.getLocation(), this.ribbon);
        return new Rectangle(location.x - buttonGap / 3, location.y - 1, rect.width + buttonGap * 2 / 3 - 1, rect.height + 1);
    }

    protected int getBandGap() {
        return 2;
    }

    protected int getTabButtonGap() {
        return 6;
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    protected LayoutManager createTaskbarLayoutManager() {
        return new TaskbarLayout();
    }

    public int getTaskbarHeight() {
        return 24;
    }

    public int getTaskToggleButtonHeight() {
        return 22;
    }

    protected void syncRibbonState() {
        BandHostPanel bandHostPanel = this.bandScrollablePanel.getView();
        bandHostPanel.removeAll();
        TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = this.taskToggleButtonsScrollablePanel.getView();
        taskToggleButtonsHostPanel.removeAll();
        if (this.helpPanel != null) {
            this.ribbon.remove(this.helpPanel);
            this.helpPanel = null;
            this.helpButton = null;
        }
        List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        RibbonTask selectedTask = this.ribbon.getSelectedTask();
        for (final RibbonTask task : visibleTasks) {
            final JRibbonTaskToggleButton taskToggleButton = new JRibbonTaskToggleButton(task);
            taskToggleButton.setKeyTip(task.getKeyTip());
            taskToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BasicRibbonUI.this.scrollAndRevealTaskToggleButton(taskToggleButton);
                            (this).BasicRibbonUI.this.ribbon.setSelectedTask(task);
                            if ((this).BasicRibbonUI.this.ribbon.isMinimized()) {
                                int ph;
                                AbstractRibbonBand<?> band;
                                if (Boolean.TRUE.equals((this).BasicRibbonUI.this.ribbon.getClientProperty(BasicRibbonUI.JUST_MINIMIZED))) {
                                    (this).BasicRibbonUI.this.ribbon.putClientProperty(BasicRibbonUI.JUST_MINIMIZED, null);
                                    return;
                                }
                                List<PopupPanelManager.PopupInfo> popups = PopupPanelManager.defaultManager().getShownPath();
                                if (popups.size() > 0) {
                                    for (PopupPanelManager.PopupInfo popup : popups) {
                                        if (popup.getPopupOriginator() != taskToggleButton) continue;
                                        PopupPanelManager.defaultManager().hidePopups(null);
                                        return;
                                    }
                                }
                                PopupPanelManager.defaultManager().hidePopups(null);
                                (this).BasicRibbonUI.this.ribbon.remove((this).BasicRibbonUI.this.bandScrollablePanel);
                                int prefHeight = (this).BasicRibbonUI.this.bandScrollablePanel.getView().getPreferredSize().height;
                                Insets ins = (this).BasicRibbonUI.this.ribbon.getInsets();
                                prefHeight += ins.top + ins.bottom;
                                AbstractRibbonBand<?> abstractRibbonBand = band = (this).BasicRibbonUI.this.ribbon.getSelectedTask().getBandCount() > 0 ? (this).BasicRibbonUI.this.ribbon.getSelectedTask().getBand(0) : null;
                                if (band != null) {
                                    Insets bandIns = band.getInsets();
                                    prefHeight += bandIns.top + bandIns.bottom;
                                }
                                BandHostPopupPanel popupPanel = new BandHostPopupPanel((this).BasicRibbonUI.this.bandScrollablePanel, new Dimension((this).BasicRibbonUI.this.ribbon.getWidth(), prefHeight));
                                int x = (this).BasicRibbonUI.this.ribbon.getLocationOnScreen().x;
                                int y = (this).BasicRibbonUI.this.ribbon.getLocationOnScreen().y + (this).BasicRibbonUI.this.ribbon.getHeight();
                                PointerInfo pi = MouseInfo.getPointerInfo();
                                GraphicsConfiguration mgc = null;
                                if (pi != null) {
                                    GraphicsDevice gd = pi.getDevice();
                                    GraphicsConfiguration[] graphicsConfigurationArray = gd.getConfigurations();
                                    int n = graphicsConfigurationArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        GraphicsConfiguration gc = graphicsConfigurationArray[n2];
                                        if (gc.getBounds().contains(pi.getLocation())) {
                                            mgc = gc;
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                if (mgc == null) {
                                    mgc = (this).BasicRibbonUI.this.ribbon.getGraphicsConfiguration();
                                }
                                Rectangle scrBounds = mgc.getBounds();
                                int pw = popupPanel.getPreferredSize().width;
                                if (x < scrBounds.x) {
                                    pw = pw - scrBounds.x + x;
                                    x = scrBounds.x;
                                }
                                if (x + pw > scrBounds.x + scrBounds.width) {
                                    pw = scrBounds.width + scrBounds.x - x;
                                }
                                if (y + (ph = popupPanel.getPreferredSize().height) > scrBounds.y + scrBounds.height) {
                                    y = (this).BasicRibbonUI.this.ribbon.getLocationOnScreen().y - prefHeight;
                                }
                                popupPanel.setPreferredSize(new Dimension(pw, prefHeight));
                                Popup popup = PopupFactory.getSharedInstance().getPopup(taskToggleButton, popupPanel, x, y);
                                PopupPanelManager.PopupListener tracker = new PopupPanelManager.PopupListener(){

                                    @Override
                                    public void popupShown(PopupPanelManager.PopupEvent event) {
                                        JComponent originator = event.getPopupOriginator();
                                        if (originator instanceof JRibbonTaskToggleButton) {
                                            ((this).this).BasicRibbonUI.this.bandScrollablePanel.doLayout();
                                            ((this).this).BasicRibbonUI.this.bandScrollablePanel.repaint();
                                        }
                                    }

                                    @Override
                                    public void popupHidden(PopupPanelManager.PopupEvent event) {
                                        JComponent originator = event.getPopupOriginator();
                                        if (originator instanceof JRibbonTaskToggleButton) {
                                            ((this).this).BasicRibbonUI.this.ribbon.add(((this).this).BasicRibbonUI.this.bandScrollablePanel);
                                            PopupPanelManager.defaultManager().removePopupListener(this);
                                            ((this).this).BasicRibbonUI.this.ribbon.revalidate();
                                            ((this).this).BasicRibbonUI.this.ribbon.doLayout();
                                            ((this).this).BasicRibbonUI.this.ribbon.repaint();
                                        }
                                    }
                                };
                                PopupPanelManager.defaultManager().addPopupListener(tracker);
                                PopupPanelManager.defaultManager().addPopup(taskToggleButton, popup, popupPanel);
                            }
                        }
                    });
                }
            });
            taskToggleButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (BasicRibbonUI.this.ribbon.getSelectedTask() == task && e.getClickCount() == 2) {
                        boolean wasMinimized = BasicRibbonUI.this.ribbon.isMinimized();
                        BasicRibbonUI.this.ribbon.setMinimized(!wasMinimized);
                        if (!wasMinimized) {
                            BasicRibbonUI.this.ribbon.putClientProperty(BasicRibbonUI.JUST_MINIMIZED, Boolean.TRUE);
                        }
                    }
                }
            });
            if (task.getContextualGroup() != null) {
                taskToggleButton.setContextualGroupHueColor(task.getContextualGroup().getHueColor());
            }
            taskToggleButton.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
            this.taskToggleButtonGroup.add(taskToggleButton);
            taskToggleButtonsHostPanel.add(taskToggleButton);
            this.taskToggleButtons.put(task, taskToggleButton);
        }
        JRibbonTaskToggleButton toSelect = this.taskToggleButtons.get(selectedTask);
        if (toSelect != null) {
            toSelect.getActionModel().setSelected(true);
        }
        int i = 0;
        while (i < this.ribbon.getTaskCount()) {
            RibbonTask task = this.ribbon.getTask(i);
            for (AbstractRibbonBand<?> band : task.getBands()) {
                bandHostPanel.add(band);
                band.setVisible(selectedTask == task);
            }
            ++i;
        }
        i = 0;
        while (i < this.ribbon.getContextualTaskGroupCount()) {
            RibbonContextualTaskGroup taskGroup = this.ribbon.getContextualTaskGroup(i);
            int j = 0;
            while (j < taskGroup.getTaskCount()) {
                RibbonTask task = taskGroup.getTask(j);
                for (AbstractRibbonBand<?> band : task.getBands()) {
                    bandHostPanel.add(band);
                    band.setVisible(selectedTask == task);
                }
                ++j;
            }
            ++i;
        }
        ActionListener helpListener = this.ribbon.getHelpActionListener();
        List helpComponents = (List)this.ribbon.getClientProperty(HELP_PANEL_COMPONENTS);
        if (helpListener != null || helpComponents != null) {
            this.helpPanel = Box.createHorizontalBox();
            if (helpComponents != null) {
                for (Component comp : helpComponents) {
                    this.helpPanel.add(comp);
                    this.helpPanel.add(Box.createHorizontalStrut(3));
                }
            }
            if (helpListener != null) {
                this.helpButton = new JCommandButton("", this.ribbon.getHelpIcon());
                this.helpButton.setActionRichTooltip(this.ribbon.getHelpRichTooltip());
                this.helpButton.setDisplayState(CommandButtonDisplayState.SMALL);
                this.helpButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
                this.helpButton.getActionModel().addActionListener(helpListener);
                this.helpPanel.add(this.helpButton);
            }
            this.ribbon.add(this.helpPanel);
        }
        this.ribbon.revalidate();
        this.ribbon.repaint();
    }

    protected List<RibbonTask> getCurrentlyShownRibbonTasks() {
        ArrayList<RibbonTask> result = new ArrayList<RibbonTask>();
        int i = 0;
        while (i < this.ribbon.getTaskCount()) {
            RibbonTask task = this.ribbon.getTask(i);
            result.add(task);
            ++i;
        }
        i = 0;
        while (i < this.ribbon.getContextualTaskGroupCount()) {
            RibbonContextualTaskGroup group = this.ribbon.getContextualTaskGroup(i);
            if (this.ribbon.isVisible(group)) {
                int j = 0;
                while (j < group.getTaskCount()) {
                    RibbonTask task = group.getTask(j);
                    result.add(task);
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    protected boolean isUsingTitlePane() {
        return Boolean.TRUE.equals(this.ribbon.getClientProperty(IS_USING_TITLE_PANE));
    }

    protected void syncApplicationMenuTips() {
        this.applicationMenuButton.setPopupRichTooltip(this.ribbon.getApplicationMenuRichTooltip());
        this.applicationMenuButton.setPopupKeyTip(this.ribbon.getApplicationMenuKeyTip());
    }

    @Override
    public boolean isShowingScrollsForTaskToggleButtons() {
        return this.taskToggleButtonsScrollablePanel.isShowingScrollButtons();
    }

    @Override
    public boolean isShowingScrollsForBands() {
        return this.bandScrollablePanel.isShowingScrollButtons();
    }

    public Map<RibbonTask, JRibbonTaskToggleButton> getTaskToggleButtons() {
        return Collections.unmodifiableMap(this.taskToggleButtons);
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent e) {
        int newSelectedTaskIndex;
        if (this.ribbon.isMinimized()) {
            return;
        }
        final List<RibbonTask> visibleTasks = this.getCurrentlyShownRibbonTasks();
        if (visibleTasks.size() == 0) {
            return;
        }
        int delta = e.getWheelRotation();
        if (delta == 0) {
            return;
        }
        int currSelectedTaskIndex = visibleTasks.indexOf(this.ribbon.getSelectedTask());
        if (!this.ribbon.getComponentOrientation().isLeftToRight()) {
            delta = -delta;
        }
        if ((newSelectedTaskIndex = currSelectedTaskIndex + (delta > 0 ? 1 : -1)) < 0) {
            return;
        }
        if (newSelectedTaskIndex >= visibleTasks.size()) {
            return;
        }
        final int indexToSet = newSelectedTaskIndex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(3));
                BasicRibbonUI.this.ribbon.setSelectedTask((RibbonTask)visibleTasks.get(indexToSet));
                BasicRibbonUI.this.ribbon.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    protected void scrollAndRevealTaskToggleButton(JRibbonTaskToggleButton taskToggleButton) {
        Point loc = SwingUtilities.convertPoint(taskToggleButton.getParent(), taskToggleButton.getLocation(), this.taskToggleButtonsScrollablePanel.getView());
        this.taskToggleButtonsScrollablePanel.scrollToIfNecessary(loc.x, taskToggleButton.getWidth());
    }

    @Override
    public synchronized void setApplicationIcon(ResizableIcon applicationIcon) {
        super.setApplicationIcon(applicationIcon);
        this.applicationMenuButton.setIcon(applicationIcon);
    }

    protected static class BandHostPanel
    extends JPanel {
        protected BandHostPanel() {
        }
    }

    private class BandHostPanelLayout
    implements LayoutManager {
        private BandHostPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int maxPrefBandHeight = 0;
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    if (ribbonBand.isHidden()) continue;
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            return new Dimension(c.getWidth(), maxPrefBandHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            width += gap;
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                if (ribbonBand.isHidden()) continue;
                int bandPrefHeight = ribbonBand.getMinimumSize().height;
                Insets bandInsets = ribbonBand.getInsets();
                RibbonBandUI bandUI = ribbonBand.getUI();
                int preferredCollapsedWidth = bandUI.getPreferredCollapsedWidth() + bandInsets.left + bandInsets.right;
                width += preferredCollapsedWidth;
                maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight);
                width += gap;
            }
            return new Dimension(width, maxMinBandHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            boolean ltr;
            int bandGap = BasicRibbonUI.this.getBandGap();
            int y = 0;
            RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
            if (selectedTask == null) {
                return;
            }
            for (AbstractRibbonBand<?> band : selectedTask.getBands()) {
                try {
                    FlamingoUtilities.checkResizePoliciesConsistency(band);
                }
                catch (IllegalStateException e) {
                    System.err.println(e);
                }
            }
            for (AbstractRibbonBand<?> band : selectedTask.getBands()) {
                List<RibbonBandResizePolicy> policies = band.getResizePolicies();
                RibbonBandResizePolicy last = policies.get(0);
                band.setCurrentResizePolicy(last);
            }
            int availableBandHeight = c.getHeight();
            int availableWidth = c.getWidth();
            if (selectedTask.getBandCount() > 0) {
                RibbonBandResizeSequencingPolicy resizeSequencingPolicy = selectedTask.getResizeSequencingPolicy();
                resizeSequencingPolicy.reset();
                AbstractRibbonBand currToTakeFrom = resizeSequencingPolicy.next();
                while (true) {
                    boolean noMore = true;
                    for (AbstractRibbonBand<?> band : selectedTask.getBands()) {
                        List<RibbonBandResizePolicy> resizePolicies;
                        RibbonBandResizePolicy currentResizePolicy = band.getCurrentResizePolicy();
                        if (currentResizePolicy == (resizePolicies = band.getResizePolicies()).get(resizePolicies.size() - 1)) continue;
                        noMore = false;
                        break;
                    }
                    if (noMore) break;
                    int totalWidth = 0;
                    for (AbstractRibbonBand abstractRibbonBand : selectedTask.getBands()) {
                        if (abstractRibbonBand.isHidden()) continue;
                        RibbonBandResizePolicy currentResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
                        Insets ribbonBandInsets = abstractRibbonBand.getInsets();
                        Object controlPanel = abstractRibbonBand.getControlPanel();
                        Insets controlPanelInsets = ((JComponent)controlPanel).getInsets();
                        int controlPanelGap = ((AbstractBandControlPanel)controlPanel).getUI().getLayoutGap();
                        int ribbonBandHeight = availableBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom;
                        int availableHeight = ribbonBandHeight - abstractRibbonBand.getUI().getBandTitleHeight();
                        if (controlPanel != null) {
                            availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                        }
                        int preferredWidth = currentResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                        totalWidth += preferredWidth + bandGap;
                    }
                    if (totalWidth < availableWidth) break;
                    List<RibbonBandResizePolicy> list = currToTakeFrom.getResizePolicies();
                    int currPolicyIndex = list.indexOf(currToTakeFrom.getCurrentResizePolicy());
                    if (currPolicyIndex != list.size() - 1) {
                        currToTakeFrom.setCurrentResizePolicy(list.get(currPolicyIndex + 1));
                    }
                    currToTakeFrom = resizeSequencingPolicy.next();
                }
            }
            int x = (ltr = c.getComponentOrientation().isLeftToRight()) ? 1 : c.getWidth() - 1;
            for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                if (ribbonBand.isHidden()) continue;
                Insets ribbonBandInsets = ribbonBand.getInsets();
                RibbonBandResizePolicy ribbonBandResizePolicy = ribbonBand.getCurrentResizePolicy();
                Object controlPanel = ribbonBand.getControlPanel();
                if (controlPanel == null) {
                    controlPanel = ribbonBand.getPopupRibbonBand().getControlPanel();
                }
                Insets controlPanelInsets = ((JComponent)controlPanel).getInsets();
                int controlPanelGap = ((AbstractBandControlPanel)controlPanel).getUI().getLayoutGap();
                int ribbonBandHeight = availableBandHeight;
                int availableHeight = ribbonBandHeight - ribbonBandInsets.top - ribbonBandInsets.bottom - ribbonBand.getUI().getBandTitleHeight();
                if (controlPanelInsets != null) {
                    availableHeight = availableHeight - controlPanelInsets.top - controlPanelInsets.bottom;
                }
                int requiredBandWidth = ribbonBandResizePolicy.getPreferredWidth(availableHeight, controlPanelGap) + ribbonBandInsets.left + ribbonBandInsets.right;
                if (ltr) {
                    ribbonBand.setBounds(x, y, requiredBandWidth, ribbonBandHeight);
                } else {
                    ribbonBand.setBounds(x - requiredBandWidth, y, requiredBandWidth, ribbonBandHeight);
                }
                if (ribbonBand.getHeight() > 0) {
                    ribbonBand.doLayout();
                }
                if (ltr) {
                    x += requiredBandWidth + bandGap;
                    continue;
                }
                x -= requiredBandWidth + bandGap;
            }
        }
    }

    protected static class BandHostPopupPanel
    extends JPopupPanel {
        public BandHostPopupPanel(Component component, Dimension originalSize) {
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(originalSize);
            this.setSize(originalSize);
        }
    }

    protected class RibbonLayout
    implements LayoutManager {
        protected RibbonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int maxPrefBandHeight = 0;
            boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
            if (!isRibbonMinimized && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    if (ribbonBand.isHidden()) continue;
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            int extraHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            if (!BasicRibbonUI.this.isUsingTitlePane()) {
                extraHeight += BasicRibbonUI.this.getTaskbarHeight();
            }
            int prefHeight = maxPrefBandHeight + extraHeight + ins.top + ins.bottom;
            return new Dimension(c.getWidth(), prefHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            int extraHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            if (!BasicRibbonUI.this.isUsingTitlePane()) {
                extraHeight += BasicRibbonUI.this.getTaskbarHeight();
            }
            if (BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean isRibbonMinimized = BasicRibbonUI.this.ribbon.isMinimized();
                RibbonTask selectedTask = BasicRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand<?> ribbonBand : selectedTask.getBands()) {
                    if (ribbonBand.isHidden()) continue;
                    int bandPrefHeight = ribbonBand.getMinimumSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    RibbonBandUI bandUI = ribbonBand.getUI();
                    width += bandUI.getPreferredCollapsedWidth();
                    if (!isRibbonMinimized) {
                        maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                    }
                    width += gap;
                }
                width -= gap;
            } else {
                width = 50;
            }
            return new Dimension(width, maxMinBandHeight + extraHeight + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            int taskButtonsWidth;
            Insets ins = c.getInsets();
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            boolean ltr = BasicRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            int width = c.getWidth();
            int taskbarHeight = BasicRibbonUI.this.getTaskbarHeight();
            int y = ins.top;
            boolean isUsingTitlePane = BasicRibbonUI.this.isUsingTitlePane();
            if (!isUsingTitlePane) {
                BasicRibbonUI.this.taskBarPanel.removeAll();
                for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                    BasicRibbonUI.this.taskBarPanel.add(regComp);
                }
                BasicRibbonUI.this.taskBarPanel.setBounds(ins.left, ins.top, width - ins.left - ins.right, taskbarHeight);
                y += taskbarHeight;
            } else {
                BasicRibbonUI.this.taskBarPanel.setBounds(0, 0, 0, 0);
            }
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int x = ltr ? ins.left : width - ins.right;
            int appMenuButtonSize = taskbarHeight + taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                BasicRibbonUI.this.applicationMenuButton.setVisible(BasicRibbonUI.this.ribbon.getApplicationMenu() != null);
                if (BasicRibbonUI.this.ribbon.getApplicationMenu() != null) {
                    if (ltr) {
                        BasicRibbonUI.this.applicationMenuButton.setBounds(x, ins.top, appMenuButtonSize, appMenuButtonSize);
                    } else {
                        BasicRibbonUI.this.applicationMenuButton.setBounds(x - appMenuButtonSize, ins.top, appMenuButtonSize, appMenuButtonSize);
                    }
                }
            } else {
                BasicRibbonUI.this.applicationMenuButton.setVisible(false);
            }
            int n = x = ltr ? x + 2 : x - 2;
            if (FlamingoUtilities.getApplicationMenuButton(SwingUtilities.getWindowAncestor(BasicRibbonUI.this.ribbon)) != null) {
                int n2 = x = ltr ? x + appMenuButtonSize : x - appMenuButtonSize;
            }
            if (BasicRibbonUI.this.helpPanel != null) {
                Dimension preferred = BasicRibbonUI.this.helpPanel.getPreferredSize();
                if (ltr) {
                    BasicRibbonUI.this.helpPanel.setBounds(width - ins.right - preferred.width, y, preferred.width, preferred.height);
                } else {
                    BasicRibbonUI.this.helpPanel.setBounds(ins.left, y, preferred.width, preferred.height);
                }
            }
            if (ltr) {
                taskButtonsWidth = BasicRibbonUI.this.helpPanel != null ? BasicRibbonUI.this.helpPanel.getX() - tabButtonGap - x : c.getWidth() - ins.right - x;
                BasicRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x, y, taskButtonsWidth, taskToggleButtonHeight);
            } else {
                taskButtonsWidth = BasicRibbonUI.this.helpPanel != null ? x - tabButtonGap - BasicRibbonUI.this.helpPanel.getX() - BasicRibbonUI.this.helpPanel.getWidth() : x - ins.left;
                BasicRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x - taskButtonsWidth, y, taskButtonsWidth, taskToggleButtonHeight);
            }
            TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            int taskToggleButtonsHostPanelMinWidth = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(taskToggleButtonsHostPanelMinWidth, BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getBounds().height));
            BasicRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            y += taskToggleButtonHeight;
            int extraHeight = taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                extraHeight += taskbarHeight;
            }
            if (BasicRibbonUI.this.bandScrollablePanel.getParent() == BasicRibbonUI.this.ribbon) {
                if (!BasicRibbonUI.this.ribbon.isMinimized() && BasicRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets bandInsets = BasicRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : BasicRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(1 + ins.left, y + bandInsets.top, c.getWidth() - 2 * ins.left - 2 * ins.right - 1, c.getHeight() - extraHeight - ins.top - ins.bottom - bandInsets.top - bandInsets.bottom);
                    BandHostPanel bandHostPanel = BasicRibbonUI.this.bandScrollablePanel.getView();
                    int bandHostPanelMinWidth = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(bandHostPanelMinWidth, BasicRibbonUI.this.bandScrollablePanel.getBounds().height));
                    BasicRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    BasicRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }

    protected class TaskToggleButtonsHostPanel
    extends JPanel {
        public static final String IS_SQUISHED = "flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished";

        protected TaskToggleButtonsHostPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintContextualTaskGroupsOutlines(g);
            if (Boolean.TRUE.equals(this.getClientProperty(IS_SQUISHED))) {
                this.paintTaskOutlines(g);
            }
        }

        protected void paintTaskOutlines(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, this.getHeight(), color);
            g2d.setPaint(paint);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            int i = 0;
            while (i < BasicRibbonUI.this.ribbon.getTaskCount() - 1) {
                RibbonTask task = BasicRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
                ++i;
            }
            i = 0;
            while (i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount()) {
                RibbonContextualTaskGroup group = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (BasicRibbonUI.this.ribbon.isVisible(group)) {
                    int j = 0;
                    while (j < group.getTaskCount() - 1) {
                        RibbonTask task = group.getTask(j);
                        tasksWithTrailingSeparators.add(task);
                        ++j;
                    }
                }
                ++i;
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JRibbonTaskToggleButton taskToggleButton = BasicRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + BasicRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.drawLine(x, 0, x, this.getHeight());
            }
            g2d.dispose();
        }

        protected void paintContextualTaskGroupsOutlines(Graphics g) {
            int i = 0;
            while (i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount()) {
                RibbonContextualTaskGroup group = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (BasicRibbonUI.this.ribbon.isVisible(group)) {
                    Rectangle rect = BasicRibbonUI.this.getContextualTaskGroupBounds(group);
                    rect.setLocation(SwingUtilities.convertPoint(BasicRibbonUI.this.ribbon, rect.getLocation(), BasicRibbonUI.this.taskToggleButtonsScrollablePanel.getView()));
                    this.paintContextualTaskGroupOutlines(g, group, rect);
                }
                ++i;
            }
        }

        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            Color color = FlamingoUtilities.getBorderColor();
            GradientPaint paint = new GradientPaint(0.0f, groupBounds.y, color, 0.0f, groupBounds.y + groupBounds.height, FlamingoUtilities.getAlphaColor(color, 0));
            g2d.setPaint(paint);
            int x = groupBounds.x;
            g2d.drawLine(x, groupBounds.y, x, groupBounds.y + groupBounds.height);
            x = groupBounds.x + groupBounds.width;
            g2d.drawLine(x, groupBounds.y, x, groupBounds.y + groupBounds.height);
            g2d.dispose();
        }
    }

    private class TaskToggleButtonsHostPanelLayout
    implements LayoutManager {
        private TaskToggleButtonsHostPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalTaskButtonsWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getPreferredSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalTaskButtonsWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            for (RibbonTask task : visibleTasks) {
                JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getMinimumSize().width;
                totalTaskButtonsWidth += pw + tabButtonGap;
            }
            return new Dimension(totalTaskButtonsWidth, taskToggleButtonHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int y = 0;
            int tabButtonGap = BasicRibbonUI.this.getTabButtonGap();
            int taskToggleButtonHeight = BasicRibbonUI.this.getTaskToggleButtonHeight();
            int totalPrefWidth = 0;
            int totalMinWidth = 0;
            List<RibbonTask> visibleTasks = BasicRibbonUI.this.getCurrentlyShownRibbonTasks();
            HashMap<JRibbonTaskToggleButton, Integer> diffMap = new HashMap<JRibbonTaskToggleButton, Integer>();
            int totalDiff = 0;
            for (RibbonTask task : visibleTasks) {
                JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                int pw = tabButton.getPreferredSize().width;
                int mw = tabButton.getMinimumSize().width;
                diffMap.put(tabButton, pw - mw);
                totalDiff += pw - mw;
                totalPrefWidth += pw;
                totalMinWidth += mw;
            }
            totalMinWidth += tabButtonGap * visibleTasks.size();
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            if ((totalPrefWidth += tabButtonGap * visibleTasks.size()) <= c.getWidth()) {
                int x = ltr ? 0 : c.getWidth();
                for (RibbonTask task : visibleTasks) {
                    JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                    int pw = tabButton.getPreferredSize().width;
                    if (ltr) {
                        tabButton.setBounds(x, y + 1, pw, taskToggleButtonHeight - 1);
                        x += pw + tabButtonGap;
                    } else {
                        tabButton.setBounds(x - pw, y + 1, pw, taskToggleButtonHeight - 1);
                        x -= pw + tabButtonGap;
                    }
                    tabButton.setActionRichTooltip(null);
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", null);
            } else {
                if (totalMinWidth > c.getWidth()) {
                    throw new IllegalStateException("Available width not enough to host minimized task tab buttons");
                }
                int x = ltr ? 0 : c.getWidth();
                int toDistribute = totalPrefWidth - c.getWidth() + 2;
                for (RibbonTask task : visibleTasks) {
                    JRibbonTaskToggleButton tabButton = BasicRibbonUI.this.taskToggleButtons.get(task);
                    int pw = tabButton.getPreferredSize().width;
                    int delta = toDistribute * (Integer)diffMap.get(tabButton) / totalDiff;
                    int finalWidth = pw - delta;
                    if (ltr) {
                        tabButton.setBounds(x, y + 1, finalWidth, taskToggleButtonHeight - 1);
                        x += finalWidth + tabButtonGap;
                    } else {
                        tabButton.setBounds(x - finalWidth, y + 1, finalWidth, taskToggleButtonHeight - 1);
                        x -= finalWidth + tabButtonGap;
                    }
                    RichTooltip tooltip = new RichTooltip();
                    tooltip.setTitle(task.getTitle());
                    tabButton.setActionRichTooltip(tooltip);
                }
                ((JComponent)c).putClientProperty("flamingo.internal.ribbon.taskToggleButtonsHostPanel.isSquished", Boolean.TRUE);
            }
        }
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = BasicRibbonUI.this.getBandGap();
            for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, BasicRibbonUI.this.getTaskbarHeight() + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = BasicRibbonUI.this.getBandGap();
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            if (ltr) {
                int x = ins.left + 1;
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    x += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
                }
                for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                    int pw = regComp.getPreferredSize().width;
                    regComp.setBounds(x, ins.top + 1, pw, c.getHeight() - ins.top - ins.bottom - 2);
                    x += pw + gap;
                }
            } else {
                int x = c.getWidth() - ins.right - 1;
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    x = BasicRibbonUI.this.applicationMenuButton.getX() - 1;
                }
                for (Component regComp : BasicRibbonUI.this.ribbon.getTaskbarComponents()) {
                    int pw = regComp.getPreferredSize().width;
                    regComp.setBounds(x - pw, ins.top + 1, pw, c.getHeight() - ins.top - ins.bottom - 2);
                    x -= pw + gap;
                }
            }
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(1, 0, 1, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            int contourMinX;
            Shape contour = this.getOutline(this);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RenderingUtils.installDesktopHints(g2d);
            if (contour != null) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.6f));
                g2d.setColor(FlamingoUtilities.getColor(Color.lightGray.brighter(), "Panel.background"));
                g2d.fill(contour);
                g2d.setColor(FlamingoUtilities.getBorderColor().darker());
                g2d.draw(contour);
            }
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            int maxX = 0;
            int minX = this.getWidth();
            if (this.getComponentCount() == 0) {
                maxX = 1;
                minX = this.getWidth() - 1;
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    maxX += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
                    minX = BasicRibbonUI.this.applicationMenuButton.getX() - 1;
                }
            } else {
                int i = 0;
                while (i < this.getComponentCount()) {
                    Component taskBarComp = this.getComponent(i);
                    maxX = Math.max(maxX, taskBarComp.getX() + taskBarComp.getWidth());
                    minX = Math.min(minX, taskBarComp.getX());
                    ++i;
                }
            }
            int height = this.getHeight();
            if (ltr) {
                g2d.drawLine(maxX, height - 1, this.getWidth(), height - 1);
            } else {
                g2d.drawLine(0, height - 1, minX, height - 1);
            }
            int n = contourMinX = contour != null ? (int)contour.getBounds2D().getMinX() - 6 : 6;
            if (!BasicRibbonUI.this.isShowingScrollsForTaskToggleButtons()) {
                g2d.setComposite(AlphaComposite.SrcOver);
                g2d.translate(-this.getBounds().x, 0);
                int i = 0;
                while (i < BasicRibbonUI.this.ribbon.getContextualTaskGroupCount()) {
                    RibbonContextualTaskGroup taskGroup = BasicRibbonUI.this.ribbon.getContextualTaskGroup(i);
                    if (BasicRibbonUI.this.ribbon.isVisible(taskGroup)) {
                        int width;
                        Rectangle taskGroupBounds = BasicRibbonUI.this.getContextualTaskGroupBounds(taskGroup);
                        Color hueColor = taskGroup.getHueColor();
                        GradientPaint paint = new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(hueColor, 0), 0.0f, height, FlamingoUtilities.getAlphaColor(hueColor, 63));
                        g2d.setPaint(paint);
                        int startX = ltr ? taskGroupBounds.x : Math.min(contourMinX, taskGroupBounds.x);
                        int n2 = width = ltr ? taskGroupBounds.x + taskGroupBounds.width - startX : Math.min(taskGroupBounds.x + taskGroupBounds.width, contourMinX) - startX;
                        if (width > 0) {
                            g2d.fillRect(startX, 0, width, height);
                            g2d.setColor(hueColor);
                            g2d.drawLine(startX + 1, height - 1, startX + width, height - 1);
                            g2d.setColor(FlamingoUtilities.getColor(Color.black, "Button.foreground"));
                            FontMetrics fm = this.getFontMetrics(BasicRibbonUI.this.ribbon.getFont());
                            int yOffset = (height + fm.getHeight()) / 2 - fm.getDescent();
                            int availableTextWidth = width - 10;
                            String titleToShow = taskGroup.getTitle();
                            if (fm.stringWidth(titleToShow) > availableTextWidth) {
                                while (titleToShow.length() != 0 && fm.stringWidth(String.valueOf(titleToShow) + "...") > availableTextWidth) {
                                    titleToShow = titleToShow.substring(0, titleToShow.length() - 1);
                                }
                                titleToShow = String.valueOf(titleToShow) + "...";
                            }
                            if (ltr) {
                                BasicGraphicsUtils.drawString(g2d, titleToShow, -1, startX + 5, yOffset);
                            } else {
                                BasicGraphicsUtils.drawString(g2d, titleToShow, -1, startX + width - 5 - fm.stringWidth(titleToShow), yOffset);
                            }
                            Color color = FlamingoUtilities.getBorderColor();
                            g2d.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getAlphaColor(color, 0), 0.0f, height, color));
                            g2d.drawLine(startX, 0, startX, height);
                            g2d.drawLine(startX + width, 0, startX + width, height);
                        }
                    }
                    ++i;
                }
            }
            g2d.dispose();
        }

        protected Shape getOutline(TaskbarPanel taskbarPanel) {
            double height = this.getHeight() - 1;
            boolean ltr = taskbarPanel.getComponentOrientation().isLeftToRight();
            if (this.getComponentCount() == 0) {
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    if (ltr) {
                        int x = 1;
                        if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                            x += BasicRibbonUI.this.applicationMenuButton.getX() + BasicRibbonUI.this.applicationMenuButton.getWidth();
                        }
                        return new Arc2D.Double((double)(x - 1) - 2.0 * height, 0.0, 2.0 * height, 2.0 * height, 0.0, 90.0, 0);
                    }
                    int x = taskbarPanel.getWidth() - 1;
                    if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                        x = BasicRibbonUI.this.applicationMenuButton.getX() - 1;
                    }
                    return new Arc2D.Double(x + 1, 0.0, 2.0 * height, 2.0 * height, 90.0, 90.0, 0);
                }
                return null;
            }
            int minX = this.getWidth();
            int maxX = 0;
            int i = 0;
            while (i < this.getComponentCount()) {
                Component taskBarComp = this.getComponent(i);
                minX = Math.min(minX, taskBarComp.getX());
                maxX = Math.max(maxX, taskBarComp.getX() + taskBarComp.getWidth());
                ++i;
            }
            float radius = (float)height / 2.0f;
            GeneralPath outline = new GeneralPath();
            if (ltr) {
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    outline.moveTo((float)(minX + 5) - 2.0f * radius, 0.0f);
                } else {
                    outline.moveTo(minX - 1, 0.0f);
                }
                outline.lineTo(maxX, 0.0f);
                outline.append(new Arc2D.Double((float)maxX - radius, 0.0, height, height, 90.0, -180.0, 0), true);
                outline.lineTo((double)(minX - 1), height);
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    outline.append(new Arc2D.Double((double)(minX - 1) - 2.0 * height, 0.0, 2.0 * height, 2.0 * height, 0.0, 90.0, 0), true);
                } else {
                    outline.lineTo(minX - 1, 0.0f);
                }
            } else {
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    outline.moveTo((float)(maxX - 5) + 2.0f * radius, 0.0f);
                } else {
                    outline.moveTo(maxX - 1, 0.0f);
                }
                outline.lineTo(minX, 0.0f);
                outline.append(new Arc2D.Double((float)minX - radius, 0.0, height, height, 90.0, 180.0, 0), true);
                outline.lineTo((double)(maxX - 1), height);
                if (BasicRibbonUI.this.applicationMenuButton.isVisible()) {
                    outline.append(new Arc2D.Double(maxX - 1, 0.0, 2.0 * height, 2.0 * height, 180.0, -90.0, 0), true);
                } else {
                    outline.lineTo(maxX + 1, 0.0f);
                }
            }
            return outline;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(result.width + result.height / 2, result.height);
        }
    }
}

