/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import java.util.ArrayList;
import java.util.Iterator;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Arbiter;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.BroadCollisionStrategy;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionSpace;
import net.phys2d.raw.Contact;
import net.phys2d.raw.Joint;
import net.phys2d.raw.JointList;
import net.phys2d.raw.forcesource.ForceSource;
import net.phys2d.raw.strategies.BruteCollisionStrategy;

public strictfp class World
extends CollisionSpace {
    private JointList joints = new JointList();
    private Vector2f gravity = new Vector2f(0.0f, 0.0f);
    private int iterations;
    private float damping = 1.0f;
    private boolean restingBodyDetection = false;
    private float hitTolerance;
    private float rotationTolerance;
    private float positionTolerance;
    private ArrayList sources = new ArrayList();

    public World(Vector2f gravity, int iterations) {
        this(gravity, iterations, new BruteCollisionStrategy());
    }

    public World(Vector2f gravity, int iterations, BroadCollisionStrategy strategy) {
        super(strategy);
        this.gravity = gravity;
        this.iterations = iterations;
    }

    public void add(ForceSource source) {
        this.sources.add(source);
    }

    public void remove(ForceSource source) {
        this.sources.remove(source);
    }

    public void enableRestingBodyDetection(float hitTolerance, float rotationTolerance, float positionTolerance) {
        this.hitTolerance = hitTolerance;
        this.rotationTolerance = rotationTolerance;
        this.positionTolerance = positionTolerance;
        this.restingBodyDetection = true;
    }

    public void disableRestingBodyDetection() {
        this.restingBodyDetection = false;
    }

    public void clearRestingState() {
        for (int i = 0; i < this.bodies.size(); ++i) {
            this.bodies.get(i).setIsResting(false);
        }
    }

    public void setDamping(float damping) {
        this.damping = damping;
    }

    public void setGravity(float x, float y) {
        this.gravity.x = x;
        this.gravity.y = y;
    }

    public JointList getJoints() {
        return this.joints;
    }

    public void clearArbiters(Body b) {
        Arbiter arb;
        Iterator it = this.arbiters.values().iterator();
        while (it.hasNext()) {
            arb = (Arbiter)it.next();
            if (!arb.concerns(b)) continue;
            this.notifySeparation(arb.getBody1(), arb.getBody2());
            it.remove();
        }
        it = this.overlapList.values().iterator();
        while (it.hasNext()) {
            arb = (Arbiter)it.next();
            if (!arb.concerns(b)) continue;
            this.notifySeparation(arb.getBody1(), arb.getBody2());
            it.remove();
        }
    }

    public void add(Joint joint) {
        this.joints.add(joint);
    }

    public void remove(Joint joint) {
        this.joints.remove(joint);
    }

    @Override
    public void clear() {
        super.clear();
        this.joints.clear();
    }

    public void step() {
        this.step(0.016666668f);
    }

    protected BodyList getActiveBodies() {
        return this.bodies;
    }

    protected JointList getActiveJoints() {
        return this.joints;
    }

    public void step(float dt) {
        int i;
        Joint j;
        Body b;
        int i2;
        float invDT;
        for (int i3 = 0; i3 < this.bodies.size(); ++i3) {
            for (int j2 = 0; j2 < this.sources.size(); ++j2) {
                ((ForceSource)this.sources.get(j2)).apply(this.bodies.get(i3), dt);
            }
        }
        BodyList bodies = this.getActiveBodies();
        JointList joints = this.getActiveJoints();
        float f = invDT = dt > 0.0f ? 1.0f / dt : 0.0f;
        if (this.restingBodyDetection) {
            for (i2 = 0; i2 < bodies.size(); ++i2) {
                b = bodies.get(i2);
                b.startFrame();
            }
            for (i2 = 0; i2 < joints.size(); ++i2) {
                j = joints.get(i2);
                j.getBody1().setIsResting(false);
                j.getBody2().setIsResting(false);
            }
        }
        this.broadPhase(dt);
        for (i2 = 0; i2 < bodies.size(); ++i2) {
            b = bodies.get(i2);
            if (b.getInvMass() == 0.0f || b.isResting() && this.restingBodyDetection) continue;
            Vector2f temp = new Vector2f(b.getForce());
            temp.scale(b.getInvMass());
            if (b.getGravityEffected()) {
                temp.add(this.gravity);
            }
            temp.scale(dt);
            b.adjustVelocity(temp);
            Vector2f damping = new Vector2f(b.getVelocity());
            damping.scale(-b.getDamping() * b.getInvMass());
            b.adjustVelocity(damping);
            b.adjustAngularVelocity(dt * b.getInvI() * b.getTorque());
            b.adjustAngularVelocity(-b.getAngularVelocity() * b.getInvI() * b.getRotDamping());
        }
        for (Arbiter arb : this.arbiters.values()) {
            if (this.restingBodyDetection && arb.hasRestingPair()) continue;
            arb.preStep(invDT, dt, this.damping);
        }
        for (i = 0; i < joints.size(); ++i) {
            j = joints.get(i);
            j.preStep(invDT);
        }
        for (i = 0; i < this.iterations; ++i) {
            for (Arbiter arb : this.arbiters.values()) {
                if (!this.restingBodyDetection || !arb.hasRestingPair()) {
                    arb.applyImpulse();
                    continue;
                }
                arb.getBody1().collided(arb.getBody2());
                arb.getBody2().collided(arb.getBody1());
            }
            for (int k = 0; k < joints.size(); ++k) {
                Joint j3 = joints.get(k);
                j3.applyImpulse();
            }
        }
        for (i = 0; i < bodies.size(); ++i) {
            Body b2 = bodies.get(i);
            Vector2f softForce = new Vector2f(b2.getSoftForce());
            softForce.scale(b2.getInvMass());
            softForce.scale(dt);
            b2.adjustVelocitySoft(softForce);
        }
        for (i = 0; i < bodies.size(); ++i) {
            Body b3 = bodies.get(i);
            if (b3.getInvMass() == 0.0f || this.restingBodyDetection && b3.isResting()) continue;
            b3.adjustPosition(b3.getVelocity(), dt);
            b3.adjustPosition(b3.getBiasedVelocity(), dt);
            b3.adjustRotation(dt * b3.getAngularVelocity());
            b3.adjustRotation(dt * b3.getBiasedAngularVelocity());
            b3.resetBias();
            b3.setForce(0.0f, 0.0f);
            b3.setSoftForce(0.0f, 0.0f);
            b3.setTorque(0.0f);
        }
        if (this.restingBodyDetection) {
            for (i = 0; i < bodies.size(); ++i) {
                Body b4 = bodies.get(i);
                b4.endFrame();
            }
        }
        this.cleanUpArbiters();
    }

    private void cleanUpArbiters() {
        Arbiter arbiter;
        Iterator it = this.arbiters.values().iterator();
        while (it.hasNext()) {
            arbiter = (Arbiter)it.next();
            if (arbiter.getBody1().added() && arbiter.getBody2().added()) continue;
            it.remove();
        }
        it = this.overlapList.values().iterator();
        while (it.hasNext()) {
            arbiter = (Arbiter)it.next();
            if (arbiter.getBody1().added() && arbiter.getBody2().added()) continue;
            it.remove();
        }
    }

    void broadPhase(float dt) {
        this.collide(dt);
    }

    public CollisionEvent[] getContacts(Body body) {
        ArrayList<CollisionEvent> collisions = new ArrayList<CollisionEvent>();
        for (Arbiter arb : this.arbiters.values()) {
            if (!arb.concerns(body)) continue;
            for (int j = 0; j < arb.getNumContacts(); ++j) {
                Contact contact = arb.getContact(j);
                CollisionEvent event = new CollisionEvent(0.0f, arb.getBody1(), arb.getBody2(), contact.getPosition(), contact.getNormal(), contact.getSeparation());
                collisions.add(event);
            }
        }
        return collisions.toArray(new CollisionEvent[0]);
    }

    public float getTotalEnergy() {
        float total = 0.0f;
        for (int i = 0; i < this.bodies.size(); ++i) {
            total += this.bodies.get(i).getEnergy();
        }
        return total;
    }

    @Override
    public void add(Body body) {
        body.configureRestingBodyDetection(this.hitTolerance, this.rotationTolerance, this.positionTolerance);
        super.add(body);
    }

    @Override
    public void remove(Body body) {
        this.clearArbiters(body);
        super.remove(body);
    }
}

