/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.Saver;
import icy.file.xls.XlsManager;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.FontUtil;
import icy.gui.util.GuiUtil;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.type.DataType;
import icy.util.XLSUtil;
import icy.util.XMLUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Scanner;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import plugins.fab.MiceProfiler.Animal;
import plugins.fab.MiceProfiler.EventCriteria;
import plugins.fab.MiceProfiler.EventTimeLine;
import plugins.fab.MiceProfiler.EventType;
import plugins.fab.MiceProfiler.FrameAccess;
import plugins.fab.MiceProfiler.MouseEventType;
import plugins.fab.MiceProfiler.TimeLineCategory;
import plugins.fab.MiceProfiler.VisionGraph;

public class MiceProfilerVideoLabelMakerInternal
implements ActionListener,
KeyListener {
    JPanel mainPanel = new JPanel();
    IcyFrame mainFrame = new IcyFrame("Video Label Maker", true, true, true, true);
    JMenuBar menuBar = new JMenuBar();
    JMenuItem openFileMenuItem = new JMenuItem("Open XML File...");
    JMenuItem compileImageFileMenuItem = new JMenuItem("Compile image files from a list of file...");
    JMenuItem mergeHeatMapMenuItem = new JMenuItem("Stitch heatmap files...");
    JScrollPane scrollPane = new JScrollPane(this.mainPanel);
    JPanel setupPanel = GuiUtil.generatePanel((String)"Setup");
    JLabel legendLabel = new JLabel("Legend", 0);
    JTextField scaleTextField = new JTextField("0.22");
    JTextField scaleVideoTextField = new JTextField("1");
    int START_MINUTE = 0;
    int NB_MINUTE = 8;
    float SEUIL_DISTANCE_1 = 22.0f;
    float SEUIL_DISTANCE_2 = 40.0f;
    float SEUIL_DISTANCE_HEAD_HEAD = 15.0f;
    float SEUIL_DISTANCE_HEAD_GENITAL = 15.0f;
    float SEUIL_SIDE = 12.0f;
    float SPEED_THRESHOLD_1 = 0.5f;
    float SPEED_THRESHOLD_2 = 2.0f;
    float SPEED_THRESHOLD_3 = 4.0f;
    float FPS = 15.0f;
    float LOAD_FRAME_START = 0.0f;
    float LOAD_FRAME_END = 1.0E7f;
    float SCALE = 0.22f;
    JTextField distance1TextField = new JTextField();
    JTextField distance2TextField = new JTextField();
    JTextField distanceHeadHeadTextField = new JTextField();
    JTextField distanceHeadGenitalTextField = new JTextField();
    JTextField seuilSideTextField = new JTextField();
    JTextField speed_threshold1TextField = new JTextField();
    JTextField speed_threshold2TextField = new JTextField();
    JTextField speed_threshold3TextField = new JTextField();
    JTextField fpsTextField = new JTextField();
    JTextField computeImageStartMinuteTextField = new JTextField();
    JTextField computeImageNbMinuteTextField = new JTextField();
    JButton refreshButton = new JButton("Refresh Data with new parameters");
    BufferedImage videoImage = new BufferedImage(200, 200, 4);
    ImageComponent imageVideoComponent = new ImageComponent();
    JLabel videoTimeLabel = new JLabel("", 0);
    int stepY = 15;
    ArrayList<VideoLabelPanel> videoLabelPanelArrayList = new ArrayList();

    public void run() {
        this.mainFrame.pack();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.videoTimeLabel.setFont(new Font("Arial", 1, 15));
        this.legendLabel.setFont(new Font("Arial", 1, 20));
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.openFileMenuItem);
        this.openFileMenuItem.addActionListener(this);
        fileMenu.addSeparator();
        fileMenu.add(this.compileImageFileMenuItem);
        this.compileImageFileMenuItem.addActionListener(this);
        fileMenu.add(this.mergeHeatMapMenuItem);
        this.mergeHeatMapMenuItem.addActionListener(this);
        this.menuBar.add(fileMenu);
        this.mainFrame.setJMenuBar(this.menuBar);
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new BorderLayout());
        JPanel videoPanel = GuiUtil.generatePanel((String)"video");
        this.imageVideoComponent.setImage(this.videoImage);
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.imageVideoComponent}));
        videoPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.videoTimeLabel}));
        sidePanel.add((Component)this.setupPanel, "North");
        sidePanel.add((Component)videoPanel, "Center");
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)sidePanel, "East");
        this.mainFrame.getContentPane().add((Component)this.legendLabel, "South");
        this.mainFrame.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.setPreferredSize(new Dimension(800, 450));
        this.distance1TextField.setText("" + this.SEUIL_DISTANCE_1);
        this.distance2TextField.setText("" + this.SEUIL_DISTANCE_2);
        this.distanceHeadHeadTextField.setText("" + this.SEUIL_DISTANCE_HEAD_HEAD);
        this.distanceHeadGenitalTextField.setText("" + this.SEUIL_DISTANCE_HEAD_GENITAL);
        this.seuilSideTextField.setText("" + this.SEUIL_SIDE);
        this.speed_threshold1TextField.setText("" + this.SPEED_THRESHOLD_1);
        this.speed_threshold2TextField.setText("" + this.SPEED_THRESHOLD_2);
        this.speed_threshold3TextField.setText("" + this.SPEED_THRESHOLD_3);
        this.fpsTextField.setText("" + this.FPS);
        this.computeImageStartMinuteTextField.setText("" + this.START_MINUTE);
        this.computeImageNbMinuteTextField.setText("" + this.NB_MINUTE);
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Distance Threshold 1(closest) in px:"), this.distance1TextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Distance Threshold 2 in px:"), this.distance2TextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Distance Head-Head in px:"), this.distanceHeadHeadTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Distance Head-Genital 2 in px:"), this.distanceHeadGenitalTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Side detection Parameter in px:"), this.seuilSideTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Speed Threshold 1 (black) in px:"), this.speed_threshold1TextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Speed Threshold 2 (gray) in px:"), this.speed_threshold2TextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Speed Threshold 3 (lightgray) in px:"), this.speed_threshold3TextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("FPS:"), this.fpsTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Computation Start Minute:"), this.computeImageStartMinuteTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Computation End Minute:"), this.computeImageNbMinuteTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Mouse Scale"), this.scaleTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{new JLabel("Video Image display scale"), this.scaleVideoTextField}));
        this.setupPanel.add(GuiUtil.besidesPanel((Component[])new Component[]{this.refreshButton}));
        this.refreshButton.addActionListener(this);
        this.scaleTextField.setFont(FontUtil.setStyle((Font)this.scaleTextField.getFont(), (int)1));
        this.scaleTextField.addKeyListener(this);
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.addToMainDesktopPane();
        this.mainFrame.setVisible(true);
    }

    public void openFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        String node = "plugins/PhysicTracker/videolabelmaker/browser";
        Preferences preferences = Preferences.userRoot().node(node);
        String path = preferences.get("path", "");
        fileChooser.setCurrentDirectory(new File(path));
        int x = preferences.getInt("x", 0);
        int y = preferences.getInt("y", 0);
        int width = preferences.getInt("width", 400);
        int height = preferences.getInt("height", 400);
        fileChooser.setLocation(x, y);
        fileChooser.setPreferredSize(new Dimension(width, height));
        int returnValue = fileChooser.showDialog(null, "Load");
        if (returnValue == 0) {
            preferences.put("path", fileChooser.getCurrentDirectory().getAbsolutePath());
            preferences.putInt("x", fileChooser.getX());
            preferences.putInt("y", fileChooser.getY());
            preferences.putInt("width", fileChooser.getWidth());
            preferences.putInt("height", fileChooser.getHeight());
            for (int i = 0; i < fileChooser.getSelectedFiles().length; ++i) {
                if (fileChooser.getSelectedFiles()[i].getName().contains("extra")) {
                    System.out.println("You are trying to load an extra xml file. Please load the original file instead.");
                    continue;
                }
                VideoLabelPanel videoLabelPanel = new VideoLabelPanel(fileChooser.getSelectedFiles()[i]);
                this.mainPanel.add(videoLabelPanel.panel);
                this.videoLabelPanelArrayList.add(videoLabelPanel);
                this.mainPanel.add(new JPanel());
            }
        }
        this.mainPanel.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshButton) {
            try {
                this.SEUIL_DISTANCE_1 = Float.parseFloat(this.distance1TextField.getText());
                this.SEUIL_DISTANCE_2 = Float.parseFloat(this.distance2TextField.getText());
                this.SEUIL_DISTANCE_HEAD_HEAD = Float.parseFloat(this.distanceHeadHeadTextField.getText());
                this.SEUIL_DISTANCE_HEAD_GENITAL = Float.parseFloat(this.distanceHeadGenitalTextField.getText());
                this.SEUIL_SIDE = Float.parseFloat(this.seuilSideTextField.getText());
                this.SPEED_THRESHOLD_1 = Float.parseFloat(this.speed_threshold1TextField.getText());
                this.SPEED_THRESHOLD_2 = Float.parseFloat(this.speed_threshold2TextField.getText());
                this.SPEED_THRESHOLD_3 = Float.parseFloat(this.speed_threshold3TextField.getText());
                this.FPS = Float.parseFloat(this.fpsTextField.getText());
            }
            catch (NumberFormatException e1) {
                MessageDialog.showDialog((String)"One of the parameters cannot be understand as a number. Please correct it and refresh again.", (int)0);
                return;
            }
            for (VideoLabelPanel vlp : this.videoLabelPanelArrayList) {
                if (vlp.isFreezed()) continue;
                vlp.buildResultImage();
            }
            double scaleVideo = 1.0;
            try {
                scaleVideo = Double.parseDouble(this.scaleVideoTextField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.imageVideoComponent.setZoom(scaleVideo);
        }
        if (e.getSource() == this.openFileMenuItem) {
            this.openFile();
        }
        if (e.getSource() == this.compileImageFileMenuItem) {
            this.compileImageFile();
        }
        if (e.getSource() == this.mergeHeatMapMenuItem) {
            this.mergeHeatMapDirectory();
        }
    }

    private void mergeHeatMapDirectory() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        String node = "plugins/PhysicTracker/videolabelmaker/browser";
        Preferences preferences = Preferences.userRoot().node(node);
        String path = preferences.get("path", "");
        fileChooser.setCurrentDirectory(new File(path));
        int returnValue = fileChooser.showDialog(null, "Load heatmap files");
        if (returnValue == 0) {
            IcyBufferedImage resultImage = new IcyBufferedImage(1, 1, 4, DataType.USHORT);
            for (int i = 0; i < fileChooser.getSelectedFiles().length; ++i) {
                File file = fileChooser.getSelectedFiles()[i];
                if (!file.getAbsolutePath().toLowerCase().endsWith("heatmap.tif")) continue;
                Point copyPoint = new Point(resultImage.getWidth(), 0);
                System.out.println("Loading file " + file.getAbsolutePath());
                Sequence sequence = Loader.loadSequence((String)file.getAbsolutePath(), (int)0, (boolean)false);
                Graphics2D g = (Graphics2D)sequence.getFirstImage().getGraphics();
                g.setColor(Color.white);
                g.setFont(new Font("Arial", 0, 12));
                g.drawString(FileUtil.getFileName((String)file.getAbsolutePath(), (boolean)false), 0, 15);
                int newHeight = Math.max(resultImage.getHeight(), sequence.getHeight());
                resultImage = IcyBufferedImageUtil.scale((IcyBufferedImage)resultImage, (int)(resultImage.getWidth() + sequence.getWidth()), (int)newHeight, (boolean)false, (int)2, (int)1);
                resultImage.copyData(sequence.getFirstImage(), null, copyPoint);
            }
            Sequence outputSequence = new Sequence(resultImage);
            File outFile = new File(FileUtil.getDirectory((String)fileChooser.getSelectedFile().getAbsolutePath()) + "/" + "heatmap stitched.tif");
            new AnnounceFrame("Saving stitched heatmap to file " + outFile.getAbsolutePath(), 5);
            Saver.save((Sequence)outputSequence, (File)outFile);
        }
    }

    private void compileImageFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        int returnValue = fileChooser.showDialog(null, "Load");
        if (returnValue == 0) {
            ArrayList<File> fileArray = new ArrayList<File>();
            HashMap<File, BufferedImage> fileImageHashMap = new HashMap<File, BufferedImage>();
            for (int i = 0; i < fileChooser.getSelectedFiles().length; ++i) {
                try {
                    BufferedImage bi = ImageIO.read(fileChooser.getSelectedFiles()[i]);
                    fileImageHashMap.put(fileChooser.getSelectedFiles()[i], bi);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                fileArray.add(fileChooser.getSelectedFiles()[i]);
            }
            int NB_TOTAL_CRITERIA = 28;
            for (int criteria = 0; criteria < NB_TOTAL_CRITERIA; ++criteria) {
                int maxWidth = 0;
                int nbFileMatching = 0;
                String tokenToLook = ".criteria_" + criteria + ".png";
                for (File file : fileArray) {
                    if (!file.getAbsoluteFile().toString().contains(tokenToLook)) continue;
                    ++nbFileMatching;
                    int w = ((BufferedImage)fileImageHashMap.get(file)).getWidth();
                    if (w <= maxWidth) continue;
                    maxWidth = w;
                }
                System.out.println("Max Width : " + maxWidth);
                if (nbFileMatching == 0) {
                    new ToolTipFrame("<html>No file matching .criteria_XX.png found in the list of file provided.<br>Create those images by clicking the save button<br>on each XML panel</html>");
                    return;
                }
                BufferedImage image2 = new BufferedImage(maxWidth, this.stepY * nbFileMatching, 4);
                Graphics2D targetG = (Graphics2D)image2.getGraphics();
                int currentY = 0;
                for (File file : fileArray) {
                    if (!file.getAbsoluteFile().toString().contains(tokenToLook)) continue;
                    BufferedImage bi = (BufferedImage)fileImageHashMap.get(file);
                    targetG.drawImage(bi, null, 0, currentY);
                    if (criteria == 2) {
                        targetG.setColor(Color.black);
                        targetG.drawString(file.getAbsoluteFile().toString(), 400, currentY + this.stepY / 2);
                    }
                    currentY += bi.getHeight();
                }
                try {
                    String fileName = fileChooser.getSelectedFile().getParent() + "\\__crit_" + criteria + ".png";
                    System.out.println("Saving : " + fileName);
                    ImageIO.write((RenderedImage)image2, "png", new File(fileName));
                    continue;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        System.out.println("Finished.");
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.scaleTextField) {
            try {
                float scale = Float.parseFloat(this.scaleTextField.getText());
                float ratio = scale / 0.22f;
                this.distance1TextField.setText("" + ratio * 22.0f);
                this.distance2TextField.setText("" + ratio * 40.0f);
                this.distanceHeadHeadTextField.setText("" + ratio * 15.0f);
                this.distanceHeadGenitalTextField.setText("" + ratio * 15.0f);
                this.seuilSideTextField.setText("" + ratio * 12.0f);
                this.speed_threshold1TextField.setText("" + (double)ratio * 0.5);
                this.speed_threshold2TextField.setText("" + ratio * 2.0f);
                this.speed_threshold3TextField.setText("" + ratio * 4.0f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public class ImageComponent
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private static final long serialVersionUID = -5907107709763419248L;
        BufferedImage image;
        ArrayList<String> stringList = new ArrayList();
        double zoom = 1.0;
        int y = 0;
        int x = 0;

        public void setZoom(double zoom) {
            this.zoom = zoom;
            this.updateUI();
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension((int)((double)image.getWidth() * this.zoom), (int)((double)image.getHeight() * this.zoom)));
            this.repaint();
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (this.image != null) {
                g2.scale(this.zoom, this.zoom);
                g2.drawImage(this.image, null, 0, 0);
                if (this.stringList.size() != 0) {
                    float[] dash = new float[]{10.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
                    g2.drawLine(this.x, 0, this.x, this.image.getHeight());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.x = e.getX();
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            String string;
            this.x = e.getX();
            int index = e.getY() / MiceProfilerVideoLabelMakerInternal.this.stepY;
            if (this.stringList.size() > index && (string = this.stringList.get(index)) != null) {
                MiceProfilerVideoLabelMakerInternal.this.legendLabel.setText(string);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.x = e.getX();
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public class VideoLabelPanel
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        JPanel panel = null;
        int firstFrame;
        int lastFrame;
        HashMap<Integer, MouseInfoRecord> mouseARecord = new HashMap();
        HashMap<Integer, MouseInfoRecord> mouseBRecord = new HashMap();
        int xPixelPetT = 1;
        BufferedImage imageChrono = new BufferedImage(100, 100, 4);
        ImageIcon imageIcon;
        ImageComponent imageComponent = new ImageComponent();
        JButton saveImageButton = new JButton("Save Chrono Image");
        JButton exportEventsAsXML = new JButton("Export Events as XML");
        JButton exportSpeedButton = new JButton("Export speed and distance");
        JCheckBox freezeSettingsCheckBox = new JCheckBox("freeze settings");
        JButton computeVisionInFollowButton = new JButton("Export follow vision graph");
        JButton computeVisionWhenStoppedButton = new JButton("Export stop vision graph");
        JButton computeLocationHeatMapButton = new JButton("Create location heat map");
        JButton computeUSVStat = new JButton("Create USV stat");
        File file;
        File extraXMLFile;
        File videoFile;
        FrameAccess frameAccess;
        Animal animal = null;
        SwimmingObject swimmingObject = null;
        DecimalFormat decimalFormat = new DecimalFormat("00");
        double demiVisionDeSouris = 2.0943951023931953;
        int startOffset = 0;

        public VideoLabelPanel(File fileXML) {
            this.computeVisionInFollowButton.setToolTipText("Location of I in the vision of R (R following)");
            this.computeVisionWhenStoppedButton.setToolTipText("Location of I in the vision of R (R stopped)");
            JPanel sidePanel2 = GuiUtil.generatePanel((String)"Video");
            if (FileUtil.getFileExtension((String)fileXML.getAbsolutePath(), (boolean)false).toLowerCase().equals("avi")) {
                System.out.println("Avi loaded. Switching to XML.");
                fileXML = new File(FileUtil.setExtension((String)fileXML.getAbsolutePath(), (String)".avi.xml"));
                System.out.println("XML file name is : " + fileXML.getAbsolutePath());
            }
            this.file = fileXML;
            this.panel = GuiUtil.generatePanel((String)fileXML.getAbsolutePath());
            this.panel.setLayout(new BorderLayout());
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.saveImageButton}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.exportEventsAsXML}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.exportSpeedButton}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.computeVisionInFollowButton}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.computeVisionWhenStoppedButton}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.computeLocationHeatMapButton}));
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.computeUSVStat}));
            this.freezeSettingsCheckBox.setSelected(false);
            sidePanel2.add(GuiUtil.besidesPanel((Component[])new Component[]{this.freezeSettingsCheckBox}));
            this.computeVisionInFollowButton.addActionListener(this);
            this.computeVisionWhenStoppedButton.addActionListener(this);
            this.computeLocationHeatMapButton.addActionListener(this);
            this.computeUSVStat.addActionListener(this);
            this.exportEventsAsXML.addActionListener(this);
            this.panel.add((Component)sidePanel2, "Center");
            this.saveImageButton.addActionListener(this);
            this.exportSpeedButton.addActionListener(this);
            this.loadXML(fileXML);
            this.panel.add((Component)this.imageComponent, "East");
            this.imageComponent.setImage(this.imageChrono);
            this.imageComponent.addMouseListener(this);
            this.imageComponent.addMouseMotionListener(this);
            this.buildResultImage();
        }

        public boolean isFreezed() {
            return this.freezeSettingsCheckBox.isSelected();
        }

        String nbFrameToDisplayInSecond(float value) {
            value = (float)((int)(10.0f * value / MiceProfilerVideoLabelMakerInternal.this.FPS)) / 10.0f;
            return "" + value + "s";
        }

        public int trimAnalysisRecord() {
            int tMin = Integer.MAX_VALUE;
            int tMax = 0;
            for (int val : this.mouseARecord.keySet()) {
                if (val > tMax) {
                    tMax = val;
                }
                if (val >= tMin) continue;
                tMin = val;
            }
            for (int val : this.mouseBRecord.keySet()) {
                if (val > tMax) {
                    tMax = val;
                }
                if (val >= tMin) continue;
                tMin = val;
            }
            HashMap<Integer, MouseInfoRecord> mouseARecordReSorted = new HashMap<Integer, MouseInfoRecord>();
            HashMap<Integer, MouseInfoRecord> mouseBRecordReSorted = new HashMap<Integer, MouseInfoRecord>();
            if (tMin != 0) {
                boolean warningHasBeenDisplayed = false;
                for (int t = tMin; t < tMax; ++t) {
                    MouseInfoRecord a = this.mouseARecord.get(t);
                    MouseInfoRecord b = this.mouseBRecord.get(t);
                    if (a == null || b == null) {
                        String problem = "A tracking frame is missing at t=" + t + " in file " + this.file + ".";
                        System.out.println(problem);
                        if (warningHasBeenDisplayed) continue;
                        MessageDialog.showDialog((String)("<html><center>" + problem + " <hr>This Message appears once per animal file. <br>See ouput to get the total list of missing frames</html>"), (int)0);
                        warningHasBeenDisplayed = true;
                        continue;
                    }
                    mouseARecordReSorted.put(t - tMin, this.mouseARecord.get(t));
                    this.mouseARecord.remove(t);
                    mouseBRecordReSorted.put(t - tMin, this.mouseBRecord.get(t));
                    this.mouseBRecord.remove(t);
                }
                this.mouseARecord = mouseARecordReSorted;
                this.mouseBRecord = mouseBRecordReSorted;
            }
            return tMin;
        }

        public void buildResultImage() {
            double angleBA;
            double angleA;
            double VAy;
            MouseInfoRecord mouseAt2;
            MouseInfoRecord mouseBt2;
            double distanceTNext;
            double distanceTPrev;
            MouseInfoRecord mouseA;
            MouseInfoRecord mouseB;
            MouseInfoRecord mouseAprev;
            float minDistance;
            MouseInfoRecord mouseA2;
            int t;
            ArrayList eventContactList = new ArrayList();
            Icy.getMainInterface().getSwimmingPool().remove(this.swimmingObject);
            this.animal = new Animal(this.file.getName());
            this.swimmingObject = new SwimmingObject((Object)this.animal);
            boolean tMin = false;
            MiceProfilerVideoLabelMakerInternal.this.START_MINUTE = Integer.parseInt(MiceProfilerVideoLabelMakerInternal.this.computeImageStartMinuteTextField.getText());
            MiceProfilerVideoLabelMakerInternal.this.NB_MINUTE = Integer.parseInt(MiceProfilerVideoLabelMakerInternal.this.computeImageNbMinuteTextField.getText());
            this.firstFrame = (int)((float)tMin + (float)(MiceProfilerVideoLabelMakerInternal.this.START_MINUTE * 60) * MiceProfilerVideoLabelMakerInternal.this.FPS);
            this.lastFrame = (int)((float)this.firstFrame + (float)(MiceProfilerVideoLabelMakerInternal.this.NB_MINUTE * 60) * MiceProfilerVideoLabelMakerInternal.this.FPS);
            System.out.println("first frame : " + this.firstFrame);
            System.out.println("last frame : " + this.lastFrame);
            int tMax = this.lastFrame;
            int nbExtraEvent = 15;
            this.imageChrono = new BufferedImage(this.lastFrame - this.firstFrame, 480 + nbExtraEvent * MiceProfilerVideoLabelMakerInternal.this.stepY, 4);
            this.imageComponent.setImage(this.imageChrono);
            this.panel.updateUI();
            int currentY = 0;
            Graphics2D g2 = (Graphics2D)this.imageChrono.getGraphics();
            g2.fillRect(0, 0, this.imageChrono.getWidth(), this.imageChrono.getHeight());
            for (t = 0; t < tMax; ++t) {
                if (this.mouseARecord.containsKey(t)) {
                    MouseInfoRecord mouseA3 = this.mouseARecord.get(t);
                    if (mouseA3 == null) {
                        System.out.println("no mouse A record at t=" + t);
                    }
                    mouseA3.distanceIsInferiorToThreshold1 = false;
                    mouseA3.distanceIsInferiorToThreshold2 = false;
                    mouseA3.isEscaping = false;
                    mouseA3.isEscapingFromOtherAndUnTouch = false;
                    mouseA3.isGettingToOtherAndTouch = false;
                    mouseA3.isGoingToTheOther = false;
                    mouseA3.mouseGetToOtherMouseAndEscapeInOut = false;
                    mouseA3.mouseGetToOtherMouseAndOtherEscapeInOut = false;
                    mouseA3.eventA = false;
                    mouseA3.eventB = false;
                    mouseA3.eventC = false;
                    mouseA3.eventD = false;
                    mouseA3.isBehindTheOther = false;
                    mouseA3.isBesideTheOther = false;
                    mouseA3.thisHeadWithOtherGenitalContact = false;
                }
                if (!this.mouseBRecord.containsKey(t)) continue;
                MouseInfoRecord mouseB2 = this.mouseBRecord.get(t);
                mouseB2.distanceIsInferiorToThreshold1 = false;
                mouseB2.distanceIsInferiorToThreshold2 = false;
                mouseB2.isEscaping = false;
                mouseB2.isEscapingFromOtherAndUnTouch = false;
                mouseB2.isGettingToOtherAndTouch = false;
                mouseB2.isGoingToTheOther = false;
                mouseB2.mouseGetToOtherMouseAndEscapeInOut = false;
                mouseB2.mouseGetToOtherMouseAndOtherEscapeInOut = false;
                mouseB2.eventA = false;
                mouseB2.eventB = false;
                mouseB2.eventC = false;
                mouseB2.eventD = false;
                mouseB2.isBehindTheOther = false;
                mouseB2.isBesideTheOther = false;
                mouseB2.thisHeadWithOtherGenitalContact = false;
            }
            g2.setColor(Color.black);
            for (t = 0; t < tMax; ++t) {
                if (!((float)t % (MiceProfilerVideoLabelMakerInternal.this.FPS * 2.0f) < 1.0f)) continue;
                g2.drawString("" + (int)((float)t / (MiceProfilerVideoLabelMakerInternal.this.FPS * 60.0f)) + ":" + this.decimalFormat.format((int)((float)t / MiceProfilerVideoLabelMakerInternal.this.FPS % 60.0f)), t - this.firstFrame, currentY + 12);
                g2.drawLine(t - this.firstFrame, currentY, t - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
            }
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            this.imageComponent.stringList.add("Time");
            boolean event = false;
            int nbEvent = 0;
            int total = 0;
            EventTimeLine distanceLessThanThreshold1TimeLine = new EventTimeLine("Distance < thr 1", EventType.DISTANCE_INFERIOR_THRESHOLD_1, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(distanceLessThanThreshold1TimeLine);
            g2.setColor(Color.red);
            for (int t2 = 0; t2 < tMax; ++t2) {
                if (!this.mouseARecord.containsKey(t2) || !this.mouseBRecord.containsKey(t2)) continue;
                mouseA2 = this.mouseARecord.get(t2);
                MouseInfoRecord mouseB3 = this.mouseBRecord.get(t2);
                minDistance = Float.MAX_VALUE;
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB3.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB3.headPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB3.tailPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB3.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB3.headPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB3.tailPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB3.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB3.headPosition));
                if ((minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB3.tailPosition))) < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_1) {
                    distanceLessThanThreshold1TimeLine.addPunctualEvent(t2 - this.firstFrame);
                    mouseA2.distanceIsInferiorToThreshold1 = true;
                    mouseB3.distanceIsInferiorToThreshold1 = true;
                    continue;
                }
                mouseA2.distanceIsInferiorToThreshold1 = false;
                mouseB3.distanceIsInferiorToThreshold1 = false;
            }
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : distanceLessThanThreshold1TimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            String string = "Distance less than THRESHOLD 1 nbEvent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            this.imageComponent.stringList.add(string);
            event = false;
            nbEvent = 0;
            total = 0;
            EventTimeLine distanceLessThanThreshold2TimeLine = new EventTimeLine("Distance < thr 2", EventType.DISTANCE_INFERIOR_THRESHOLD_2, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(distanceLessThanThreshold2TimeLine);
            g2.setColor(Color.orange);
            for (int t3 = 0; t3 < tMax; ++t3) {
                if (!this.mouseARecord.containsKey(t3) || !this.mouseBRecord.containsKey(t3)) continue;
                mouseA2 = this.mouseARecord.get(t3);
                MouseInfoRecord mouseB4 = this.mouseBRecord.get(t3);
                minDistance = Float.MAX_VALUE;
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB4.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB4.headPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.bodyPosition.distance(mouseB4.tailPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB4.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB4.headPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB4.tailPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB4.bodyPosition));
                minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB4.headPosition));
                if ((minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB4.tailPosition))) < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_2) {
                    distanceLessThanThreshold2TimeLine.addPunctualEvent(t3 - this.firstFrame);
                    mouseA2.distanceIsInferiorToThreshold2 = true;
                    mouseB4.distanceIsInferiorToThreshold2 = true;
                    continue;
                }
                mouseA2.distanceIsInferiorToThreshold2 = false;
                mouseB4.distanceIsInferiorToThreshold2 = false;
            }
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : distanceLessThanThreshold2TimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Distance less than THRESHOLD 2 nbEvent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            this.imageComponent.stringList.add(string);
            event = false;
            nbEvent = 0;
            total = 0;
            EventTimeLine OralOralTimeLine = new EventTimeLine("Oral-Oral", EventType.ORAL_ORAL, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(OralOralTimeLine);
            g2.setColor(Color.black);
            for (int t4 = 0; t4 < tMax; ++t4) {
                if (!this.mouseARecord.containsKey(t4) || !this.mouseBRecord.containsKey(t4)) continue;
                mouseA2 = this.mouseARecord.get(t4);
                MouseInfoRecord mouseB5 = this.mouseBRecord.get(t4);
                minDistance = Float.MAX_VALUE;
                if (!((minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB5.headPosition))) < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_HEAD_HEAD)) continue;
                OralOralTimeLine.addPunctualEvent(t4 - this.firstFrame);
            }
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : OralOralTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Head - Head : nbevent: " + nbEvent + " TotalT=" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            this.imageComponent.stringList.add(string);
            event = false;
            nbEvent = 0;
            total = 0;
            EventTimeLine eventTimeLine = new EventTimeLine("Oral A - Genital B", EventType.ORAL_A_GENITAL_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            g2.setColor(Color.RED);
            for (int t5 = 0; t5 < tMax; ++t5) {
                if (!this.mouseARecord.containsKey(t5) || !this.mouseBRecord.containsKey(t5)) continue;
                mouseA2 = this.mouseARecord.get(t5);
                MouseInfoRecord mouseB6 = this.mouseBRecord.get(t5);
                minDistance = Float.MAX_VALUE;
                if (!((minDistance = this.getMin(minDistance, (float)mouseA2.headPosition.distance(mouseB6.tailPosition))) < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_HEAD_GENITAL)) continue;
                eventTimeLine.addPunctualEvent(t5 - this.firstFrame);
                mouseA2.thisHeadWithOtherGenitalContact = true;
            }
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            g2.drawLine(0, currentY - 1, this.imageChrono.getWidth(), currentY - 1);
            string = "Head A - Genital B nbEvent:" + nbEvent + " TotalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            this.imageComponent.stringList.add(string);
            event = false;
            nbEvent = 0;
            total = 0;
            eventTimeLine = new EventTimeLine("Oral B - Genital A", EventType.ORAL_B_GENITAL_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            g2.setColor(Color.GREEN);
            for (int t6 = 0; t6 < tMax; ++t6) {
                if (!this.mouseARecord.containsKey(t6) || !this.mouseBRecord.containsKey(t6)) continue;
                mouseA2 = this.mouseARecord.get(t6);
                MouseInfoRecord mouseB7 = this.mouseBRecord.get(t6);
                minDistance = Float.MAX_VALUE;
                if (!((minDistance = this.getMin(minDistance, (float)mouseA2.tailPosition.distance(mouseB7.headPosition))) < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_HEAD_GENITAL)) continue;
                eventTimeLine.addPunctualEvent(t6 - this.firstFrame);
                mouseB7.thisHeadWithOtherGenitalContact = true;
            }
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Head B - Genital A : nbEvent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event = false;
            nbEvent = 0;
            total = 0;
            eventTimeLine = new EventTimeLine("Mouse A behind B (any distance)", EventType.A_BEHIND_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            for (int t7 = 0; t7 < tMax; ++t7) {
                float mouseABodyToMouseBHead;
                if (!this.mouseARecord.containsKey(t7) || !this.mouseBRecord.containsKey(t7)) continue;
                mouseA2 = this.mouseARecord.get(t7);
                MouseInfoRecord mouseB8 = this.mouseBRecord.get(t7);
                float mouseABodyToMouseBTail = (float)mouseA2.bodyPosition.distance(mouseB8.tailPosition);
                if (!(mouseABodyToMouseBTail < (mouseABodyToMouseBHead = (float)mouseA2.bodyPosition.distance(mouseB8.headPosition)))) continue;
                eventTimeLine.addPunctualEvent(t7 - this.firstFrame);
                mouseA2.isBehindTheOther = true;
            }
            g2.setColor(Color.RED);
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            g2.drawLine(0, currentY - 1, this.imageChrono.getWidth(), currentY - 1);
            string = "Mouse A is behind B nbevent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event = false;
            nbEvent = 0;
            total = 0;
            eventTimeLine = new EventTimeLine("Mouse B behind A (any distance)", EventType.B_BEHIND_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            for (int t8 = 0; t8 < tMax; ++t8) {
                float mouseBBodyToMouseAHead;
                if (!this.mouseARecord.containsKey(t8) || !this.mouseBRecord.containsKey(t8)) continue;
                mouseA2 = this.mouseARecord.get(t8);
                MouseInfoRecord mouseB9 = this.mouseBRecord.get(t8);
                float mouseBBodyToMouseATail = (float)mouseB9.bodyPosition.distance(mouseA2.tailPosition);
                if (mouseBBodyToMouseATail < (mouseBBodyToMouseAHead = (float)mouseB9.bodyPosition.distance(mouseA2.headPosition))) {
                    eventTimeLine.addPunctualEvent(t8 - this.firstFrame);
                    mouseB9.isBehindTheOther = true;
                    continue;
                }
                event = false;
            }
            g2.setColor(Color.GREEN);
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B is behind A nbevent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event = false;
            nbEvent = 0;
            total = 0;
            eventTimeLine = new EventTimeLine("Mouse next to each other (same way) < distance 2", EventType.BESIDE_SAME_WAY, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            for (int t9 = 0; t9 < tMax; ++t9) {
                if (!this.mouseARecord.containsKey(t9) || !this.mouseBRecord.containsKey(t9)) continue;
                mouseA2 = this.mouseARecord.get(t9);
                MouseInfoRecord mouseB10 = this.mouseBRecord.get(t9);
                float mouseABodyToMouseBBody = (float)mouseA2.bodyPosition.distance(mouseB10.bodyPosition);
                float mouseAHeadToMouseBHead = (float)mouseA2.headPosition.distance(mouseB10.headPosition);
                double vectSourisAX = mouseA2.headPosition.getX() - mouseA2.bodyPosition.getX();
                double vectSourisAY = mouseA2.headPosition.getY() - mouseA2.bodyPosition.getY();
                double vectSourisBX = mouseB10.headPosition.getX() - mouseB10.bodyPosition.getX();
                double vectSourisBY = mouseB10.headPosition.getY() - mouseB10.bodyPosition.getY();
                double produitScalaire = vectSourisAX * vectSourisBX + vectSourisAY * vectSourisBY;
                double distance = Double.parseDouble(MiceProfilerVideoLabelMakerInternal.this.distance1TextField.getText());
                if (!(produitScalaire >= 0.0) || !(mouseAHeadToMouseBHead < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_1) || !(mouseABodyToMouseBBody < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_1)) continue;
                eventTimeLine.addPunctualEvent(t9 - this.firstFrame);
                mouseA2.isBesideTheOther = true;
                mouseB10.isBesideTheOther = true;
            }
            g2.setColor(Color.DARK_GRAY);
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mice are next to the each other and body distance < DISTANCE_2 (same way) nbevent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event = false;
            nbEvent = 0;
            total = 0;
            eventTimeLine = new EventTimeLine("Mouse next to each other (opposite way) < distance 2", EventType.BESIDE_OPPOSITE_WAY, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            for (int t10 = 0; t10 < tMax; ++t10) {
                if (!this.mouseARecord.containsKey(t10) || !this.mouseBRecord.containsKey(t10)) continue;
                mouseA2 = this.mouseARecord.get(t10);
                MouseInfoRecord mouseB11 = this.mouseBRecord.get(t10);
                double vectSourisAX = mouseA2.headPosition.getX() - mouseA2.bodyPosition.getX();
                double vectSourisAY = mouseA2.headPosition.getY() - mouseA2.bodyPosition.getY();
                double vectSourisBX = mouseB11.headPosition.getX() - mouseB11.bodyPosition.getX();
                double vectSourisBY = mouseB11.headPosition.getY() - mouseB11.bodyPosition.getY();
                double produitScalaire = vectSourisAX * vectSourisBX + vectSourisAY * vectSourisBY;
                float mouseABodyToMouseBHead = (float)mouseA2.bodyPosition.distance(mouseB11.headPosition);
                float mouseAHeadToMouseBBody = (float)mouseA2.headPosition.distance(mouseB11.bodyPosition);
                if (!(produitScalaire < 0.0) || !(mouseABodyToMouseBHead < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_1) || !(mouseAHeadToMouseBBody < MiceProfilerVideoLabelMakerInternal.this.SEUIL_DISTANCE_1)) continue;
                eventTimeLine.addPunctualEvent(t10 - this.firstFrame);
            }
            g2.setColor(Color.BLACK);
            nbEvent = 0;
            total = 0;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                ++nbEvent;
                total += eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mice are next to the each other and body distance < DISTANCE_2 (opposite) nbevent:" + nbEvent + " totalT:" + this.nbFrameToDisplayInSecond(total);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            int frameWindow = 6;
            EventTimeLine eventTimeLine2 = new EventTimeLine("Mouse A speed", EventType.MOUSE_A_SPEED, TimeLineCategory.USE_DISCRETE_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine2);
            float nbVal = 0.0f;
            float totalDistance = 0.0f;
            for (int t11 = 0; t11 < tMax; ++t11) {
                if (!this.mouseARecord.containsKey(t11 - frameWindow) || !this.mouseBRecord.containsKey(t11 - frameWindow) || !this.mouseARecord.containsKey(t11 + frameWindow) || !this.mouseBRecord.containsKey(t11 + frameWindow) || !this.mouseARecord.containsKey(t11) || !this.mouseBRecord.containsKey(t11)) continue;
                mouseAprev = this.mouseARecord.get(t11 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t11 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t11 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t11 + frameWindow);
                MouseInfoRecord mouseA4 = this.mouseARecord.get(t11);
                mouseB = this.mouseBRecord.get(t11);
                float distance = (float)mouseAprev.bodyPosition.distance(mouseAnext.bodyPosition);
                nbVal += 1.0f;
                totalDistance += (distance /= (float)(frameWindow * 2 + 1));
                mouseA4.speed = distance;
                eventTimeLine2.addValue(t11 - this.firstFrame, distance);
                if (distance <= MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) {
                    g2.setColor(Color.BLACK);
                    g2.drawLine(t11 - this.firstFrame, currentY, t11 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
                if (distance > MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1 && distance < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2) {
                    g2.setColor(Color.DARK_GRAY);
                    g2.drawLine(t11 - this.firstFrame, currentY, t11 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
                if (!(distance >= MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2)) continue;
                g2.setColor(Color.GRAY);
                g2.drawLine(t11 - this.firstFrame, currentY, t11 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
            }
            g2.setColor(Color.red);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A speed slow=black fast=gray mean speed: " + totalDistance / nbVal;
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine2 = new EventTimeLine("Mouse B speed", EventType.MOUSE_B_SPEED, TimeLineCategory.USE_DISCRETE_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine2);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            for (int t12 = 0; t12 < tMax; ++t12) {
                if (!this.mouseARecord.containsKey(t12 - frameWindow) || !this.mouseBRecord.containsKey(t12 - frameWindow) || !this.mouseARecord.containsKey(t12 + frameWindow) || !this.mouseBRecord.containsKey(t12 + frameWindow) || !this.mouseARecord.containsKey(t12) || !this.mouseBRecord.containsKey(t12)) continue;
                mouseAprev = this.mouseARecord.get(t12 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t12 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t12 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t12 + frameWindow);
                MouseInfoRecord mouseA5 = this.mouseARecord.get(t12);
                mouseB = this.mouseBRecord.get(t12);
                float distance = (float)mouseBprev.bodyPosition.distance(mouseBnext.bodyPosition);
                mouseB.speed = distance /= (float)(frameWindow * 2 + 1);
                nbVal += 1.0f;
                totalDistance += distance;
                eventTimeLine2.addValue(t12 - this.firstFrame, distance);
                if (distance <= MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) {
                    g2.setColor(Color.BLACK);
                    g2.drawLine(t12 - this.firstFrame, currentY, t12 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
                if (distance > MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1 && distance < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2) {
                    g2.setColor(Color.DARK_GRAY);
                    g2.drawLine(t12 - this.firstFrame, currentY, t12 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
                if (!(distance >= MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2)) continue;
                g2.setColor(Color.GRAY);
                g2.drawLine(t12 - this.firstFrame, currentY, t12 - this.firstFrame, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
            }
            g2.setColor(Color.red);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B speed slow=black fast=gray mean speed: " + totalDistance / nbVal;
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            boolean event2 = false;
            float nbEvent2 = 0.0f;
            float total2 = 0.0f;
            EventTimeLine eventTimeLine3 = new EventTimeLine("A Stop", EventType.A_STOP, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t13 = 0; t13 < tMax; ++t13) {
                if (!this.mouseARecord.containsKey(t13 - frameWindow) || !this.mouseBRecord.containsKey(t13 - frameWindow) || !this.mouseARecord.containsKey(t13 + frameWindow) || !this.mouseBRecord.containsKey(t13 + frameWindow) || !this.mouseARecord.containsKey(t13) || !this.mouseBRecord.containsKey(t13)) continue;
                MouseInfoRecord mouseAprev2 = this.mouseARecord.get(t13 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t13 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t13 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t13 + frameWindow);
                mouseA = this.mouseARecord.get(t13);
                MouseInfoRecord mouseB12 = this.mouseBRecord.get(t13);
                distanceTPrev = mouseAprev2.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (mouseA.speed < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) {
                    eventTimeLine3.addPunctualEvent(t13 - this.firstFrame);
                    continue;
                }
                event2 = false;
            }
            g2.setColor(Color.red);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            String string2 = "A Stop : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string2, 0, currentY + 12);
            this.imageComponent.stringList.add(string2);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event2 = false;
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            eventTimeLine3 = new EventTimeLine("B Stop", EventType.B_STOP, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t14 = 0; t14 < tMax; ++t14) {
                if (!this.mouseARecord.containsKey(t14 - frameWindow) || !this.mouseBRecord.containsKey(t14 - frameWindow) || !this.mouseARecord.containsKey(t14 + frameWindow) || !this.mouseBRecord.containsKey(t14 + frameWindow) || !this.mouseARecord.containsKey(t14) || !this.mouseBRecord.containsKey(t14)) continue;
                MouseInfoRecord mouseAprev3 = this.mouseARecord.get(t14 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t14 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t14 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t14 + frameWindow);
                mouseA = this.mouseARecord.get(t14);
                MouseInfoRecord mouseB13 = this.mouseBRecord.get(t14);
                distanceTPrev = mouseAprev3.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (mouseB13.speed < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) {
                    eventTimeLine3.addPunctualEvent(t14 - this.firstFrame);
                    continue;
                }
                event2 = false;
            }
            g2.setColor(Color.green);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "B Stop : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event2 = false;
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            eventTimeLine3 = new EventTimeLine("A Speed > B Speed & A GET TO B", EventType.A_SPEED_HIGHER_THAN_B_SPEED_AND_A_GET_TO_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t15 = 0; t15 < tMax; ++t15) {
                if (!this.mouseARecord.containsKey(t15 - frameWindow) || !this.mouseBRecord.containsKey(t15 - frameWindow) || !this.mouseARecord.containsKey(t15 + frameWindow) || !this.mouseBRecord.containsKey(t15 + frameWindow) || !this.mouseARecord.containsKey(t15) || !this.mouseBRecord.containsKey(t15)) continue;
                MouseInfoRecord mouseAprev4 = this.mouseARecord.get(t15 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t15 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t15 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t15 + frameWindow);
                mouseA = this.mouseARecord.get(t15);
                MouseInfoRecord mouseB14 = this.mouseBRecord.get(t15);
                distanceTPrev = mouseAprev4.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (mouseA.speed > mouseB14.speed) {
                    if (!(distanceTPrev > distanceTNext)) continue;
                    eventTimeLine3.addPunctualEvent(t15 - this.firstFrame);
                    mouseA.isGoingToTheOther = true;
                    continue;
                }
                event2 = false;
            }
            g2.setColor(Color.red);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A Speed > Mouse B Speed & Mouse A getting to B : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event2 = false;
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            eventTimeLine3 = new EventTimeLine("B Speed > A Speed & B GET TO A", EventType.B_SPEED_HIGHER_THAN_A_SPEED_AND_B_GET_TO_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t16 = 0; t16 < tMax; ++t16) {
                if (!this.mouseARecord.containsKey(t16 - frameWindow) || !this.mouseBRecord.containsKey(t16 - frameWindow) || !this.mouseARecord.containsKey(t16 + frameWindow) || !this.mouseBRecord.containsKey(t16 + frameWindow) || !this.mouseARecord.containsKey(t16) || !this.mouseBRecord.containsKey(t16)) continue;
                MouseInfoRecord mouseAprev5 = this.mouseARecord.get(t16 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t16 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t16 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t16 + frameWindow);
                mouseA = this.mouseARecord.get(t16);
                MouseInfoRecord mouseB15 = this.mouseBRecord.get(t16);
                distanceTPrev = mouseAprev5.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (mouseB15.speed > mouseA.speed) {
                    if (!(distanceTPrev > distanceTNext)) continue;
                    eventTimeLine3.addPunctualEvent(t16 - this.firstFrame);
                    mouseB15.isGoingToTheOther = true;
                    continue;
                }
                event2 = false;
            }
            g2.setColor(Color.green);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B Speed > Mouse A Speed & Mouse B getting to A : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event2 = false;
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            eventTimeLine3 = new EventTimeLine("A Speed > B Speed & A escape B", EventType.A_SPEED_HIGHER_THAN_B_SPEED_AND_A_ESCAPE_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t17 = 0; t17 < tMax; ++t17) {
                if (!this.mouseARecord.containsKey(t17 - frameWindow) || !this.mouseBRecord.containsKey(t17 - frameWindow) || !this.mouseARecord.containsKey(t17 + frameWindow) || !this.mouseBRecord.containsKey(t17 + frameWindow) || !this.mouseARecord.containsKey(t17) || !this.mouseBRecord.containsKey(t17)) continue;
                MouseInfoRecord mouseAprev6 = this.mouseARecord.get(t17 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t17 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t17 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t17 + frameWindow);
                mouseA = this.mouseARecord.get(t17);
                MouseInfoRecord mouseB16 = this.mouseBRecord.get(t17);
                distanceTPrev = mouseAprev6.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (!(mouseA.speed > mouseB16.speed)) continue;
                if (distanceTPrev < distanceTNext) {
                    eventTimeLine3.addPunctualEvent(t17 - this.firstFrame);
                    mouseA.isEscaping = true;
                    continue;
                }
                mouseA.isEscaping = false;
            }
            g2.setColor(Color.red);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A Speed > Mouse B Speed & Mouse A escaping from B : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            event2 = false;
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            eventTimeLine3 = new EventTimeLine("B Speed > A Speed & B escape A", EventType.B_SPEED_HIGHER_THAN_A_SPEED_AND_B_ESCAPE_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine3);
            for (int t18 = 0; t18 < tMax; ++t18) {
                if (!this.mouseARecord.containsKey(t18 - frameWindow) || !this.mouseBRecord.containsKey(t18 - frameWindow) || !this.mouseARecord.containsKey(t18 + frameWindow) || !this.mouseBRecord.containsKey(t18 + frameWindow) || !this.mouseARecord.containsKey(t18) || !this.mouseBRecord.containsKey(t18)) continue;
                MouseInfoRecord mouseAprev7 = this.mouseARecord.get(t18 - frameWindow);
                MouseInfoRecord mouseBprev = this.mouseBRecord.get(t18 - frameWindow);
                MouseInfoRecord mouseAnext = this.mouseARecord.get(t18 + frameWindow);
                MouseInfoRecord mouseBnext = this.mouseBRecord.get(t18 + frameWindow);
                mouseA = this.mouseARecord.get(t18);
                MouseInfoRecord mouseB17 = this.mouseBRecord.get(t18);
                distanceTPrev = mouseAprev7.bodyPosition.distance(mouseBprev.bodyPosition);
                distanceTNext = mouseAnext.bodyPosition.distance(mouseBnext.bodyPosition);
                if (!(mouseB17.speed > mouseA.speed)) continue;
                if (distanceTPrev < distanceTNext) {
                    eventTimeLine3.addPunctualEvent(t18 - this.firstFrame);
                    mouseB17.isEscaping = true;
                    continue;
                }
                mouseB17.isEscaping = false;
            }
            g2.setColor(Color.green);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine3.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B Speed > Mouse A Speed & Mouse B escaping from A : nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("Mouse A going to B and finishing with contact starting from no contact", EventType.A_GOTO_B_FINISH_CONTACT_START_NO_CONTACT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (int t19 = 0; t19 < tMax; ++t19) {
                MouseInfoRecord mouseAt22;
                int t2;
                if (!this.mouseARecord.containsKey(t19) || !this.mouseBRecord.containsKey(t19)) continue;
                MouseInfoRecord mouseA6 = this.mouseARecord.get(t19);
                MouseInfoRecord mouseB18 = this.mouseBRecord.get(t19);
                if (!mouseA6.distanceIsInferiorToThreshold1) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                block50: for (t2 = t19; t2 > 0; --t2) {
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt22 = this.mouseARecord.get(t2);
                    if (mouseAt22.isGoingToTheOther) {
                        timeToFill.add(t2);
                        if (mouseAt22.distanceIsInferiorToThreshold1) continue;
                        for (int t3 = t2; t3 > 0; --t3) {
                            if (!this.mouseARecord.containsKey(t3)) continue;
                            MouseInfoRecord mouseAt3 = this.mouseARecord.get(t3);
                            if (!mouseAt3.isGoingToTheOther) break block50;
                            timeToFill.add(t3);
                        }
                        break;
                    }
                    if (!mouseAt22.distanceIsInferiorToThreshold1) break;
                    timeToFill.clear();
                    break;
                }
                if (timeToFill.size() > 0) {
                    t2 = t19 + 1;
                    while (t2 < tMax) {
                        mouseAt22 = this.mouseARecord.get(t2);
                        if (!mouseAt22.isGoingToTheOther) break;
                        timeToFill.add(t2);
                        t19 = t2++;
                    }
                }
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    MouseInfoRecord mouseAt23 = this.mouseARecord.get(index);
                    mouseAt23.isGettingToOtherAndTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                }
            }
            g2.setColor(Color.red);
            nbEvent2 = 0.0f;
            total2 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent2 += 1.0f;
                total2 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A going to B and finishing with contact starting from no contact.: nbEvent : " + nbEvent2 + " total: " + this.nbFrameToDisplayInSecond(total2);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("Mouse B going to A and finishing with contact and starting from no contact", EventType.B_GOTO_A_FINISH_CONTACT_START_NO_CONTACT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            float nbEvent3 = 0.0f;
            float total3 = 0.0f;
            for (int t20 = 0; t20 < tMax; ++t20) {
                MouseInfoRecord mouseBt22;
                int t2;
                if (!this.mouseARecord.containsKey(t20) || !this.mouseBRecord.containsKey(t20)) continue;
                MouseInfoRecord mouseA7 = this.mouseARecord.get(t20);
                MouseInfoRecord mouseB19 = this.mouseBRecord.get(t20);
                if (!mouseA7.distanceIsInferiorToThreshold1) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                block57: for (t2 = t20; t2 > 0; --t2) {
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt22 = this.mouseBRecord.get(t2);
                    if (mouseBt22.isGoingToTheOther) {
                        timeToFill.add(t2);
                        if (mouseBt22.distanceIsInferiorToThreshold1) continue;
                        for (int t3 = t2; t3 > 0; --t3) {
                            if (!this.mouseBRecord.containsKey(t3)) continue;
                            MouseInfoRecord mouseBt3 = this.mouseBRecord.get(t3);
                            if (!mouseBt3.isGoingToTheOther) break block57;
                            timeToFill.add(t3);
                        }
                        break;
                    }
                    if (!mouseBt22.distanceIsInferiorToThreshold1) break;
                    timeToFill.clear();
                    break;
                }
                if (timeToFill.size() > 0) {
                    t2 = t20 + 1;
                    while (t2 < tMax) {
                        mouseBt22 = this.mouseBRecord.get(t2);
                        if (!mouseBt22.isGoingToTheOther) break;
                        timeToFill.add(t2);
                        t20 = t2++;
                    }
                }
                g2.setColor(Color.green);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    MouseInfoRecord mouseBt23 = this.mouseBRecord.get(index);
                    mouseBt23.isGettingToOtherAndTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                }
            }
            g2.setColor(Color.green);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            String string3 = "Mouse B going to A and finishing with contact starting from no contact.: nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string3, 0, currentY + 12);
            this.imageComponent.stringList.add(string3);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("Mouse A escaping after contact. finish with out threshold.", EventType.A_ESCAPE_AFTER_CONTACT_FINISH_WITH_NO_CONTACT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t21 = 0; t21 < tMax; ++t21) {
                if (!this.mouseARecord.containsKey(t21) || !this.mouseBRecord.containsKey(t21)) continue;
                MouseInfoRecord mouseA8 = this.mouseARecord.get(t21);
                MouseInfoRecord mouseB20 = this.mouseBRecord.get(t21);
                if (!mouseA8.distanceIsInferiorToThreshold1) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                block64: for (int t2 = t21; t2 < Integer.MAX_VALUE && this.mouseARecord.containsKey(t2); ++t2) {
                    MouseInfoRecord mouseAt24 = this.mouseARecord.get(t2);
                    if (mouseAt24.isEscaping) {
                        timeToFill.add(t2);
                        if (mouseAt24.distanceIsInferiorToThreshold1) continue;
                        for (int t3 = t2; t3 < tMax; ++t3) {
                            if (!this.mouseARecord.containsKey(t3)) continue;
                            MouseInfoRecord mouseAt3 = this.mouseARecord.get(t3);
                            if (!mouseAt3.isEscaping) break block64;
                            timeToFill.add(t3);
                        }
                        break;
                    }
                    if (!mouseAt24.distanceIsInferiorToThreshold1) break;
                    timeToFill.clear();
                    break;
                }
                g2.setColor(Color.red);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    MouseInfoRecord mouseAt25 = this.mouseARecord.get(index);
                    mouseAt25.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                }
                t21 += timeToFill.size();
            }
            g2.setColor(Color.red);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A escaping after contact and finish out of distance threshold. : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("Mouse B escaping after contact. finish with out threshold.", EventType.B_ESCAPE_AFTER_CONTACT_FINISH_WITH_NO_CONTACT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t22 = 0; t22 < tMax; ++t22) {
                if (!this.mouseARecord.containsKey(t22) || !this.mouseBRecord.containsKey(t22)) continue;
                MouseInfoRecord mouseA9 = this.mouseARecord.get(t22);
                MouseInfoRecord mouseB21 = this.mouseBRecord.get(t22);
                if (!mouseA9.distanceIsInferiorToThreshold1) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                block70: for (int t2 = t22; t2 < Integer.MAX_VALUE && this.mouseBRecord.containsKey(t2); ++t2) {
                    MouseInfoRecord mouseBt24 = this.mouseBRecord.get(t2);
                    if (mouseBt24.isEscaping) {
                        timeToFill.add(t2);
                        if (mouseBt24.distanceIsInferiorToThreshold1) continue;
                        for (int t3 = t2; t3 < tMax; ++t3) {
                            if (!this.mouseBRecord.containsKey(t3)) continue;
                            MouseInfoRecord mouseBt3 = this.mouseBRecord.get(t3);
                            if (!mouseBt3.isEscaping) break block70;
                            timeToFill.add(t3);
                        }
                        break;
                    }
                    if (!mouseBt24.distanceIsInferiorToThreshold1) break;
                    timeToFill.clear();
                    break;
                }
                g2.setColor(Color.green);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    MouseInfoRecord mouseBt25 = this.mouseBRecord.get(index);
                    mouseBt25.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                }
                t22 += timeToFill.size();
            }
            g2.setColor(Color.green);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B escaping after contact and finish out of distance threshold : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("A get to B and B escape threshold in and out", EventType.A_GOTO_B_AND_B_ESCAPE_THRESHOLD_IN_OUT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t23 = 0; t23 < tMax; ++t23) {
                MouseInfoRecord mouseAt26;
                int seeker;
                int t2;
                if (!this.mouseARecord.containsKey(t23) || !this.mouseBRecord.containsKey(t23)) continue;
                MouseInfoRecord mouseA10 = this.mouseARecord.get(t23);
                MouseInfoRecord mouseB22 = this.mouseBRecord.get(t23);
                if (!mouseA10.isGettingToOtherAndTouch) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                boolean step1ok = false;
                boolean step2ok = false;
                boolean step3ok = false;
                for (t2 = seeker = t23; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt26 = this.mouseARecord.get(t2);
                    if (mouseAt26.isGettingToOtherAndTouch) {
                        timeToFill.add(t2);
                        continue;
                    }
                    step1ok = true;
                    break;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt26 = this.mouseARecord.get(t2);
                    if (mouseAt26.distanceIsInferiorToThreshold1) {
                        timeToFill.add(t2);
                        continue;
                    }
                    step2ok = true;
                    break;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    MouseInfoRecord mouseBt26 = this.mouseBRecord.get(t2);
                    if (!mouseBt26.isEscapingFromOtherAndUnTouch) break;
                    timeToFill.add(t2);
                    step3ok = true;
                }
                if (!(step1ok && step2ok && step3ok)) {
                    timeToFill.clear();
                }
                g2.setColor(Color.red);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    mouseBt2 = this.mouseBRecord.get(index);
                    mouseBt2.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                    this.mouseARecord.get((Object)Integer.valueOf((int)index)).mouseGetToOtherMouseAndOtherEscapeInOut = true;
                }
                t23 += timeToFill.size();
            }
            g2.setColor(Color.red);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            g2.drawLine(0, currentY + 1, this.imageChrono.getWidth(), currentY + 1);
            string = "Mouse A get to mouse B and B escape with threshold distance in and out : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("B get to A and A escape threshold in and out", EventType.B_GOTO_A_AND_A_ESCAPE_THRESHOLD_IN_OUT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t24 = 0; t24 < tMax; ++t24) {
                MouseInfoRecord mouseBt27;
                int seeker;
                int t2;
                if (!this.mouseARecord.containsKey(t24) || !this.mouseBRecord.containsKey(t24)) continue;
                MouseInfoRecord mouseA11 = this.mouseARecord.get(t24);
                MouseInfoRecord mouseB23 = this.mouseBRecord.get(t24);
                if (!mouseB23.isGettingToOtherAndTouch) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                boolean step1ok = false;
                boolean step2ok = false;
                boolean step3ok = false;
                for (t2 = seeker = t24; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt27 = this.mouseBRecord.get(t2);
                    if (mouseBt27.isGettingToOtherAndTouch) {
                        timeToFill.add(t2);
                        continue;
                    }
                    step1ok = true;
                    break;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt27 = this.mouseBRecord.get(t2);
                    if (mouseBt27.distanceIsInferiorToThreshold1) {
                        timeToFill.add(t2);
                        continue;
                    }
                    step2ok = true;
                    break;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    MouseInfoRecord mouseAt27 = this.mouseARecord.get(t2);
                    if (!mouseAt27.isEscapingFromOtherAndUnTouch) break;
                    timeToFill.add(t2);
                    step3ok = true;
                }
                if (!(step1ok && step2ok && step3ok)) {
                    timeToFill.clear();
                }
                g2.setColor(Color.green);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    mouseAt2 = this.mouseARecord.get(index);
                    mouseAt2.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                    this.mouseBRecord.get((Object)Integer.valueOf((int)index)).mouseGetToOtherMouseAndOtherEscapeInOut = true;
                }
                t24 += timeToFill.size();
            }
            g2.setColor(Color.green);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B get to mouse A and A escape with threshold distance in and out : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("A get to B and A escape threshold in and out", EventType.A_GOTO_B_AND_A_ESCAPE_THRESHOLD_IN_OUT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t25 = 0; t25 < tMax; ++t25) {
                MouseInfoRecord mouseAt28;
                int seeker;
                int t2;
                if (!this.mouseARecord.containsKey(t25) || !this.mouseBRecord.containsKey(t25)) continue;
                MouseInfoRecord mouseA12 = this.mouseARecord.get(t25);
                MouseInfoRecord mouseB24 = this.mouseBRecord.get(t25);
                if (!mouseA12.isGettingToOtherAndTouch) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                boolean step1ok = false;
                boolean step2ok = false;
                boolean step3ok = false;
                for (t2 = seeker = t25; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt28 = this.mouseARecord.get(t2);
                    if (!mouseAt28.isGettingToOtherAndTouch) break;
                    timeToFill.add(t2);
                    step1ok = true;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt28 = this.mouseARecord.get(t2);
                    if (!mouseAt28.distanceIsInferiorToThreshold1) break;
                    timeToFill.add(t2);
                    step2ok = true;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseARecord.containsKey(t2)) continue;
                    mouseAt28 = this.mouseARecord.get(t2);
                    if (!mouseAt28.isEscapingFromOtherAndUnTouch) break;
                    timeToFill.add(t2);
                    step3ok = true;
                }
                if (!(step1ok && step2ok && step3ok)) {
                    timeToFill.clear();
                }
                g2.setColor(Color.red);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    mouseBt2 = this.mouseBRecord.get(index);
                    mouseBt2.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                    this.mouseARecord.get((Object)Integer.valueOf((int)index)).mouseGetToOtherMouseAndEscapeInOut = true;
                }
                t25 += timeToFill.size();
            }
            g2.setColor(Color.red);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            g2.drawLine(0, currentY + 1, this.imageChrono.getWidth(), currentY + 1);
            string = "Mouse A get to mouse B and A escape with threshold distance in and out : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("B get to A and B escape threshold in and out", EventType.B_GOTO_A_AND_B_ESCAPE_THRESHOLD_IN_OUT, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (int t26 = 0; t26 < tMax; ++t26) {
                MouseInfoRecord mouseBt28;
                int seeker;
                int t2;
                if (!this.mouseARecord.containsKey(t26) || !this.mouseBRecord.containsKey(t26)) continue;
                MouseInfoRecord mouseA13 = this.mouseARecord.get(t26);
                MouseInfoRecord mouseB25 = this.mouseBRecord.get(t26);
                if (!mouseB25.isGettingToOtherAndTouch) continue;
                ArrayList<Integer> timeToFill = new ArrayList<Integer>();
                boolean step1ok = false;
                boolean step2ok = false;
                boolean step3ok = false;
                for (t2 = seeker = t26; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt28 = this.mouseBRecord.get(t2);
                    if (!mouseBt28.isGettingToOtherAndTouch) break;
                    timeToFill.add(t2);
                    step1ok = true;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt28 = this.mouseBRecord.get(t2);
                    if (!mouseBt28.distanceIsInferiorToThreshold1) break;
                    timeToFill.add(t2);
                    step2ok = true;
                }
                for (t2 = seeker; t2 < tMax; ++t2) {
                    seeker = t2;
                    if (!this.mouseBRecord.containsKey(t2)) continue;
                    mouseBt28 = this.mouseBRecord.get(t2);
                    if (!mouseBt28.isEscapingFromOtherAndUnTouch) break;
                    timeToFill.add(t2);
                    step3ok = true;
                }
                if (!(step1ok && step2ok && step3ok)) {
                    timeToFill.clear();
                }
                g2.setColor(Color.green);
                if (timeToFill.size() > 0) {
                    nbEvent3 += 1.0f;
                }
                total3 += (float)timeToFill.size();
                for (int i = 0; i < timeToFill.size(); ++i) {
                    int index = (Integer)timeToFill.get(i);
                    mouseAt2 = this.mouseARecord.get(index);
                    mouseAt2.isEscapingFromOtherAndUnTouch = true;
                    eventTimeLine.addPunctualEvent(index - this.firstFrame);
                    this.mouseBRecord.get((Object)Integer.valueOf((int)index)).mouseGetToOtherMouseAndEscapeInOut = true;
                }
                t26 += timeToFill.size();
            }
            g2.setColor(Color.green);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B get to mouse A and B escape with threshold distance in and out : nbEvent : " + nbEvent3 + " total: " + this.nbFrameToDisplayInSecond(total3);
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
            eventTimeLine = new EventTimeLine("A follow B", EventType.A_FOLLOW_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            Object currentCriteria = null;
            for (int t27 = 0; t27 < tMax; ++t27) {
                if (!this.mouseARecord.containsKey(t27) || !this.mouseBRecord.containsKey(t27)) continue;
                MouseInfoRecord mouseA14 = this.mouseARecord.get(t27);
                MouseInfoRecord mouseB26 = this.mouseBRecord.get(t27);
                double distanceHeadABodyB = mouseA14.headPosition.distanceSq(mouseB26.bodyPosition);
                double distanceHeadAHeadB = mouseA14.headPosition.distanceSq(mouseB26.headPosition);
                double distanceBodyABodyB = mouseA14.bodyPosition.distanceSq(mouseB26.bodyPosition);
                double distanceBodyAHeadB = mouseA14.bodyPosition.distanceSq(mouseB26.headPosition);
                if (!mouseB26.distanceIsInferiorToThreshold2 || !(mouseA14.speed > MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2) || !(mouseB26.speed > MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_2) || !mouseA14.isBehindTheOther && !mouseA14.isBesideTheOther) continue;
                eventTimeLine.addPunctualEvent(t27 - this.firstFrame);
            }
            eventTimeLine.removeEventLessThanLength(3);
            g2.setColor(Color.RED);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            String string4 = "Mouse A poursuit B : nbEvent : " + nbEvent3 + " total time: " + total3 / MiceProfilerVideoLabelMakerInternal.this.FPS + "s";
            g2.drawString(string4, 0, currentY + 12);
            this.imageComponent.stringList.add(string4);
            g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
            eventTimeLine = new EventTimeLine("back to back", EventType.A_BEHIND_B_AND_B_BEHIND_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            currentCriteria = null;
            for (int t28 = 0; t28 < tMax; ++t28) {
                if (!this.mouseARecord.containsKey(t28) || !this.mouseBRecord.containsKey(t28)) continue;
                MouseInfoRecord mouseA15 = this.mouseARecord.get(t28);
                MouseInfoRecord mouseB27 = this.mouseBRecord.get(t28);
                double distanceHeadABodyB = mouseA15.headPosition.distanceSq(mouseB27.bodyPosition);
                double distanceHeadAHeadB = mouseA15.headPosition.distanceSq(mouseB27.headPosition);
                double distanceBodyABodyB = mouseA15.bodyPosition.distanceSq(mouseB27.bodyPosition);
                double distanceBodyAHeadB = mouseA15.bodyPosition.distanceSq(mouseB27.headPosition);
                double VAx = mouseA15.headPosition.getX() - mouseA15.bodyPosition.getX();
                VAy = mouseA15.headPosition.getY() - mouseA15.bodyPosition.getY();
                angleA = Math.atan2(VAy, VAx);
                double VBx = mouseB27.headPosition.getX() - mouseB27.bodyPosition.getX();
                double VBy = mouseB27.headPosition.getY() - mouseB27.bodyPosition.getY();
                double angleB = Math.atan2(VBy, VBx);
                double VABx = mouseB27.bodyPosition.getX() - mouseA15.bodyPosition.getX();
                double VABy = mouseB27.bodyPosition.getY() - mouseA15.bodyPosition.getY();
                double angleAB = Math.atan2(VABy, VABx);
                angleB -= Math.PI;
                double minAngle = Double.MAX_VALUE;
                for (double a = -4.0; a < 5.0; a += 1.0) {
                    double testVal = Math.abs(angleB + Math.PI * 2 * a - angleA);
                    if (!(testVal < minAngle)) continue;
                    minAngle = testVal;
                }
                double minAngleABwithA = Double.MAX_VALUE;
                for (double a = -4.0; a < 5.0; a += 1.0) {
                    double testVal = Math.abs(angleA + Math.PI * a - angleAB);
                    if (!(testVal < minAngleABwithA)) continue;
                    minAngleABwithA = testVal;
                }
                double minAngleABwithB = Double.MAX_VALUE;
                for (double a = -4.0; a < 5.0; a += 1.0) {
                    double testVal = Math.abs(angleB + Math.PI * a - angleAB);
                    if (!(testVal < minAngleABwithB)) continue;
                    minAngleABwithB = testVal;
                }
                if (!(mouseA15.speed < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) || !(mouseB27.speed < MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1) || mouseA15.distanceIsInferiorToThreshold2 || !(minAngle < 0.52) || !mouseA15.isBehindTheOther || !mouseB27.isBehindTheOther || !(minAngleABwithA < 0.52) || !(minAngleABwithB < 0.52)) continue;
                eventTimeLine.addPunctualEvent(t28 - this.firstFrame);
            }
            eventTimeLine.removeEventLessThanLength(3);
            g2.setColor(Color.gray);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Back to back: nbEvent : " + nbEvent3 + " total time: " + total3 / MiceProfilerVideoLabelMakerInternal.this.FPS + "s";
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
            eventTimeLine = new EventTimeLine("A can see B", EventType.A_CAN_SEE_B, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            currentCriteria = null;
            for (int t29 = 0; t29 < tMax; ++t29) {
                if (!this.mouseARecord.containsKey(t29) || !this.mouseBRecord.containsKey(t29)) continue;
                MouseInfoRecord mouseA16 = this.mouseARecord.get(t29);
                MouseInfoRecord mouseB28 = this.mouseBRecord.get(t29);
                double distanceHeadABodyB = mouseA16.headPosition.distanceSq(mouseB28.bodyPosition);
                double distanceHeadAHeadB = mouseA16.headPosition.distanceSq(mouseB28.headPosition);
                double distanceBodyABodyB = mouseA16.bodyPosition.distanceSq(mouseB28.bodyPosition);
                double distanceBodyAHeadB = mouseA16.bodyPosition.distanceSq(mouseB28.headPosition);
                double VAx = mouseA16.headPosition.getX() - mouseA16.bodyPosition.getX();
                VAy = mouseA16.headPosition.getY() - mouseA16.bodyPosition.getY();
                angleA = Math.atan2(VAy, VAx);
                double VABx = mouseA16.headPosition.getX() - mouseB28.headPosition.getX();
                double VABy = mouseA16.headPosition.getY() - mouseB28.headPosition.getY();
                angleBA = Math.atan2(VABy, VABx) + Math.PI;
                boolean eventIsOk = true;
                if (!(this.angleMin(angleBA, angleA) < this.demiVisionDeSouris)) {
                    eventIsOk = false;
                }
                if (mouseA16.distanceIsInferiorToThreshold2) {
                    eventIsOk = false;
                }
                if (!eventIsOk) continue;
                eventTimeLine.addPunctualEvent(t29 - this.firstFrame);
            }
            eventTimeLine.removeEventLessThanLength(3);
            g2.setColor(Color.RED);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse A can see B: nbEvent : " + nbEvent3 + " total time: " + total3 / MiceProfilerVideoLabelMakerInternal.this.FPS + "s";
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            currentY += MiceProfilerVideoLabelMakerInternal.this.stepY;
            eventTimeLine = new EventTimeLine("B can see A", EventType.B_CAN_SEE_A, TimeLineCategory.USE_BOOLEAN_EVENT);
            this.animal.eventTimeLineList.add(eventTimeLine);
            nbVal = 0.0f;
            totalDistance = 0.0f;
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            currentCriteria = null;
            for (int t30 = 0; t30 < tMax; ++t30) {
                if (!this.mouseARecord.containsKey(t30) || !this.mouseBRecord.containsKey(t30)) continue;
                MouseInfoRecord mouseA17 = this.mouseARecord.get(t30);
                MouseInfoRecord mouseB29 = this.mouseBRecord.get(t30);
                double distanceHeadABodyB = mouseA17.headPosition.distanceSq(mouseB29.bodyPosition);
                double distanceHeadAHeadB = mouseA17.headPosition.distanceSq(mouseB29.headPosition);
                double distanceBodyABodyB = mouseA17.bodyPosition.distanceSq(mouseB29.bodyPosition);
                double distanceBodyAHeadB = mouseA17.bodyPosition.distanceSq(mouseB29.headPosition);
                double VBx = mouseB29.headPosition.getX() - mouseB29.bodyPosition.getX();
                double VBy = mouseB29.headPosition.getY() - mouseB29.bodyPosition.getY();
                double angleB = Math.atan2(VBy, VBx);
                double VBAx = mouseB29.headPosition.getX() - mouseA17.headPosition.getX();
                double VBAy = mouseB29.headPosition.getY() - mouseA17.headPosition.getY();
                angleBA = Math.atan2(VBAy, VBAx) + Math.PI;
                boolean eventIsOk = true;
                if (!(this.angleMin(angleBA, angleB) < this.demiVisionDeSouris)) {
                    eventIsOk = false;
                }
                if (!eventIsOk) continue;
                eventTimeLine.addPunctualEvent(t30 - this.firstFrame);
            }
            eventTimeLine.removeEventLessThanLength(3);
            g2.setColor(Color.GREEN);
            nbEvent3 = 0.0f;
            total3 = 0.0f;
            for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                nbEvent3 += 1.0f;
                total3 += (float)eventCriteria.getLength();
                for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                    g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                }
            }
            g2.setColor(Color.black);
            g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
            string = "Mouse B can see A: nbEvent : " + nbEvent3 + " total time: " + total3 / MiceProfilerVideoLabelMakerInternal.this.FPS + "s";
            g2.drawString(string, 0, currentY + 12);
            this.imageComponent.stringList.add(string);
            g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
            currentY = this.loadExtraLabelXMLFile(this.file, currentY, g2);
            currentY = this.loadExtraLabelAviSoftTXTFile(this.file, currentY, g2);
            Icy.getMainInterface().getSwimmingPool().add(this.swimmingObject);
        }

        private File getExtraXMLFile(File originalFile) {
            File extraFile = new File(FileUtil.setExtension((String)this.file.getAbsolutePath(), (String)".extra.xml"));
            return extraFile;
        }

        private File getExtraAviSoftTXTFile(File originalFile) {
            File extraFile = new File(FileUtil.setExtension((String)this.file.getAbsolutePath(), (String)".avisoft.txt"));
            return extraFile;
        }

        private File getExtraAviSoftXLSFile(File originalFile) {
            File extraFile = new File(FileUtil.setExtension((String)this.file.getAbsolutePath(), (String)".avisoft.xls"));
            return extraFile;
        }

        private int getNbExtraEvent(File originalFile) {
            HashMap<String, Integer> eventFoundHashMap;
            int nbExtraEvent = 0;
            File extraFile = this.getExtraXMLFile(originalFile);
            if (extraFile.exists()) {
                Document xmlDocument = XMLUtil.loadDocument((File)extraFile);
                ArrayList labelElementList = XMLUtil.getElements((Node)XMLUtil.getRootElement((Document)xmlDocument), (String)"LABEL");
                System.out.println("Number of extra user labels (XML): " + labelElementList.size());
                nbExtraEvent += labelElementList.size();
            }
            if ((extraFile = this.getExtraAviSoftTXTFile(originalFile)).exists()) {
                int nbElement = 0;
                eventFoundHashMap = new HashMap<String, Integer>();
                try {
                    Scanner scanner = new Scanner(extraFile);
                    while (scanner.hasNextLine()) {
                        int line = scanner.nextInt();
                        String labelName = scanner.next();
                        int nbLabelWithThisName = 0;
                        if (eventFoundHashMap.containsKey(labelName)) {
                            nbLabelWithThisName = (Integer)eventFoundHashMap.get(labelName);
                        }
                        eventFoundHashMap.put(labelName, nbLabelWithThisName + 1);
                        scanner.nextLine();
                    }
                    for (String labelName : eventFoundHashMap.keySet()) {
                        System.out.println("Label Name : " + labelName + " #" + eventFoundHashMap.get(labelName));
                    }
                    nbElement += eventFoundHashMap.keySet().size();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                System.out.println("Number of extra user labels (AviSoft TXT): " + nbElement);
                nbExtraEvent += nbElement;
            }
            if ((extraFile = this.getExtraAviSoftXLSFile(originalFile)).exists()) {
                int nbElement = 0;
                eventFoundHashMap = new HashMap();
                try {
                    Workbook workbook = Workbook.getWorkbook((File)extraFile);
                    Sheet sheet = workbook.getSheet(0);
                    int nbRow = sheet.getRows();
                    System.out.println("Number of row in excel file: " + nbRow);
                    for (int row = 1; row < nbRow; ++row) {
                        String labelName = sheet.getCell(1, row).getContents();
                        int nbLabelWithThisName = 0;
                        if (eventFoundHashMap.containsKey(labelName)) {
                            nbLabelWithThisName = (Integer)eventFoundHashMap.get(labelName);
                        }
                        eventFoundHashMap.put(labelName, nbLabelWithThisName + 1);
                    }
                    for (String labelName : eventFoundHashMap.keySet()) {
                        System.out.println("Label Name : " + labelName + " #" + eventFoundHashMap.get(labelName));
                    }
                    nbElement += eventFoundHashMap.keySet().size();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (BiffException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Number of extra user labels (AviSoft XLS): " + nbElement);
                nbExtraEvent += nbElement;
            }
            return nbExtraEvent;
        }

        private int loadExtraLabelAviSoftTXTFile(File originalFile, int currentY, Graphics2D g2) {
            File extraFile = this.getExtraAviSoftTXTFile(originalFile);
            if (extraFile.exists()) {
                int nbElement = 0;
                HashMap<String, EventTimeLine> eventTimeLineHashMap = new HashMap<String, EventTimeLine>();
                try {
                    this.loadDefaultUserEventSet(eventTimeLineHashMap, originalFile);
                    Scanner scanner = new Scanner(extraFile);
                    while (scanner.hasNextLine()) {
                        int startTimeInFrame;
                        int lineNumber = scanner.nextInt();
                        System.out.println("next line number : " + lineNumber);
                        String labelName = scanner.next();
                        EventTimeLine userEvent = null;
                        if (eventTimeLineHashMap.containsKey(labelName)) {
                            userEvent = eventTimeLineHashMap.get(labelName);
                        } else {
                            userEvent = new EventTimeLine(labelName, EventType.USER_EVENT, TimeLineCategory.USE_BOOLEAN_EVENT);
                            eventTimeLineHashMap.put(labelName, userEvent);
                            this.animal.eventTimeLineList.add(userEvent);
                        }
                        float duration = scanner.nextFloat();
                        float interval = scanner.nextFloat();
                        float startTime = scanner.nextFloat();
                        int durationInFrame = (int)(MiceProfilerVideoLabelMakerInternal.this.FPS * duration);
                        for (int t = startTimeInFrame = (int)(MiceProfilerVideoLabelMakerInternal.this.FPS * startTime); t <= startTimeInFrame + durationInFrame; ++t) {
                            userEvent.addPunctualEvent(t - this.firstFrame);
                        }
                        if (!scanner.hasNextLine()) continue;
                        scanner.nextLine();
                    }
                    scanner.close();
                    ArrayList<String> keys = new ArrayList<String>(eventTimeLineHashMap.keySet());
                    Collections.sort(keys);
                    for (int iTimeLine = 29; iTimeLine < this.animal.eventTimeLineList.size(); ++iTimeLine) {
                        EventTimeLine eventTimeLine = this.animal.eventTimeLineList.get(iTimeLine);
                        System.out.println("Processing eventTimeLine... " + eventTimeLine.criteriaName + " nb event : " + eventTimeLine.eventList.size());
                        ++nbElement;
                        int nbEvent = 0;
                        int total = 0;
                        g2.setColor(Color.BLUE);
                        for (EventCriteria eventCriteria : eventTimeLine.eventList) {
                            ++nbEvent;
                            total += eventCriteria.getLength();
                            for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                                g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                            }
                        }
                        g2.setColor(Color.BLACK);
                        g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
                        String string = eventTimeLine.criteriaName + " nb event: " + nbEvent + " totalT: " + this.nbFrameToDisplayInSecond(total);
                        g2.drawString(string, 0, currentY + 12);
                        this.imageComponent.stringList.add(string);
                        g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                System.out.println("Number of extra user labels (AviSoft): " + nbElement);
            }
            return currentY;
        }

        private void loadDefaultUserEventSet(HashMap<String, EventTimeLine> eventTimeLineHashMap, File originalFile) {
            File defaultUserEventSetFile = new File(FileUtil.getDirectory((String)originalFile.getAbsolutePath()) + "//defaultUserEvents.txt");
            System.out.println("DefaultUserEventFile is: " + defaultUserEventSetFile.getAbsolutePath());
            if (FileUtil.exists((String)defaultUserEventSetFile.getAbsolutePath())) {
                System.out.println("Loading default User events...");
                try {
                    Scanner scanner = new Scanner(defaultUserEventSetFile);
                    while (scanner.hasNextLine()) {
                        String labelName = scanner.nextLine();
                        System.out.println(labelName);
                        EventTimeLine userEvent = new EventTimeLine(labelName, EventType.USER_EVENT, TimeLineCategory.USE_BOOLEAN_EVENT);
                        eventTimeLineHashMap.put(labelName, userEvent);
                        this.animal.eventTimeLineList.add(userEvent);
                    }
                    scanner.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }

        private int loadExtraLabelXMLFile(File originalFile, int currentY, Graphics2D g2) {
            File extraFile = this.getExtraXMLFile(originalFile);
            System.out.println("XML file is: " + this.file.getAbsolutePath());
            System.out.println("Extra XML file is: " + extraFile.getAbsolutePath());
            if (!extraFile.exists()) {
                return currentY;
            }
            System.out.println("The extra info file exists... Processing...");
            Document xmlDocument = XMLUtil.loadDocument((File)extraFile);
            int offset = 0;
            ArrayList labelElementListOffset = XMLUtil.getElements((Node)XMLUtil.getRootElement((Document)xmlDocument), (String)"OFFSET");
            for (Element labelElement : labelElementListOffset) {
                offset = XMLUtil.getAttributeIntValue((Element)labelElement, (String)"offset", (int)0);
            }
            int minDurationEvent = 0;
            ArrayList labelElementListMinDuration = XMLUtil.getElements((Node)XMLUtil.getRootElement((Document)xmlDocument), (String)"MINDURATION");
            for (Element labelElement : labelElementListMinDuration) {
                minDurationEvent = XMLUtil.getAttributeIntValue((Element)labelElement, (String)"minduration", (int)0);
            }
            ArrayList labelElementList = XMLUtil.getElements((Node)XMLUtil.getRootElement((Document)xmlDocument), (String)"LABEL");
            for (Element labelElement : labelElementList) {
                String userLabelName = XMLUtil.getAttributeValue((Element)labelElement, (String)"name", (String)"no name");
                String userLabelColorString = XMLUtil.getAttributeValue((Element)labelElement, (String)"color", (String)"green");
                System.out.println("Loading label " + userLabelName);
                Color userEventColor = null;
                try {
                    Field field = Class.forName("java.awt.Color").getField(userLabelColorString);
                    userEventColor = (Color)field.get(null);
                }
                catch (Exception e) {
                    userEventColor = Color.green;
                    System.err.println("Unsupported color in label " + userLabelName + " (switching to green)");
                }
                int nbEvent = 0;
                int total = 0;
                EventTimeLine userEvent = new EventTimeLine(userLabelName, EventType.USER_EVENT, TimeLineCategory.USE_BOOLEAN_EVENT);
                this.animal.eventTimeLineList.add(userEvent);
                this.synchronizeAllAnimalEvent(userEvent);
                g2.setColor(userEventColor);
                ArrayList labelEventList = XMLUtil.getElements((Node)labelElement, (String)"EVENT");
                for (Element labelEvent : labelEventList) {
                    int start = XMLUtil.getAttributeIntValue((Element)labelEvent, (String)"start", (int)-1);
                    int end = XMLUtil.getAttributeIntValue((Element)labelEvent, (String)"end", (int)-1);
                    if (start == -1) {
                        System.err.println("Error in label " + userLabelName);
                        System.err.println("Wrong start value (skipping event)");
                        continue;
                    }
                    if (end == -1) {
                        System.err.println("Error in label " + userLabelName);
                        System.err.println("Wrong end value (skipping event)");
                        continue;
                    }
                    if (start > end) {
                        System.err.println("Error in label " + userLabelName);
                        System.err.println("start value > end value (skipping event)");
                        continue;
                    }
                    if ((end += offset) - (start += offset) < minDurationEvent) {
                        end = start + minDurationEvent;
                    }
                    for (int t = start; t <= end; ++t) {
                        userEvent.addPunctualEvent(t - this.firstFrame);
                    }
                }
                nbEvent = 0;
                total = 0;
                for (EventCriteria eventCriteria : userEvent.eventList) {
                    ++nbEvent;
                    total += eventCriteria.getLength();
                    for (int i = eventCriteria.startFrame; i <= eventCriteria.endFrame; ++i) {
                        g2.drawLine(i, currentY, i, currentY + MiceProfilerVideoLabelMakerInternal.this.stepY);
                    }
                }
                g2.setColor(Color.black);
                g2.drawLine(0, currentY, this.imageChrono.getWidth(), currentY);
                String string = userLabelName + nbEvent + " totalT: " + this.nbFrameToDisplayInSecond(total);
                g2.drawString(string, 0, currentY + 12);
                this.imageComponent.stringList.add(string);
                g2.drawLine(0, currentY += MiceProfilerVideoLabelMakerInternal.this.stepY, this.imageChrono.getWidth(), currentY);
            }
            System.out.println("Custom XML user label loaded.");
            return currentY;
        }

        private void synchronizeAllAnimalEvent(EventTimeLine userEvent) {
            ArrayList<Animal> animalList = new ArrayList<Animal>();
            for (VideoLabelPanel videoLabelPanel : MiceProfilerVideoLabelMakerInternal.this.videoLabelPanelArrayList) {
                animalList.add(videoLabelPanel.animal);
            }
        }

        float getMin(float a, float b) {
            if (a < b) {
                return a;
            }
            return b;
        }

        public void loadXML(File currentFile) {
            int currentT;
            MouseInfoRecord mouseInfoRecord;
            Element detNode;
            int i;
            NodeList nodes;
            System.out.println("Loading document");
            this.mouseARecord.clear();
            this.mouseBRecord.clear();
            File XMLFile = currentFile;
            if (!XMLFile.exists()) {
                return;
            }
            Document XMLDocument = XMLUtil.loadDocument((File)XMLFile);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "//FILENAME";
            try {
                NodeList nodes2 = (NodeList)xpath.evaluate(expression, XMLDocument, XPathConstants.NODESET);
                Element fileNode = (Element)nodes2.item(0);
                System.out.println("Video file is :" + fileNode.getTextContent());
                this.videoFile = new File(fileNode.getTextContent());
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            float startFrame = 0.0f;
            float endFrame = Float.MAX_VALUE;
            String expression2 = "//MOUSEA/DET";
            try {
                nodes = (NodeList)xpath.evaluate(expression2, XMLDocument, XPathConstants.NODESET);
                for (i = 0; i < nodes.getLength(); ++i) {
                    detNode = (Element)nodes.item(i);
                    mouseInfoRecord = new MouseInfoRecord();
                    mouseInfoRecord.bodyPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("bodyx")), Float.parseFloat(detNode.getAttribute("bodyy")));
                    mouseInfoRecord.headPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("headx")), Float.parseFloat(detNode.getAttribute("heady")));
                    mouseInfoRecord.tailPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("tailx")), Float.parseFloat(detNode.getAttribute("taily")));
                    currentT = Integer.parseInt(detNode.getAttribute("t"));
                    if (!((float)currentT >= startFrame) || !((float)currentT <= endFrame)) continue;
                    this.mouseARecord.put(currentT, mouseInfoRecord);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            expression2 = "//MOUSEB/DET";
            try {
                nodes = (NodeList)xpath.evaluate(expression2, XMLDocument, XPathConstants.NODESET);
                for (i = 0; i < nodes.getLength(); ++i) {
                    detNode = (Element)nodes.item(i);
                    mouseInfoRecord = new MouseInfoRecord();
                    mouseInfoRecord.bodyPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("bodyx")), Float.parseFloat(detNode.getAttribute("bodyy")));
                    mouseInfoRecord.headPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("headx")), Float.parseFloat(detNode.getAttribute("heady")));
                    mouseInfoRecord.tailPosition = new Point2D.Float(Float.parseFloat(detNode.getAttribute("tailx")), Float.parseFloat(detNode.getAttribute("taily")));
                    currentT = Integer.parseInt(detNode.getAttribute("t"));
                    if (!((float)currentT >= startFrame) || !((float)currentT <= endFrame)) continue;
                    this.mouseBRecord.put(currentT, mouseInfoRecord);
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            this.startOffset = this.trimAnalysisRecord();
        }

        double only2digit(double val) {
            val *= 100.0;
            val = Math.floor(val);
            return val /= 100.0;
        }

        void computeVisionGraph(VisionGraph visionGraph) {
            float nbVal = 0.0f;
            float totalDistance = 0.0f;
            float nbEvent = 0.0f;
            float total = 0.0f;
            int[] tabAngle = new int[361];
            int graphNumber = 0;
            int binSize = 5;
            Object currentCriteria = null;
            int tMin = Integer.MAX_VALUE;
            int tMax = 0;
            for (int val : this.mouseARecord.keySet()) {
                if (val > tMax) {
                    tMax = val;
                }
                if (val >= tMin) continue;
                tMin = val;
            }
            for (int t = 0; t < tMax; ++t) {
                int angleVisionDeg;
                if (!this.mouseARecord.containsKey(t) || !this.mouseBRecord.containsKey(t)) continue;
                MouseInfoRecord mouseA = this.mouseARecord.get(t);
                MouseInfoRecord mouseB = this.mouseBRecord.get(t);
                double distanceHeadABodyB = mouseA.headPosition.distanceSq(mouseB.bodyPosition);
                double distanceHeadAHeadB = mouseA.headPosition.distanceSq(mouseB.headPosition);
                double distanceBodyABodyB = mouseA.bodyPosition.distanceSq(mouseB.bodyPosition);
                double distanceBodyAHeadB = mouseA.bodyPosition.distanceSq(mouseB.headPosition);
                double VAx = mouseA.headPosition.getX() - mouseA.bodyPosition.getX();
                double VAy = mouseA.headPosition.getY() - mouseA.bodyPosition.getY();
                double angleA = Math.atan2(VAy, VAx);
                double VABx = -mouseA.headPosition.getX() + mouseB.headPosition.getX();
                double VABy = -mouseA.headPosition.getY() + mouseB.headPosition.getY();
                double angleBA = Math.atan2(VABy, VABx);
                boolean eventIsOk = true;
                if (!(this.angleMin(angleBA, angleA) < this.demiVisionDeSouris)) {
                    eventIsOk = false;
                }
                if (visionGraph == VisionGraph.AT_FOLLOW_STATE && (mouseA.distanceIsInferiorToThreshold2 || !mouseA.isGettingToOtherAndTouch)) {
                    eventIsOk = false;
                }
                if (visionGraph == VisionGraph.AT_STOP_STATE && (mouseA.distanceIsInferiorToThreshold1 || mouseA.speed > MiceProfilerVideoLabelMakerInternal.this.SPEED_THRESHOLD_1)) {
                    eventIsOk = false;
                }
                if (!eventIsOk) continue;
                double angleSouris = angleA;
                double angleVision = angleBA;
                for (angleVisionDeg = (int)(180.0 * (angleVision -= angleSouris) / Math.PI); angleVisionDeg > 180; angleVisionDeg -= 360) {
                }
                while (angleVisionDeg < -180) {
                    angleVisionDeg += 360;
                }
                int angleToFill = binSize * (angleVisionDeg / binSize);
                int n = 180 + angleToFill;
                tabAngle[n] = tabAngle[n] + 1;
            }
            XlsManager xls = null;
            File xlsFile = new File(System.getProperty("user.home") + "\\" + visionGraph.toString() + " " + this.animal.animalName + ".xls");
            try {
                xls = new XlsManager(xlsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            xls.createNewPage("result");
            XYSeriesCollection xyDataset = new XYSeriesCollection();
            YIntervalSeriesCollection yintervalseriescollection = new YIntervalSeriesCollection();
            IcyFrame graphFrame = new IcyFrame("graph " + graphNumber + " " + this.animal.animalName, true, true, true, true);
            ++graphNumber;
            JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"angle", (String)"y", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYSeries seriesXY = new XYSeries((Comparable)((Object)("Sight " + this.animal.animalName)));
            xyDataset.addSeries(seriesXY);
            int cursorX = 0;
            for (int i = 0; i < 360; i += binSize) {
                seriesXY.add((double)(i - 180), (double)tabAngle[i]);
                xls.setNumber(cursorX, 0, (double)tabAngle[i]);
                ++cursorX;
            }
            new AnnounceFrame("Exported in file " + xlsFile);
            xls.SaveAndClose();
            graphFrame.getContentPane().add((Component)new ChartPanel(chart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true));
            graphFrame.setVisible(true);
            graphFrame.pack();
            graphFrame.addToMainDesktopPane();
            graphFrame.center();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.computeVisionInFollowButton) {
                this.computeVisionGraph(VisionGraph.AT_FOLLOW_STATE);
            }
            if (e.getSource() == this.computeVisionWhenStoppedButton) {
                this.computeVisionGraph(VisionGraph.AT_STOP_STATE);
            }
            if (e.getSource() == this.exportSpeedButton) {
                File xlsFile = new File(this.file.getAbsolutePath() + ".speed.xls");
                try {
                    XlsManager xls = new XlsManager(xlsFile);
                    this.exportSpeed(xls, this.mouseARecord, "Mouse A");
                    this.exportSpeed(xls, this.mouseBRecord, "Mouse B");
                    xls.SaveAndClose();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                new AnnounceFrame("Speed data have been exported to " + xlsFile.getAbsolutePath(), 5);
            }
            if (e.getSource() == this.computeLocationHeatMapButton) {
                this.computeLocationHeatMap();
            }
            if (e.getSource() == this.computeUSVStat) {
                this.computeUSVStats();
            }
            if (e.getSource() == this.exportEventsAsXML) {
                this.exportEventsAsXML();
            }
            if (e.getSource() == this.saveImageButton) {
                BufferedImage image2;
                try {
                    ImageIO.write((RenderedImage)this.imageChrono, "png", new File(this.file.getAbsolutePath() + ".1.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                int numeroCriteria = 0;
                for (int y = 0; y < this.imageChrono.getHeight(); y += MiceProfilerVideoLabelMakerInternal.this.stepY) {
                    image2 = new BufferedImage(this.imageChrono.getWidth(), MiceProfilerVideoLabelMakerInternal.this.stepY, 4);
                    Graphics2D targetG = (Graphics2D)image2.getGraphics();
                    targetG.drawImage(this.imageChrono, null, 0, -y);
                    try {
                        ImageIO.write((RenderedImage)image2, "png", new File(this.file.getAbsolutePath() + ".criteria_" + numeroCriteria + ".png"));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    ++numeroCriteria;
                }
                float desiredWidth = 3200.0f;
                image2 = new BufferedImage((int)desiredWidth, (int)((float)(this.imageChrono.getHeight() * this.imageChrono.getWidth()) / desiredWidth), 4);
                Graphics2D sourceG = (Graphics2D)this.imageChrono.getGraphics();
                Graphics2D targetG = (Graphics2D)image2.getGraphics();
                int stepY = 0;
                int offset = 0;
                while (offset < this.imageChrono.getWidth()) {
                    targetG.drawImage(this.imageChrono, null, -offset, stepY * this.imageChrono.getHeight());
                    ++stepY;
                    offset = (int)((float)offset + desiredWidth);
                }
                try {
                    ImageIO.write((RenderedImage)image2, "png", new File(this.file.getAbsolutePath() + ".2.png"));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void exportEventsAsXML() {
            Document document = XMLUtil.createDocument((boolean)true);
            for (EventTimeLine eventTimeLine : this.animal.eventTimeLineList) {
                Element elementTimeLine = document.createElement("EventTimeLine");
                document.getDocumentElement().appendChild(elementTimeLine);
                XMLUtil.setAttributeIntValue((Element)elementTimeLine, (String)"index", (int)this.animal.eventTimeLineList.indexOf(eventTimeLine));
                XMLUtil.setAttributeValue((Element)elementTimeLine, (String)"name", (String)eventTimeLine.criteriaName);
                XMLUtil.setAttributeValue((Element)elementTimeLine, (String)"type", (String)eventTimeLine.eventType.toString());
                XMLUtil.setAttributeValue((Element)elementTimeLine, (String)"timeLineCategory", (String)eventTimeLine.timeLineCategory.toString());
                for (EventCriteria event : eventTimeLine.eventList) {
                    Element elementEvent = document.createElement("event");
                    elementTimeLine.appendChild(elementEvent);
                    XMLUtil.setAttributeIntValue((Element)elementEvent, (String)"startFrame", (int)event.startFrame);
                    XMLUtil.setAttributeIntValue((Element)elementEvent, (String)"endFrame", (int)event.endFrame);
                }
            }
            File xmlFile = new File(this.file.getAbsolutePath() + ".allEventsExported.xml");
            XMLUtil.saveDocument((Document)document, (File)xmlFile);
            AnnounceFrame f = new AnnounceFrame("File exported: " + xmlFile.getAbsolutePath());
        }

        private void computeUSVStats() {
            try {
                WritableWorkbook workbook = XLSUtil.createWorkbook((File)new File(this.file.getAbsolutePath() + ".event.xls"));
                WritableSheet page = XLSUtil.createNewPage((WritableWorkbook)workbook, (String)"result");
                int currentColumn = 1;
                for (int indexOfUSVEvent = 29; indexOfUSVEvent < this.animal.eventTimeLineList.size(); ++indexOfUSVEvent) {
                    EventTimeLine eventTimeLineWatched = this.animal.eventTimeLineList.get(indexOfUSVEvent);
                    XLSUtil.setCellString((WritableSheet)page, (int)0, (int)0, (String)this.file.getAbsolutePath());
                    int row = 5;
                    XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"event");
                    XLSUtil.setCellString((WritableSheet)page, (int)currentColumn, (int)(row - 2), (String)("Event: " + eventTimeLineWatched.criteriaName));
                    XLSUtil.setCellString((WritableSheet)page, (int)currentColumn, (int)(row - 1), (String)("Nb event: " + eventTimeLineWatched.eventList.size()));
                    XLSUtil.setCellString((WritableSheet)page, (int)currentColumn, (int)row, (String)"nb corr event ");
                    XLSUtil.setCellString((WritableSheet)page, (int)(currentColumn + 1), (int)row, (String)"% corr event");
                    row += 2;
                    for (EventTimeLine eventTimeLineCandidate : this.animal.eventTimeLineList) {
                        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)eventTimeLineCandidate.criteriaName);
                        int nbEventCandidate = eventTimeLineCandidate.eventList.size();
                        int nbOccur = 0;
                        block5: for (EventCriteria eventUSV : eventTimeLineWatched.eventList) {
                            for (EventCriteria eventCandidate : eventTimeLineCandidate.eventList) {
                                if (!this.isEventOverlapping(eventUSV, eventCandidate)) continue;
                                ++nbOccur;
                                continue block5;
                            }
                        }
                        float ratio = 100.0f * (float)nbOccur / (float)eventTimeLineWatched.eventList.size();
                        XLSUtil.setCellNumber((WritableSheet)page, (int)currentColumn, (int)row, (double)nbOccur);
                        XLSUtil.setCellNumber((WritableSheet)page, (int)(currentColumn + 1), (int)row, (double)ratio);
                        ++row;
                    }
                    currentColumn += 2;
                }
                XLSUtil.saveAndClose((WritableWorkbook)workbook);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
        }

        private boolean isEventOverlapping(EventCriteria a, EventCriteria b) {
            return b.startFrame <= a.endFrame && b.endFrame >= a.startFrame;
        }

        private void feedXLSWithIntersectingEvent(int vocEventIndex, int candidateEventIndex, WritableSheet sheet) {
            EventTimeLine vocTimeLine = this.animal.eventTimeLineList.get(vocEventIndex);
            EventTimeLine candidateTimeLine = this.animal.eventTimeLineList.get(candidateEventIndex);
            int totalNbVoc = vocTimeLine.eventList.size();
            int nbVocWithEvent = this.getNumberOfEventOverlap(vocTimeLine, candidateTimeLine);
            int row = sheet.getRows();
            XLSUtil.setCellString((WritableSheet)sheet, (int)0, (int)row, (String)("nb Voc with event :" + candidateTimeLine.criteriaName));
            XLSUtil.setCellNumber((WritableSheet)sheet, (int)1, (int)row, (double)nbVocWithEvent);
            XLSUtil.setCellString((WritableSheet)sheet, (int)2, (int)row, (String)"percent:");
            XLSUtil.setCellNumber((WritableSheet)sheet, (int)3, (int)row++, (double)((float)nbVocWithEvent * 100.0f / (float)totalNbVoc));
        }

        private int getNumberOfEventOverlap(EventTimeLine vocTimeLine, EventTimeLine candidateTimeLine) {
            int nbEvent = 0;
            System.out.println("nb of event of type ** " + vocTimeLine.criteriaName + " ** matching ** " + candidateTimeLine.criteriaName + " **");
            block0: for (EventCriteria vocEvent : vocTimeLine.eventList) {
                for (EventCriteria candidateEvent : this.animal.eventTimeLineList.get((int)1).eventList) {
                    if (!this.isEventOverlapping(vocEvent, candidateEvent)) continue;
                    ++nbEvent;
                    continue block0;
                }
            }
            return nbEvent;
        }

        private void computeEventLocationHeatMap() {
            MouseInfoRecord mouseB;
            MouseInfoRecord mouseA;
            int t;
            MiceProfilerVideoLabelMakerInternal.this.SCALE = Float.parseFloat(MiceProfilerVideoLabelMakerInternal.this.scaleTextField.getText());
            IcyBufferedImage image = new IcyBufferedImage(800, 600, 3, DataType.USHORT);
            for (EventCriteria event : this.animal.eventTimeLineList.get((int)0).eventList) {
                for (t = event.startFrame; t <= event.endFrame; ++t) {
                    mouseA = this.mouseARecord.get(t);
                    this.additiveDrawMouse(mouseA, image, 0);
                    mouseB = this.mouseBRecord.get(t);
                    this.additiveDrawMouse(mouseB, image, 0);
                }
            }
            for (EventCriteria event : this.animal.eventTimeLineList.get((int)29).eventList) {
                for (t = event.startFrame; t <= event.endFrame; ++t) {
                    mouseA = this.mouseARecord.get(t);
                    this.additiveDrawMouse(mouseA, image, 1);
                    mouseB = this.mouseBRecord.get(t);
                    this.additiveDrawMouse(mouseB, image, 1);
                }
            }
            image.dataChanged();
            Sequence outPutSequence = new Sequence(image);
            File heatMapFile = new File(FileUtil.setExtension((String)this.file.getAbsolutePath(), (String)".heatmap.event.tif"));
            Saver.save((Sequence)outPutSequence, (File)heatMapFile);
            new AnnounceFrame("HeatMapFile saved to " + heatMapFile.getAbsolutePath(), 5);
        }

        private void computeLocationHeatMap() {
            MouseInfoRecord mouseB;
            MiceProfilerVideoLabelMakerInternal.this.SCALE = Float.parseFloat(MiceProfilerVideoLabelMakerInternal.this.scaleTextField.getText());
            IcyBufferedImage image = new IcyBufferedImage(800, 600, 4, DataType.USHORT);
            for (Integer t : this.mouseARecord.keySet()) {
                MouseInfoRecord mouseA = this.mouseARecord.get(t);
                this.additiveDrawMouse(mouseA, image, 0);
            }
            for (Integer t : this.mouseBRecord.keySet()) {
                mouseB = this.mouseBRecord.get(t);
                this.additiveDrawMouse(mouseB, image, 1);
            }
            for (Integer t : this.mouseBRecord.keySet()) {
                mouseB = this.mouseBRecord.get(t);
                MouseInfoRecord mouseA = this.mouseARecord.get(t);
                EventTimeLine eventTimeLineWatched = this.animal.eventTimeLineList.get(29);
                if (eventTimeLineWatched.getNbEvent(t, t) != 1.0) continue;
                this.additiveDrawMouse(mouseA, image, 2);
                this.additiveDrawMouse(mouseB, image, 3);
            }
            image.dataChanged();
            Sequence outPutSequence = new Sequence(image);
            File heatMapFile = new File(FileUtil.setExtension((String)this.file.getAbsolutePath(), (String)".heatmap.tif"));
            Saver.save((Sequence)outPutSequence, (File)heatMapFile);
            new AnnounceFrame("HeatMapFile saved to " + heatMapFile.getAbsolutePath(), 5);
        }

        private void additiveDrawMouse(MouseInfoRecord mouse, IcyBufferedImage image, int channel) {
            Ellipse2D.Float head = new Ellipse2D.Float((float)mouse.headPosition.getX() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouse.headPosition.getY() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
            Ellipse2D.Float body = new Ellipse2D.Float((float)mouse.bodyPosition.getX() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouse.bodyPosition.getY() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
            Ellipse2D.Float tail = new Ellipse2D.Float((float)mouse.tailPosition.getX() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouse.tailPosition.getY() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
            boolean centerX = false;
            boolean centerY = false;
            int ray = 30;
            this.additiveDrawOverImage(image, (int)head.getCenterX(), (int)head.getCenterY(), (int)(40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f), channel);
            this.additiveDrawOverImage(image, (int)body.getCenterX(), (int)body.getCenterY(), (int)(77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f), channel);
            this.additiveDrawOverImage(image, (int)tail.getCenterX(), (int)tail.getCenterY(), (int)(13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f), channel);
        }

        private void additiveDrawOverImage(IcyBufferedImage image, int ox, int oy, int r, int channel) {
            short[] buffer = image.getDataXYAsShort(channel);
            int width = image.getWidth();
            for (int x = -r; x < r; ++x) {
                int height = (int)Math.sqrt(r * r - x * x);
                for (int y = -height; y < height; ++y) {
                    int n = (oy + y) * width + x + ox;
                    buffer[n] = (short)(buffer[n] + 1);
                }
            }
        }

        private void exportSpeed(XlsManager xls, HashMap<Integer, MouseInfoRecord> mouseRecord, String name) {
            xls.createNewPage(name);
            boolean tMin = false;
            MiceProfilerVideoLabelMakerInternal.this.START_MINUTE = Integer.parseInt(MiceProfilerVideoLabelMakerInternal.this.computeImageStartMinuteTextField.getText());
            MiceProfilerVideoLabelMakerInternal.this.NB_MINUTE = Integer.parseInt(MiceProfilerVideoLabelMakerInternal.this.computeImageNbMinuteTextField.getText());
            this.firstFrame = (int)((float)tMin + (float)(MiceProfilerVideoLabelMakerInternal.this.START_MINUTE * 60) * MiceProfilerVideoLabelMakerInternal.this.FPS);
            int tMax = this.lastFrame = (int)((float)this.firstFrame + (float)(MiceProfilerVideoLabelMakerInternal.this.NB_MINUTE * 60) * MiceProfilerVideoLabelMakerInternal.this.FPS);
            int frameWindow = 6;
            double[] speedFrame = new double[tMax - this.firstFrame];
            xls.setLabel(0, 0, "frame#");
            xls.setLabel(1, 0, "speed in px/frame time");
            xls.setLabel(2, 0, "cumulated distance in px");
            float nbVal = 0.0f;
            double totalDistance = 0.0;
            for (int t = 0; t < tMax; ++t) {
                if (!mouseRecord.containsKey(t - frameWindow) || !mouseRecord.containsKey(t + frameWindow) || !mouseRecord.containsKey(t)) continue;
                MouseInfoRecord mouseRecordPrev = mouseRecord.get(t - frameWindow);
                MouseInfoRecord mouseRecordNext = mouseRecord.get(t + frameWindow);
                MouseInfoRecord mouseRecordCurrentFrame = mouseRecord.get(t);
                float distance = (float)mouseRecordPrev.bodyPosition.distance(mouseRecordNext.bodyPosition);
                mouseRecordCurrentFrame.speed = distance;
                speedFrame[t - this.firstFrame] = distance;
                xls.setNumber(0, (int)(nbVal + 1.0f), (double)nbVal);
                xls.setNumber(1, (int)(nbVal + 1.0f), (double)distance);
                xls.setNumber(2, (int)(nbVal + 1.0f), totalDistance += (double)(distance /= (float)(frameWindow * 2 + 1)));
                nbVal += 1.0f;
            }
            xls.setLabel(4, 0, "second#");
            xls.setLabel(5, 0, "speed in px/s");
            xls.setLabel(6, 0, "cumulated distance in px");
            int sec = 0;
            int arrayCounter = 0;
            double totalDistance2 = 0.0;
            while ((float)arrayCounter < (float)tMax - MiceProfilerVideoLabelMakerInternal.this.FPS) {
                double speedSec = 0.0;
                int i = 0;
                while ((float)i < MiceProfilerVideoLabelMakerInternal.this.FPS) {
                    speedSec += speedFrame[arrayCounter];
                    totalDistance2 += speedFrame[arrayCounter];
                    ++arrayCounter;
                    ++i;
                }
                System.out.println("sec:" + sec);
                xls.setNumber(4, sec + 1, (double)sec);
                xls.setNumber(5, sec + 1, speedSec);
                xls.setNumber(6, sec + 1, totalDistance2);
                ++sec;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                this.updateVideoImageAt(e.getX());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                this.updateVideoImageAt(e.getX());
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        private void updateVideoImageAt(int x) throws InterruptedException {
            x += this.firstFrame;
            if (this.frameAccess == null) {
                if (this.videoFile.exists()) {
                    this.frameAccess = new FrameAccess(this.videoFile);
                } else {
                    System.out.println("File specified in XML is not present. Checking in XML folder.");
                    this.videoFile = new File(FileUtil.getDirectory((String)this.file.getAbsolutePath()) + "/" + FileUtil.getFileName((String)this.videoFile.getName()));
                    this.frameAccess = new FrameAccess(this.videoFile);
                }
            }
            MiceProfilerVideoLabelMakerInternal.this.videoImage = this.frameAccess.getImageAt(x + this.startOffset + 3);
            if (MiceProfilerVideoLabelMakerInternal.this.videoImage == null) {
                MiceProfilerVideoLabelMakerInternal.this.videoImage = IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)new IcyBufferedImage(640, 480, 1, DataType.BYTE), null);
            }
            Graphics2D g2 = (Graphics2D)MiceProfilerVideoLabelMakerInternal.this.videoImage.getGraphics();
            g2.setColor(Color.red);
            MouseInfoRecord mouseA = this.mouseARecord.get(x);
            MouseInfoRecord mouseB = this.mouseBRecord.get(x);
            if (mouseA != null) {
                int angleDifDegree;
                MiceProfilerVideoLabelMakerInternal.this.SCALE = Float.parseFloat(MiceProfilerVideoLabelMakerInternal.this.scaleTextField.getText());
                Ellipse2D.Float head = new Ellipse2D.Float((float)mouseA.headPosition.getX() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseA.headPosition.getY() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                Ellipse2D.Float body = new Ellipse2D.Float((float)mouseA.bodyPosition.getX() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseA.bodyPosition.getY() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                Ellipse2D.Float tail = new Ellipse2D.Float((float)mouseA.tailPosition.getX() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseA.tailPosition.getY() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                g2.draw(head);
                g2.draw(body);
                g2.draw(tail);
                double VAx = mouseA.headPosition.getX() - mouseA.bodyPosition.getX();
                double VAy = mouseA.headPosition.getY() - mouseA.bodyPosition.getY();
                double angleA = Math.atan2(VAy, VAx);
                double departAngle1 = -2.792526803190927;
                double departAngle2 = 1.0471975511965976;
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleA) * 100.0), (int)(mouseA.headPosition.getY() + Math.sin(angleA) * 100.0));
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleA - 1.0471975511965976) * 50.0), (int)(mouseA.headPosition.getY() + Math.sin(angleA - 1.0471975511965976) * 50.0));
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleA - 2.0943951023931953) * 100.0), (int)(mouseA.headPosition.getY() + Math.sin(angleA - 2.0943951023931953) * 100.0));
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleA + 1.0471975511965976) * 50.0), (int)(mouseA.headPosition.getY() + Math.sin(angleA + 1.0471975511965976) * 50.0));
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleA + 2.0943951023931953) * 100.0), (int)(mouseA.headPosition.getY() + Math.sin(angleA + 2.0943951023931953) * 100.0));
                double VABx = -mouseA.headPosition.getX() + mouseB.headPosition.getX();
                double VABy = -mouseA.headPosition.getY() + mouseB.headPosition.getY();
                double angleBA = Math.atan2(VABy, VABx);
                boolean eventIsOk = true;
                if (!(this.angleMin(angleBA, angleA) < this.demiVisionDeSouris)) {
                    eventIsOk = false;
                }
                if (mouseA.distanceIsInferiorToThreshold2) {
                    eventIsOk = false;
                }
                g2.setColor(Color.black);
                g2.drawLine((int)mouseA.headPosition.getX(), (int)mouseA.headPosition.getY(), (int)(mouseA.headPosition.getX() + Math.cos(angleBA) * 100.0), (int)(mouseA.headPosition.getY() + Math.sin(angleBA) * 100.0));
                double angleDif = angleBA - angleA;
                for (angleDifDegree = (int)(180.0 * angleDif / Math.PI); angleDifDegree > 180; angleDifDegree -= 360) {
                }
                while (angleDifDegree < -180) {
                    angleDifDegree += 360;
                }
            }
            g2.setColor(Color.green);
            MouseInfoRecord mouseB2 = this.mouseBRecord.get(x);
            if (mouseB2 != null) {
                Ellipse2D.Float head = new Ellipse2D.Float((float)mouseB2.headPosition.getX() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseB2.headPosition.getY() - 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 40.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                Ellipse2D.Float body = new Ellipse2D.Float((float)mouseB2.bodyPosition.getX() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseB2.bodyPosition.getY() - 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 77.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                Ellipse2D.Float tail = new Ellipse2D.Float((float)mouseB2.tailPosition.getX() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, (float)mouseB2.tailPosition.getY() - 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE / 2.0f, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE, 13.0f * MiceProfilerVideoLabelMakerInternal.this.SCALE);
                g2.draw(head);
                g2.draw(body);
                g2.draw(tail);
                double VAx = mouseB2.headPosition.getX() - mouseB2.bodyPosition.getX();
                double VAy = mouseB2.headPosition.getY() - mouseB2.bodyPosition.getY();
                double angleA = Math.atan2(VAy, VAx);
                double departAngle1 = -2.792526803190927;
                double departAngle2 = 1.0471975511965976;
                g2.drawLine((int)mouseB2.headPosition.getX(), (int)mouseB2.headPosition.getY(), (int)(mouseB2.headPosition.getX() + Math.cos(angleA) * 100.0), (int)(mouseB2.headPosition.getY() + Math.sin(angleA) * 100.0));
                g2.drawLine((int)mouseB2.headPosition.getX(), (int)mouseB2.headPosition.getY(), (int)(mouseB2.headPosition.getX() + Math.cos(angleA - 1.0471975511965976) * 50.0), (int)(mouseB2.headPosition.getY() + Math.sin(angleA - 1.0471975511965976) * 50.0));
                g2.drawLine((int)mouseB2.headPosition.getX(), (int)mouseB2.headPosition.getY(), (int)(mouseB2.headPosition.getX() + Math.cos(angleA - 2.0943951023931953) * 100.0), (int)(mouseB2.headPosition.getY() + Math.sin(angleA - 2.0943951023931953) * 100.0));
                g2.drawLine((int)mouseB2.headPosition.getX(), (int)mouseB2.headPosition.getY(), (int)(mouseB2.headPosition.getX() + Math.cos(angleA + 1.0471975511965976) * 50.0), (int)(mouseB2.headPosition.getY() + Math.sin(angleA + 1.0471975511965976) * 50.0));
                g2.drawLine((int)mouseB2.headPosition.getX(), (int)mouseB2.headPosition.getY(), (int)(mouseB2.headPosition.getX() + Math.cos(angleA + 2.0943951023931953) * 100.0), (int)(mouseB2.headPosition.getY() + Math.sin(angleA + 2.0943951023931953) * 100.0));
            }
            MiceProfilerVideoLabelMakerInternal.this.videoTimeLabel.setText("frame #" + x + "    " + (int)((float)x / (MiceProfilerVideoLabelMakerInternal.this.FPS * 60.0f)) + ":" + this.decimalFormat.format((int)((float)x / MiceProfilerVideoLabelMakerInternal.this.FPS % 60.0f)));
            MiceProfilerVideoLabelMakerInternal.this.imageVideoComponent.setImage(MiceProfilerVideoLabelMakerInternal.this.videoImage);
            MiceProfilerVideoLabelMakerInternal.this.imageVideoComponent.updateUI();
        }

        public double angleMin(double a1, double a2) {
            double angleMin = Double.MAX_VALUE;
            a1 = this.angleToZeroTwoPi(a1);
            a2 = this.angleToZeroTwoPi(a2);
            for (int i = -2; i < 3; ++i) {
                double dif = Math.abs(a1 + (double)i * Math.PI * 2.0 - a2);
                if (!(dif < angleMin)) continue;
                angleMin = dif;
            }
            return angleMin;
        }

        public double angleToZeroTwoPi(double a) {
            while (a < 0.0) {
                a += Math.PI * 2;
            }
            while (a > Math.PI * 2) {
                a -= Math.PI * 2;
            }
            return a;
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }

        class Periode {
            int start;
            int end;
            MouseEventType mouseEvent;

            Periode() {
            }

            public int length() {
                return this.end - this.start;
            }
        }
    }

    class MouseInfoRecord {
        boolean isGettingToOtherAndTouch = false;
        boolean isEscapingFromOtherAndUnTouch = false;
        boolean isEscaping = false;
        boolean distanceIsInferiorToThreshold1 = false;
        boolean isGoingToTheOther = false;
        boolean mouseGetToOtherMouseAndEscapeInOut = false;
        boolean mouseGetToOtherMouseAndOtherEscapeInOut = false;
        boolean eventA = false;
        boolean eventB = false;
        boolean eventC = false;
        boolean eventD = false;
        float speed;
        Point2D headPosition;
        Point2D tailPosition;
        Point2D bodyPosition;
        public boolean distanceIsInferiorToThreshold2 = false;
        public boolean isBehindTheOther = false;
        public boolean isBesideTheOther = false;
        public boolean thisHeadWithOtherGenitalContact = false;

        MouseInfoRecord() {
        }
    }
}

