/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap$PyExposer;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="stringmap", isBaseType=false)
public class PyStringMap
extends PyObject {
    private static PyType lazyType;
    private final ConcurrentMap<Object, PyObject> table;

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(int capacity) {
        super(PyStringMap.getLazyType());
        this.table = new ConcurrentHashMap<Object, PyObject>(capacity, 0.75f, 2);
    }

    public PyStringMap(Map<Object, PyObject> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        this.table.putAll(map);
    }

    public PyStringMap(PyObject[] elements) {
        this(elements.length);
        for (int i = 0; i < elements.length; i += 2) {
            this.__setitem__(elements[i], elements[i + 1]);
        }
    }

    private static PyType getLazyType() {
        if (lazyType == null) {
            lazyType = PyType.fromClass(PyStringMap.class);
        }
        return lazyType;
    }

    @ExposedNew
    static final PyObject stringmap_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyStringMap map = new PyStringMap();
        map.stringmap_update(args, keywords);
        return map;
    }

    @Override
    public int __len__() {
        return this.stringmap___len__();
    }

    final int stringmap___len__() {
        return this.table.size();
    }

    @Override
    public boolean __nonzero__() {
        return this.table.size() != 0;
    }

    @Override
    public PyObject __finditem__(String key) {
        if (key == null) {
            return null;
        }
        return (PyObject)this.table.get(key);
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__finditem__(((PyString)key).internedString());
        }
        return (PyObject)this.table.get(key);
    }

    public PyObject __getitem__(String key) {
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError("'" + key + "'");
        }
        return o;
    }

    @Override
    public PyObject __getitem__(PyObject key) {
        return this.stringmap___getitem__(key);
    }

    final PyObject stringmap___getitem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__getitem__(((PyString)key).internedString());
        }
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError("'" + key.toString() + "'");
        }
        return o;
    }

    @Override
    public PyObject __iter__() {
        return this.stringmap___iter__();
    }

    final PyObject stringmap___iter__() {
        return this.stringmap_iterkeys();
    }

    @Override
    public void __setitem__(String key, PyObject value) {
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        this.stringmap___setitem__(key, value);
    }

    final void stringmap___setitem__(PyObject key, PyObject value) {
        if (value == null) {
            this.table.remove(PyStringMap.pyToKey(key));
        } else if (key instanceof PyString) {
            this.__setitem__(((PyString)key).internedString(), value);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __delitem__(String key) {
        Object ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key);
        }
    }

    @Override
    public void __delitem__(PyObject key) {
        this.stringmap___delitem__(key);
    }

    final void stringmap___delitem__(PyObject key) {
        if (key instanceof PyString) {
            this.__delitem__(((PyString)key).internedString());
        } else {
            Object ret = this.table.remove(key);
            if (ret == null) {
                throw Py.KeyError(key.toString());
            }
        }
    }

    public void clear() {
        this.stringmap_clear();
    }

    final void stringmap_clear() {
        this.table.clear();
    }

    @Override
    public String toString() {
        return this.stringmap_toString();
    }

    final String stringmap_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.table.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                buf.append(new PyString((String)key).__repr__().toString());
            } else {
                buf.append(((PyObject)key).__repr__().toString());
            }
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.stringmap___cmp__(other);
    }

    final int stringmap___cmp__(PyObject other) {
        int bn;
        if (!(other instanceof PyStringMap) && !(other instanceof PyDictionary)) {
            return -2;
        }
        int an = this.__len__();
        if (an < (bn = other.__len__())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = null;
        bkeys = other instanceof PyStringMap ? ((PyStringMap)other).keys() : ((PyDictionary)other).keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            c = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(String key) {
        return this.table.containsKey(key);
    }

    public boolean has_key(PyObject key) {
        return this.stringmap_has_key(key);
    }

    final boolean stringmap_has_key(PyObject key) {
        return this.table.containsKey(PyStringMap.pyToKey(key));
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.stringmap___contains__(o);
    }

    final boolean stringmap___contains__(PyObject o) {
        return this.stringmap_has_key(o);
    }

    public PyObject get(PyObject key, PyObject defaultObj) {
        return this.stringmap_get(key, defaultObj);
    }

    final PyObject stringmap_get(PyObject key, PyObject defaultObj) {
        PyObject obj = this.__finditem__(key);
        return obj == null ? defaultObj : obj;
    }

    public PyObject get(PyObject key) {
        return this.stringmap_get(key, Py.None);
    }

    public PyStringMap copy() {
        return this.stringmap_copy();
    }

    final PyStringMap stringmap_copy() {
        return new PyStringMap(this.table);
    }

    public void update(PyObject other) {
        this.stringmap_update(new PyObject[]{other}, Py.NoKeywords);
    }

    final void stringmap_update(PyObject[] args, String[] keywords) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "update", 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.__setitem__(keywords[i], args[nargs + i]);
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyStringMap) {
            this.table.putAll(((PyStringMap)other).table);
        } else if (other instanceof PyDictionary) {
            this.mergeFromKeys(other, ((PyDictionary)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.__setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeFromSeq(PyObject other) {
        PyObject i;
        PyObject pairs = other.__iter__();
        boolean bl = false;
        while ((i = pairs.__iternext__()) != null) {
            void pair;
            try {
                i = PySequence.fastSequence(i, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", (int)pair));
                }
                throw pye;
            }
            int n = i.__len__();
            if (n != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", (int)pair, n));
            }
            this.__setitem__(i.__getitem__(0), i.__getitem__(1));
            ++pair;
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        return this.stringmap_setdefault(key, failobj);
    }

    final PyObject stringmap_setdefault(PyObject key, PyObject failobj) {
        PyObject internedKey = key instanceof PyString ? ((PyString)key).internedString() : key;
        PyObject oldValue = this.table.putIfAbsent(internedKey, failobj);
        return oldValue == null ? failobj : oldValue;
    }

    public PyObject popitem() {
        return this.stringmap_popitem();
    }

    final PyObject stringmap_popitem() {
        Iterator it = this.table.entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        PyTuple tuple = this.itemTuple(it.next());
        it.remove();
        return tuple;
    }

    public PyObject pop(PyObject key) {
        if (this.table.size() == 0) {
            throw Py.KeyError("pop(): dictionary is empty");
        }
        return this.stringmap_pop(key, null);
    }

    public PyObject pop(PyObject key, PyObject failobj) {
        return this.stringmap_pop(key, failobj);
    }

    final PyObject stringmap_pop(PyObject key, PyObject failobj) {
        PyObject value = (PyObject)this.table.remove(PyStringMap.pyToKey(key));
        if (value == null) {
            if (failobj == null) {
                throw Py.KeyError(key.__repr__().toString());
            }
            return failobj;
        }
        return value;
    }

    public PyList items() {
        return this.stringmap_items();
    }

    final PyList stringmap_items() {
        return new PyList(this.stringmap_iteritems());
    }

    private PyTuple itemTuple(Map.Entry<Object, PyObject> entry) {
        return new PyTuple(PyStringMap.keyToPy(entry.getKey()), entry.getValue());
    }

    public PyList keys() {
        return this.stringmap_keys();
    }

    final PyList stringmap_keys() {
        PyObject[] keyArray = new PyObject[this.table.size()];
        int i = 0;
        for (Object key : this.table.keySet()) {
            keyArray[i++] = PyStringMap.keyToPy(key);
        }
        return new PyList(keyArray);
    }

    public PyList values() {
        return this.stringmap_values();
    }

    final PyList stringmap_values() {
        return new PyList(this.table.values());
    }

    public PyObject iteritems() {
        return this.stringmap_iteritems();
    }

    final PyObject stringmap_iteritems() {
        return new ItemsIter(this.table.entrySet());
    }

    public PyObject iterkeys() {
        return this.stringmap_iterkeys();
    }

    final PyObject stringmap_iterkeys() {
        return new KeysIter(this.table.keySet());
    }

    public PyObject itervalues() {
        return this.stringmap_itervalues();
    }

    final PyObject stringmap_itervalues() {
        return new ValuesIter(this.table.values());
    }

    @Override
    public int hashCode() {
        return this.stringmap___hash__();
    }

    final int stringmap___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public boolean isMappingType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    private static PyObject keyToPy(Object objKey) {
        if (objKey instanceof String) {
            return PyString.fromInterned((String)objKey);
        }
        return (PyObject)objKey;
    }

    private static Object pyToKey(PyObject pyKey) {
        if (pyKey instanceof PyString) {
            return ((PyString)pyKey).internedString();
        }
        return pyKey;
    }

    static {
        PyType.addBuilder(PyStringMap.class, new PyStringMap$PyExposer());
    }

    private class ItemsIter
    extends StringMapIter<Map.Entry<Object, PyObject>> {
        public ItemsIter(Set<Map.Entry<Object, PyObject>> s) {
            super(s);
        }

        @Override
        public PyObject stringMapNext() {
            return PyStringMap.this.itemTuple((Map.Entry)this.iterator.next());
        }
    }

    private class KeysIter
    extends StringMapIter<Object> {
        public KeysIter(Set<Object> s) {
            super(s);
        }

        @Override
        protected PyObject stringMapNext() {
            return PyStringMap.keyToPy(this.iterator.next());
        }
    }

    private class ValuesIter
    extends StringMapIter<PyObject> {
        public ValuesIter(Collection<PyObject> c) {
            super(c);
        }

        @Override
        public PyObject stringMapNext() {
            return (PyObject)this.iterator.next();
        }
    }

    private abstract class StringMapIter<T>
    extends PyIterator {
        protected final Iterator<T> iterator;
        private final int size;

        public StringMapIter(Collection<T> c) {
            this.iterator = c.iterator();
            this.size = c.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyStringMap.this.table.size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.stringMapNext();
        }

        protected abstract PyObject stringMapNext();
    }
}

