/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.plugin.frame.Channels;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class CompositeImage
extends ImagePlus {
    public static final int COMPOSITE = 1;
    public static final int COLOR = 2;
    public static final int GRAYSCALE = 3;
    public static final int TRANSPARENT = 4;
    public static final int MAX_CHANNELS = 8;
    public static final Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow, Color.white};
    int[] rgbPixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    Image awtImage;
    WritableRaster rgbRaster;
    SampleModel rgbSampleModel;
    BufferedImage rgbImage;
    ColorModel rgbCM;
    ImageProcessor[] cip;
    LUT[] lut;
    int currentChannel = -1;
    int previousChannel;
    int currentSlice = 1;
    int currentFrame = 1;
    boolean singleChannel;
    boolean[] active = new boolean[8];
    int mode = 2;
    int bitDepth;
    double[] displayRanges;
    byte[][] channelLuts;
    boolean customLuts;
    boolean syncChannels;

    public CompositeImage(ImagePlus imp) {
        this(imp, 2);
    }

    public CompositeImage(ImagePlus imp, int mode) {
        ImageStack stack2;
        boolean isRGB;
        if (mode < 1 || mode > 3) {
            mode = 2;
        }
        this.mode = mode;
        int channels = imp.getNChannels();
        this.bitDepth = this.getBitDepth();
        if (IJ.debugMode) {
            IJ.log("CompositeImage: " + imp + " " + mode + " " + channels);
        }
        boolean bl = isRGB = imp.getBitDepth() == 24;
        if (isRGB) {
            if (imp.getImageStackSize() > 1) {
                throw new IllegalArgumentException("RGB stacks not supported");
            }
            stack2 = this.getRGBStack(imp);
        } else {
            stack2 = imp.getImageStack();
        }
        int stackSize = stack2.getSize();
        if (channels == 1 && isRGB) {
            channels = 3;
        }
        if (channels == 1 && stackSize <= 8 && !imp.dimensionsSet) {
            channels = stackSize;
        }
        if (channels < 1 || stackSize % channels != 0) {
            throw new IllegalArgumentException("stacksize not multiple of channels");
        }
        if (mode == 1 && channels > 8) {
            this.mode = 2;
        }
        this.compositeImage = true;
        int z = imp.getNSlices();
        int t = imp.getNFrames();
        if (channels == stackSize || channels * z * t != stackSize) {
            this.setDimensions(channels, stackSize / channels, 1);
        } else {
            this.setDimensions(channels, z, t);
        }
        this.setStack(imp.getTitle(), stack2);
        this.setCalibration(imp.getCalibration());
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            this.displayRanges = fi.displayRanges;
            this.channelLuts = fi.channelLuts;
        }
        this.setFileInfo(fi);
        Object info = imp.getProperty("Info");
        if (info != null) {
            this.setProperty("Info", imp.getProperty("Info"));
        }
        this.setProperties(imp.getPropertiesAsArray());
        if (mode == 1) {
            for (int i = 0; i < 8; ++i) {
                this.active[i] = true;
            }
        } else {
            this.active[0] = true;
        }
        this.setRoi(imp.getRoi());
        this.setOverlay(imp.getOverlay());
        if (channels != stackSize) {
            this.setOpenAsHyperStack(true);
        }
    }

    @Override
    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    @Override
    public void updateChannelAndDraw() {
        if (!this.customLuts) {
            this.singleChannel = true;
        }
        this.updateAndDraw();
    }

    public void updateAllChannelsAndDraw() {
        if (this.mode != 1) {
            this.updateChannelAndDraw();
        } else {
            this.syncChannels = true;
            this.singleChannel = false;
            this.updateAndDraw();
        }
    }

    @Override
    public ImageProcessor getChannelProcessor() {
        if (this.cip != null && this.currentChannel != -1) {
            return this.cip[this.currentChannel];
        }
        return this.getProcessor();
    }

    synchronized void setup(int channels, ImageStack stack2) {
        if (stack2 != null && stack2.getSize() > 0 && stack2.getProcessor(1) instanceof ColorProcessor) {
            this.cip = null;
            this.lut = null;
            return;
        }
        this.setupLuts(channels);
        if (this.mode == 1) {
            this.cip = new ImageProcessor[channels];
            for (int i = 0; i < channels; ++i) {
                this.cip[i] = stack2.getProcessor(i + 1);
                this.cip[i].setLut(this.lut[i]);
            }
            this.currentFrame = 1;
            this.currentSlice = 1;
        }
    }

    void setupLuts(int channels) {
        if (this.ip == null) {
            return;
        }
        if (this.lut == null || this.lut.length < channels) {
            if (this.displayRanges != null && channels != this.displayRanges.length / 2) {
                this.displayRanges = null;
            }
            if (this.displayRanges == null && this.ip.getMin() == 0.0 && this.ip.getMax() == 0.0) {
                this.ip.resetMinAndMax();
            }
            this.lut = new LUT[channels];
            LUT lut2 = channels > 8 ? this.createLutFromColor(Color.white) : null;
            for (int i = 0; i < channels; ++i) {
                if (this.channelLuts != null && i < this.channelLuts.length) {
                    this.lut[i] = this.createLutFromBytes(this.channelLuts[i]);
                    this.customLuts = true;
                } else {
                    this.lut[i] = i < 8 ? this.createLutFromColor(colors[i]) : (LUT)lut2.clone();
                }
                if (this.displayRanges != null) {
                    this.lut[i].min = this.displayRanges[i * 2];
                    this.lut[i].max = this.displayRanges[i * 2 + 1];
                    continue;
                }
                this.lut[i].min = this.ip.getMin();
                this.lut[i].max = this.ip.getMax();
            }
            this.displayRanges = null;
        }
    }

    public void resetDisplayRanges() {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        ImageStack stack2 = this.getImageStack();
        if (this.lut == null || channels != this.lut.length || channels > stack2.getSize() || channels > 8) {
            return;
        }
        for (int i = 0; i < channels; ++i) {
            ImageProcessor ip2 = stack2.getProcessor(i + 1);
            ip2.resetMinAndMax();
            this.lut[i].min = ip2.getMin();
            this.lut[i].max = ip2.getMax();
        }
    }

    @Override
    public void updateAndDraw() {
        if (this.win == null) {
            this.img = null;
            return;
        }
        this.updateImage();
        if (this.win != null) {
            this.notifyListeners(2);
        }
        this.draw();
    }

    @Override
    public synchronized void updateImage() {
        long t0;
        int imageSize = this.width * this.height;
        int nChannels = this.getNChannels();
        int ch = this.getChannel();
        if (ch > nChannels) {
            ch = nChannels;
        }
        boolean newChannel = false;
        if (ch - 1 != this.currentChannel) {
            this.previousChannel = this.currentChannel;
            this.currentChannel = ch - 1;
            newChannel = true;
        }
        ImageProcessor ip = this.getProcessor();
        if (this.mode != 1) {
            if (newChannel) {
                this.setupLuts(nChannels);
                LUT cm = this.lut[this.currentChannel];
                if (ip != null && !(ip instanceof ColorProcessor)) {
                    if (this.mode == 2) {
                        ip.setLut(cm);
                    }
                    if (cm.min != 0.0 || cm.max != 0.0) {
                        ip.setMinAndMax(cm.min, cm.max);
                    }
                }
                if (!IJ.isMacro()) {
                    ContrastAdjuster.update();
                }
                for (int i = 0; i < 8; ++i) {
                    this.active[i] = i == this.currentChannel;
                }
                Channels.updateChannels();
            }
            if (ip != null) {
                this.img = ip.createImage();
            }
            return;
        }
        if (nChannels == 1) {
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            if (ip != null) {
                this.img = ip.createImage();
            }
            return;
        }
        if (this.cip == null || this.cip[0].getWidth() != this.width || this.cip[0].getHeight() != this.height || this.getBitDepth() != this.bitDepth) {
            this.setup(nChannels, this.getImageStack());
            this.rgbPixels = null;
            this.rgbSampleModel = null;
            if (this.currentChannel >= nChannels) {
                this.setSlice(1);
                this.currentChannel = 0;
                newChannel = true;
            }
            this.bitDepth = this.getBitDepth();
        }
        if (newChannel) {
            this.getProcessor().setMinAndMax(this.cip[this.currentChannel].getMin(), this.cip[this.currentChannel].getMax());
            if (!IJ.isMacro()) {
                ContrastAdjuster.update();
            }
        }
        if (this.getSlice() != this.currentSlice || this.getFrame() != this.currentFrame) {
            this.currentSlice = this.getSlice();
            this.currentFrame = this.getFrame();
            int position = this.getStackIndex(1, this.currentSlice, this.currentFrame);
            if (this.cip == null) {
                return;
            }
            for (int i = 0; i < nChannels; ++i) {
                this.cip[i].setPixels(this.getImageStack().getProcessor(position + i).getPixels());
            }
        }
        if (this.rgbPixels == null) {
            this.rgbPixels = new int[imageSize];
            this.newPixels = true;
            this.imageSource = null;
            this.rgbRaster = null;
            this.rgbImage = null;
        }
        this.cip[this.currentChannel].setMinAndMax(ip.getMin(), ip.getMax());
        int projectionMode = 5;
        String prop = this.getProp("CompositeProjection");
        if (prop != null) {
            if (prop.contains("Max") || prop.contains("max")) {
                projectionMode = 6;
            } else if (prop.contains("Min") || prop.contains("min")) {
                projectionMode = 7;
            } else if (prop.contains("Invert") || prop.contains("invert")) {
                projectionMode = 8;
            }
        }
        long l = t0 = IJ.debugMode ? System.nanoTime() : 0L;
        if (this.singleChannel && nChannels <= 3) {
            switch (this.currentChannel) {
                case 0: {
                    this.cip[0].updateComposite(this.rgbPixels, 1);
                    break;
                }
                case 1: {
                    this.cip[1].updateComposite(this.rgbPixels, 2);
                    break;
                }
                case 2: {
                    this.cip[2].updateComposite(this.rgbPixels, 3);
                }
            }
        } else if (projectionMode == 8) {
            this.makeInvertedComposite(this.active);
        } else {
            if (this.cip == null) {
                return;
            }
            if (this.syncChannels) {
                ImageProcessor ip2 = this.getProcessor();
                double min = ip2.getMin();
                double max = ip2.getMax();
                for (int i = 0; i < nChannels; ++i) {
                    this.cip[i].setMinAndMax(min, max);
                    this.lut[i].min = min;
                    this.lut[i].max = max;
                }
                this.syncChannels = false;
            }
            if (this.active[0]) {
                this.cip[0].updateComposite(this.rgbPixels, 4);
            } else {
                int fill = projectionMode == 7 ? 0xFFFFFF : 0;
                for (int i = 1; i < imageSize; ++i) {
                    this.rgbPixels[i] = fill;
                }
            }
            if (this.cip == null || nChannels > this.cip.length) {
                return;
            }
            for (int i = 1; i < nChannels; ++i) {
                if (!this.active[i]) continue;
                this.cip[i].updateComposite(this.rgbPixels, projectionMode);
            }
        }
        if (IJ.debugMode) {
            IJ.log("" + (System.nanoTime() - t0) / 1000L);
        }
        this.createBufferedImage();
        if (this.img == null && this.awtImage != null) {
            this.img = this.awtImage;
        }
        this.singleChannel = false;
    }

    private void makeInvertedComposite(boolean[] chnActive) {
        int bitDepth = this.getBitDepth();
        int w = this.getWidth();
        int h = this.getHeight();
        int nChn = this.getNChannels();
        int nChnActive = 0;
        for (int c = 0; c < nChn; ++c) {
            if (!chnActive[c]) continue;
            ++nChnActive;
        }
        byte[][] in8 = null;
        short[][] in16 = null;
        float[][] in32 = null;
        switch (bitDepth) {
            case 8: {
                in8 = new byte[nChn][];
                break;
            }
            case 16: {
                in16 = new short[nChn][];
                break;
            }
            case 32: {
                in32 = new float[nChn][];
            }
        }
        double[] mins = new double[nChn];
        double[] maxs = new double[nChn];
        double[] scale = new double[nChn];
        LUT[] luts = this.getLuts();
        block16: for (int c = 0; c < nChn; ++c) {
            mins[c] = this.cip[c].getMin();
            maxs[c] = this.cip[c].getMax();
            scale[c] = 255.0 / (maxs[c] - mins[c]);
            switch (bitDepth) {
                case 8: {
                    in8[c] = (byte[])this.cip[c].getPixels();
                    continue block16;
                }
                case 16: {
                    in16[c] = (short[])this.cip[c].getPixels();
                    continue block16;
                }
                case 32: {
                    in32[c] = (float[])this.cip[c].getPixels();
                }
            }
        }
        int[] v = new int[nChn];
        int[] r = new int[nChn];
        int[] g = new int[nChn];
        int[] b = new int[nChn];
        for (int idx = 0; idx < w * h; ++idx) {
            int value;
            int c;
            for (c = 0; c < nChn; ++c) {
                switch (bitDepth) {
                    case 8: {
                        v[c] = (int)Math.floor(((double)(in8[c][idx] & 0xFF) - mins[c]) * scale[c]);
                        break;
                    }
                    case 16: {
                        v[c] = (int)Math.floor(((double)(in16[c][idx] & 0xFFFF) - mins[c]) * scale[c]);
                        break;
                    }
                    case 32: {
                        v[c] = (int)Math.floor(((double)in32[c][idx] - mins[c]) * scale[c]);
                    }
                }
                v[c] = Math.min(v[c], 255);
                v[c] = Math.max(v[c], 0);
                r[c] = luts[c].getRed(v[c]);
                g[c] = luts[c].getGreen(v[c]);
                b[c] = luts[c].getBlue(v[c]);
            }
            int sumB = 0;
            int sumG = 0;
            int sumR = 0;
            for (c = 0; c < nChn; ++c) {
                if (!chnActive[c]) continue;
                sumR += r[c];
                sumG += g[c];
                sumB += b[c];
            }
            int newR = sumR - (nChnActive - 1) * 255;
            int newG = sumG - (nChnActive - 1) * 255;
            int newB = sumB - (nChnActive - 1) * 255;
            newR = Math.max(newR, 0);
            newG = Math.max(newG, 0);
            newB = Math.max(newB, 0);
            this.rgbPixels[idx] = value = newR * 256 * 256 + newG * 256 + newB;
        }
    }

    void createImage() {
        if (this.imageSource == null) {
            this.rgbCM = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.imageSource = new MemoryImageSource(this.width, this.height, this.rgbCM, this.rgbPixels, 0, this.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.newPixels = false;
        } else if (this.newPixels) {
            this.imageSource.newPixels(this.rgbPixels, this.rgbCM, 0, this.width);
            this.newPixels = false;
        } else {
            this.imageSource.newPixels();
        }
    }

    void createBufferedImage() {
        if (this.rgbSampleModel == null) {
            this.rgbSampleModel = this.getRGBSampleModel();
        }
        if (this.rgbRaster == null) {
            DataBufferInt dataBuffer = new DataBufferInt(this.rgbPixels, this.width * this.height, 0);
            this.rgbRaster = Raster.createWritableRaster(this.rgbSampleModel, dataBuffer, null);
        }
        if (this.rgbImage == null) {
            this.rgbImage = new BufferedImage(this.rgbCM, this.rgbRaster, false, null);
        }
        this.awtImage = this.rgbImage;
    }

    SampleModel getRGBSampleModel() {
        this.rgbCM = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster wr = this.rgbCM.createCompatibleWritableRaster(1, 1);
        SampleModel sampleModel = wr.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(this.width, this.height);
        return sampleModel;
    }

    ImageStack getRGBStack(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ImageStack stack = new ImageStack(w, h);
        stack.addSlice("Red", r);
        stack.addSlice("Green", g);
        stack.addSlice("Blue", b);
        stack.setColorModel(ip.getDefaultColorModel());
        return stack;
    }

    public LUT createLutFromColor(Color color) {
        return LUT.createLutFromColor(color);
    }

    LUT createLutFromBytes(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length != 768) {
            return this.createLutFromColor(Color.white);
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (i = 0; i < 256; ++i) {
            r[i] = bytes[i];
        }
        for (i = 0; i < 256; ++i) {
            g[i] = bytes[256 + i];
        }
        for (i = 0; i < 256; ++i) {
            b[i] = bytes[512 + i];
        }
        return new LUT(r, g, b);
    }

    public Color getChannelColor() {
        if (this.lut == null || this.mode == 3) {
            return Color.black;
        }
        LUT cm = this.lut[this.getChannelIndex()];
        if (cm == null) {
            return Color.black;
        }
        int index = cm.getMapSize() - 1;
        int r = cm.getRed(index);
        int g = cm.getGreen(index);
        int b = cm.getBlue(index);
        if (r < 100 || g < 100 || b < 100) {
            return new Color(r, g, b);
        }
        return Color.black;
    }

    public ImageProcessor getProcessor(int channel) {
        if (this.cip == null || channel > this.cip.length) {
            return null;
        }
        return this.cip[channel - 1];
    }

    public boolean[] getActiveChannels() {
        return this.active;
    }

    public synchronized void setMode(int mode) {
        int i;
        if (mode < 1 || mode > 3) {
            return;
        }
        if (mode == 1 && this.getNChannels() > 8) {
            mode = 2;
        }
        if (mode != 1 || mode != this.mode) {
            for (i = 0; i < 8; ++i) {
                this.active[i] = true;
            }
        }
        if (this.mode != 1 && mode == 1) {
            this.img = null;
        }
        this.mode = mode;
        if (mode == 2 || mode == 3) {
            if (this.cip != null) {
                for (i = 0; i < this.cip.length; ++i) {
                    if (this.cip[i] != null) {
                        this.cip[i].setPixels(null);
                    }
                    this.cip[i] = null;
                }
            }
            this.cip = null;
            this.rgbPixels = null;
            this.awtImage = null;
            this.currentChannel = -1;
        }
        if (mode == 3 || mode == 4) {
            this.ip.setColorModel(this.ip.getDefaultColorModel());
        }
        Channels.updateChannels();
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString() {
        switch (this.mode) {
            case 1: {
                return "composite";
            }
            case 2: {
                return "color";
            }
            case 3: {
                return "grayscale";
            }
        }
        return "";
    }

    public LUT getChannelLut(int channel) {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        if (channel < 1 || channel > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range: " + channel);
        }
        return this.lut[channel - 1];
    }

    public LUT getChannelLut() {
        int c = this.getChannelIndex();
        return this.lut[c];
    }

    @Override
    public LUT[] getLuts() {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        LUT[] luts = new LUT[channels];
        for (int i = 0; i < channels; ++i) {
            luts[i] = i < this.lut.length ? (LUT)this.lut[i].clone() : (LUT)this.lut[0].clone();
        }
        return luts;
    }

    public void setLuts(LUT[] luts) {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        if (luts == null || luts.length < channels) {
            throw new IllegalArgumentException("Lut array is null or too small");
        }
        for (int i = 0; i < channels; ++i) {
            this.setChannelLut(luts[i], i + 1);
        }
    }

    public synchronized void copyLuts(ImagePlus imp) {
        int channels = this.getNChannels();
        if (!imp.isComposite() || imp.getNChannels() != channels) {
            return;
        }
        CompositeImage ci = (CompositeImage)imp;
        LUT[] luts = ci.getLuts();
        if (luts != null && luts.length == channels) {
            this.lut = luts;
            this.cip = null;
        }
        int mode2 = ci.getMode();
        this.setMode(mode2);
        if (mode2 == 1) {
            boolean[] active2 = ci.getActiveChannels();
            for (int i = 0; i < 8; ++i) {
                this.active[i] = active2[i];
            }
        }
        if (ci.hasCustomLuts()) {
            this.customLuts = true;
        }
    }

    int getChannelIndex() {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        int index = this.getChannel() - 1;
        return index;
    }

    public void reset() {
        int nChannels = this.getNChannels();
        if (nChannels > 8 && this.getMode() == 1) {
            this.setMode(2);
        }
        this.setup(nChannels, this.getImageStack());
    }

    public void completeReset() {
        this.cip = null;
        this.lut = null;
    }

    public void setChannelLut(LUT table) {
        int c = this.getChannelIndex();
        double min = this.lut[c].min;
        double max = this.lut[c].max;
        this.lut[c] = table;
        this.lut[c].min = min;
        this.lut[c].max = max;
        if (this.mode == 1 && this.cip != null && c < this.cip.length) {
            this.cip[c].setColorModel(this.lut[c]);
            this.imageSource = null;
            this.newPixels = true;
            this.img = null;
        }
        this.currentChannel = -1;
        this.getProcessor().setLut(table);
        this.customLuts = true;
        if (!IJ.isMacro()) {
            ContrastAdjuster.update();
        }
    }

    public synchronized void setChannelLut(LUT table, int channel) {
        int channels = this.getNChannels();
        if (this.lut == null) {
            this.setupLuts(channels);
        }
        if (channel < 1 || channel > this.lut.length) {
            throw new IllegalArgumentException("Channel out of range");
        }
        this.lut[channel - 1] = (LUT)table.clone();
        if (this.getWindow() != null && channel == this.getChannel()) {
            this.getProcessor().setLut(this.lut[channel - 1]);
        }
        if (this.cip != null && this.cip.length >= channel && this.cip[channel - 1] != null) {
            this.cip[channel - 1].setLut(this.lut[channel - 1]);
        } else {
            this.cip = null;
        }
        this.customLuts = true;
    }

    public void setChannelColorModel(IndexColorModel cm) {
        this.setChannelLut(new LUT(cm, 0.0, 0.0));
    }

    @Override
    public void setDisplayRange(double min, double max) {
        this.ip.setMinAndMax(min, max);
        int c = this.getChannelIndex();
        this.lut[c].min = min;
        this.lut[c].max = max;
        if (this.getWindow() == null && this.cip != null && c < this.cip.length) {
            this.cip[c].setLut(this.lut[c]);
        }
    }

    @Override
    public double getDisplayRangeMin() {
        if (this.lut != null) {
            return this.lut[this.getChannelIndex()].min;
        }
        return 0.0;
    }

    @Override
    public double getDisplayRangeMax() {
        if (this.lut != null) {
            return this.lut[this.getChannelIndex()].max;
        }
        return 255.0;
    }

    @Override
    public void resetDisplayRange() {
        if (this.getType() == 1 && CompositeImage.getDefault16bitRange() != 0) {
            int defaultRange = CompositeImage.getDefault16bitRange();
            for (int i = 1; i <= this.getNChannels(); ++i) {
                LUT lut = this.getChannelLut(i);
                lut.min = 0.0;
                lut.max = Math.pow(2.0, defaultRange) - 1.0;
                if (this.getWindow() == null) continue;
                this.setChannelLut(lut, i);
            }
        } else {
            this.ip.resetMinAndMax();
            int c = this.getChannelIndex();
            this.lut[c].min = this.ip.getMin();
            this.lut[c].max = this.ip.getMax();
        }
    }

    public boolean hasCustomLuts() {
        return this.customLuts && this.mode != 3;
    }

    @Override
    public void close() {
        int i;
        super.close();
        this.rgbPixels = null;
        this.imageSource = null;
        this.awtImage = null;
        this.rgbRaster = null;
        this.rgbSampleModel = null;
        this.rgbImage = null;
        this.rgbCM = null;
        if (this.cip != null) {
            for (i = 0; i < this.cip.length; ++i) {
                this.cip[i] = null;
            }
            this.cip = null;
        }
        if (this.lut != null) {
            for (i = 0; i < this.lut.length; ++i) {
                this.lut[i] = null;
            }
            this.lut = null;
        }
        if (this.channelLuts != null) {
            for (i = 0; i < this.channelLuts.length; ++i) {
                this.channelLuts[i] = null;
            }
            this.channelLuts = null;
        }
    }

    public synchronized void setChannelsUpdated() {
        if (this.cip != null) {
            for (int i = 0; i < this.cip.length; ++i) {
                if (this.cip[i] != null) {
                    this.cip[i].setPixels(null);
                }
                this.cip[i] = null;
            }
        }
        this.cip = null;
        this.lut = null;
        this.img = null;
        this.currentChannel = -1;
        this.previousChannel = 0;
        this.currentFrame = 1;
        this.currentSlice = 1;
        this.singleChannel = false;
        this.rgbPixels = null;
        this.awtImage = null;
        this.channelLuts = null;
        boolean[] active = new boolean[8];
    }
}

