/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.tool.PlugInTool;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class OverlayBrushTool
extends PlugInTool
implements Runnable {
    private static final int UNCONSTRAINED = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int DO_RESIZE = 3;
    private static final int RESIZED = 4;
    private static final int IDLE = 5;
    private static String WIDTH_KEY = "obrush.width";
    private static final String LOC_KEY = "obrush.loc";
    private static float width = (float)Prefs.get(WIDTH_KEY, 5.0);
    private int transparency;
    private BasicStroke stroke;
    private GeneralPath path;
    private int mode;
    private float xStart;
    private float yStart;
    private float oldWidth = width;
    private boolean newPath;
    private Options options;
    private GenericDialog gd;

    @Override
    public void mousePressed(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        float x = (float)ic.offScreenXD(e.getX());
        float y = (float)ic.offScreenYD(e.getY());
        this.xStart = x;
        this.yStart = y;
        this.oldWidth = width;
        int ctrlMask = IJ.isMacintosh() ? 4 : 2;
        int resizeMask = 1 | ctrlMask;
        if ((e.getModifiers() & resizeMask) == resizeMask) {
            this.mode = 3;
            return;
        }
        if ((e.getModifiers() & ctrlMask) != 0) {
            boolean altKeyDown;
            int[] rgbValues = imp.flatten().getPixel((int)x, (int)y);
            Color color = new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
            boolean bl = altKeyDown = (e.getModifiers() & 8) != 0;
            if (altKeyDown) {
                Toolbar.setBackgroundColor(color);
            } else {
                Toolbar.setForegroundColor(color);
                if (this.gd != null) {
                    this.options.setColor(color);
                }
            }
            this.mode = 5;
            return;
        }
        this.mode = 0;
        this.path = new GeneralPath();
        this.path.moveTo(x, y);
        this.newPath = true;
        this.stroke = new BasicStroke(width, 1, 1);
    }

    @Override
    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        if (this.mode == 5) {
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        float x = (float)ic.offScreenXD(e.getX());
        float y = (float)ic.offScreenYD(e.getY());
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
        }
        if (this.mode == 3 || this.mode == 4) {
            this.changeBrushSize(x - this.xStart, imp);
            return;
        }
        if ((e.getModifiers() & 1) != 0) {
            if (this.mode == 0) {
                if (Math.abs(x - this.xStart) > Math.abs(y - this.yStart)) {
                    this.mode = 1;
                } else if (Math.abs(x - this.xStart) < Math.abs(y - this.yStart)) {
                    this.mode = 2;
                } else {
                    return;
                }
            }
            if (this.mode == 1) {
                y = this.yStart;
            } else if (this.mode == 2) {
                x = this.xStart;
            }
        } else {
            this.xStart = x;
            this.yStart = y;
            this.mode = 0;
        }
        this.path.lineTo(x, y);
        ShapeRoi roi = new ShapeRoi(this.path);
        boolean altKeyDown = (e.getModifiers() & 8) != 0;
        Color color = altKeyDown ? Toolbar.getBackgroundColor() : Toolbar.getForegroundColor();
        float red = (float)((double)color.getRed() / 255.0);
        float green = (float)((double)color.getGreen() / 255.0);
        float blue = (float)((double)color.getBlue() / 255.0);
        float alpha = (float)((double)(100 - this.transparency) / 100.0);
        roi.setStrokeColor(new Color(red, green, blue, alpha));
        roi.setStroke(this.stroke);
        if (this.newPath) {
            overlay.add(roi);
            this.newPath = false;
        } else {
            overlay.remove(overlay.size() - 1);
            overlay.add(roi);
        }
        imp.setOverlay(overlay);
    }

    @Override
    public void mouseReleased(ImagePlus imp, MouseEvent e) {
        if (this.mode == 4) {
            Overlay overlay = imp.getOverlay();
            overlay.remove(overlay.size() - 1);
            imp.setOverlay(overlay);
            Prefs.set(WIDTH_KEY, width);
            if (this.gd != null) {
                this.options.setWidth(width);
            }
        } else if (this.newPath) {
            this.mouseDragged(imp, e);
        }
    }

    private void changeBrushSize(float deltaWidth, ImagePlus imp) {
        if (deltaWidth != 0.0f) {
            Overlay overlay = imp.getOverlay();
            width = this.oldWidth + deltaWidth;
            if (width < 0.0f) {
                width = 0.0f;
            }
            OvalRoi circle = new OvalRoi(this.xStart - width / 2.0f, this.yStart - width / 2.0f, width, width);
            circle.setStrokeColor(Color.red);
            overlay = imp.getOverlay();
            if (overlay == null) {
                overlay = new Overlay();
            }
            if (this.mode == 4) {
                overlay.remove(overlay.size() - 1);
            }
            overlay.add(circle);
            imp.setOverlay(overlay);
        }
        IJ.showStatus("Overlay Brush width: " + IJ.d2s(width));
        this.mode = 4;
    }

    @Override
    public void showOptionsDialog() {
        Thread thread = new Thread((Runnable)this, "Brush Options");
        thread.setPriority(5);
        thread.start();
    }

    @Override
    public String getToolName() {
        return "Overlay Brush Tool";
    }

    @Override
    public String getToolIcon() {
        return "C037La077Ld098L6859L4a2fL2f4fL3f99L5e9bL9b98L6888L5e8dL888cC123P2f7f9ebdcaf70";
    }

    @Override
    public void run() {
        new Options();
    }

    public static void setWidth(double brushWidth) {
        width = (float)brushWidth;
    }

    class Options
    implements DialogListener {
        Options() {
            if (OverlayBrushTool.this.gd != null) {
                OverlayBrushTool.this.gd.toFront();
                return;
            }
            OverlayBrushTool.this.options = this;
            if (IJ.debugMode) {
                IJ.log("Options: true");
            }
            this.showDialog();
        }

        void setWidth(float width) {
            Vector numericFields = OverlayBrushTool.this.gd.getNumericFields();
            TextField widthField = (TextField)numericFields.elementAt(0);
            widthField.setText(IJ.d2s(width, 1));
            Vector sliders = OverlayBrushTool.this.gd.getSliders();
            Scrollbar sb = (Scrollbar)sliders.elementAt(0);
            sb.setValue((int)(width + 0.5f));
        }

        void setColor(Color c) {
            String name = Colors.getColorName(c, "");
            if (name.length() > 0) {
                Vector choices = OverlayBrushTool.this.gd.getChoices();
                Choice ch = (Choice)choices.elementAt(0);
                ch.select(name);
            }
        }

        public void showDialog() {
            Color color = Toolbar.getForegroundColor();
            String colorName = Colors.colorToString2(color);
            OverlayBrushTool.this.gd = GUI.newNonBlockingDialog("Overlay Brush Options");
            OverlayBrushTool.this.gd.addSlider("Brush width:", 0.0, 50.0, width);
            OverlayBrushTool.this.gd.addSlider("Transparency:", 0.0, 100.0, OverlayBrushTool.this.transparency);
            OverlayBrushTool.this.gd.addChoice("Color:", Colors.getColors(colorName), colorName);
            OverlayBrushTool.this.gd.setInsets(10, 0, 0);
            String ctrlString = IJ.isMacintosh() ? "CMD" : "CTRL";
            OverlayBrushTool.this.gd.addMessage("SHIFT for horizontal or vertical lines\nALT to draw in background color\n" + ctrlString + "-SHIFT-drag to change brush width\n" + ctrlString + "-click to change foreground color\n", null, Color.darkGray);
            OverlayBrushTool.this.gd.hideCancelButton();
            OverlayBrushTool.this.gd.addHelp("");
            OverlayBrushTool.this.gd.setHelpLabel("Undo");
            OverlayBrushTool.this.gd.setOKLabel("Close");
            OverlayBrushTool.this.gd.addDialogListener(this);
            Point loc = Prefs.getLocation(OverlayBrushTool.LOC_KEY);
            if (loc != null) {
                OverlayBrushTool.this.gd.centerDialog(false);
                OverlayBrushTool.this.gd.setLocation(loc);
            }
            OverlayBrushTool.this.gd.showDialog();
            Prefs.saveLocation(OverlayBrushTool.LOC_KEY, OverlayBrushTool.this.gd.getLocation());
            if (IJ.debugMode) {
                IJ.log("Options: false");
            }
            OverlayBrushTool.this.gd = null;
        }

        @Override
        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            if (e != null && e.toString().contains("Undo")) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp == null) {
                    return true;
                }
                Overlay overlay = imp.getOverlay();
                if (overlay != null && overlay.size() > 0) {
                    overlay.remove(overlay.size() - 1);
                    imp.draw();
                }
                return true;
            }
            width = (float)gd.getNextNumber();
            if (gd.invalidNumber() || width < 0.0f) {
                width = (float)Prefs.get(WIDTH_KEY, 5.0);
            }
            OverlayBrushTool.this.transparency = (int)gd.getNextNumber();
            if (gd.invalidNumber() || OverlayBrushTool.this.transparency < 0 || OverlayBrushTool.this.transparency > 100) {
                OverlayBrushTool.this.transparency = 100;
            }
            String colorName = gd.getNextChoice();
            Color color = Colors.decode(colorName, null);
            Toolbar.setForegroundColor(color);
            Prefs.set(WIDTH_KEY, width);
            return true;
        }
    }
}

