/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.exception.TooLargeArrayException;
import icy.common.exception.UnsupportedFormatException;
import icy.common.listener.ChangeListener;
import icy.image.IcyBufferedImageEvent;
import icy.image.IcyBufferedImageListener;
import icy.image.IcyBufferedImageUtil;
import icy.image.cache.ImageCache;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.image.colormodel.IcyColorModel;
import icy.image.colormodel.IcyColorModelEvent;
import icy.image.colormodel.IcyColorModelListener;
import icy.image.lut.LUT;
import icy.math.ArrayMath;
import icy.math.MathUtil;
import icy.math.Scaler;
import icy.preferences.GeneralPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequenceIdImporter;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.ArrayUtil;
import icy.type.collection.array.ByteArrayConvert;
import icy.util.StringUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.PlanarImage;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.gui.SignedByteBuffer;
import loci.formats.gui.SignedShortBuffer;
import loci.formats.gui.UnsignedIntBuffer;
import plugins.kernel.importer.LociImporterPlugin;

public class IcyBufferedImage
extends BufferedImage
implements IcyColorModelListener,
ChangeListener {
    static final ImageDataLoader imageDataLoader = new ImageDataLoader();
    static final Map<Integer, WeakIcyBufferedImageReference> images = new HashMap<Integer, WeakIcyBufferedImageReference>();
    @Deprecated
    public static int TYPE_BYTE = 0;
    @Deprecated
    public static int TYPE_DOUBLE = 5;
    @Deprecated
    public static int TYPE_FLOAT = 4;
    @Deprecated
    public static int TYPE_INT = 3;
    @Deprecated
    public static int TYPE_SHORT = 2;
    @Deprecated
    public static int TYPE_UNDEFINED = 32;
    protected ImageSourceInfo imageSourceInfo;
    protected boolean autoUpdateChannelBounds;
    protected boolean volatile_;
    protected final int width;
    protected final int height;
    protected final int minX;
    protected final int minY;
    protected final int offsetX;
    protected final int offsetY;
    protected boolean dataInitialized;
    protected int lockedCount = 0;
    private boolean constructed = false;
    protected final UpdateEventHandler updater;
    protected final List<IcyBufferedImageListener> listeners;
    protected ColorModel colorModel;
    protected WritableRaster raster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IcyBufferedImage getIcyBufferedImage(Integer idHashCode) {
        WeakIcyBufferedImageReference ref;
        Map<Integer, WeakIcyBufferedImageReference> map = images;
        synchronized (map) {
            ref = images.get(idHashCode);
        }
        if (ref != null) {
            return (IcyBufferedImage)ref.get();
        }
        return null;
    }

    public static IcyBufferedImage getIcyBufferedImage(int idHashCode) {
        return IcyBufferedImage.getIcyBufferedImage((Integer)idHashCode);
    }

    @Deprecated
    protected static IcyBufferedImageUtil.FilterType getNewFilterType(FilterType ft) {
        switch (ft) {
            default: {
                return IcyBufferedImageUtil.FilterType.NEAREST;
            }
            case BILINEAR: {
                return IcyBufferedImageUtil.FilterType.BILINEAR;
            }
            case BICUBIC: 
        }
        return IcyBufferedImageUtil.FilterType.BICUBIC;
    }

    @Deprecated
    public static IcyBufferedImage convert(List<BufferedImage> imageList) {
        return IcyBufferedImage.createFrom(imageList);
    }

    public static IcyBufferedImage createFrom(List<? extends BufferedImage> imageList) throws IllegalArgumentException {
        if (imageList.size() == 0) {
            throw new IllegalArgumentException("imageList should contains at least 1 image");
        }
        ArrayList<IcyBufferedImage> icyImageList = new ArrayList<IcyBufferedImage>();
        for (BufferedImage bufferedImage : imageList) {
            icyImageList.add(IcyBufferedImage.createFrom(bufferedImage));
        }
        IcyBufferedImage firstImage = (IcyBufferedImage)icyImageList.get(0);
        if (icyImageList.size() == 1) {
            return firstImage;
        }
        DataType dataType = firstImage.getDataType_();
        int width = firstImage.getWidth();
        int height = firstImage.getHeight();
        int numChannel = 0;
        for (IcyBufferedImage image : icyImageList) {
            numChannel += image.getSizeC();
        }
        Object[] data = Array2DUtil.createArray(dataType, numChannel);
        IcyColorMap[] colormaps = new IcyColorMap[numChannel];
        int destC = 0;
        for (IcyBufferedImage image : icyImageList) {
            if (dataType != image.getDataType_()) {
                throw new IllegalArgumentException("All images contained in imageList should have the same dataType");
            }
            if (width != image.getWidth() || height != image.getHeight()) {
                throw new IllegalArgumentException("All images contained in imageList should have the same dimension");
            }
            for (int c = 0; c < image.getSizeC(); ++c) {
                data[destC] = image.getDataXY(c);
                colormaps[destC++] = image.getColorMap(c);
            }
        }
        IcyBufferedImage result = new IcyBufferedImage(width, height, data, dataType.isSigned());
        for (int c = 0; c < result.getSizeC(); ++c) {
            result.setColorMap(c, colormaps[c], false);
        }
        return result;
    }

    @Deprecated
    public static IcyBufferedImage convert(BufferedImage image) {
        return IcyBufferedImage.createFrom(image);
    }

    public static IcyBufferedImage createFrom(PlanarImage image, boolean signedDataType) {
        DataBuffer db = image.getData().getDataBuffer();
        int w = image.getWidth();
        int h = image.getHeight();
        if (db instanceof DataBufferByte) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferByte)db).getBankData(), signedDataType);
        }
        if (db instanceof DataBufferShort) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferShort)db).getBankData(), signedDataType);
        }
        if (db instanceof DataBufferUShort) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferUShort)db).getBankData(), signedDataType);
        }
        if (db instanceof DataBufferInt) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferInt)db).getBankData(), signedDataType);
        }
        if (db instanceof java.awt.image.DataBufferFloat) {
            return new IcyBufferedImage(w, h, (Object[])((java.awt.image.DataBufferFloat)db).getBankData(), true);
        }
        if (db instanceof DataBufferFloat) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferFloat)db).getBankData(), true);
        }
        if (db instanceof java.awt.image.DataBufferDouble) {
            return new IcyBufferedImage(w, h, (Object[])((java.awt.image.DataBufferDouble)db).getBankData(), true);
        }
        if (db instanceof DataBufferDouble) {
            return new IcyBufferedImage(w, h, (Object[])((DataBufferDouble)db).getBankData(), true);
        }
        return IcyBufferedImage.createFrom(image.getAsBufferedImage());
    }

    public static IcyBufferedImage createFrom(PlanarImage image) {
        return IcyBufferedImage.createFrom(image, false);
    }

    public static IcyBufferedImage createFrom(BufferedImage image) {
        BufferedImage temp;
        if (image instanceof IcyBufferedImage) {
            return (IcyBufferedImage)image;
        }
        if (image.getColorModel() instanceof IcyColorModel) {
            return new IcyBufferedImage(IcyColorModel.createInstance((IcyColorModel)image.getColorModel(), false, false), image.getRaster());
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int type = image.getType();
        switch (type) {
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                temp = new BufferedImage(w, h, 5);
                Graphics2D g = temp.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                temp = new BufferedImage(w, h, 6);
                Graphics2D g = temp.createGraphics();
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                break;
            }
            case 5: 
            case 6: {
                temp = image;
                break;
            }
            default: {
                if (image.getColorModel().getNumComponents() > 1 && !(image.getSampleModel() instanceof ComponentSampleModel)) {
                    temp = new BufferedImage(w, h, 6);
                    Graphics2D g = temp.createGraphics();
                    g.drawImage((Image)image, 0, 0, null);
                    g.dispose();
                    break;
                }
                temp = image;
            }
        }
        DataType dataType = DataType.getDataTypeFromDataBufferType(temp.getColorModel().getTransferType());
        int numComponents = temp.getRaster().getNumBands();
        IcyBufferedImage result = new IcyBufferedImage(w, h, numComponents, dataType);
        result.copyData(temp);
        switch (type) {
            case 12: 
            case 13: {
                if (numComponents != 2) break;
                result.setColorMaps(image);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                if (numComponents != 4) break;
                result.setColorMap(3, LinearColorMap.alpha_, true);
            }
        }
        return result;
    }

    @Deprecated
    public static IcyBufferedImage createCompatibleThumbnailFrom(IFormatReader reader, int z, int t) throws FormatException, IOException {
        return LociImporterPlugin.getThumbnailCompatible(reader, z, t, -1);
    }

    @Deprecated
    public static IcyBufferedImage createThumbnailFrom(IFormatReader reader, int z, int t) throws FormatException, IOException {
        return LociImporterPlugin.getThumbnail(reader, z, t, -1);
    }

    @Deprecated
    public static IcyBufferedImage createFrom(IFormatReader reader, int x, int y, int w, int h, int z, int t, int c) throws FormatException, IOException {
        return LociImporterPlugin.getImage(reader, new Rectangle(x, y, w, h), z, t, c, 0);
    }

    @Deprecated
    public static IcyBufferedImage createFrom(IFormatReader reader, int z, int t) throws FormatException, IOException {
        return LociImporterPlugin.getImage(reader, null, z, t);
    }

    @Deprecated
    public static IcyBufferedImage createEmptyImage(int width, int height, IcyColorModel cm) {
        return new IcyBufferedImage(width, height, cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IcyBufferedImage(IcyColorModel cm, WritableRaster wr, boolean autoUpdateChannelBounds, boolean dataInitialized, boolean forceVolatileData) {
        super(cm, cm.createDummyWritableRaster(wr.getWidth(), wr.getHeight()), false, null);
        Map<Integer, WeakIcyBufferedImageReference> map = images;
        synchronized (map) {
            images.put(System.identityHashCode(this), new WeakIcyBufferedImageReference(this));
        }
        this.colorModel = cm;
        this.imageSourceInfo = null;
        this.width = wr.getWidth();
        this.height = wr.getHeight();
        this.minX = wr.getMinX();
        this.minY = wr.getMinY();
        this.offsetX = wr.getSampleModelTranslateX();
        this.offsetY = wr.getSampleModelTranslateY();
        this.autoUpdateChannelBounds = autoUpdateChannelBounds;
        this.updater = new UpdateEventHandler(this, false);
        this.listeners = new ArrayList<IcyBufferedImageListener>();
        if (forceVolatileData || GeneralPreferences.getVirtualMode()) {
            this.volatile_ = true;
            this.raster = null;
        } else {
            this.volatile_ = false;
            this.raster = wr;
        }
        this.dataInitialized = dataInitialized;
        if (dataInitialized) {
            this.saveRasterInCache(wr);
            if (autoUpdateChannelBounds) {
                this.updateChannelsBounds();
            }
        }
        cm.addListener(this);
        this.constructed = true;
    }

    protected IcyBufferedImage(IcyColorModel cm, WritableRaster wr, boolean autoUpdateChannelBounds) {
        this(cm, wr, autoUpdateChannelBounds, true, false);
    }

    protected IcyBufferedImage(IcyColorModel cm, WritableRaster wr) {
        this(cm, wr, false, true, false);
    }

    protected IcyBufferedImage(IcyColorModel cm, int width, int height, boolean forceVolatileData) {
        this(cm, cm.createCompatibleWritableRaster(width, height), false, false, forceVolatileData);
    }

    protected IcyBufferedImage(IcyColorModel cm, int width, int height) {
        this(cm, cm.createCompatibleWritableRaster(width, height), false, false, false);
    }

    protected IcyBufferedImage(IcyColorModel cm, Object[] data, int width, int height, boolean autoUpdateChannelBounds) {
        this(cm, cm.createWritableRaster(data, width, height), autoUpdateChannelBounds);
    }

    public IcyBufferedImage(int width, int height, Object[] data, boolean signed, boolean autoUpdateChannelBounds) {
        this(IcyColorModel.createInstance(data.length, ArrayUtil.getDataType(data[0], signed)), data, width, height, autoUpdateChannelBounds);
    }

    public IcyBufferedImage(int width, int height, Object[] data, boolean signed) {
        this(IcyColorModel.createInstance(data.length, ArrayUtil.getDataType(data[0], signed)), data, width, height, false);
    }

    public IcyBufferedImage(int width, int height, Object[] data) {
        this(width, height, data, false);
    }

    public IcyBufferedImage(int width, int height, Object data, boolean signed, boolean autoUpdateChannelBounds) {
        this(width, height, ArrayUtil.encapsulate(data), signed, autoUpdateChannelBounds);
    }

    public IcyBufferedImage(int width, int height, Object data, boolean signed) {
        this(width, height, ArrayUtil.encapsulate(data), signed);
    }

    public IcyBufferedImage(int width, int height, Object data) {
        this(width, height, ArrayUtil.encapsulate(data));
    }

    public IcyBufferedImage(int width, int height, int numComponents, DataType dataType, boolean forceVolatileData) {
        this(IcyColorModel.createInstance(numComponents, dataType), width, height, forceVolatileData);
    }

    public IcyBufferedImage(int width, int height, int numComponents, DataType dataType) {
        this(IcyColorModel.createInstance(numComponents, dataType), width, height, false);
    }

    public IcyBufferedImage(int width, int height, IcyColorModel cm) {
        this(width, height, cm.getNumComponents(), cm.getDataType_());
    }

    @Deprecated
    public IcyBufferedImage(int width, int height, int numComponents, int dataType, boolean signed) {
        this(IcyColorModel.createInstance(numComponents, dataType, signed), width, height);
    }

    @Deprecated
    public IcyBufferedImage(int width, int height, int numComponents, int dataType) {
        this(IcyColorModel.createInstance(numComponents, dataType, false), width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        imageDataLoader.cancelTasks(this);
        if (ImageCache.isEnabled()) {
            ImageCache.remove(this);
        }
        Map<Integer, WeakIcyBufferedImageReference> map = images;
        synchronized (map) {
            images.remove(System.identityHashCode(this));
        }
        super.finalize();
    }

    public ImageSourceInfo getImageSourceInfo() {
        return this.imageSourceInfo;
    }

    public void setImageSourceInfo(SequenceIdImporter imp, int series, int resolution, Rectangle region, int t, int z, int c) {
        this.imageSourceInfo = new ImageSourceInfo(imp, series, resolution, region, t, z, c);
    }

    public boolean isDataInitialized() {
        return this.dataInitialized;
    }

    public boolean isDataLoaded() {
        return this.isDataInitialized();
    }

    public boolean isDataInMemory() {
        return !ImageCache.isEnabled() || ImageCache.isOnMemoryCache(this);
    }

    public boolean isVolatile() {
        return this.volatile_;
    }

    public void setVolatile(boolean value) throws OutOfMemoryError, UnsupportedOperationException {
        if (value == this.volatile_) {
            return;
        }
        if (value && !ImageCache.isEnabled()) {
            throw new UnsupportedOperationException("IcyBufferedImage.setVolatile(..) error: Image cache is disabled.");
        }
        this.volatile_ = value;
        if (value) {
            if (this.raster != null) {
                this.saveRasterInCache(this.raster);
                this.raster = null;
            }
        } else {
            try {
                this.raster = !this.isDataInitialized() ? this.buildRaster(this.createEmptyRasterData()) : this.getRaster();
                ImageCache.remove(this);
            }
            catch (OutOfMemoryError e) {
                System.err.println(e.getMessage());
                System.err.println("IcyBufferedImage.setVolatile(false) error: not enough memory to set image data back in memory.");
                throw e;
            }
            catch (Throwable e) {
                System.err.println("IcyBufferedImage.setVolatile(..) error:");
                System.err.println(e.getMessage());
            }
        }
    }

    public void loadData() {
        if (!this.isDataInitialized()) {
            this.getRaster();
        }
    }

    protected synchronized WritableRaster getRasterInternal() {
        WritableRaster result = this.raster;
        if (this.constructed && !this.isDataInitialized()) {
            Object rasterData = this.initializeData();
            if (rasterData == null) {
                return this.buildRaster(this.createEmptyRasterData());
            }
            this.saveRasterDataInCache(rasterData, false);
            if (result != null) {
                this.setRasterData(result, rasterData);
            }
            this.dataInitialized = true;
            if (this.autoUpdateChannelBounds) {
                this.updateChannelsBounds();
            }
        }
        if (result == null) {
            result = this.loadRasterFromCache();
        }
        return result;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(IcyColorModel cm) {
        if (this.colorModel != cm) {
            if (this.colorModel instanceof IcyColorModel) {
                ((IcyColorModel)this.colorModel).removeListener(this);
            }
            this.colorModel = cm;
            if (cm != null) {
                cm.addListener(this);
            }
        }
    }

    @Override
    public int getTransparency() {
        return this.getColorModel().getTransparency();
    }

    @Override
    public boolean isAlphaPremultiplied() {
        return this.getColorModel().isAlphaPremultiplied();
    }

    @Override
    public WritableRaster getRaster() {
        return this.getRasterInternal();
    }

    @Override
    public WritableRaster getAlphaRaster() {
        return this.getColorModel().getAlphaRaster(this.getRaster());
    }

    public synchronized boolean isRasterLocked() {
        return this.raster != null;
    }

    public synchronized void lockRaster() {
        if (this.lockedCount++ != 0) {
            return;
        }
        this.raster = this.getRaster();
    }

    public synchronized void releaseRaster(boolean saveInCache) {
        if (--this.lockedCount != 0) {
            return;
        }
        if (this.isVolatile() && this.raster != null) {
            if (saveInCache) {
                this.saveRasterInCache(this.raster);
            }
            this.raster = null;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.width;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.height;
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.offsetX;
    }

    @Override
    public int getTileGridYOffset() {
        return this.offsetY;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.getRaster().getSampleModel();
    }

    @Override
    public void coerceData(boolean isAlphaPremultiplied) {
    }

    @Override
    public WritableRaster copyData(WritableRaster outRaster) {
        if (outRaster == null) {
            return (WritableRaster)this.getData();
        }
        WritableRaster wr = this.getRaster();
        int width = outRaster.getWidth();
        int height = outRaster.getHeight();
        int startX = outRaster.getMinX();
        int startY = outRaster.getMinY();
        Object tdata = null;
        for (int i = startY; i < startY + height; ++i) {
            tdata = wr.getDataElements(startX, i, width, 1, tdata);
            outRaster.setDataElements(startX, i, width, 1, tdata);
        }
        return outRaster;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        if (tileX == 0 && tileY == 0) {
            return this.getRaster();
        }
        throw new ArrayIndexOutOfBoundsException("BufferedImages only have one tile with index 0,0");
    }

    @Override
    public WritableRaster getWritableTile(int tileX, int tileY) {
        this.lockRaster();
        return this.getRaster();
    }

    @Override
    public void releaseWritableTile(int tileX, int tileY) {
        this.releaseRaster(true);
    }

    @Override
    public Raster getData() {
        WritableRaster wr = this.getRaster();
        WritableRaster result = Raster.createWritableRaster(wr.getSampleModel(), new Point(wr.getSampleModelTranslateX(), wr.getSampleModelTranslateY()));
        int width = wr.getWidth();
        int height = wr.getHeight();
        int startX = wr.getMinX();
        int startY = wr.getMinY();
        Object tdata = null;
        for (int i = startY; i < startY + height; ++i) {
            tdata = wr.getDataElements(startX, i, width, 1, tdata);
            result.setDataElements(startX, i, width, 1, tdata);
        }
        return result;
    }

    @Override
    public Raster getData(Rectangle rect) {
        WritableRaster wr = this.getRaster();
        SampleModel sm = wr.getSampleModel();
        SampleModel nsm = sm.createCompatibleSampleModel(rect.width, rect.height);
        WritableRaster result = Raster.createWritableRaster(nsm, rect.getLocation());
        int width = rect.width;
        int height = rect.height;
        int startX = rect.x;
        int startY = rect.y;
        Object tdata = null;
        for (int i = startY; i < startY + height; ++i) {
            tdata = wr.getDataElements(startX, i, width, 1, tdata);
            result.setDataElements(startX, i, width, 1, tdata);
        }
        return result;
    }

    @Override
    public void setData(Raster r) {
        WritableRaster wr = this.getRaster();
        int width = r.getWidth();
        int height = r.getHeight();
        int startX = r.getMinX();
        int startY = r.getMinY();
        int[] tdata = null;
        Rectangle rclip = new Rectangle(startX, startY, width, height);
        Rectangle bclip = new Rectangle(0, 0, wr.getWidth(), wr.getHeight());
        Rectangle intersect = rclip.intersection(bclip);
        if (intersect.isEmpty()) {
            return;
        }
        width = intersect.width;
        height = intersect.height;
        startX = intersect.x;
        for (int i = startY = intersect.y; i < startY + height; ++i) {
            tdata = r.getPixels(startX, i, width, 1, tdata);
            wr.setPixels(startX, i, width, 1, tdata);
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.getColorModel().getRGB(this.getRaster().getDataElements(x, y, null));
    }

    @Override
    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        Object[] data;
        IcyColorModel cm = this.getIcyColorModel();
        WritableRaster wr = this.getRaster();
        int yoff = offset;
        int nbands = wr.getNumBands();
        int dataType = wr.getDataBuffer().getDataType();
        switch (dataType) {
            case 0: {
                data = new byte[nbands];
                break;
            }
            case 1: {
                data = new short[nbands];
                break;
            }
            case 3: {
                data = new int[nbands];
                break;
            }
            case 4: {
                data = new float[nbands];
                break;
            }
            case 5: {
                data = new double[nbands];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + dataType);
            }
        }
        if (rgbArray == null) {
            rgbArray = new int[offset + h * scansize];
        }
        int y = startY;
        while (y < startY + h) {
            int off = yoff;
            for (int x = startX; x < startX + w; ++x) {
                rgbArray[off++] = cm.getRGB(wr.getDataElements(x, y, data));
            }
            ++y;
            yoff += scansize;
        }
        return rgbArray;
    }

    @Override
    public synchronized void setRGB(int x, int y, int rgb) {
        WritableRaster wr = this.getRaster();
        wr.setDataElements(x, y, this.getColorModel().getDataElements(rgb, null));
        this.saveRasterInCache(wr);
    }

    @Override
    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        IcyColorModel cm = this.getIcyColorModel();
        WritableRaster wr = this.getRaster();
        int yoff = offset;
        Object pixel = null;
        int y = startY;
        while (y < startY + h) {
            int off = yoff;
            for (int x = startX; x < startX + w; ++x) {
                pixel = cm.getDataElements(rgbArray[off++], pixel);
                wr.setDataElements(x, y, pixel);
            }
            ++y;
            yoff += scansize;
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public Sequence getOwnerSequence() {
        for (IcyBufferedImageListener listener : this.listeners) {
            if (!(listener instanceof Sequence)) continue;
            return (Sequence)listener;
        }
        return null;
    }

    protected WritableRaster loadRasterFromCache() {
        Object rasterData = null;
        boolean datalost = false;
        try {
            rasterData = ImageCache.get(this);
        }
        catch (Throwable e) {
            datalost = true;
            System.err.println(e.getMessage());
        }
        if (rasterData == null) {
            rasterData = this.initializeData();
            if (rasterData == null) {
                rasterData = this.createEmptyRasterData();
            } else {
                if (datalost) {
                    System.out.println("Data re-initialized (changes are lost)");
                }
                this.saveRasterDataInCache(rasterData, false);
            }
        }
        return this.buildRaster(rasterData);
    }

    public void saveDataInCache() {
        if (this.isDataInitialized()) {
            this.saveRasterInCache(this.getRaster());
        }
    }

    protected void saveRasterInCache(WritableRaster wr) {
        this.saveRasterDataInCache(IcyBufferedImage.getRasterData(wr), true);
    }

    protected void saveRasterDataInCache(Object rasterData, boolean eternal) {
        if (this.isVolatile()) {
            try {
                ImageCache.set(this, rasterData, eternal);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected void saveRasterDataInCache(Object rasterData) {
        this.saveRasterDataInCache(rasterData, true);
    }

    protected WritableRaster buildRaster(Object data) {
        return IcyColorModel.createWritableRaster(data, this.getWidth(), this.getHeight());
    }

    protected static Object getRasterData(WritableRaster wr) {
        DataBuffer db = wr.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                return ((DataBufferByte)db).getBankData();
            }
            case 1: {
                return ((DataBufferUShort)db).getBankData();
            }
            case 2: {
                return ((DataBufferShort)db).getBankData();
            }
            case 3: {
                return ((DataBufferInt)db).getBankData();
            }
            case 4: {
                return ((java.awt.image.DataBufferFloat)db).getBankData();
            }
            case 5: {
                return ((java.awt.image.DataBufferDouble)db).getBankData();
            }
        }
        return null;
    }

    protected void setRasterData(WritableRaster wr, Object data) {
        Object dest;
        DataBuffer db = wr.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                dest = ((DataBufferByte)db).getBankData();
                break;
            }
            case 1: {
                dest = ((DataBufferUShort)db).getBankData();
                break;
            }
            case 2: {
                dest = ((DataBufferShort)db).getBankData();
                break;
            }
            case 3: {
                dest = ((DataBufferInt)db).getBankData();
                break;
            }
            case 4: {
                dest = ((java.awt.image.DataBufferFloat)db).getBankData();
                break;
            }
            case 5: {
                dest = ((java.awt.image.DataBufferDouble)db).getBankData();
                break;
            }
            default: {
                dest = null;
            }
        }
        if (dest != null) {
            int len = Array.getLength(dest);
            for (int i = 0; i < len; ++i) {
                Object destSub = Array.get(dest, i);
                System.arraycopy(Array.get(data, i), 0, destSub, 0, Array.getLength(destSub));
            }
        }
    }

    protected Object initializeData() {
        try {
            return this.loadDataFromImporter();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ClosedByInterruptException e) {
            System.err.println("IcyBufferedImage.loadDataFromImporter() error: image loading from ImageProvider was interrupted (further image won't be loaded) !");
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("IcyBufferedImage.loadDataFromImporter() warning: cannot get image from ImageProvider (possible data loss).");
            return null;
        }
    }

    protected Object createEmptyRasterData() {
        DataType dataType = this.getDataType_();
        int sizeC = this.getSizeC();
        int sizeXY = this.getSizeX() * this.getSizeY();
        Object[] result = Array2DUtil.createArray(dataType, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c] = Array1DUtil.createArray(dataType, sizeXY);
        }
        return result;
    }

    protected Object loadDataFromImporter() throws UnsupportedFormatException, IOException, InterruptedException {
        if (this.imageSourceInfo == null) {
            return this.createEmptyRasterData();
        }
        try {
            return imageDataLoader.loadImageData(this);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsupportedFormatException) {
                throw (UnsupportedFormatException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    public boolean getAutoUpdateChannelBounds() {
        return this.autoUpdateChannelBounds;
    }

    public void setAutoUpdateChannelBounds(boolean value) {
        if (this.autoUpdateChannelBounds != value) {
            if (value) {
                this.updateChannelsBounds();
            }
            this.autoUpdateChannelBounds = value;
        }
    }

    @Deprecated
    public BufferedImage convertToBufferedImage(BufferedImage out, LUT lut) throws InterruptedException {
        return IcyBufferedImageUtil.toBufferedImage(this, out, lut);
    }

    @Deprecated
    public BufferedImage convertToBufferedImage(BufferedImage out) throws InterruptedException {
        return IcyBufferedImageUtil.toBufferedImage(this, out);
    }

    @Deprecated
    public BufferedImage getARGBImage(LUT lut, BufferedImage out) throws InterruptedException {
        return IcyBufferedImageUtil.getARGBImage(this, lut, out);
    }

    @Deprecated
    public BufferedImage getARGBImage(BufferedImage out) throws InterruptedException {
        return IcyBufferedImageUtil.getARGBImage(this, out);
    }

    @Deprecated
    public BufferedImage getARGBImage(LUT lut) throws InterruptedException {
        return IcyBufferedImageUtil.getARGBImage(this, lut);
    }

    @Deprecated
    public BufferedImage getARGBImage() throws InterruptedException {
        return IcyBufferedImageUtil.getARGBImage(this);
    }

    @Deprecated
    public IcyBufferedImage convertToType(DataType dataType, Scaler scaler) {
        return IcyBufferedImageUtil.convertToType(this, dataType, scaler);
    }

    @Deprecated
    public IcyBufferedImage convertToType(int dataType, boolean signed, Scaler scaler) {
        return IcyBufferedImageUtil.convertToType(this, DataType.getDataType(dataType, signed), scaler);
    }

    @Deprecated
    public IcyBufferedImage convertToType(DataType dataType, boolean rescale) {
        return IcyBufferedImageUtil.convertToType(this, dataType, rescale);
    }

    @Deprecated
    public IcyBufferedImage convertToType(int dataType, boolean signed, boolean rescale) {
        return this.convertToType(DataType.getDataType(dataType, signed), rescale);
    }

    @Deprecated
    public BufferedImage convertToBufferedImage(LUT lut, int imageType) throws InterruptedException {
        return IcyBufferedImageUtil.toBufferedImage(this, imageType, lut);
    }

    @Deprecated
    public BufferedImage convertToBufferedImage(int imageType, LUT lut) throws InterruptedException {
        return IcyBufferedImageUtil.toBufferedImage(this, imageType, lut);
    }

    @Deprecated
    public IcyBufferedImage getCopy() {
        return IcyBufferedImageUtil.getCopy(this);
    }

    @Deprecated
    public IcyBufferedImage getSubImageCopy(int x, int y, int w, int h) {
        return IcyBufferedImageUtil.getSubImage(this, x, y, w, h);
    }

    @Override
    @Deprecated
    public IcyBufferedImage getSubimage(int x, int y, int w, int h) {
        throw new UnsupportedOperationException("IcyBufferedImage doesn't support getSubimage method, use getSubImageCopy instead.");
    }

    public IcyBufferedImage getImage(int c) {
        if (c == -1) {
            return this;
        }
        int sizeC = this.getSizeC();
        if (c < 0 || c >= sizeC) {
            return null;
        }
        if (sizeC == 1) {
            return this;
        }
        return new IcyBufferedImage(this.getWidth(), this.getHeight(), this.getDataXY(c), this.isSignedDataType());
    }

    @Deprecated
    public IcyBufferedImage extractChannel(int channelNumber) {
        return IcyBufferedImageUtil.extractChannel(this, channelNumber);
    }

    @Deprecated
    public IcyBufferedImage extractChannels(List<Integer> channelNumbers) {
        return IcyBufferedImageUtil.extractChannels(this, channelNumbers);
    }

    @Deprecated
    public IcyBufferedImage extractBand(int bandNumber) {
        return IcyBufferedImageUtil.extractChannel(this, bandNumber);
    }

    @Deprecated
    public IcyBufferedImage extractBands(List<Integer> bandNumbers) {
        return IcyBufferedImageUtil.extractChannels(this, bandNumbers);
    }

    @Deprecated
    public IcyBufferedImage getScaledCopy(int width, int height, boolean resizeContent, int xAlign, int yAlign, FilterType filterType) {
        return IcyBufferedImageUtil.scale(this, width, height, resizeContent, xAlign, yAlign, IcyBufferedImage.getNewFilterType(filterType));
    }

    @Deprecated
    public IcyBufferedImage getScaledCopy(int width, int height, boolean resizeContent, int xAlign, int yAlign) {
        return IcyBufferedImageUtil.scale(this, width, height, resizeContent, xAlign, yAlign);
    }

    @Deprecated
    public IcyBufferedImage getScaledCopy(int width, int height, FilterType filterType) {
        return IcyBufferedImageUtil.scale(this, width, height, IcyBufferedImage.getNewFilterType(filterType));
    }

    @Deprecated
    public IcyBufferedImage getScaledCopy(int width, int height) {
        return IcyBufferedImageUtil.scale(this, width, height);
    }

    @Deprecated
    public void translate(int dx, int dy, int channel) {
        IcyBufferedImageUtil.translate(this, dx, dy, channel);
    }

    @Deprecated
    public void translate(int dx, int dy) {
        IcyBufferedImageUtil.translate(this, dx, dy);
    }

    protected double[] getCalculatedChannelBounds(int channel) {
        if (!this.isDataInitialized()) {
            return new double[]{0.0, 0.0};
        }
        DataType dataType = this.getDataType_();
        boolean signed = dataType.isSigned();
        Object data = this.getDataXY(channel);
        double min = ArrayMath.min(data, signed);
        double max = ArrayMath.max(data, signed);
        return new double[]{min, max};
    }

    protected double[] adjustBoundsForDataType(double[] bounds) {
        double min = bounds[0];
        double max = bounds[1];
        if (!this.isFloatDataType()) {
            if (min > 0.0) {
                min = 0.0;
            }
            if (max < 0.0) {
                max = 0.0;
            }
        }
        DataType dataType = this.getDataType_();
        switch (dataType.getJavaType()) {
            default: {
                return dataType.getDefaultBounds();
            }
            case SHORT: 
            case INT: 
            case LONG: {
                min = MathUtil.prevPow2((long)min + 1L);
                max = MathUtil.nextPow2Mask((long)max);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                if (!(min >= -1.0) || !(max <= 1.0)) break;
                min = MathUtil.prevPow10(min);
                max = MathUtil.nextPow10(max);
            }
        }
        return new double[]{min, max};
    }

    public double getDataTypeMin() {
        return this.getDataType_().getMinValue();
    }

    public double getDataTypeMax() {
        return this.getDataType_().getMaxValue();
    }

    public double[] getDataTypeBounds() {
        return new double[]{this.getDataTypeMin(), this.getDataTypeMax()};
    }

    public double getChannelTypeMin(int channel) {
        return this.getIcyColorModel().getComponentAbsMinValue(channel);
    }

    public double getChannelTypeMax(int channel) {
        return this.getIcyColorModel().getComponentAbsMaxValue(channel);
    }

    public double[] getChannelTypeBounds(int channel) {
        return this.getIcyColorModel().getComponentAbsBounds(channel);
    }

    public double[][] getChannelsTypeBounds() {
        int sizeC = this.getSizeC();
        double[][] result = new double[sizeC][];
        for (int c = 0; c < sizeC; ++c) {
            result[c] = this.getChannelTypeBounds(c);
        }
        return result;
    }

    public double[] getChannelsGlobalTypeBounds() {
        int sizeC = this.getSizeC();
        double[] result = this.getChannelTypeBounds(0);
        for (int c = 1; c < sizeC; ++c) {
            double[] bounds = this.getChannelTypeBounds(c);
            result[0] = Math.min(bounds[0], result[0]);
            result[1] = Math.max(bounds[1], result[1]);
        }
        return result;
    }

    @Deprecated
    public double[] getChannelTypeGlobalBounds() {
        return this.getChannelsGlobalTypeBounds();
    }

    @Deprecated
    public double[] getGlobalChannelTypeBounds() {
        return this.getChannelTypeGlobalBounds();
    }

    @Deprecated
    public double getComponentAbsMinValue(int component) {
        return this.getChannelTypeMin(component);
    }

    @Deprecated
    public double getComponentAbsMaxValue(int component) {
        return this.getChannelTypeMax(component);
    }

    @Deprecated
    public double[] getComponentAbsBounds(int component) {
        return this.getChannelTypeBounds(component);
    }

    @Deprecated
    public double[][] getComponentsAbsBounds() {
        return this.getChannelsTypeBounds();
    }

    @Deprecated
    public double[] getGlobalComponentAbsBounds() {
        return this.getChannelTypeGlobalBounds();
    }

    public double getChannelMin(int channel) {
        return this.getIcyColorModel().getComponentUserMinValue(channel);
    }

    public double getChannelMax(int channel) {
        return this.getIcyColorModel().getComponentUserMaxValue(channel);
    }

    public double[] getChannelBounds(int channel) {
        return this.getIcyColorModel().getComponentUserBounds(channel);
    }

    public double[][] getChannelsBounds() {
        int sizeC = this.getSizeC();
        double[][] result = new double[sizeC][];
        for (int c = 0; c < sizeC; ++c) {
            result[c] = this.getChannelBounds(c);
        }
        return result;
    }

    public double[] getChannelsGlobalBounds() {
        int sizeC = this.getSizeC();
        double[] result = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (int c = 0; c < sizeC; ++c) {
            double[] bounds = this.getChannelBounds(c);
            if (bounds[0] < result[0]) {
                result[0] = bounds[0];
            }
            if (!(bounds[1] > result[1])) continue;
            result[1] = bounds[1];
        }
        return result;
    }

    @Deprecated
    public double getComponentUserMinValue(int component) {
        return this.getChannelMin(component);
    }

    @Deprecated
    public double getComponentUserMaxValue(int component) {
        return this.getChannelMax(component);
    }

    @Deprecated
    public double[] getComponentUserBounds(int component) {
        return this.getChannelBounds(component);
    }

    @Deprecated
    public double[][] getComponentsUserBounds() {
        return this.getChannelsBounds();
    }

    public void setChannelTypeMin(int channel, double min) {
        this.getIcyColorModel().setComponentAbsMinValue(channel, min);
    }

    public void setChannelTypeMax(int channel, double max) {
        this.getIcyColorModel().setComponentAbsMaxValue(channel, max);
    }

    public void setChannelTypeBounds(int channel, double min, double max) {
        this.getIcyColorModel().setComponentAbsBounds(channel, min, max);
    }

    public void setChannelsTypeBounds(double[][] bounds) {
        this.getIcyColorModel().setComponentsAbsBounds(bounds);
    }

    @Deprecated
    public void setComponentAbsMinValue(int component, double min) {
        this.setChannelTypeMin(component, min);
    }

    @Deprecated
    public void setComponentAbsMaxValue(int component, double max) {
        this.setChannelTypeMax(component, max);
    }

    @Deprecated
    public void setComponentAbsBounds(int component, double[] bounds) {
        this.setChannelTypeBounds(component, bounds[0], bounds[1]);
    }

    @Deprecated
    public void setComponentAbsBounds(int component, double min, double max) {
        this.setChannelTypeBounds(component, min, max);
    }

    @Deprecated
    public void setComponentsAbsBounds(double[][] bounds) {
        this.setChannelsTypeBounds(bounds);
    }

    public void setChannelMin(int channel, double min) {
        IcyColorModel cm = this.getIcyColorModel();
        if (min < cm.getComponentAbsMinValue(channel)) {
            cm.setComponentAbsMinValue(channel, min);
        }
        cm.setComponentUserMinValue(channel, min);
    }

    public void setChannelMax(int channel, double max) {
        IcyColorModel cm = this.getIcyColorModel();
        if (max > cm.getComponentAbsMaxValue(channel)) {
            cm.setComponentAbsMinValue(channel, max);
        }
        cm.setComponentUserMaxValue(channel, max);
    }

    public void setChannelBounds(int channel, double min, double max) {
        IcyColorModel cm = this.getIcyColorModel();
        double[] typeBounds = cm.getComponentAbsBounds(channel);
        if (min < typeBounds[0] || max > typeBounds[1]) {
            cm.setComponentAbsBounds(channel, min, max);
        }
        cm.setComponentUserBounds(channel, min, max);
    }

    public void setChannelsBounds(double[][] bounds) {
        for (int c = 0; c < bounds.length; ++c) {
            double[] b = bounds[c];
            this.setChannelBounds(c, b[0], b[1]);
        }
    }

    @Deprecated
    public void setComponentUserMinValue(int component, double min) {
        this.setChannelMin(component, min);
    }

    @Deprecated
    public void setComponentUserMaxValue(int component, double max) {
        this.setChannelMax(component, max);
    }

    @Deprecated
    public void setComponentUserBounds(int component, double[] bounds) {
        this.setChannelBounds(component, bounds[0], bounds[1]);
    }

    @Deprecated
    public void setComponentUserBounds(int component, double min, double max) {
        this.setChannelBounds(component, min, max);
    }

    @Deprecated
    public void setComponentsUserBounds(double[][] bounds) {
        this.setChannelsBounds(bounds);
    }

    public void updateChannelsBounds() {
        IcyColorModel cm = this.getIcyColorModel();
        if (cm != null) {
            int sizeC = this.getSizeC();
            for (int c = 0; c < sizeC; ++c) {
                double[] bounds = this.getCalculatedChannelBounds(c);
                cm.setComponentAbsBounds(c, this.adjustBoundsForDataType(bounds));
                cm.setComponentUserBounds(c, bounds);
            }
        }
    }

    @Deprecated
    public void updateComponentsBounds(boolean updateChannelBounds, boolean adjustByteToo) {
        this.updateChannelsBounds();
    }

    @Deprecated
    public void updateComponentsBounds(boolean updateUserBounds) {
        this.updateChannelsBounds();
    }

    public boolean isInside(Point p) {
        return this.isInside(p.x, p.y);
    }

    public boolean isInside(int x, int y) {
        return x >= 0 && x < this.getSizeX() && y >= 0 && y < this.getSizeY();
    }

    public boolean isInside(double x, double y) {
        return x >= 0.0 && x < (double)this.getSizeX() && y >= 0.0 && y < (double)this.getSizeY();
    }

    public IcyColorModel getIcyColorModel() {
        return (IcyColorModel)this.getColorModel();
    }

    public DataType getDataType_() {
        return this.getIcyColorModel().getDataType_();
    }

    @Deprecated
    public int getDataType() {
        return this.getIcyColorModel().getDataType();
    }

    public boolean isFloatDataType() {
        return this.getDataType_().isFloat();
    }

    public boolean isSignedDataType() {
        return this.getDataType_().isSigned();
    }

    @Deprecated
    public int getNumComponents() {
        return this.getSizeC();
    }

    public int getSizeC() {
        return this.getColorModel().getNumComponents();
    }

    public int getSizeX() {
        return this.getWidth();
    }

    public int getSizeY() {
        return this.getHeight();
    }

    public Dimension getDimension() {
        return new Dimension(this.getSizeX(), this.getSizeY());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getSizeX(), this.getSizeY());
    }

    public int getNumSample() {
        return this.getSizeX() * this.getSizeY() * this.getSizeC();
    }

    public int getOffset(int x, int y) {
        return y * this.getWidth() + x;
    }

    public LUT createCompatibleLUT(boolean createColorModel) {
        IcyColorModel cm = createColorModel ? IcyColorModel.createInstance(this.getIcyColorModel(), false, false) : this.getIcyColorModel();
        return new LUT(cm);
    }

    public LUT createCompatibleLUT() {
        return this.createCompatibleLUT(true);
    }

    @Deprecated
    public LUT getLUT() {
        return this.createCompatibleLUT();
    }

    public Object getDataXYC() {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYCAsByte();
            }
            case SHORT: {
                return this.getDataXYCAsShort();
            }
            case INT: {
                return this.getDataXYCAsInt();
            }
            case FLOAT: {
                return this.getDataXYCAsFloat();
            }
            case DOUBLE: {
                return this.getDataXYCAsDouble();
            }
        }
        return null;
    }

    public Object getDataXY(int c) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYAsByte(c);
            }
            case SHORT: {
                return this.getDataXYAsShort(c);
            }
            case INT: {
                return this.getDataXYAsInt(c);
            }
            case FLOAT: {
                return this.getDataXYAsFloat(c);
            }
            case DOUBLE: {
                return this.getDataXYAsDouble(c);
            }
        }
        return null;
    }

    public Object getDataCopyXYC() {
        return this.getDataCopyXYC(null, 0);
    }

    public Object getDataCopyXYC(Object out, int offset) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYCAsByte((byte[])out, offset);
            }
            case SHORT: {
                return this.getDataCopyXYCAsShort((short[])out, offset);
            }
            case INT: {
                return this.getDataCopyXYCAsInt((int[])out, offset);
            }
            case FLOAT: {
                return this.getDataCopyXYCAsFloat((float[])out, offset);
            }
            case DOUBLE: {
                return this.getDataCopyXYCAsDouble((double[])out, offset);
            }
        }
        return null;
    }

    public Object getDataCopyXY(int c) {
        return this.getDataCopyXY(c, null, 0);
    }

    public Object getDataCopyXY(int c, Object out, int offset) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYAsByte(c, (byte[])out, offset);
            }
            case SHORT: {
                return this.getDataCopyXYAsShort(c, (short[])out, offset);
            }
            case INT: {
                return this.getDataCopyXYAsInt(c, (int[])out, offset);
            }
            case FLOAT: {
                return this.getDataCopyXYAsFloat(c, (float[])out, offset);
            }
            case DOUBLE: {
                return this.getDataCopyXYAsDouble(c, (double[])out, offset);
            }
        }
        return null;
    }

    public Object getDataCopyCXY() {
        return this.getDataCopyCXY(null, 0);
    }

    public Object getDataCopyCXY(Object out, int offset) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyCXYAsByte((byte[])out, offset);
            }
            case SHORT: {
                return this.getDataCopyCXYAsShort((short[])out, offset);
            }
            case INT: {
                return this.getDataCopyCXYAsInt((int[])out, offset);
            }
            case FLOAT: {
                return this.getDataCopyCXYAsFloat((float[])out, offset);
            }
            case DOUBLE: {
                return this.getDataCopyCXYAsDouble((double[])out, offset);
            }
        }
        return null;
    }

    public Object getDataCopyC(int x, int y) {
        return this.getDataCopyC(x, y, null, 0);
    }

    public Object getDataCopyC(int x, int y, Object out, int offset) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyCAsByte(x, y, (byte[])out, offset);
            }
            case SHORT: {
                return this.getDataCopyCAsShort(x, y, (short[])out, offset);
            }
            case INT: {
                return this.getDataCopyCAsInt(x, y, (int[])out, offset);
            }
            case FLOAT: {
                return this.getDataCopyCAsFloat(x, y, (float[])out, offset);
            }
            case DOUBLE: {
                return this.getDataCopyCAsDouble(x, y, (double[])out, offset);
            }
        }
        return null;
    }

    public void setDataXY(int c, Object values) {
        this.lockRaster();
        try {
            ArrayUtil.arrayToArray(values, this.getDataXY(c), this.getDataType_().isSigned());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataC(int x, int y, Object values) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                this.setDataCAsByte(x, y, (byte[])values);
                break;
            }
            case SHORT: {
                this.setDataCAsShort(x, y, (short[])values);
                break;
            }
            case INT: {
                this.setDataCAsInt(x, y, (int[])values);
                break;
            }
            case FLOAT: {
                this.setDataCAsFloat(x, y, (float[])values);
                break;
            }
            case DOUBLE: {
                this.setDataCAsDouble(x, y, (double[])values);
                break;
            }
        }
    }

    public byte[][] getDataXYCAsByte() {
        return ((DataBufferByte)this.getRaster().getDataBuffer()).getBankData();
    }

    public short[][] getDataXYCAsShort() {
        DataBuffer db = this.getRaster().getDataBuffer();
        if (db instanceof DataBufferUShort) {
            return ((DataBufferUShort)db).getBankData();
        }
        return ((DataBufferShort)db).getBankData();
    }

    public int[][] getDataXYCAsInt() {
        return ((DataBufferInt)this.getRaster().getDataBuffer()).getBankData();
    }

    public float[][] getDataXYCAsFloat() {
        return ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getBankData();
    }

    public double[][] getDataXYCAsDouble() {
        return ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getBankData();
    }

    public byte[] getDataXYAsByte(int c) {
        return ((DataBufferByte)this.getRaster().getDataBuffer()).getData(c);
    }

    public short[] getDataXYAsShort(int c) {
        DataBuffer db = this.getRaster().getDataBuffer();
        if (db instanceof DataBufferUShort) {
            return ((DataBufferUShort)db).getData(c);
        }
        return ((DataBufferShort)db).getData(c);
    }

    public int[] getDataXYAsInt(int c) {
        return ((DataBufferInt)this.getRaster().getDataBuffer()).getData(c);
    }

    public float[] getDataXYAsFloat(int c) {
        return ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getData(c);
    }

    public double[] getDataXYAsDouble(int c) {
        return ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getData(c);
    }

    public byte[] getDataCopyXYCAsByte() {
        return this.getDataCopyXYCAsByte(null, 0);
    }

    public byte[] getDataCopyXYCAsByte(byte[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[][] banks = ((DataBufferByte)this.getRaster().getDataBuffer()).getBankData();
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int offset = off;
        int c = 0;
        while ((long)c < sizeC) {
            byte[] src = banks[c];
            System.arraycopy(src, 0, result, offset, (int)len);
            offset = (int)((long)offset + len);
            ++c;
        }
        return result;
    }

    public short[] getDataCopyXYCAsShort() {
        return this.getDataCopyXYCAsShort(null, 0);
    }

    public short[] getDataCopyXYCAsShort(short[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        DataBuffer db = this.getRaster().getDataBuffer();
        short[][] banks = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getBankData() : ((DataBufferShort)db).getBankData();
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int offset = off;
        int c = 0;
        while ((long)c < sizeC) {
            short[] src = banks[c];
            System.arraycopy(src, 0, result, offset, (int)len);
            offset = (int)((long)offset + len);
            ++c;
        }
        return result;
    }

    public int[] getDataCopyXYCAsInt() {
        return this.getDataCopyXYCAsInt(null, 0);
    }

    public int[] getDataCopyXYCAsInt(int[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[][] banks = ((DataBufferInt)this.getRaster().getDataBuffer()).getBankData();
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int offset = off;
        int c = 0;
        while ((long)c < sizeC) {
            int[] src = banks[c];
            System.arraycopy(src, 0, result, offset, (int)len);
            offset = (int)((long)offset + len);
            ++c;
        }
        return result;
    }

    public float[] getDataCopyXYCAsFloat() {
        return this.getDataCopyXYCAsFloat(null, 0);
    }

    public float[] getDataCopyXYCAsFloat(float[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[][] banks = ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getBankData();
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int offset = off;
        int c = 0;
        while ((long)c < sizeC) {
            float[] src = banks[c];
            System.arraycopy(src, 0, result, offset, (int)len);
            offset = (int)((long)offset + len);
            ++c;
        }
        return result;
    }

    public double[] getDataCopyXYCAsDouble() {
        return this.getDataCopyXYCAsDouble(null, 0);
    }

    public double[] getDataCopyXYCAsDouble(double[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[][] banks = ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getBankData();
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int offset = off;
        int c = 0;
        while ((long)c < sizeC) {
            double[] src = banks[c];
            System.arraycopy(src, 0, result, offset, (int)len);
            offset = (int)((long)offset + len);
            ++c;
        }
        return result;
    }

    public byte[] getDataCopyXYAsByte(int c) {
        return this.getDataCopyXYAsByte(c, null, 0);
    }

    public byte[] getDataCopyXYAsByte(int c, byte[] out, int off) {
        int len = this.getSizeX() * this.getSizeY();
        byte[] src = ((DataBufferByte)this.getRaster().getDataBuffer()).getData(c);
        byte[] result = Array1DUtil.allocIfNull(out, len);
        System.arraycopy(src, 0, result, off, len);
        return result;
    }

    public short[] getDataCopyXYAsShort(int c) {
        return this.getDataCopyXYAsShort(c, null, 0);
    }

    public short[] getDataCopyXYAsShort(int c, short[] out, int off) {
        int len = this.getSizeX() * this.getSizeY();
        DataBuffer db = this.getRaster().getDataBuffer();
        short[] src = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData(c) : ((DataBufferShort)db).getData(c);
        short[] result = Array1DUtil.allocIfNull(out, len);
        System.arraycopy(src, 0, result, off, len);
        return result;
    }

    public int[] getDataCopyXYAsInt(int c) {
        return this.getDataCopyXYAsInt(c, null, 0);
    }

    public int[] getDataCopyXYAsInt(int c, int[] out, int off) {
        int len = this.getSizeX() * this.getSizeY();
        int[] src = ((DataBufferInt)this.getRaster().getDataBuffer()).getData(c);
        int[] result = Array1DUtil.allocIfNull(out, len);
        System.arraycopy(src, 0, result, off, len);
        return result;
    }

    public float[] getDataCopyXYAsFloat(int c) {
        return this.getDataCopyXYAsFloat(c, null, 0);
    }

    public float[] getDataCopyXYAsFloat(int c, float[] out, int off) {
        int len = this.getSizeX() * this.getSizeY();
        float[] src = ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getData(c);
        float[] result = Array1DUtil.allocIfNull(out, len);
        System.arraycopy(src, 0, result, off, len);
        return result;
    }

    public double[] getDataCopyXYAsDouble(int c) {
        return this.getDataCopyXYAsDouble(c, null, 0);
    }

    public double[] getDataCopyXYAsDouble(int c, double[] out, int off) {
        int len = this.getSizeX() * this.getSizeY();
        double[] src = ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getData(c);
        double[] result = Array1DUtil.allocIfNull(out, len);
        System.arraycopy(src, 0, result, off, len);
        return result;
    }

    public byte[] getDataCopyCXYAsByte() {
        return this.getDataCopyCXYAsByte(null, 0);
    }

    public byte[] getDataCopyCXYAsByte(byte[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[][] banks = ((DataBufferByte)this.getRaster().getDataBuffer()).getBankData();
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int c = 0;
        while ((long)c < sizeC) {
            byte[] src = banks[c];
            int offset = c + off;
            int i = 0;
            while ((long)i < len) {
                result[offset] = src[i];
                ++i;
                offset = (int)((long)offset + sizeC);
            }
            ++c;
        }
        return result;
    }

    public short[] getDataCopyCXYAsShort() {
        return this.getDataCopyCXYAsShort(null, 0);
    }

    public short[] getDataCopyCXYAsShort(short[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        DataBuffer db = this.getRaster().getDataBuffer();
        short[][] banks = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getBankData() : ((DataBufferShort)db).getBankData();
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int c = 0;
        while ((long)c < sizeC) {
            short[] src = banks[c];
            int offset = c + off;
            int i = 0;
            while ((long)i < len) {
                result[offset] = src[i];
                ++i;
                offset = (int)((long)offset + sizeC);
            }
            ++c;
        }
        return result;
    }

    public int[] getDataCopyCXYAsInt() {
        return this.getDataCopyCXYAsInt(null, 0);
    }

    public int[] getDataCopyCXYAsInt(int[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[][] banks = ((DataBufferInt)this.getRaster().getDataBuffer()).getBankData();
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int c = 0;
        while ((long)c < sizeC) {
            int[] src = banks[c];
            int offset = c + off;
            int i = 0;
            while ((long)i < len) {
                result[offset] = src[i];
                ++i;
                offset = (int)((long)offset + sizeC);
            }
            ++c;
        }
        return result;
    }

    public float[] getDataCopyCXYAsFloat() {
        return this.getDataCopyCXYAsFloat(null, 0);
    }

    public float[] getDataCopyCXYAsFloat(float[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[][] banks = ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getBankData();
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int c = 0;
        while ((long)c < sizeC) {
            float[] src = banks[c];
            int offset = c + off;
            int i = 0;
            while ((long)i < len) {
                result[offset] = src[i];
                ++i;
                offset = (int)((long)offset + sizeC);
            }
            ++c;
        }
        return result;
    }

    public double[] getDataCopyCXYAsDouble() {
        return this.getDataCopyCXYAsDouble(null, 0);
    }

    public double[] getDataCopyCXYAsDouble(double[] out, int off) {
        long sizeC = this.getSizeC();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeC >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[][] banks = ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getBankData();
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeC));
        int c = 0;
        while ((long)c < sizeC) {
            double[] src = banks[c];
            int offset = c + off;
            int i = 0;
            while ((long)i < len) {
                result[offset] = src[i];
                ++i;
                offset = (int)((long)offset + sizeC);
            }
            ++c;
        }
        return result;
    }

    public byte[] getDataCopyCAsByte(int x, int y) {
        return this.getDataCopyCAsByte(x, y, null, 0);
    }

    public byte[] getDataCopyCAsByte(int x, int y, byte[] out, int off) {
        int sizeC = this.getSizeC();
        int offset = x + y * this.getWidth();
        byte[][] data = ((DataBufferByte)this.getRaster().getDataBuffer()).getBankData();
        byte[] result = Array1DUtil.allocIfNull(out, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c + off] = data[c][offset];
        }
        return result;
    }

    public short[] getDataCopyCAsShort(int x, int y) {
        return this.getDataCopyCAsShort(x, y, null, 0);
    }

    public short[] getDataCopyCAsShort(int x, int y, short[] out, int off) {
        int sizeC = this.getSizeC();
        int offset = x + y * this.getWidth();
        DataBuffer db = this.getRaster().getDataBuffer();
        short[][] data = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getBankData() : ((DataBufferShort)db).getBankData();
        short[] result = Array1DUtil.allocIfNull(out, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c + off] = data[c][offset];
        }
        return result;
    }

    public int[] getDataCopyCAsInt(int x, int y) {
        return this.getDataCopyCAsInt(x, y, null, 0);
    }

    public int[] getDataCopyCAsInt(int x, int y, int[] out, int off) {
        int sizeC = this.getSizeC();
        int offset = x + y * this.getWidth();
        int[][] data = ((DataBufferInt)this.getRaster().getDataBuffer()).getBankData();
        int[] result = Array1DUtil.allocIfNull(out, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c + off] = data[c][offset];
        }
        return result;
    }

    public float[] getDataCopyCAsFloat(int x, int y) {
        return this.getDataCopyCAsFloat(x, y, null, 0);
    }

    public float[] getDataCopyCAsFloat(int x, int y, float[] out, int off) {
        int sizeC = this.getSizeC();
        int offset = x + y * this.getWidth();
        float[][] data = ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getBankData();
        float[] result = Array1DUtil.allocIfNull(out, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c + off] = data[c][offset];
        }
        return result;
    }

    public double[] getDataCopyCAsDouble(int x, int y) {
        return this.getDataCopyCAsDouble(x, y, null, 0);
    }

    public double[] getDataCopyCAsDouble(int x, int y, double[] out, int off) {
        int sizeC = this.getSizeC();
        int offset = x + y * this.getWidth();
        double[][] data = ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getBankData();
        double[] result = Array1DUtil.allocIfNull(out, sizeC);
        for (int c = 0; c < sizeC; ++c) {
            result[c + off] = data[c][offset];
        }
        return result;
    }

    public void setDataXYAsByte(int c, byte[] values) {
        this.lockRaster();
        try {
            System.arraycopy(values, 0, this.getDataXYAsByte(c), 0, this.getSizeX() * this.getSizeY());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataXYAsShort(int c, short[] values) {
        this.lockRaster();
        try {
            System.arraycopy(values, 0, this.getDataXYAsShort(c), 0, this.getSizeX() * this.getSizeY());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataXYAsInt(int c, int[] values) {
        this.lockRaster();
        try {
            System.arraycopy(values, 0, this.getDataXYAsInt(c), 0, this.getSizeX() * this.getSizeY());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataXYAsFloat(int c, float[] values) {
        this.lockRaster();
        try {
            System.arraycopy(values, 0, this.getDataXYAsFloat(c), 0, this.getSizeX() * this.getSizeY());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataXYAsDouble(int c, double[] values) {
        this.lockRaster();
        try {
            System.arraycopy(values, 0, this.getDataXYAsDouble(c), 0, this.getSizeX() * this.getSizeY());
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setDataCAsByte(int x, int y, byte[] values) {
        int offset = x + y * this.getWidth();
        int len = values.length;
        WritableRaster wr = this.getRaster();
        byte[][] data = ((DataBufferByte)wr.getDataBuffer()).getBankData();
        for (int comp = 0; comp < len; ++comp) {
            data[comp][offset] = values[comp];
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public void setDataCAsShort(int x, int y, short[] values) {
        int offset = x + y * this.getWidth();
        int len = values.length;
        WritableRaster wr = this.getRaster();
        DataBuffer db = wr.getDataBuffer();
        short[][] data = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getBankData() : ((DataBufferShort)db).getBankData();
        for (int comp = 0; comp < len; ++comp) {
            data[comp][offset] = values[comp];
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public void setDataCAsInt(int x, int y, int[] values) {
        int offset = x + y * this.getWidth();
        int len = values.length;
        WritableRaster wr = this.getRaster();
        int[][] data = ((DataBufferInt)wr.getDataBuffer()).getBankData();
        for (int comp = 0; comp < len; ++comp) {
            data[comp][offset] = values[comp];
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public void setDataCAsFloat(int x, int y, float[] values) {
        int offset = x + y * this.getWidth();
        int len = values.length;
        WritableRaster wr = this.getRaster();
        float[][] data = ((java.awt.image.DataBufferFloat)wr.getDataBuffer()).getBankData();
        for (int comp = 0; comp < len; ++comp) {
            data[comp][offset] = values[comp];
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public void setDataCAsDouble(int x, int y, double[] values) {
        int offset = x + y * this.getWidth();
        int len = values.length;
        WritableRaster wr = this.getRaster();
        double[][] data = ((java.awt.image.DataBufferDouble)wr.getDataBuffer()).getBankData();
        for (int comp = 0; comp < len; ++comp) {
            data[comp][offset] = values[comp];
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public double getData(int x, int y, int c) {
        return Array1DUtil.getValue(this.getDataXY(c), this.getOffset(x, y), this.getDataType_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(int x, int y, int c, double value) {
        this.lockRaster();
        try {
            Array1DUtil.setValue(this.getDataXY(c), this.getOffset(x, y), this.getDataType_(), value);
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public double getDataInterpolated(double x, double y, int c) {
        int xi = (int)x;
        int xip = xi + 1;
        int yi = (int)y;
        int yip = yi + 1;
        int sx = this.getSizeX();
        int sy = this.getSizeY();
        double result = 0.0;
        if (xi < sx && yi < sy && xip >= 0 && yip >= 0) {
            double ratioNextX = x - (double)xi;
            double ratioCurX = 1.0 - ratioNextX;
            double ratioNextY = y - (double)yi;
            double ratioCurY = 1.0 - ratioNextY;
            if (yi >= 0) {
                if (xi >= 0) {
                    result += this.getData(xi, yi, c) * (ratioCurX * ratioCurY);
                }
                if (xip < sx) {
                    result += this.getData(xip, yi, c) * (ratioNextX * ratioCurY);
                }
            }
            if (yip < sy) {
                if (xi >= 0) {
                    result += this.getData(xi, yip, c) * (ratioCurX * ratioNextY);
                }
                if (xip < sx) {
                    result += this.getData(xip, yip, c) * (ratioNextX * ratioNextY);
                }
            }
        }
        return result;
    }

    public byte getDataAsByte(int x, int y, int c) {
        return ((DataBufferByte)this.getRaster().getDataBuffer()).getData(c)[x + y * this.getWidth()];
    }

    public void setDataAsByte(int x, int y, int c, byte value) {
        WritableRaster wr = this.getRaster();
        ((DataBufferByte)wr.getDataBuffer()).getData((int)c)[x + y * this.getWidth()] = value;
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public short getDataAsShort(int x, int y, int c) {
        DataBuffer db = this.getRaster().getDataBuffer();
        if (db instanceof DataBufferUShort) {
            return ((DataBufferUShort)db).getData(c)[x + y * this.getWidth()];
        }
        return ((DataBufferShort)db).getData(c)[x + y * this.getWidth()];
    }

    public void setDataAsShort(int x, int y, int c, short value) {
        WritableRaster wr = this.getRaster();
        DataBuffer db = wr.getDataBuffer();
        if (db instanceof DataBufferUShort) {
            ((DataBufferUShort)db).getData((int)c)[x + y * this.getWidth()] = value;
        } else {
            ((DataBufferShort)db).getData((int)c)[x + y * this.getWidth()] = value;
        }
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public int getDataAsInt(int x, int y, int c) {
        return ((DataBufferInt)this.getRaster().getDataBuffer()).getData(c)[x + y * this.getWidth()];
    }

    public void setDataAsInt(int x, int y, int c, int value) {
        WritableRaster wr = this.getRaster();
        ((DataBufferInt)wr.getDataBuffer()).getData((int)c)[x + y * this.getWidth()] = value;
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public float getDataAsFloat(int x, int y, int c) {
        return ((java.awt.image.DataBufferFloat)this.getRaster().getDataBuffer()).getData(c)[x + y * this.getWidth()];
    }

    public void setDataAsFloat(int x, int y, int c, float value) {
        WritableRaster wr = this.getRaster();
        ((java.awt.image.DataBufferFloat)wr.getDataBuffer()).getData((int)c)[x + y * this.getWidth()] = value;
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public double getDataAsDouble(int x, int y, int c) {
        return ((java.awt.image.DataBufferDouble)this.getRaster().getDataBuffer()).getData(c)[x + y * this.getWidth()];
    }

    public void setDataAsDouble(int x, int y, int c, double value) {
        WritableRaster wr = this.getRaster();
        ((java.awt.image.DataBufferDouble)wr.getDataBuffer()).getData((int)c)[x + y * this.getWidth()] = value;
        this.saveRasterInCache(wr);
        this.dataChanged();
    }

    public int getRGB(int x, int y, LUT lut) {
        return this.getIcyColorModel().getRGB(this.getRaster().getDataElements(x, y, null), lut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fastCopyData(IcyBufferedImage srcImage, Rectangle srcRect, Point dstPt, int srcChannel, int dstChannel) {
        int srcSizeX = srcImage.getSizeX();
        int dstSizeX = this.getSizeX();
        Rectangle adjSrcRect = srcRect.intersection(new Rectangle(srcSizeX, srcImage.getSizeY()));
        if (dstPt.x < 0) {
            adjSrcRect.x += -dstPt.x;
        }
        if (dstPt.y < 0) {
            adjSrcRect.y += -dstPt.y;
        }
        Rectangle dstRect = new Rectangle(dstPt.x, dstPt.y, adjSrcRect.width, adjSrcRect.height);
        Rectangle adjDstRect = dstRect.intersection(new Rectangle(dstSizeX, this.getSizeY()));
        int w = Math.min(adjSrcRect.width, adjDstRect.width);
        int h = Math.min(adjSrcRect.height, adjDstRect.height);
        if (w == 0 || h == 0) {
            return;
        }
        this.lockRaster();
        try {
            boolean signed = srcImage.getDataType_().isSigned();
            Object src = srcImage.getDataXY(srcChannel);
            Object dst = this.getDataXY(dstChannel);
            int srcOffset = adjSrcRect.x + adjSrcRect.y * srcSizeX;
            int dstOffset = adjDstRect.x + adjDstRect.y * dstSizeX;
            for (int y = 0; y < h; ++y) {
                ArrayUtil.arrayToArray(src, srcOffset, dst, dstOffset, w, signed);
                srcOffset += srcSizeX;
                dstOffset += dstSizeX;
            }
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    protected void internalCopyData(int srcChannel, int dstChannel, DataBuffer src_db, DataBuffer dst_db, int[] indices, int[] band_offsets, int[] bank_offsets, int scanlineStride_src, int pixelStride_src, int maxX, int maxY, int decOffsetSrc) {
        int scanlineStride_dst = this.getSizeX();
        int bank = indices[srcChannel];
        int offset = band_offsets[srcChannel] + bank_offsets[bank] - decOffsetSrc;
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                byte[] dst = ((DataBufferByte)dst_db).getData(dstChannel);
                byte[] src = src_db instanceof SignedByteBuffer ? ((SignedByteBuffer)src_db).getData(bank) : ((DataBufferByte)src_db).getData(bank);
                int offset_src = offset;
                int offset_dst = 0;
                for (int y = 0; y < maxY; ++y) {
                    int offset_src_pix = offset_src;
                    int offset_dst_pix = offset_dst;
                    for (int x = 0; x < maxX; ++x) {
                        dst[offset_dst_pix] = src[offset_src_pix];
                        offset_src_pix += pixelStride_src;
                        ++offset_dst_pix;
                    }
                    offset_src += scanlineStride_src;
                    offset_dst += scanlineStride_dst;
                }
                break;
            }
            case SHORT: {
                short[] src = src_db instanceof SignedShortBuffer ? ((SignedShortBuffer)src_db).getData(bank) : (src_db instanceof DataBufferShort ? ((DataBufferShort)src_db).getData(bank) : ((DataBufferUShort)src_db).getData(bank));
                short[] dst = dst_db instanceof DataBufferShort ? ((DataBufferShort)dst_db).getData(dstChannel) : ((DataBufferUShort)dst_db).getData(dstChannel);
                int offset_src = offset;
                int offset_dst = 0;
                for (int y = 0; y < maxY; ++y) {
                    int offset_src_pix = offset_src;
                    int offset_dst_pix = offset_dst;
                    for (int x = 0; x < maxX; ++x) {
                        dst[offset_dst_pix] = src[offset_src_pix];
                        offset_src_pix += pixelStride_src;
                        ++offset_dst_pix;
                    }
                    offset_src += scanlineStride_src;
                    offset_dst += scanlineStride_dst;
                }
                break;
            }
            case INT: {
                int[] dst = ((DataBufferInt)dst_db).getData(dstChannel);
                int[] src = src_db instanceof UnsignedIntBuffer ? ((UnsignedIntBuffer)src_db).getData(bank) : ((DataBufferInt)src_db).getData(bank);
                int offset_src = offset;
                int offset_dst = 0;
                for (int y = 0; y < maxY; ++y) {
                    int offset_src_pix = offset_src;
                    int offset_dst_pix = offset_dst;
                    for (int x = 0; x < maxX; ++x) {
                        dst[offset_dst_pix] = src[offset_src_pix];
                        offset_src_pix += pixelStride_src;
                        ++offset_dst_pix;
                    }
                    offset_src += scanlineStride_src;
                    offset_dst += scanlineStride_dst;
                }
                break;
            }
            case FLOAT: {
                float[] src = ((java.awt.image.DataBufferFloat)src_db).getData(bank);
                float[] dst = ((java.awt.image.DataBufferFloat)dst_db).getData(dstChannel);
                int offset_src = offset;
                int offset_dst = 0;
                for (int y = 0; y < maxY; ++y) {
                    int offset_src_pix = offset_src;
                    int offset_dst_pix = offset_dst;
                    for (int x = 0; x < maxX; ++x) {
                        dst[offset_dst_pix] = src[offset_src_pix];
                        offset_src_pix += pixelStride_src;
                        ++offset_dst_pix;
                    }
                    offset_src += scanlineStride_src;
                    offset_dst += scanlineStride_dst;
                }
                break;
            }
            case DOUBLE: {
                double[] src = ((java.awt.image.DataBufferDouble)src_db).getData(bank);
                double[] dst = ((java.awt.image.DataBufferDouble)dst_db).getData(dstChannel);
                int offset_src = offset;
                int offset_dst = 0;
                for (int y = 0; y < maxY; ++y) {
                    int offset_src_pix = offset_src;
                    int offset_dst_pix = offset_dst;
                    for (int x = 0; x < maxX; ++x) {
                        dst[offset_dst_pix] = src[offset_src_pix];
                        offset_src_pix += pixelStride_src;
                        ++offset_dst_pix;
                    }
                    offset_src += scanlineStride_src;
                    offset_dst += scanlineStride_dst;
                }
                break;
            }
        }
    }

    public boolean copyData(ComponentSampleModel sampleModel, WritableRaster sourceRaster, int srcChannel, int dstChannel) {
        if (DataType.getDataTypeFromDataBufferType(sampleModel.getDataType()) != this.getDataType_()) {
            return false;
        }
        DataBuffer src_db = sourceRaster.getDataBuffer();
        WritableRaster dst_raster = this.getRaster();
        DataBuffer dst_db = dst_raster.getDataBuffer();
        int[] indices = sampleModel.getBankIndices();
        int[] band_offsets = sampleModel.getBandOffsets();
        int[] bank_offsets = src_db.getOffsets();
        int scanlineStride_src = sampleModel.getScanlineStride();
        int pixelStride_src = sampleModel.getPixelStride();
        int maxX = Math.min(this.getSizeX(), sampleModel.getWidth());
        int maxY = Math.min(this.getSizeY(), sampleModel.getHeight());
        int decOffsetSrc = sourceRaster.getSampleModelTranslateX() + sourceRaster.getSampleModelTranslateY() * scanlineStride_src;
        if (srcChannel == -1) {
            int numBands = sampleModel.getNumBands();
            for (int band = 0; band < numBands; ++band) {
                this.internalCopyData(band, band, src_db, dst_db, indices, band_offsets, bank_offsets, scanlineStride_src, pixelStride_src, maxX, maxY, decOffsetSrc);
            }
        } else {
            this.internalCopyData(srcChannel, dstChannel, src_db, dst_db, indices, band_offsets, bank_offsets, scanlineStride_src, pixelStride_src, maxX, maxY, decOffsetSrc);
        }
        this.saveRasterInCache(dst_raster);
        this.dataChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyData(Object data, Dimension dataDim, boolean signed, Point dstPt, int dstChannel) {
        if (data == null || dataDim == null) {
            return;
        }
        Rectangle adjSrcRect = new Rectangle(dataDim);
        if (dstPt.x < 0) {
            adjSrcRect.x += -dstPt.x;
        }
        if (dstPt.y < 0) {
            adjSrcRect.y += -dstPt.y;
        }
        Rectangle dstRect = new Rectangle(dstPt.x, dstPt.y, adjSrcRect.width, adjSrcRect.height);
        Rectangle adjDstRect = dstRect.intersection(new Rectangle(this.getSizeX(), this.getSizeY()));
        int w = Math.min(adjSrcRect.width, adjDstRect.width);
        int h = Math.min(adjSrcRect.height, adjDstRect.height);
        if (w == 0 || h == 0) {
            return;
        }
        this.lockRaster();
        try {
            Object dst = this.getDataXY(dstChannel);
            int srcSizeX = dataDim.width;
            int dstSizeX = this.getSizeX();
            int srcOffset = adjSrcRect.x + adjSrcRect.y * srcSizeX;
            int dstOffset = adjDstRect.x + adjDstRect.y * dstSizeX;
            for (int y = 0; y < h; ++y) {
                ArrayUtil.arrayToArray(data, srcOffset, dst, dstOffset, w, signed);
                srcOffset += srcSizeX;
                dstOffset += dstSizeX;
            }
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyData(IcyBufferedImage srcImage, Rectangle srcRect, Point dstPt, int srcChannel, int dstChannel) {
        if (srcImage == null) {
            return;
        }
        Rectangle adjSrcRect = srcRect == null ? new Rectangle(srcImage.getSizeX(), srcImage.getSizeY()) : srcRect;
        Point adjDstPt = dstPt == null ? new Point(0, 0) : dstPt;
        if (srcChannel == -1) {
            int sizeC = Math.min(srcImage.getSizeC(), this.getSizeC());
            this.beginUpdate();
            try {
                for (int c = 0; c < sizeC; ++c) {
                    this.fastCopyData(srcImage, adjSrcRect, adjDstPt, c, c);
                }
            }
            finally {
                this.endUpdate();
            }
        } else {
            this.fastCopyData(srcImage, adjSrcRect, adjDstPt, srcChannel, dstChannel);
        }
    }

    public void copyData(IcyBufferedImage srcImage, Rectangle srcRect, Point dstPt) {
        if (srcImage == null) {
            return;
        }
        this.copyData(srcImage, srcRect, dstPt, -1, 0);
    }

    public void copyData(BufferedImage srcImage, int srcChannel, int dstChannel) {
        if (srcImage == null) {
            return;
        }
        if (srcImage instanceof IcyBufferedImage) {
            this.copyData((IcyBufferedImage)srcImage, null, null, srcChannel, dstChannel);
        } else {
            boolean done = srcImage.getSampleModel() instanceof ComponentSampleModel ? this.copyData((ComponentSampleModel)srcImage.getSampleModel(), srcImage.getRaster(), srcChannel, dstChannel) : false;
            if (!done) {
                WritableRaster wr = this.getRaster();
                srcImage.copyData(wr);
                this.saveRasterInCache(wr);
                this.dataChanged();
            }
        }
    }

    public void copyData(BufferedImage srcImage) {
        this.copyData(srcImage, -1, -1);
    }

    public byte[] getRawData(int c, byte[] out, int offset, boolean little) {
        byte[] result = Array1DUtil.allocIfNull(out, offset + this.getSizeX() * this.getSizeY() * this.getDataType_().getSize());
        return ByteArrayConvert.toByteArray(this.getDataXY(c), 0, result, offset, little);
    }

    public byte[] getRawData(int c, boolean little) {
        return this.getRawData(c, null, 0, little);
    }

    public byte[] getRawData(byte[] out, int offset, boolean little) {
        int sizeXY = this.getSizeX() * this.getSizeY();
        int sizeC = this.getSizeC();
        int sizeType = this.getDataType_().getSize();
        byte[] result = Array1DUtil.allocIfNull(out, offset + sizeC * sizeXY * sizeType);
        int outOff = offset;
        for (int c = 0; c < sizeC; ++c) {
            this.getRawData(c, result, outOff, little);
            outOff += sizeXY * sizeType;
        }
        return result;
    }

    public byte[] getRawData(boolean little) {
        return this.getRawData(null, 0, little);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawData(int c, byte[] data, int offset, boolean little) {
        if (data == null) {
            return;
        }
        this.lockRaster();
        try {
            ByteArrayConvert.byteArrayTo(data, offset, this.getDataXY(c), 0, -1, little);
        }
        finally {
            this.releaseRaster(true);
        }
        this.dataChanged();
    }

    public void setRawData(int c, byte[] data, boolean little) {
        this.setRawData(c, data, 0, little);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRawData(byte[] data, int offset, boolean little) {
        if (data == null) {
            return;
        }
        int sizeXY = this.getSizeX() * this.getSizeY();
        int sizeC = this.getSizeC();
        int sizeType = this.getDataType_().getSize();
        this.beginUpdate();
        try {
            int inOff = offset;
            for (int c = 0; c < sizeC; ++c) {
                this.setRawData(c, data, inOff, little);
                inOff += sizeXY * sizeType;
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setRawData(byte[] data, boolean little) {
        this.setRawData(data, 0, little);
    }

    public IcyColorMap getColorMap(int channel) {
        return this.getIcyColorModel().getColorMap(channel);
    }

    @Deprecated
    public IcyColorMap getColormap(int channel) {
        return this.getColorMap(channel);
    }

    @Deprecated
    public void copyColormap(BufferedImage srcImage) {
        this.setColorMaps(srcImage);
    }

    public void setColorMaps(BufferedImage srcImage) {
        this.getIcyColorModel().setColorMaps(srcImage.getColorModel());
    }

    @Deprecated
    public void setColormaps(BufferedImage srcImage) {
        this.setColorMaps(srcImage);
    }

    public void setColorMap(int channel, IcyColorMap map, boolean setAlpha) {
        this.getIcyColorModel().setColorMap(channel, map, setAlpha);
    }

    public void setColorMap(int channel, IcyColorMap map) {
        this.getIcyColorModel().setColorMap(channel, map, map.isAlpha());
    }

    @Deprecated
    public void setColormap(int channel, IcyColorMap map) {
        this.setColorMap(channel, map, true);
    }

    public void dataChanged() {
        this.updater.changed(new IcyBufferedImageEvent(this, IcyBufferedImageEvent.IcyBufferedImageEventType.DATA_CHANGED));
    }

    protected void colormapChanged(int component) {
        this.updater.changed(new IcyBufferedImageEvent(this, IcyBufferedImageEvent.IcyBufferedImageEventType.COLORMAP_CHANGED, component));
    }

    public void channelBoundsChanged(int channel) {
        this.updater.changed(new IcyBufferedImageEvent(this, IcyBufferedImageEvent.IcyBufferedImageEventType.BOUNDS_CHANGED, channel));
    }

    @Deprecated
    public void componentBoundsChanged(int component) {
        this.channelBoundsChanged(component);
    }

    protected void fireChangeEvent(IcyBufferedImageEvent e) {
        for (IcyBufferedImageListener listener : new ArrayList<IcyBufferedImageListener>(this.listeners)) {
            listener.imageChanged(e);
        }
    }

    public void addListener(IcyBufferedImageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IcyBufferedImageListener listener) {
        this.listeners.remove(listener);
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
        this.lockRaster();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        this.releaseRaster(true);
        return this.updater.isUpdating();
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        IcyBufferedImageEvent event = (IcyBufferedImageEvent)object;
        switch (event.getType()) {
            case DATA_CHANGED: {
                if (!this.autoUpdateChannelBounds) break;
                this.updateChannelsBounds();
                break;
            }
            case BOUNDS_CHANGED: {
                break;
            }
        }
        this.fireChangeEvent(event);
    }

    @Override
    public void colorModelChanged(IcyColorModelEvent e) {
        switch (e.getType()) {
            case COLORMAP_CHANGED: {
                this.colormapChanged(e.getComponent());
                break;
            }
            case SCALER_CHANGED: {
                this.channelBoundsChanged(e.getComponent());
            }
        }
    }

    @Override
    public String toString() {
        return "IcyBufferedImage: " + this.getSizeX() + " x " + this.getSizeY() + " - " + this.getSizeC() + " ch (" + (Object)((Object)this.getDataType_()) + ")";
    }

    static class WeakIcyBufferedImageReference
    extends WeakReference<IcyBufferedImage> {
        final int hc;

        WeakIcyBufferedImageReference(IcyBufferedImage image) {
            super(image);
            this.hc = System.identityHashCode(image);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WeakIcyBufferedImageReference) {
                return obj.hashCode() == this.hashCode();
            }
            return super.equals(obj);
        }
    }

    @Deprecated
    public static enum FilterType {
        NEAREST,
        BILINEAR,
        BICUBIC;

    }

    public static class ImageSourceInfo {
        public final SequenceIdImporter imp;
        public final int series;
        public final int resolution;
        public final Rectangle region;
        public final int t;
        public final int z;
        public final int c;

        public ImageSourceInfo(SequenceIdImporter imp, int series, int resolution, Rectangle region, int t, int z, int c) {
            this.imp = imp;
            this.series = series;
            this.resolution = resolution;
            this.region = region;
            this.t = t;
            this.z = z;
            this.c = c;
        }

        public String toString() {
            return this.imp.toString() + " s=" + this.series + " r=" + this.resolution + " t=" + this.t + " z=" + this.z + " c=" + this.c;
        }
    }

    private static class ImageDataLoader {
        final Processor processor = new Processor(SystemUtil.getNumberOfCPUs() * 2);

        public ImageDataLoader() {
            this.processor.setThreadName("Image data loader");
        }

        Object loadImageData(IcyBufferedImage image) throws ExecutionException, InterruptedException {
            ImageDataLoaderTask task = new ImageDataLoaderTask(new ImageDataLoaderWorker(image));
            this.processor.execute(task);
            try {
                return task.get();
            }
            catch (InterruptedException e) {
                this.processor.remove(task);
                task.cancel(false);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelTasks(IcyBufferedImage image) {
            ArrayList<ImageDataLoaderTask> tasks = new ArrayList<ImageDataLoaderTask>();
            BlockingQueue<Runnable> queue = this.processor.getQueue();
            BlockingQueue<Runnable> blockingQueue = queue;
            synchronized (blockingQueue) {
                for (Runnable task : queue) {
                    ImageDataLoaderTask imgTask = (ImageDataLoaderTask)task;
                    IcyBufferedImage imgImage = imgTask.getImage();
                    if (imgImage != null && imgImage != image) continue;
                    tasks.add(imgTask);
                }
            }
            for (ImageDataLoaderTask task : tasks) {
                this.processor.remove(task);
                task.cancel(false);
            }
        }
    }

    private static class ImageDataLoaderTask
    extends FutureTask<Object> {
        final ImageDataLoaderWorker worker;

        ImageDataLoaderTask(ImageDataLoaderWorker worker) {
            super(worker);
            this.worker = worker;
        }

        IcyBufferedImage getImage() {
            return this.worker.getImage();
        }
    }

    private static class ImageDataLoaderWorker
    implements Callable<Object> {
        final WeakReference<IcyBufferedImage> imageRef;

        ImageDataLoaderWorker(IcyBufferedImage image) {
            this.imageRef = new WeakReference<IcyBufferedImage>(image);
        }

        @Override
        public Object call() throws Exception {
            IcyBufferedImage image = (IcyBufferedImage)this.imageRef.get();
            if (image == null) {
                return null;
            }
            ImageSourceInfo imageSourceInfo = image.imageSourceInfo;
            SequenceIdImporter imp = imageSourceInfo.imp;
            if (StringUtil.isEmpty(imp.getOpened())) {
                throw new IOException("Cannot load image data: Sequence importer is closed.");
            }
            int sizeC = image.getSizeC();
            Object[] result = Array2DUtil.createArray(image.getDataType_(), sizeC);
            if (imageSourceInfo.c == -1 && sizeC > 1) {
                IcyBufferedImage newImage = imp.getImage(imageSourceInfo.series, imageSourceInfo.resolution, imageSourceInfo.region, imageSourceInfo.z, imageSourceInfo.t);
                newImage.setVolatile(false);
                for (int c = 0; c < sizeC; ++c) {
                    result[c] = newImage.getDataXY(c);
                }
            } else {
                int startC = imageSourceInfo.c == -1 ? 0 : imageSourceInfo.c;
                for (int c = 0; c < sizeC; ++c) {
                    result[c] = imp.getPixels(imageSourceInfo.series, imageSourceInfo.resolution, imageSourceInfo.region, imageSourceInfo.z, imageSourceInfo.t, startC + c);
                }
            }
            return result;
        }

        IcyBufferedImage getImage() {
            return (IcyBufferedImage)this.imageRef.get();
        }
    }
}

