/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.image.colormodel.IcyColorModel;
import icy.image.colorspace.IcyColorSpace;
import icy.image.lut.LUT;
import icy.type.DataType;

public class DoubleColorModel
extends IcyColorModel {
    public DoubleColorModel(int numComponents, int[] bits) {
        super(numComponents, DataType.DOUBLE, bits);
    }

    public DoubleColorModel(IcyColorSpace colorSpace, int[] bits) {
        super(colorSpace, DataType.DOUBLE, bits);
    }

    @Override
    public int getRGB(Object pixel) {
        double[] pix = (double[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)this.colormapScalers[comp].scale(pix[comp]);
        }
        return this.getIcyColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int getRGB(Object pixel, LUT lut) {
        double[] pix = (double[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)lut.getLutChannel(comp).getScaler().scale(pix[comp]);
        }
        return lut.getColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int[] result;
        if (components == null) {
            result = new int[offset + this.numComponents];
        } else {
            if (components.length - offset < this.numComponents) {
                throw new IllegalArgumentException("Length of components array < number of components in model");
            }
            result = components;
        }
        double[] data = (double[])pixel;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result[offset + i] = (int)data[i];
        }
        return result;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        int len = components.length;
        double[] pixel = obj == null ? new double[this.numComponents] : (double[])obj;
        for (int i = 0; i < len; ++i) {
            pixel[i] = components[offset + i];
        }
        return pixel;
    }

    @Override
    public Object getDataElements(float[] normComponents, int offset, Object obj) {
        double[] pixel = obj == null ? new double[this.numComponents] : (double[])obj;
        int c = 0;
        int nc = offset;
        while (c < this.numComponents) {
            pixel[c] = this.normalScalers[c].unscale(normComponents[nc]);
            ++c;
            ++nc;
        }
        return pixel;
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        float[] result = normComponents == null ? new float[this.numComponents + normOffset] : normComponents;
        double[] data = (double[])pixel;
        int c = 0;
        int nc = normOffset;
        while (c < this.numComponents) {
            result[nc] = (float)this.normalScalers[c].scale((float)data[c]);
            ++c;
            ++nc;
        }
        return result;
    }
}

