/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import plugins.nchenouard.particletracking.filtering.IMM2D;
import plugins.nchenouard.particletracking.filtering.IMM3D;
import plugins.nchenouard.particletracking.filtering.KF2dDirected;
import plugins.nchenouard.particletracking.filtering.KF2dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KF3dDirected;
import plugins.nchenouard.particletracking.filtering.KF3dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor2D;
import plugins.nchenouard.particletracking.filtering.Predictor3D;
import plugins.nchenouard.particletracking.legacytracker.gui.FilterCovariancesPanel;
import plugins.nchenouard.particletracking.legacytracker.gui.PredictorPanel;

public class IMMPanel
extends PredictorPanel {
    private static final long serialVersionUID = -6006993674059346298L;
    private FilterCovariancesPanel[] covPanelTab1 = new FilterCovariancesPanel[2];
    private FilterCovariancesPanel[] covPanelTab2 = new FilterCovariancesPanel[2];
    private String name = "Interacting Multiple Models";
    private JTextField immInertia = new JTextField(6);
    private JCheckBox maxLBox = new JCheckBox("Use only most likely model");
    private DecimalFormat f1 = new DecimalFormat("000");
    private JComboBox immTypeBox = new JComboBox<String>(new String[]{"Brownian and directed motion models", "Heterogeneous Brownian motion models"});

    public IMMPanel() {
        GridBagLayout mainLayout = new GridBagLayout();
        this.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)new JLabel("Inertia:"), constraints);
        ++constraints.gridy;
        this.add((Component)this.immInertia, constraints);
        ++constraints.gridy;
        this.add((Component)this.maxLBox, constraints);
        ++constraints.gridy;
        this.maxLBox.setSelected(false);
        this.add((Component)this.immTypeBox, constraints);
        ++constraints.gridy;
        final CardLayout immTypeLayout = new CardLayout();
        final JPanel immTypePanel = new JPanel(immTypeLayout);
        this.add((Component)immTypePanel, constraints);
        ++constraints.gridy;
        JPanel brownianDirectedPanel = new JPanel(new GridLayout(2, 1));
        this.covPanelTab1[0] = new FilterCovariancesPanel();
        this.covPanelTab1[1] = new FilterCovariancesPanel();
        Dimension covPanelSize = this.covPanelTab1[0].getPreferredSize();
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)this.covPanelTab1[0], "Center");
        panel1.add((Component)new JLabel("Brownian motion covariance"), "North");
        brownianDirectedPanel.add(panel1);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.covPanelTab1[1], "Center");
        panel2.add((Component)new JLabel("Directed motion covariance"), "North");
        brownianDirectedPanel.add(panel2);
        JScrollPane scrollPane1 = new JScrollPane(brownianDirectedPanel);
        scrollPane1.setPreferredSize(new Dimension((int)(1.2 * (double)covPanelSize.width), (int)((double)covPanelSize.height * 1.5)));
        immTypePanel.add((Component)scrollPane1, this.immTypeBox.getItemAt(0).toString());
        JPanel directedDirectedPanel = new JPanel(new GridLayout(2, 1));
        this.covPanelTab2[0] = new FilterCovariancesPanel();
        this.covPanelTab2[1] = new FilterCovariancesPanel();
        panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)this.covPanelTab2[0], "Center");
        panel1.add((Component)new JLabel("Brownian motion 1 covariance"), "North");
        directedDirectedPanel.add(panel1);
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.covPanelTab2[1], "Center");
        panel2.add((Component)new JLabel("Brownian motion 2 covariance"), "North");
        directedDirectedPanel.add(panel2);
        JScrollPane scrollPane2 = new JScrollPane(directedDirectedPanel);
        scrollPane2.setPreferredSize(new Dimension((int)(1.2 * (double)covPanelSize.width), (int)((double)covPanelSize.height * 1.5)));
        immTypePanel.add((Component)scrollPane2, this.immTypeBox.getItemAt(1).toString());
        this.immTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                immTypeLayout.show(immTypePanel, IMMPanel.this.immTypeBox.getSelectedItem().toString());
            }
        });
        immTypeLayout.show(immTypePanel, this.immTypeBox.getSelectedItem().toString());
    }

    @Override
    public Predictor buildPredictor(int dim) {
        return this.buildPredictor(dim, false);
    }

    @Override
    public Predictor buildPredictor(int dim, boolean covUpdate) {
        if (dim == 3) {
            ArrayList<Predictor3D> predictors = new ArrayList<Predictor3D>();
            int selectedIdx = this.immTypeBox.getSelectedIndex();
            switch (selectedIdx) {
                case 0: {
                    KalmanFilter predictor = new KF3dRandomWalk();
                    double[] trackingCovariances = new double[]{this.covPanelTab1[0].getTrackingCovX(), this.covPanelTab1[0].getTrackingCovY(), this.covPanelTab1[0].getTrackingCovZ()};
                    ((KF3dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                    predictor.setUpdateCovariances(covUpdate);
                    predictors.add((Predictor3D)((Object)predictor));
                    predictor = new KF3dDirected();
                    trackingCovariances = new double[]{this.covPanelTab1[1].getTrackingCovX(), this.covPanelTab1[1].getTrackingCovY(), this.covPanelTab1[1].getTrackingCovZ()};
                    ((KF3dDirected)predictor).setTrackingCovariances(trackingCovariances);
                    predictor.setUpdateCovariances(covUpdate);
                    predictors.add((Predictor3D)((Object)predictor));
                    break;
                }
                case 1: {
                    KalmanFilter predictor = new KF3dRandomWalk();
                    double[] trackingCovariances = new double[]{this.covPanelTab1[0].getTrackingCovX(), this.covPanelTab1[0].getTrackingCovY(), this.covPanelTab1[0].getTrackingCovZ()};
                    ((KF3dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                    predictor.setUpdateCovariances(covUpdate);
                    predictors.add((Predictor3D)((Object)predictor));
                    predictor = new KF3dRandomWalk();
                    trackingCovariances = new double[]{this.covPanelTab1[1].getTrackingCovX(), this.covPanelTab1[1].getTrackingCovY(), this.covPanelTab1[1].getTrackingCovZ()};
                    ((KF3dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                    predictor.setUpdateCovariances(covUpdate);
                    predictors.add((Predictor3D)((Object)predictor));
                }
            }
            IMM3D.LikelihoodTypes predictorType = IMM3D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD;
            if (this.maxLBox.isSelected()) {
                predictorType = IMM3D.LikelihoodTypes.IMM_MAX_LIKELIHOOD;
            }
            double inertia = Double.parseDouble(this.immInertia.getText());
            IMM3D immFilter = new IMM3D(predictorType, inertia, predictors);
            return immFilter;
        }
        ArrayList<Predictor2D> predictors = new ArrayList<Predictor2D>();
        int selectedIdx = this.immTypeBox.getSelectedIndex();
        switch (selectedIdx) {
            case 0: {
                KalmanFilter predictor = new KF2dRandomWalk();
                double[] trackingCovariances = new double[]{this.covPanelTab1[0].getTrackingCovX(), this.covPanelTab1[0].getTrackingCovY()};
                ((KF2dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(covUpdate);
                predictors.add((Predictor2D)((Object)predictor));
                predictor = new KF2dDirected();
                trackingCovariances = new double[]{this.covPanelTab1[1].getTrackingCovX(), this.covPanelTab1[1].getTrackingCovY()};
                ((KF2dDirected)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(covUpdate);
                predictors.add((Predictor2D)((Object)predictor));
                break;
            }
            case 1: {
                KalmanFilter predictor = new KF2dRandomWalk();
                double[] trackingCovariances = new double[]{this.covPanelTab1[0].getTrackingCovX(), this.covPanelTab1[0].getTrackingCovY()};
                ((KF2dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(covUpdate);
                predictors.add((Predictor2D)((Object)predictor));
                predictor = new KF2dRandomWalk();
                trackingCovariances = new double[]{this.covPanelTab1[1].getTrackingCovX(), this.covPanelTab1[1].getTrackingCovY()};
                ((KF2dRandomWalk)predictor).setTrackingCovariances(trackingCovariances);
                predictor.setUpdateCovariances(covUpdate);
                predictors.add((Predictor2D)((Object)predictor));
            }
        }
        IMM2D.LikelihoodTypes predictorType = IMM2D.LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD;
        if (this.maxLBox.isSelected()) {
            predictorType = IMM2D.LikelihoodTypes.IMM_MAX_LIKELIHOOD;
        }
        double inertia = Double.parseDouble(this.immInertia.getText());
        IMM2D immFilter = new IMM2D(predictorType, inertia, predictors);
        return immFilter;
    }

    public double getIMMInertia() {
        try {
            return this.f1.parse(this.immInertia.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 0.8;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDefaultValues() {
        for (FilterCovariancesPanel covPanel : this.covPanelTab1) {
            covPanel.setDefaultValues();
        }
        for (FilterCovariancesPanel covPanel : this.covPanelTab2) {
            covPanel.setDefaultValues();
        }
        this.immInertia.setText("0.8");
        this.maxLBox.setSelected(false);
    }
}

