/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager;

import icy.common.Version;
import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.MMStudio;
import org.micromanager.acquisition.AcquisitionWrapperEngine;
import org.micromanager.acquisition.TaggedImageQueue;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.SequenceSettings;
import org.micromanager.api.TaggedImageAnalyzer;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;
import plugins.tprovoost.Microscopy.MicroManager.core.AcquisitionResult;
import plugins.tprovoost.Microscopy.MicroManager.event.AcquisitionListener;
import plugins.tprovoost.Microscopy.MicroManager.event.CoreListener;
import plugins.tprovoost.Microscopy.MicroManager.event.LiveListener;
import plugins.tprovoost.Microscopy.MicroManager.gui.LiveSettingsPanel;
import plugins.tprovoost.Microscopy.MicroManager.gui.LoadFrame;
import plugins.tprovoost.Microscopy.MicroManager.gui.LoadingFrame;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;

public class MicroManager {
    private static final Map<Integer, JSONObject> metadatas = new HashMap<Integer, JSONObject>(4);
    static final List<CoreListener> coreListeners = new ArrayList<CoreListener>();
    static final List<AcquisitionListener> acqListeners = new ArrayList<AcquisitionListener>();
    static final List<LiveListener> liveListeners = new ArrayList<LiveListener>();
    static AcquisitionResult acquisitionManager = null;
    static MMMainFrame instance = null;
    static Thread liveManager = null;
    static boolean inConfigSet = false;
    static String lastPresetSet = "";

    public static MMMainFrame getInstance() {
        return instance;
    }

    public static Version getMMVersion() {
        return new Version("1.4.22");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CoreListener> getCoreListeners() {
        ArrayList<CoreListener> result;
        List<CoreListener> list = coreListeners;
        synchronized (list) {
            result = new ArrayList<CoreListener>(coreListeners);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoreListener(CoreListener listener) {
        List<CoreListener> list = coreListeners;
        synchronized (list) {
            if (!coreListeners.contains(listener)) {
                coreListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCoreListener(CoreListener listener) {
        List<CoreListener> list = coreListeners;
        synchronized (list) {
            coreListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AcquisitionListener> getAcquisitionListeners() {
        ArrayList<AcquisitionListener> result;
        List<AcquisitionListener> list = acqListeners;
        synchronized (list) {
            result = new ArrayList<AcquisitionListener>(acqListeners);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAcquisitionListener(AcquisitionListener listener) {
        List<AcquisitionListener> list = acqListeners;
        synchronized (list) {
            if (!acqListeners.contains(listener)) {
                acqListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAcquisitionListener(AcquisitionListener listener) {
        List<AcquisitionListener> list = acqListeners;
        synchronized (list) {
            acqListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiveListener> getLiveListeners() {
        ArrayList<LiveListener> result;
        List<LiveListener> list = liveListeners;
        synchronized (list) {
            result = new ArrayList<LiveListener>(liveListeners);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLiveListener(LiveListener listener) {
        List<LiveListener> list = liveListeners;
        synchronized (list) {
            if (!liveListeners.contains(listener)) {
                liveListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLiveListener(LiveListener listener) {
        List<LiveListener> list = liveListeners;
        synchronized (list) {
            liveListeners.remove(listener);
        }
    }

    @Deprecated
    public static void registerListener(AcquisitionListener listener) {
        MicroManager.addAcquisitionListener(listener);
    }

    @Deprecated
    public static void removeListener(AcquisitionListener listener) {
        MicroManager.removeAcquisitionListener(listener);
    }

    @Deprecated
    public static void registerListener(LiveListener listener) {
        MicroManager.addLiveListener(listener);
    }

    @Deprecated
    public static void removeListener(LiveListener listener) {
        MicroManager.removeLiveListener(listener);
    }

    public static MMStudio getMMStudio() {
        MMMainFrame inst = MicroManager.getInstance();
        if (inst == null) {
            return null;
        }
        return inst.getMMStudio();
    }

    public static CMMCore getCore() {
        MMStudio mmstudio = MicroManager.getMMStudio();
        if (mmstudio == null) {
            return null;
        }
        return mmstudio.getCore();
    }

    public static boolean lock(long wait) throws InterruptedException {
        MMMainFrame inst = MicroManager.getInstance();
        if (inst == null) {
            return false;
        }
        return inst.lock(wait);
    }

    public static void lock() {
        MMMainFrame inst = MicroManager.getInstance();
        if (inst == null) {
            return;
        }
        inst.lock();
    }

    public static void unlock() {
        MMMainFrame inst = MicroManager.getInstance();
        if (inst == null) {
            return;
        }
        inst.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForDevice(String device) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        long start = System.currentTimeMillis();
        if (!StringUtil.isEmpty((String)device)) {
            boolean busy = true;
            while (busy && System.currentTimeMillis() - start < 3000L) {
                MicroManager.lock();
                try {
                    busy = core.deviceBusy(device);
                    if (!busy) continue;
                    Thread.yield();
                }
                finally {
                    MicroManager.unlock();
                }
            }
            MicroManager.lock();
            try {
                core.waitForDevice(device);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static String getDefaultConfigFileName() {
        return System.getProperty("org.micromanager.default.config.file", "MMConfig_demo.cfg");
    }

    public static void setDefaultConfigFileName(String fileName) {
        if (fileName != null) {
            System.setProperty("org.micromanager.default.config.file", fileName);
        }
    }

    public static AcquisitionWrapperEngine getAcquisitionEngine() {
        MMStudio mmstudio = MicroManager.getMMStudio();
        if (mmstudio == null) {
            return null;
        }
        return mmstudio.getAcquisitionEngine();
    }

    public static IAcquisitionEngine2010 getAcquisitionEngine2010() {
        MMStudio mmstudio = MicroManager.getMMStudio();
        if (mmstudio == null) {
            return null;
        }
        return mmstudio.getAcquisitionEngine2010();
    }

    public static SequenceSettings getAcquisitionSettings() {
        AcquisitionWrapperEngine acqEngine = MicroManager.getAcquisitionEngine();
        if (acqEngine == null) {
            return null;
        }
        return acqEngine.getSequenceSettings();
    }

    public static JSONObject getAcquisitionMetaData() {
        AcquisitionWrapperEngine acqEngine = MicroManager.getAcquisitionEngine();
        if (acqEngine == null) {
            return null;
        }
        return acqEngine.getSummaryMetadata();
    }

    public static long getCameraChannelCount() {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return 0L;
        }
        return core.getNumberOfCameraChannels();
    }

    public static JSONObject getMetadata(int channel) {
        return metadatas.get(channel);
    }

    public static JSONObject getMetadata() {
        return MicroManager.getMetadata(0);
    }

    public static IcyBufferedImage getLastImage() throws Exception {
        return MMUtils.convertToIcyImage(MicroManager.getLastTaggedImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaggedImage> getLastTaggedImage() throws Exception {
        int c;
        CMMCore core = MicroManager.getCore();
        if (core == null || !core.isSequenceRunning()) {
            return new ArrayList<TaggedImage>();
        }
        int numChannel = (int)core.getNumberOfCameraChannels();
        ArrayList<TaggedImage> result = new ArrayList<TaggedImage>(numChannel);
        MicroManager.lock();
        try {
            for (c = 0; c < numChannel; ++c) {
                TaggedImage image = core.getLastTaggedImage(c);
                result.add(image);
                if (image == null) continue;
                MDUtils.setChannelIndex((JSONObject)image.tags, (int)c);
                MDUtils.setNumChannels((JSONObject)image.tags, (int)numChannel);
            }
        }
        finally {
            MicroManager.unlock();
        }
        if (MMUtils.hasNullOrPoison(result)) {
            return new ArrayList<TaggedImage>();
        }
        for (c = 0; c < numChannel; ++c) {
            metadatas.put(c, ((TaggedImage)result.get((int)c)).tags);
        }
        return result;
    }

    public static IcyBufferedImage getNextImage() throws Exception {
        return MMUtils.convertToIcyImage(MicroManager.getNextTaggedImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaggedImage> getNextTaggedImage() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null || !core.isSequenceRunning()) {
            return new ArrayList<TaggedImage>();
        }
        final boolean[] done = new boolean[]{false};
        LiveListener listener = new LiveListener(){

            @Override
            public void liveStopped() {
                done[0] = true;
            }

            @Override
            public void liveStarted() {
            }

            @Override
            public void liveImgReceived(List<TaggedImage> images) {
                done[0] = true;
            }
        };
        MicroManager.addLiveListener(listener);
        try {
            long maxWait = System.currentTimeMillis();
            maxWait = Math.max(maxWait + 2000L, maxWait + (long)core.getExposure() * 2L);
            while (System.currentTimeMillis() < maxWait) {
                if (done[0]) {
                    break;
                }
                ThreadUtil.sleep((long)1L);
            }
        }
        finally {
            MicroManager.removeLiveListener(listener);
        }
        return MicroManager.getLastTaggedImage();
    }

    public static IcyBufferedImage snapImage() throws Exception {
        return MMUtils.convertToIcyImage(MicroManager.snapTaggedImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TaggedImage> snapTaggedImage() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return new ArrayList<TaggedImage>();
        }
        if (core.isSequenceRunning()) {
            return MicroManager.getNextTaggedImage();
        }
        int numChannel = (int)core.getNumberOfCameraChannels();
        ArrayList<TaggedImage> result = new ArrayList<TaggedImage>();
        MicroManager.lock();
        try {
            core.waitForDevice(core.getCameraDevice());
            core.snapImage();
            for (int c = 0; c < numChannel; ++c) {
                TaggedImage image = core.getTaggedImage(c);
                result.add(image);
                if (image != null) {
                    MDUtils.setChannelIndex((JSONObject)image.tags, (int)c);
                    MDUtils.setNumChannels((JSONObject)image.tags, (int)numChannel);
                    metadatas.put(c, image.tags);
                    continue;
                }
                metadatas.put(c, null);
            }
        }
        finally {
            MicroManager.unlock();
        }
        return result;
    }

    public static boolean isLiveRunning() {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return false;
        }
        return core.isSequenceRunning();
    }

    public static boolean startLiveMode() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return false;
        }
        if (!core.isSequenceRunning()) {
            MicroManager.lock();
            try {
                core.clearCircularBuffer();
                core.startContinuousSequenceAcquisition(0.0);
            }
            finally {
                MicroManager.unlock();
            }
            MicroManager.getInstance().liveStarted();
            for (LiveListener l : MicroManager.getLiveListeners()) {
                l.liveStarted();
            }
            return true;
        }
        return false;
    }

    public static void stopLiveMode() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (core.isSequenceRunning()) {
            MicroManager.lock();
            try {
                core.stopSequenceAcquisition();
            }
            finally {
                MicroManager.unlock();
            }
            instance.liveStopped();
            for (LiveListener l : MicroManager.getLiveListeners()) {
                l.liveStopped();
            }
        }
    }

    public static boolean isAcquisitionRunning() {
        AcquisitionWrapperEngine eng = MicroManager.getAcquisitionEngine();
        if (eng == null) {
            return false;
        }
        return eng.isAcquisitionRunning();
    }

    public static void startAcquisition(int numImages, double intervalMs) throws Exception {
        MicroManager.lock();
        try {
            MicroManager.getCore().startSequenceAcquisition(numImages, intervalMs, false);
        }
        finally {
            MicroManager.unlock();
        }
    }

    public static void stopAcquisition() {
        AcquisitionWrapperEngine eng = MicroManager.getAcquisitionEngine();
        if (eng == null) {
            return;
        }
        if (eng.isAcquisitionRunning()) {
            MicroManager.lock();
            try {
                eng.stop(true);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static List<Sequence> getAcquisitionResult() {
        if (acquisitionManager == null || acquisitionManager.getSequences().isEmpty()) {
            return null;
        }
        return acquisitionManager.getSequences();
    }

    public static String getCamera() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return "";
        }
        return core.getCameraDevice();
    }

    public static double getExposure() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return 0.0;
        }
        return core.getExposure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExposure(double exposure) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        MMStudio mmstudio = MicroManager.getMMStudio();
        if (mmstudio == null) {
            return;
        }
        if (core.getExposure() != exposure) {
            MicroManager.lock();
            try {
                MicroManager.stopAcquisition();
                boolean liveRunning = MicroManager.isLiveRunning();
                if (liveRunning) {
                    MicroManager.stopLiveMode();
                }
                mmstudio.setExposure(exposure);
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    private static String getBinningAsString(CMMCore core, String camera) throws Exception {
        return core.getProperty(camera, MMCoreJ.getG_Keyword_Binning());
    }

    public static String getBinningAsString() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return "";
        }
        String camera = core.getCameraDevice();
        if (!StringUtil.isEmpty((String)camera)) {
            return MicroManager.getBinningAsString(core, camera);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBinning(String value) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        String camera = core.getCameraDevice();
        if (!StringUtil.isEmpty((String)camera) && MicroManager.getBinningAsString(core, camera) != value) {
            MicroManager.lock();
            try {
                MicroManager.stopAcquisition();
                boolean liveRunning = MicroManager.isLiveRunning();
                if (liveRunning) {
                    MicroManager.stopLiveMode();
                }
                core.waitForDevice(camera);
                core.setProperty(camera, MMCoreJ.getG_Keyword_Binning(), value);
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    private static int getBinningAsInt(String value, int def) throws Exception {
        if (!StringUtil.isEmpty((String)value)) {
            return StringUtil.parseInt((String)value.substring(0, 1), (int)1);
        }
        return def;
    }

    public static int getBinning() throws Exception {
        return MicroManager.getBinningAsInt(MicroManager.getBinningAsString(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBinning(int value) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        String camera = core.getCameraDevice();
        if (!StringUtil.isEmpty((String)camera) && MicroManager.getBinningAsInt(MicroManager.getBinningAsString(core, camera), value) != value) {
            StrVector availableBinnings = core.getAllowedPropertyValues(camera, MMCoreJ.getG_Keyword_Binning());
            MicroManager.lock();
            try {
                MicroManager.stopAcquisition();
                boolean liveRunning = MicroManager.isLiveRunning();
                if (liveRunning) {
                    MicroManager.stopLiveMode();
                }
                core.waitForDevice(camera);
                for (String binningStr : availableBinnings) {
                    if (MicroManager.getBinningAsInt(binningStr, 0) != value) continue;
                    core.setProperty(camera, MMCoreJ.getG_Keyword_Binning(), binningStr);
                    break;
                }
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static String getShutter() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return "";
        }
        return core.getShutterDevice();
    }

    public static void setShutter(String value) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (!StringUtil.equals((String)value, (String)MicroManager.getShutter())) {
            MicroManager.lock();
            try {
                core.setShutterDevice(value);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static boolean isShutterOpen() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return false;
        }
        return core.getShutterOpen();
    }

    public static void setShutterOpen(boolean value) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (value != MicroManager.isShutterOpen()) {
            MicroManager.lock();
            try {
                core.setShutterOpen(value);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static boolean getAutoShutter() throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return false;
        }
        return core.getAutoShutter();
    }

    public static void setAutoShutter(boolean value) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (value != MicroManager.getAutoShutter()) {
            MicroManager.lock();
            try {
                core.setShutterOpen(false);
                core.setAutoShutter(value);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static double getPixelSize() {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return 0.0;
        }
        return core.getPixelSizeUm();
    }

    public static List<String> getConfigGroups() {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return new ArrayList<String>();
        }
        StrVector list = core.getAvailableConfigGroups();
        ArrayList<String> result = new ArrayList<String>((int)list.size());
        int i = 0;
        while ((long)i < list.size()) {
            result.add(list.get(i));
            ++i;
        }
        return result;
    }

    public static List<String> getConfigs(String group) {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return new ArrayList<String>();
        }
        if (StringUtil.isEmpty((String)group)) {
            return new ArrayList<String>();
        }
        StrVector list = core.getAvailableConfigs(group);
        ArrayList<String> result = new ArrayList<String>((int)list.size());
        int i = 0;
        while ((long)i < list.size()) {
            result.add(list.get(i));
            ++i;
        }
        return result;
    }

    public static String getCurrentConfig(String group) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return "";
        }
        if (StringUtil.isEmpty((String)group)) {
            return "";
        }
        return MicroManager.getCore().getCurrentConfig(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigForGroup(String group, String preset, boolean wait) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (StringUtil.isEmpty((String)group) || StringUtil.isEmpty((String)preset)) {
            return;
        }
        if (!StringUtil.equals((String)MicroManager.getCurrentConfig(group), (String)preset)) {
            MicroManager.lock();
            try {
                inConfigSet = true;
                MicroManager.stopAcquisition();
                boolean liveRunning = MicroManager.isLiveRunning();
                if (liveRunning) {
                    MicroManager.stopLiveMode();
                }
                lastPresetSet = preset;
                core.setConfig(group, preset);
                if (wait) {
                    core.waitForConfig(group, preset);
                }
                if (liveRunning) {
                    MicroManager.startLiveMode();
                }
            }
            finally {
                inConfigSet = false;
                MicroManager.unlock();
            }
        }
    }

    public static String getInternalSetPreset() {
        if (inConfigSet) {
            return lastPresetSet;
        }
        return "";
    }

    public static String getChannelGroup() {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return "";
        }
        return core.getChannelGroup();
    }

    public static void setChannelGroup(String group) throws Exception {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        if (StringUtil.isEmpty((String)group)) {
            return;
        }
        if (!MicroManager.getChannelGroup().equals(group)) {
            MicroManager.lock();
            try {
                MicroManager.stopAcquisition();
                boolean liveRunning = MicroManager.isLiveRunning();
                if (liveRunning) {
                    MicroManager.stopLiveMode();
                }
                core.setChannelGroup(group);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static List<String> getChannelConfigs() {
        return MicroManager.getConfigs(MicroManager.getChannelGroup());
    }

    public static boolean getStoreLastAcquisition() {
        if (MicroManager.isInitialized()) {
            return instance.getStoreLastAcquisition();
        }
        return false;
    }

    public static void setStoreLastAcquisition(boolean value) {
        if (MicroManager.isInitialized()) {
            instance.setStoreLastAcquisition(value);
        }
    }

    public static boolean getDisplayAcquisitionSequence() {
        if (MicroManager.isInitialized()) {
            return instance.getDisplayAcquisitionSequence();
        }
        return false;
    }

    public static void setDisplayAcquisitionSequence(boolean value) {
        if (MicroManager.isInitialized()) {
            instance.setDisplayAcquisitionSequence(value);
        }
    }

    public static void enableDebugLogging(boolean enable) {
        CMMCore core = MicroManager.getCore();
        if (core == null) {
            return;
        }
        core.enableDebugLog(enable);
        core.enableStderrLog(enable);
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() {
        if (Icy.isExiting()) {
            return;
        }
        if (instance != null) {
            instance.setVisible(true);
            instance.toFront();
            return;
        }
        try {
            Version version = null;
            try {
                version = MicroManager.getMMVersion();
                ClassUtil.findClass((String)MMStudio.class.getName());
            }
            catch (Throwable t) {
                version = new Version("1");
            }
            if (version == null || version.isLower(new Version("1.4.19"))) {
                MessageDialog.showDialog((String)"Error while loading Micro-Manager", (String)"Your version of Micro-Manager seems to not be compatible !\nThis plugin is only compatible with version 1.4.19 or above.\nAlso check that you are using the same architecture for Icy and Micro-Manager (32/64 bits)\nYou need to restart Icy to redefine the Micro-Manager folder.", (int)0);
                MMUtils.resetLibrayPath();
                return;
            }
            if (!MicroManager.showConfigSelection()) {
                return;
            }
            loadingFrame.show();
            try (LoadingFrame loadingFrame = new LoadingFrame("  Please wait while loading Micro-Manager, Icy interface may not respond...  ");){
                try {
                    instance = new MMMainFrame();
                }
                catch (Throwable e) {
                    IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true, (boolean)true);
                    MessageDialog.showDialog((String)"Error while loading Micro-Manager", (String)(e.getMessage() + "\nYou may try to restart Icy to fix the issue."), (int)0);
                    loadingFrame.close();
                    return;
                }
                CMMCore core = MicroManager.getCore();
                ReportingUtils.setCore((CMMCore)core);
                try {
                    if (!StringUtil.isEmpty((String)core.getCameraDevice())) {
                        core.initializeCircularBuffer();
                    }
                }
                catch (Throwable e) {
                    throw new Exception("Error while initializing circular buffer of Micro Manager", e);
                }
                ThreadUtil.invokeNow((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MicroManager.getAcquisitionEngine().addImageProcessor((DataProcessor)new ImageAnalyser());
                    }
                });
                StageMover.loadPreferences(instance.getPreferences().node("StageMover"));
                instance.init();
                if (!instance.isVisible()) {
                    throw new Exception("Could not load configuration file.");
                }
                liveManager = new LiveListenerThread();
                liveManager.start();
                instance.toFront();
                MicroManager.cleanOldMM();
            }
        }
        catch (Throwable t) {
            MessageDialog.showDialog((String)"Cannot load Micro-Manager", (String)"Your version of Micro-Manager seems to not be compatible !\nThis plugin is only compatible with version 1.4.19 or above.\nAlso check that you are using the same architecture for Icy and Micro-Manager (32/64 bits).", (int)0);
        }
    }

    private static void cleanOldMM() {
        String baseFolder = FileUtil.getApplicationDirectory() + "/plugins/tprovoost/Microscopy";
        if (FileUtil.exists((String)baseFolder)) {
            FileUtil.delete((String)(baseFolder + "/MicroscopeAdvancedAcquisition"), (boolean)true);
            FileUtil.delete((String)(baseFolder + "/MicroscopeLive"), (boolean)true);
            FileUtil.delete((String)(baseFolder + "/microscopelive3d"), (boolean)true);
            FileUtil.delete((String)(baseFolder + "/MicroscopeSnapper"), (boolean)true);
            FileUtil.delete((String)(baseFolder + "/blocks"), (boolean)true);
        }
    }

    private static boolean showConfigSelection() {
        final AtomicBoolean configLoaded = new AtomicBoolean(false);
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                LoadFrame f = new LoadFrame();
                int res = f.showDialog();
                switch (res) {
                    case 0: {
                        MicroManager.setDefaultConfigFileName(f.getConfigFilePath());
                        Preferences.userNodeForPackage(MMStudio.class).put("sysconfig_file", f.getConfigFilePath());
                        configLoaded.set(true);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        new FailedAnnounceFrame("Error while loading configuration file, please restart Micro-Manager.", 2);
                    }
                }
            }
        });
        return configLoaded.get();
    }

    public static void shutdown() {
        if (MicroManager.isInitialized()) {
            try {
                MicroManager.stopAcquisition();
                MicroManager.stopLiveMode();
            }
            catch (Throwable t) {
                IcyExceptionHandler.showErrorMessage((Throwable)t, (boolean)true);
            }
        }
        if (liveListeners != null) {
            liveListeners.clear();
        }
        if (acqListeners != null) {
            acqListeners.clear();
        }
        StageMover.clearListener();
        if (metadatas != null) {
            metadatas.clear();
        }
        if (liveManager != null) {
            liveManager.interrupt();
            try {
                liveManager.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            liveManager = null;
        }
        if (instance != null) {
            instance.setDefaultCloseOperation(2);
            instance.close();
        }
        instance = null;
        acquisitionManager = null;
    }

    private static class LiveListenerThread
    extends Thread {
        public LiveListenerThread() {
            super("uManager - LiveListener");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                CMMCore core = MicroManager.getCore();
                while (core.isSequenceRunning() && core.getRemainingImageCount() > 0) {
                    try {
                        List<TaggedImage> taggedImages;
                        block11: {
                            MicroManager.lock();
                            try {
                                taggedImages = MicroManager.getLastTaggedImage();
                                if (taggedImages.isEmpty()) break block11;
                                try {
                                    if (!MicroManager.isAcquisitionRunning() && core.getRemainingImageCount() > 0) {
                                        core.popNextImage();
                                    }
                                }
                                catch (Exception e) {
                                    IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
                                }
                            }
                            finally {
                                MicroManager.unlock();
                            }
                        }
                        if (taggedImages.isEmpty()) continue;
                        for (LiveListener l : MicroManager.getLiveListeners()) {
                            l.liveImgReceived(taggedImages);
                        }
                    }
                    catch (Exception e) {
                        IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
                    }
                }
                ThreadUtil.sleep((int)1);
            }
        }
    }

    private static class ImageAnalyser
    extends TaggedImageAnalyzer {
        ImageAnalyser() {
        }

        protected void analyze(TaggedImage image) {
            List<AcquisitionListener> listeners = MicroManager.getAcquisitionListeners();
            try {
                boolean newAcquisition;
                if (image == null || TaggedImageQueue.isPoison((TaggedImage)image)) {
                    if (acquisitionManager != null) {
                        acquisitionManager.done();
                    }
                    for (AcquisitionListener l : listeners) {
                        l.acquisitionFinished(MicroManager.getAcquisitionResult());
                    }
                    return;
                }
                JSONObject tags = image.tags;
                boolean firstImage = MDUtils.getPositionIndex((JSONObject)tags) == 0 && MDUtils.getFrameIndex((JSONObject)tags) == 0 && MDUtils.getChannelIndex((JSONObject)tags) == 0 && MDUtils.getSliceIndex((JSONObject)tags) == 0;
                boolean bl = newAcquisition = acquisitionManager == null || acquisitionManager.isDone();
                if (firstImage || newAcquisition) {
                    if (!newAcquisition) {
                        acquisitionManager.done();
                        for (AcquisitionListener l : listeners) {
                            l.acquisitionFinished(MicroManager.getAcquisitionResult());
                        }
                    }
                    SequenceSettings settings = MicroManager.getAcquisitionSettings();
                    JSONObject metadata = MicroManager.getAcquisitionMetaData();
                    LiveSettingsPanel livePanel = MicroManager.instance.livePanel;
                    settings.prefix = livePanel.hasCustomAcqName() ? livePanel.getAcqName() : "Acquisition";
                    acquisitionManager = new AcquisitionResult(settings, metadata, livePanel.hasDateSuffix());
                    for (AcquisitionListener l : listeners) {
                        l.acquisitionStarted(settings, metadata);
                    }
                }
                if (MicroManager.getStoreLastAcquisition()) {
                    acquisitionManager.imageReceived(image);
                }
                for (AcquisitionListener l : listeners) {
                    l.acqImgReveived(image);
                }
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
            }
        }
    }
}

