/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import java.util.ArrayList;
import java.util.HashMap;
import plugins.fab.MiceProfiler.EventCriteria;
import plugins.fab.MiceProfiler.EventType;
import plugins.fab.MiceProfiler.TimeLineCategory;

public class EventTimeLine {
    public String criteriaName;
    public EventType eventType;
    public TimeLineCategory timeLineCategory;
    ArrayList<EventCriteria> eventList = new ArrayList();
    HashMap<Integer, Double> hashValue = new HashMap();

    public EventTimeLine(String criteriaName, EventType eventType, TimeLineCategory timeLineCategory) {
        this.timeLineCategory = timeLineCategory;
        this.criteriaName = criteriaName;
        this.eventType = eventType;
    }

    public void addValue(int frame, double value) {
        this.hashValue.put(frame, value);
    }

    public void removeValue(int frame) {
        this.hashValue.remove(frame);
    }

    public double getValueAt(int frame) {
        Double value = this.hashValue.get(frame);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public void addEvent(EventCriteria eventCriteria) {
        this.eventList.add(eventCriteria);
    }

    public void removeEvent(EventCriteria eventCriteria) {
        this.eventList.remove(eventCriteria);
    }

    public void addPunctualEvent(int t) {
        for (EventCriteria event : this.eventList) {
            if (event.endFrame != t - 1) continue;
            event.endFrame = t;
            return;
        }
        for (EventCriteria event : this.eventList) {
            if (event.startFrame != t + 1) continue;
            event.startFrame = t;
            return;
        }
        EventCriteria event = new EventCriteria(this.eventType, t, t);
        this.addEvent(event);
    }

    public void removeEventLessThanLength(int length) {
        for (EventCriteria eventCriteria : (ArrayList)this.eventList.clone()) {
            if (eventCriteria.getLength() >= length) continue;
            this.eventList.remove(eventCriteria);
        }
    }

    public double getMeanValue(int tStart, int tEnd) {
        int nbValue = 0;
        double total = 0.0;
        for (int t = tStart; t <= tEnd; ++t) {
            total += this.getValueAt(t);
            ++nbValue;
        }
        if (nbValue == 0) {
            return 0.0;
        }
        return total / (double)nbValue;
    }

    public double getNbEvent(int tStart, int tEnd) {
        double nbEvent = 0.0;
        for (EventCriteria eventCriteria : this.eventList) {
            if (eventCriteria.startFrame >= tStart && eventCriteria.startFrame <= tEnd) {
                nbEvent += 1.0;
            }
            if (eventCriteria.startFrame >= tStart || eventCriteria.endFrame <= tEnd) continue;
            nbEvent += 1.0;
        }
        return nbEvent;
    }

    public double getDensity(int tStart, int tEnd) {
        double nbEvent = 0.0;
        block0: for (int t = tStart; t <= tEnd; ++t) {
            for (EventCriteria eventCriteria : this.eventList) {
                if (eventCriteria.startFrame > t || eventCriteria.endFrame < t) continue;
                if (tStart == 0) {
                    // empty if block
                }
                nbEvent += 1.0;
                continue block0;
            }
        }
        double ret = nbEvent / (double)(tEnd - tStart);
        System.out.println("density: " + tStart + " : " + tEnd + ":" + nbEvent + ":" + ret);
        return ret;
    }

    public double getLengthEvent(int tStart, int tEnd) {
        double totalLength = 0.0;
        double nbEvent = 0.0;
        for (EventCriteria eventCriteria : this.eventList) {
            if (eventCriteria.startFrame >= tStart && eventCriteria.startFrame <= tEnd) {
                totalLength += (double)eventCriteria.getLength();
                nbEvent += 1.0;
            }
            if (eventCriteria.startFrame >= tStart || eventCriteria.endFrame <= tEnd) continue;
            totalLength += (double)eventCriteria.getLength();
            nbEvent += 1.0;
        }
        if (nbEvent == 0.0) {
            return 0.0;
        }
        return totalLength / nbEvent;
    }
}

