/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CompoundTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueMDArray;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5EnumTypeRetriever;
import ch.systemsx.cisd.hdf5.PaddingUtils;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

abstract class HDF5CompoundInformationRetriever
implements IHDF5CompoundInformationRetriever {
    protected final HDF5BaseReader baseReader;
    protected final IHDF5EnumTypeRetriever enumTypeRetriever;

    HDF5CompoundInformationRetriever(HDF5BaseReader baseReader, IHDF5EnumTypeRetriever enumTypeRetriever) {
        assert (baseReader != null);
        assert (enumTypeRetriever != null);
        this.baseReader = baseReader;
        this.enumTypeRetriever = enumTypeRetriever;
    }

    @Override
    public <T> HDF5CompoundMemberInformation[] getMemberInfo(Class<T> compoundClass) {
        return this.getMemberInfo(compoundClass.getSimpleName());
    }

    @Override
    public HDF5CompoundMemberInformation[] getMemberInfo(String dataTypeName) {
        return this.getMemberInfo(dataTypeName, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5CompoundMemberInformation[] getMemberInfo(final String dataTypeName, final HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5CompoundMemberInformation[]> writeRunnable = new ICallableWithCleanUp<HDF5CompoundMemberInformation[]>(){

            @Override
            public HDF5CompoundMemberInformation[] call(ICleanUpRegistry registry) {
                String dataTypePath = HDF5Utils.createDataTypePath("Compound_", HDF5CompoundInformationRetriever.this.baseReader.houseKeepingNameSuffix, dataTypeName);
                long compoundDataTypeId = HDF5CompoundInformationRetriever.this.baseReader.h5.openDataType(HDF5CompoundInformationRetriever.this.baseReader.fileId, dataTypePath, registry);
                CompoundTypeInformation compoundInformation = HDF5CompoundInformationRetriever.this.getCompoundTypeInformation(compoundDataTypeId, dataTypePath, dataTypeInfoOptions, registry);
                return compoundInformation.getCopyOfMembers();
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public HDF5CompoundMemberInformation[] getDataSetInfo(String dataSetPath) throws HDF5JavaException {
        return this.getDataSetInfo(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public HDF5CompoundMemberInformation[] getDataSetInfo(final String dataSetPath, final HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) throws HDF5JavaException {
        ICallableWithCleanUp<HDF5CompoundMemberInformation[]> infoRunnable = new ICallableWithCleanUp<HDF5CompoundMemberInformation[]>(){

            @Override
            public HDF5CompoundMemberInformation[] call(ICleanUpRegistry registry) {
                return HDF5CompoundInformationRetriever.this.getFullCompoundDataSetInformation(dataSetPath, dataTypeInfoOptions, registry).getCopyOfMembers();
            }
        };
        HDF5CompoundMemberInformation[] compoundInformation = this.baseReader.runner.call(infoRunnable);
        return compoundInformation;
    }

    private CompoundTypeInformation getFullCompoundAttributeInformation(String objectPath, String attributeName, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, ICleanUpRegistry registry) throws HDF5JavaException {
        long compoundDataTypeId;
        long dataSetId = this.baseReader.h5.openObject(this.baseReader.fileId, objectPath, registry);
        long attributeId = this.baseReader.h5.openAttribute(dataSetId, attributeName, registry);
        long storageDataTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
        int classType = this.baseReader.h5.getClassType(storageDataTypeId);
        if (classType == HDF5Constants.H5T_ARRAY) {
            compoundDataTypeId = this.baseReader.h5.getBaseDataType(storageDataTypeId, registry);
            classType = this.baseReader.h5.getClassType(compoundDataTypeId);
        } else {
            compoundDataTypeId = storageDataTypeId;
        }
        if (classType != HDF5Constants.H5T_COMPOUND) {
            throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of compound type.");
        }
        String dataTypePathOrNull = this.baseReader.tryGetDataTypePath(compoundDataTypeId);
        CompoundTypeInformation compoundInformation = this.getCompoundTypeInformation(compoundDataTypeId, dataTypePathOrNull, dataTypeInfoOptions, registry);
        return compoundInformation;
    }

    private CompoundTypeInformation getFullCompoundDataSetInformation(String dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, ICleanUpRegistry registry) throws HDF5JavaException {
        long dataSetId = this.baseReader.h5.openDataSet(this.baseReader.fileId, dataSetPath, registry);
        long compoundDataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
        if (this.baseReader.h5.getClassType(compoundDataTypeId) != HDF5Constants.H5T_COMPOUND) {
            throw new HDF5JavaException("Data set '" + dataSetPath + "' is not of compound type.");
        }
        String dataTypePathOrNull = dataTypeInfoOptions.knowsDataTypePath() || dataTypeInfoOptions.knowsDataTypeVariant() ? this.baseReader.tryGetDataTypePath(compoundDataTypeId) : null;
        CompoundTypeInformation compoundInformation = this.getCompoundTypeInformation(compoundDataTypeId, dataTypePathOrNull, dataTypeInfoOptions, registry);
        return compoundInformation;
    }

    private CompoundTypeInformation getFullCompoundDataTypeInformation(String dataTypePath, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, ICleanUpRegistry registry) throws HDF5JavaException {
        long compoundDataTypeId = this.baseReader.h5.openDataType(this.baseReader.fileId, dataTypePath, registry);
        if (this.baseReader.h5.getClassType(compoundDataTypeId) != HDF5Constants.H5T_COMPOUND) {
            throw new HDF5JavaException("Data type '" + dataTypePath + "' is not a compound type.");
        }
        CompoundTypeInformation compoundInformation = this.getCompoundTypeInformation(compoundDataTypeId, dataTypePath, dataTypeInfoOptions, registry);
        return compoundInformation;
    }

    CompoundTypeInformation getCompoundTypeInformation(long compoundDataTypeId, String dataTypePathOrNull, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, ICleanUpRegistry registry) {
        HDF5DataTypeVariant[] memberTypeVariantsOrNull;
        String typeName = HDF5Utils.getDataTypeNameFromPath(dataTypePathOrNull, this.baseReader.houseKeepingNameSuffix, HDF5DataClass.COMPOUND);
        String[] memberNames = this.baseReader.h5.getNamesForEnumOrCompoundMembers(compoundDataTypeId);
        long nativeCompoundDataTypeId = this.baseReader.h5.getNativeDataType(compoundDataTypeId, registry);
        int recordSizeOnDisk = this.baseReader.h5.getDataTypeSize(compoundDataTypeId);
        int recordSizeInMemory = this.baseReader.h5.getDataTypeSize(nativeCompoundDataTypeId);
        CompoundTypeInformation compoundInfo = new CompoundTypeInformation(typeName, compoundDataTypeId, nativeCompoundDataTypeId, memberNames.length, recordSizeOnDisk, recordSizeInMemory);
        HDF5DataTypeVariant[] hDF5DataTypeVariantArray = memberTypeVariantsOrNull = dataTypeInfoOptions.knowsDataTypeVariant() ? this.baseReader.tryGetTypeVariantForCompoundMembers(dataTypePathOrNull, registry) : null;
        if (memberTypeVariantsOrNull != null && memberTypeVariantsOrNull.length != memberNames.length) {
            throw new HDF5JavaException("Invalid member data type variant information on committed data type '" + dataTypePathOrNull + "'.");
        }
        int offsetOnDisk = 0;
        int offsetInMemory = 0;
        int i = 0;
        while (i < memberNames.length) {
            HDF5EnumerationType enumTypeOrNull;
            long dataTypeId;
            compoundInfo.dataTypeIds[i] = dataTypeId = this.baseReader.h5.getDataTypeForIndex(compoundDataTypeId, i, registry);
            HDF5DataTypeInformation dataTypeInformation = this.baseReader.getDataTypeInformation(dataTypeId, dataTypeInfoOptions, registry);
            if (memberTypeVariantsOrNull != null && memberTypeVariantsOrNull[i].isTypeVariant()) {
                dataTypeInformation.setTypeVariant(memberTypeVariantsOrNull[i]);
            }
            if (dataTypeInformation.getDataClass() == HDF5DataClass.ENUM) {
                if (dataTypeInformation.isArrayType()) {
                    long baseDataSetType = this.baseReader.h5.getBaseDataType(dataTypeId, registry);
                    enumTypeOrNull = this.baseReader.getEnumTypeForStorageDataType(null, baseDataSetType, false, null, null, registry);
                } else {
                    enumTypeOrNull = this.baseReader.getEnumTypeForStorageDataType(null, dataTypeId, false, null, null, registry);
                }
            } else {
                enumTypeOrNull = null;
            }
            compoundInfo.enumTypes[i] = enumTypeOrNull;
            if (enumTypeOrNull != null) {
                compoundInfo.setMember(i, new HDF5CompoundMemberInformation(memberNames[i], dataTypeInformation, offsetOnDisk, offsetInMemory, enumTypeOrNull.getEnumType().getValueArray()));
            } else {
                compoundInfo.setMember(i, new HDF5CompoundMemberInformation(memberNames[i], dataTypeInformation, offsetOnDisk, offsetInMemory));
            }
            HDF5DataTypeInformation typeInfo = compoundInfo.getMember(i).getType();
            int size = typeInfo.getSize();
            offsetOnDisk += size;
            offsetInMemory = PaddingUtils.padOffset(offsetInMemory + size, typeInfo.getElementSizeForPadding());
            ++i;
        }
        return compoundInfo;
    }

    @Override
    public <T> HDF5CompoundType<T> getType(String name, Class<T> pojoClass, boolean requireTypesToBeEqual, HDF5CompoundMemberMapping ... members) {
        this.baseReader.checkOpen();
        HDF5ValueObjectByteifyer<T> objectArrayifyer = this.baseReader.createCompoundByteifyers(pojoClass, members, null);
        return this.getType(name, -1L, pojoClass, requireTypesToBeEqual, objectArrayifyer);
    }

    @Override
    public <T> HDF5CompoundType<T> getType(String name, Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.getType(name, pojoClass, true, members);
    }

    <T> HDF5CompoundType<T> getType(final String name, long committedDataTypeId, Class<T> compoundType, boolean requireEqualsType, HDF5ValueObjectByteifyer<T> objectArrayifyer) {
        final long storageDataTypeId = committedDataTypeId < 0L ? this.baseReader.createStorageCompoundDataType(objectArrayifyer) : committedDataTypeId;
        long nativeDataTypeId = this.baseReader.createNativeCompoundDataType(objectArrayifyer);
        return new HDF5CompoundType<T>(this.baseReader.fileId, storageDataTypeId, nativeDataTypeId, name, compoundType, requireEqualsType, objectArrayifyer, new HDF5CompoundType.IHDF5InternalCompoundMemberInformationRetriever(){

            @Override
            public HDF5CompoundMemberInformation[] getCompoundMemberInformation(HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
                return HDF5CompoundInformationRetriever.this.getCompoundMemberInformation(storageDataTypeId, name, dataTypeInfoOptions);
            }
        }, this.baseReader);
    }

    HDF5CompoundMemberInformation[] getCompoundMemberInformation(final long storageDataTypeId, final String dataTypeNameOrNull, final HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5CompoundMemberInformation[]> writeRunnable = new ICallableWithCleanUp<HDF5CompoundMemberInformation[]>(){

            @Override
            public HDF5CompoundMemberInformation[] call(ICleanUpRegistry registry) {
                String dataTypePath = dataTypeNameOrNull == null ? null : HDF5Utils.createDataTypePath("Compound_", HDF5CompoundInformationRetriever.this.baseReader.houseKeepingNameSuffix, dataTypeNameOrNull);
                CompoundTypeInformation compoundInformation = HDF5CompoundInformationRetriever.this.getCompoundTypeInformation(storageDataTypeId, dataTypePath, dataTypeInfoOptions, registry);
                return compoundInformation.getCopyOfMembers();
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public <T> HDF5CompoundType<T> getType(Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.getType(null, pojoClass, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getInferredType(name, (T)pojoClass, hints, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, Class<T> pojoClass, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        return this.getType(name, pojoClass, requireTypesToBeEqual, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(pojoClass), hints)));
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getInferredType(null, (T)pojoClass, hints);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, Class<T> pojoClass) {
        return this.getInferredType(name, (T)pojoClass, null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(Class<T> pojoClass) {
        return this.getInferredType(null, (T)pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T pojo, HDF5CompoundMappingHints hints) {
        return this.getInferredType(name, pojo, hints, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T pojo, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        if (Map.class.isInstance(pojo)) {
            String compoundTypeName = name == null ? HDF5CompoundMemberMapping.constructCompoundTypeName(((Map)pojo).keySet(), true) : name;
            return this.getType(compoundTypeName, Map.class, requireTypesToBeEqual, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping((Map)pojo), hints)));
        }
        Class<?> pojoClass = pojo.getClass();
        return this.getType(name, pojoClass, requireTypesToBeEqual, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(pojo, HDF5CompoundMemberMapping.inferEnumerationTypeMap(pojo, this.enumTypeRetriever), HDF5CompoundMappingHints.isUseVariableLengthStrings(hints)), hints)));
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T[] pojo) {
        return this.getInferredType(name, pojo, (HDF5CompoundMappingHints)null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(T[] pojo) {
        return this.getInferredType((String)null, pojo, (HDF5CompoundMappingHints)null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T[] pojo, HDF5CompoundMappingHints hints) {
        return this.getInferredType(name, pojo, hints, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T[] pojo, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        Class<?> componentType = pojo.getClass().getComponentType();
        if (pojo.length == 0) {
            return this.getInferredType(name, (T)componentType, hints);
        }
        if (Map.class.isAssignableFrom(componentType)) {
            String compoundTypeName = name == null ? HDF5CompoundMemberMapping.constructCompoundTypeName(((Map)pojo[0]).keySet(), true) : name;
            return this.getType(compoundTypeName, Map.class, requireTypesToBeEqual, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping((Map)pojo[0]), hints)));
        }
        return this.getType(name, componentType, requireTypesToBeEqual, this.addEnumTypes(HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(pojo, HDF5CompoundMemberMapping.inferEnumerationTypeMap(pojo, this.enumTypeRetriever), hints == null ? false : hints.isUseVariableLengthStrings()), hints)));
    }

    HDF5CompoundMemberMapping[] addEnumTypes(HDF5CompoundMemberMapping[] mapping) {
        HDF5CompoundMemberMapping[] hDF5CompoundMemberMappingArray = mapping;
        int n = mapping.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5CompoundMemberMapping m3 = hDF5CompoundMemberMappingArray[n2];
            Class<?> memberClass = m3.tryGetMemberClass();
            if (memberClass != null) {
                if (memberClass.isEnum()) {
                    Class<?> enumClass = memberClass;
                    String typeName = StringUtils.isBlank(m3.tryGetEnumTypeName()) ? memberClass.getSimpleName() : m3.tryGetEnumTypeName();
                    m3.setEnumerationType(this.enumTypeRetriever.getType(typeName, ReflectionUtils.getEnumOptions(enumClass)));
                } else if (memberClass == HDF5EnumerationValue.class || memberClass == HDF5EnumerationValueArray.class || memberClass == HDF5EnumerationValueMDArray.class) {
                    HDF5EnumerationType typeOrNull;
                    HDF5CompoundMappingHints hintsOrNull = m3.tryGetHints();
                    HDF5EnumerationType hDF5EnumerationType = typeOrNull = hintsOrNull != null ? hintsOrNull.tryGetEnumType(m3.getMemberName()) : null;
                    if (typeOrNull != null) {
                        m3.setEnumerationType(typeOrNull);
                    }
                }
            }
            ++n2;
        }
        return mapping;
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(String name, T pojo) {
        return this.getInferredType(name, pojo, null);
    }

    @Override
    public <T> HDF5CompoundType<T> getInferredType(T pojo) {
        return this.getInferredType(null, pojo);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredType(String name, List<String> memberNames, List<?> data, HDF5CompoundMappingHints hints) {
        return this.getInferredType(name, memberNames, data, hints, true);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredType(String name, List<String> memberNames, List<?> data, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        String compoundTypeName = name == null ? HDF5CompoundMemberMapping.constructCompoundTypeName(memberNames, false) : name;
        HDF5CompoundType<List<?>> type = this.getType(compoundTypeName, List.class, requireTypesToBeEqual, HDF5CompoundMemberMapping.addHints(HDF5CompoundMemberMapping.inferMapping(memberNames, data), hints));
        return type;
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredType(String name, List<String> memberNames, List<?> data) {
        return this.getInferredType(name, memberNames, data, null);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredType(List<String> memberNames, List<?> data) {
        return this.getInferredType(null, memberNames, data);
    }

    @Override
    public HDF5CompoundType<List<?>> getInferredType(List<String> memberNames, List<?> data, HDF5CompoundMappingHints hints) {
        return this.getInferredType(null, memberNames, data, hints);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredType(String[] memberNames, Object[] data) {
        return this.getInferredType(null, memberNames, data);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredType(String name, String[] memberNames, Object[] data) {
        String compoundTypeName = name == null ? HDF5CompoundMemberMapping.constructCompoundTypeName(Arrays.asList(memberNames), false) : name;
        return this.getType(compoundTypeName, Object[].class, HDF5CompoundMemberMapping.inferMapping(memberNames, data));
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredType(String name, String[] memberNames, Object[] data, HDF5CompoundMappingHints hints) {
        return this.getInferredType(name, memberNames, data, hints, true);
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredType(String name, String[] memberNames, Object[] data, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        String compoundTypeName = name == null ? HDF5CompoundMemberMapping.constructCompoundTypeName(Arrays.asList(memberNames), false) : name;
        return this.getType(compoundTypeName, Object[].class, requireTypesToBeEqual, HDF5CompoundMemberMapping.inferMapping(memberNames, data, hints));
    }

    @Override
    public HDF5CompoundType<Object[]> getInferredType(String[] memberNames, Object[] data, HDF5CompoundMappingHints hints) {
        return this.getInferredType(null, memberNames, data, hints);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetType(String objectPath, Class<T> pojoClass, HDF5CompoundMemberMapping ... members) {
        return this.getDataSetType(objectPath, pojoClass, true, members);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetType(String objectPath, Class<T> pojoClass, boolean requireTypesToBeEqual, HDF5CompoundMemberMapping ... members) {
        this.baseReader.checkOpen();
        CompoundTypeInformation cpdTypeInfo = this.getFullCompoundDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL, this.baseReader.fileRegistry);
        HDF5CompoundType<T> typeForClass = this.getType(cpdTypeInfo.name, cpdTypeInfo.compoundDataTypeId, pojoClass, requireTypesToBeEqual, this.createByteifyers(pojoClass, cpdTypeInfo, members));
        return typeForClass;
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetType(String objectPath, Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getDataSetType(objectPath, pojoClass, hints, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetType(String objectPath, Class<T> pojoClass, HDF5CompoundMappingHints hints, boolean requireTypesToBeEqual) {
        this.baseReader.checkOpen();
        CompoundTypeInformation cpdTypeInfo = this.getFullCompoundDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.ALL, this.baseReader.fileRegistry);
        HDF5CompoundType<T> typeForClass = this.getType(cpdTypeInfo.name, cpdTypeInfo.compoundDataTypeId, pojoClass, requireTypesToBeEqual, this.createByteifyers(pojoClass, cpdTypeInfo, hints));
        return typeForClass;
    }

    @Override
    public <T> HDF5CompoundType<T> getDataSetType(String objectPath, Class<T> pojoClass) {
        return this.getDataSetType(objectPath, pojoClass, (HDF5CompoundMappingHints)null);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeType(String objectPath, String attributeName, Class<T> pojoClass) {
        return this.getAttributeType(objectPath, attributeName, pojoClass, null);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeType(String objectPath, String attributeName, Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getAttributeType(objectPath, attributeName, pojoClass, hints, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeType(String objectPath, String attributeName, Class<T> pojoClass, HDF5CompoundMappingHints hints, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.getAttributeType(objectPath, attributeName, pojoClass, hints, dataTypeInfoOptions, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getAttributeType(String objectPath, String attributeName, Class<T> pojoClass, HDF5CompoundMappingHints hints, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, boolean requireTypesToBeEqual) {
        CompoundTypeInformation cpdTypeInfo = this.getFullCompoundAttributeInformation(objectPath, attributeName, dataTypeInfoOptions, this.baseReader.fileRegistry);
        HDF5CompoundType<T> typeForClass = this.getType(cpdTypeInfo.name, cpdTypeInfo.compoundDataTypeId, pojoClass, requireTypesToBeEqual, this.createByteifyers(pojoClass, cpdTypeInfo, hints));
        return typeForClass;
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(Class<T> pojoClass) {
        return this.getNamedType(pojoClass.getSimpleName(), pojoClass);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(String dataTypeName, Class<T> pojoClass) {
        return this.getNamedType(dataTypeName, pojoClass, null, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(String dataTypeName, Class<T> pojoClass, HDF5CompoundMappingHints hints) {
        return this.getNamedType(dataTypeName, pojoClass, hints, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(String dataTypeName, Class<T> pojoClass, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.getNamedType(dataTypeName, pojoClass, null, dataTypeInfoOptions);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(String dataTypeName, Class<T> pojoClass, HDF5CompoundMappingHints hints, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions) {
        return this.getNamedType(dataTypeName, pojoClass, hints, dataTypeInfoOptions, true);
    }

    @Override
    public <T> HDF5CompoundType<T> getNamedType(String dataTypeName, Class<T> pojoClass, HDF5CompoundMappingHints hints, HDF5DataTypeInformation.DataTypeInfoOptions dataTypeInfoOptions, boolean requireTypesToBeEqual) {
        String dataTypePath = HDF5Utils.createDataTypePath("Compound_", this.baseReader.houseKeepingNameSuffix, dataTypeName);
        CompoundTypeInformation cpdTypeInfo = this.getFullCompoundDataTypeInformation(dataTypePath, dataTypeInfoOptions, this.baseReader.fileRegistry);
        HDF5CompoundType<T> typeForClass = this.getType(dataTypeName, cpdTypeInfo.compoundDataTypeId, pojoClass, requireTypesToBeEqual, this.createByteifyers(pojoClass, cpdTypeInfo, hints));
        return typeForClass;
    }

    private <T> HDF5ValueObjectByteifyer<T> createByteifyers(Class<T> compoundClazz, CompoundTypeInformation compoundTypeInfo, HDF5CompoundMemberMapping[] mapping) {
        return this.baseReader.createCompoundByteifyers(compoundClazz, mapping, compoundTypeInfo);
    }

    private <T> HDF5ValueObjectByteifyer<T> createByteifyers(Class<T> compoundClazz, CompoundTypeInformation compoundTypeInfo, HDF5CompoundMappingHints hintsOrNull) {
        return this.baseReader.createCompoundByteifyers(compoundClazz, this.inferMemberMapping(compoundClazz, compoundTypeInfo, hintsOrNull), compoundTypeInfo);
    }

    private HDF5CompoundMemberMapping[] inferMemberMapping(Class<?> compoundClazz, CompoundTypeInformation compoundTypeInfo, HDF5CompoundMappingHints hintsOrNull) {
        ArrayList<HDF5CompoundMemberMapping> mapping = new ArrayList<HDF5CompoundMemberMapping>(compoundTypeInfo.getNumberOfMembers());
        Map<String, Field> fields = ReflectionUtils.getFieldMap(compoundClazz);
        int i = 0;
        while (i < compoundTypeInfo.getNumberOfMembers()) {
            HDF5CompoundMemberInformation compoundMember = compoundTypeInfo.getMember(i);
            long compoundMemberTypeId = compoundTypeInfo.dataTypeIds[i];
            Field fieldOrNull = fields.get(compoundMember.getName());
            String memberName = compoundMember.getName();
            String fieldName = fieldOrNull != null ? fieldOrNull.getName() : memberName;
            HDF5DataTypeInformation typeInfo = compoundMember.getType();
            int[] dimensions = typeInfo.getDimensions();
            if (typeInfo.getDataClass() == HDF5DataClass.ENUM) {
                if (dimensions.length == 0 || dimensions.length == 1 && dimensions[0] == 1) {
                    mapping.add(HDF5CompoundMemberMapping.mapping(memberName).fieldName(fieldName).enumType(compoundTypeInfo.enumTypes[i]).typeVariant(typeInfo.tryGetTypeVariant()));
                } else if (dimensions.length == 1) {
                    mapping.add(HDF5CompoundMemberMapping.mappingWithStorageTypeId(fieldName, memberName, new HDF5EnumerationType(this.baseReader.fileId, -1L, this.baseReader.h5.getNativeDataType(compoundMemberTypeId, this.baseReader.fileRegistry), this.baseReader.getEnumDataTypeName(compoundMember.getType().tryGetName(), compoundMemberTypeId), compoundMember.tryGetEnumValues(), this.baseReader), dimensions, compoundMemberTypeId, typeInfo.tryGetTypeVariant()));
                }
            } else if (typeInfo.getDataClass() == HDF5DataClass.STRING) {
                if (fieldOrNull != null && fieldOrNull.getType() != String.class && fieldOrNull.getType() != char[].class) {
                    throw new HDF5JavaException("Field of string type does not correspond to string or char[] value");
                }
                mapping.add(HDF5CompoundMemberMapping.mappingArrayWithStorageId(fieldName, memberName, String.class, new int[]{typeInfo.getElementSize()}, compoundMemberTypeId, false, typeInfo.isVariableLengthString(), false, typeInfo.tryGetTypeVariant()));
            } else if (typeInfo.getDataClass() == HDF5DataClass.REFERENCE) {
                if (fieldOrNull != null && fieldOrNull.getType() != String.class && fieldOrNull.getType() != char[].class) {
                    throw new HDF5JavaException("Field of rererence type does not correspond to string or char[] value");
                }
                mapping.add(HDF5CompoundMemberMapping.mappingArrayWithStorageId(fieldName, memberName, String.class, new int[]{typeInfo.getElementSize()}, compoundMemberTypeId, false, false, true, typeInfo.tryGetTypeVariant()));
            } else {
                Class<?> memberClazz = fieldOrNull != null ? fieldOrNull.getType() : typeInfo.tryGetJavaType();
                mapping.add(HDF5CompoundMemberMapping.mappingArrayWithStorageId(fieldName, memberName, memberClazz, dimensions, compoundMemberTypeId, !compoundMember.getType().isSigned(), false, false, typeInfo.tryGetTypeVariant()));
            }
            ++i;
        }
        return HDF5CompoundMemberMapping.addHints(mapping.toArray(new HDF5CompoundMemberMapping[mapping.size()]), hintsOrNull);
    }
}

